// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package simpledb_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/simpledb"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleSimpleDB_BatchDeleteAttributes() {
	sess := session.Must(session.NewSession())

	svc := simpledb.New(sess)

	params := &simpledb.BatchDeleteAttributesInput{
		DomainName: aws.String("String"), // Required
		Items: []*simpledb.DeletableItem{ // Required
			{ // Required
				Name: aws.String("String"), // Required
				Attributes: []*simpledb.DeletableAttribute{
					{ // Required
						Name:  aws.String("String"), // Required
						Value: aws.String("String"),
					},
					// More values...
				},
			},
			// More values...
		},
	}
	resp, err := svc.BatchDeleteAttributes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSimpleDB_BatchPutAttributes() {
	sess := session.Must(session.NewSession())

	svc := simpledb.New(sess)

	params := &simpledb.BatchPutAttributesInput{
		DomainName: aws.String("String"), // Required
		Items: []*simpledb.ReplaceableItem{ // Required
			{ // Required
				Attributes: []*simpledb.ReplaceableAttribute{ // Required
					{ // Required
						Name:    aws.String("String"), // Required
						Value:   aws.String("String"), // Required
						Replace: aws.Bool(true),
					},
					// More values...
				},
				Name: aws.String("String"), // Required
			},
			// More values...
		},
	}
	resp, err := svc.BatchPutAttributes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSimpleDB_CreateDomain() {
	sess := session.Must(session.NewSession())

	svc := simpledb.New(sess)

	params := &simpledb.CreateDomainInput{
		DomainName: aws.String("String"), // Required
	}
	resp, err := svc.CreateDomain(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSimpleDB_DeleteAttributes() {
	sess := session.Must(session.NewSession())

	svc := simpledb.New(sess)

	params := &simpledb.DeleteAttributesInput{
		DomainName: aws.String("String"), // Required
		ItemName:   aws.String("String"), // Required
		Attributes: []*simpledb.DeletableAttribute{
			{ // Required
				Name:  aws.String("String"), // Required
				Value: aws.String("String"),
			},
			// More values...
		},
		Expected: &simpledb.UpdateCondition{
			Exists: aws.Bool(true),
			Name:   aws.String("String"),
			Value:  aws.String("String"),
		},
	}
	resp, err := svc.DeleteAttributes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSimpleDB_DeleteDomain() {
	sess := session.Must(session.NewSession())

	svc := simpledb.New(sess)

	params := &simpledb.DeleteDomainInput{
		DomainName: aws.String("String"), // Required
	}
	resp, err := svc.DeleteDomain(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSimpleDB_DomainMetadata() {
	sess := session.Must(session.NewSession())

	svc := simpledb.New(sess)

	params := &simpledb.DomainMetadataInput{
		DomainName: aws.String("String"), // Required
	}
	resp, err := svc.DomainMetadata(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSimpleDB_GetAttributes() {
	sess := session.Must(session.NewSession())

	svc := simpledb.New(sess)

	params := &simpledb.GetAttributesInput{
		DomainName: aws.String("String"), // Required
		ItemName:   aws.String("String"), // Required
		AttributeNames: []*string{
			aws.String("String"), // Required
			// More values...
		},
		ConsistentRead: aws.Bool(true),
	}
	resp, err := svc.GetAttributes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSimpleDB_ListDomains() {
	sess := session.Must(session.NewSession())

	svc := simpledb.New(sess)

	params := &simpledb.ListDomainsInput{
		MaxNumberOfDomains: aws.Int64(1),
		NextToken:          aws.String("String"),
	}
	resp, err := svc.ListDomains(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSimpleDB_PutAttributes() {
	sess := session.Must(session.NewSession())

	svc := simpledb.New(sess)

	params := &simpledb.PutAttributesInput{
		Attributes: []*simpledb.ReplaceableAttribute{ // Required
			{ // Required
				Name:    aws.String("String"), // Required
				Value:   aws.String("String"), // Required
				Replace: aws.Bool(true),
			},
			// More values...
		},
		DomainName: aws.String("String"), // Required
		ItemName:   aws.String("String"), // Required
		Expected: &simpledb.UpdateCondition{
			Exists: aws.Bool(true),
			Name:   aws.String("String"),
			Value:  aws.String("String"),
		},
	}
	resp, err := svc.PutAttributes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSimpleDB_Select() {
	sess := session.Must(session.NewSession())

	svc := simpledb.New(sess)

	params := &simpledb.SelectInput{
		SelectExpression: aws.String("String"), // Required
		ConsistentRead:   aws.Bool(true),
		NextToken:        aws.String("String"),
	}
	resp, err := svc.Select(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
