// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workdocs_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/workdocs"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleWorkDocs_AbortDocumentVersionUpload() {
	sess := session.Must(session.NewSession())

	svc := workdocs.New(sess)

	params := &workdocs.AbortDocumentVersionUploadInput{
		DocumentId: aws.String("ResourceIdType"),        // Required
		VersionId:  aws.String("DocumentVersionIdType"), // Required
	}
	resp, err := svc.AbortDocumentVersionUpload(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkDocs_ActivateUser() {
	sess := session.Must(session.NewSession())

	svc := workdocs.New(sess)

	params := &workdocs.ActivateUserInput{
		UserId: aws.String("IdType"), // Required
	}
	resp, err := svc.ActivateUser(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkDocs_AddResourcePermissions() {
	sess := session.Must(session.NewSession())

	svc := workdocs.New(sess)

	params := &workdocs.AddResourcePermissionsInput{
		Principals: []*workdocs.SharePrincipal{ // Required
			{ // Required
				Id:   aws.String("IdType"),        // Required
				Role: aws.String("RoleType"),      // Required
				Type: aws.String("PrincipalType"), // Required
			},
			// More values...
		},
		ResourceId: aws.String("ResourceIdType"), // Required
	}
	resp, err := svc.AddResourcePermissions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkDocs_CreateFolder() {
	sess := session.Must(session.NewSession())

	svc := workdocs.New(sess)

	params := &workdocs.CreateFolderInput{
		ParentFolderId: aws.String("ResourceIdType"), // Required
		Name:           aws.String("ResourceNameType"),
	}
	resp, err := svc.CreateFolder(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkDocs_CreateNotificationSubscription() {
	sess := session.Must(session.NewSession())

	svc := workdocs.New(sess)

	params := &workdocs.CreateNotificationSubscriptionInput{
		Endpoint:         aws.String("SubscriptionEndPointType"), // Required
		OrganizationId:   aws.String("IdType"),                   // Required
		Protocol:         aws.String("SubscriptionProtocolType"), // Required
		SubscriptionType: aws.String("SubscriptionType"),         // Required
	}
	resp, err := svc.CreateNotificationSubscription(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkDocs_CreateUser() {
	sess := session.Must(session.NewSession())

	svc := workdocs.New(sess)

	params := &workdocs.CreateUserInput{
		GivenName:      aws.String("UserAttributeValueType"), // Required
		Password:       aws.String("PasswordType"),           // Required
		Surname:        aws.String("UserAttributeValueType"), // Required
		Username:       aws.String("UsernameType"),           // Required
		OrganizationId: aws.String("IdType"),
		StorageRule: &workdocs.StorageRuleType{
			StorageAllocatedInBytes: aws.Int64(1),
			StorageType:             aws.String("StorageType"),
		},
		TimeZoneId: aws.String("TimeZoneIdType"),
	}
	resp, err := svc.CreateUser(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkDocs_DeactivateUser() {
	sess := session.Must(session.NewSession())

	svc := workdocs.New(sess)

	params := &workdocs.DeactivateUserInput{
		UserId: aws.String("IdType"), // Required
	}
	resp, err := svc.DeactivateUser(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkDocs_DeleteDocument() {
	sess := session.Must(session.NewSession())

	svc := workdocs.New(sess)

	params := &workdocs.DeleteDocumentInput{
		DocumentId: aws.String("ResourceIdType"), // Required
	}
	resp, err := svc.DeleteDocument(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkDocs_DeleteFolder() {
	sess := session.Must(session.NewSession())

	svc := workdocs.New(sess)

	params := &workdocs.DeleteFolderInput{
		FolderId: aws.String("ResourceIdType"), // Required
	}
	resp, err := svc.DeleteFolder(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkDocs_DeleteFolderContents() {
	sess := session.Must(session.NewSession())

	svc := workdocs.New(sess)

	params := &workdocs.DeleteFolderContentsInput{
		FolderId: aws.String("ResourceIdType"), // Required
	}
	resp, err := svc.DeleteFolderContents(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkDocs_DeleteNotificationSubscription() {
	sess := session.Must(session.NewSession())

	svc := workdocs.New(sess)

	params := &workdocs.DeleteNotificationSubscriptionInput{
		OrganizationId: aws.String("IdType"), // Required
		SubscriptionId: aws.String("IdType"), // Required
	}
	resp, err := svc.DeleteNotificationSubscription(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkDocs_DeleteUser() {
	sess := session.Must(session.NewSession())

	svc := workdocs.New(sess)

	params := &workdocs.DeleteUserInput{
		UserId: aws.String("IdType"), // Required
	}
	resp, err := svc.DeleteUser(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkDocs_DescribeDocumentVersions() {
	sess := session.Must(session.NewSession())

	svc := workdocs.New(sess)

	params := &workdocs.DescribeDocumentVersionsInput{
		DocumentId: aws.String("ResourceIdType"), // Required
		Fields:     aws.String("FieldNamesType"),
		Include:    aws.String("FieldNamesType"),
		Limit:      aws.Int64(1),
		Marker:     aws.String("PageMarkerType"),
	}
	resp, err := svc.DescribeDocumentVersions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkDocs_DescribeFolderContents() {
	sess := session.Must(session.NewSession())

	svc := workdocs.New(sess)

	params := &workdocs.DescribeFolderContentsInput{
		FolderId: aws.String("ResourceIdType"), // Required
		Include:  aws.String("FieldNamesType"),
		Limit:    aws.Int64(1),
		Marker:   aws.String("PageMarkerType"),
		Order:    aws.String("OrderType"),
		Sort:     aws.String("ResourceSortType"),
		Type:     aws.String("FolderContentType"),
	}
	resp, err := svc.DescribeFolderContents(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkDocs_DescribeNotificationSubscriptions() {
	sess := session.Must(session.NewSession())

	svc := workdocs.New(sess)

	params := &workdocs.DescribeNotificationSubscriptionsInput{
		OrganizationId: aws.String("IdType"), // Required
		Limit:          aws.Int64(1),
		Marker:         aws.String("PageMarkerType"),
	}
	resp, err := svc.DescribeNotificationSubscriptions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkDocs_DescribeResourcePermissions() {
	sess := session.Must(session.NewSession())

	svc := workdocs.New(sess)

	params := &workdocs.DescribeResourcePermissionsInput{
		ResourceId: aws.String("ResourceIdType"), // Required
		Limit:      aws.Int64(1),
		Marker:     aws.String("PageMarkerType"),
	}
	resp, err := svc.DescribeResourcePermissions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkDocs_DescribeUsers() {
	sess := session.Must(session.NewSession())

	svc := workdocs.New(sess)

	params := &workdocs.DescribeUsersInput{
		Fields:         aws.String("FieldNamesType"),
		Include:        aws.String("UserFilterType"),
		Limit:          aws.Int64(1),
		Marker:         aws.String("PageMarkerType"),
		Order:          aws.String("OrderType"),
		OrganizationId: aws.String("IdType"),
		Query:          aws.String("SearchQueryType"),
		Sort:           aws.String("UserSortType"),
		UserIds:        aws.String("UserIdsType"),
	}
	resp, err := svc.DescribeUsers(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkDocs_GetDocument() {
	sess := session.Must(session.NewSession())

	svc := workdocs.New(sess)

	params := &workdocs.GetDocumentInput{
		DocumentId: aws.String("ResourceIdType"), // Required
	}
	resp, err := svc.GetDocument(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkDocs_GetDocumentPath() {
	sess := session.Must(session.NewSession())

	svc := workdocs.New(sess)

	params := &workdocs.GetDocumentPathInput{
		DocumentId: aws.String("IdType"), // Required
		Fields:     aws.String("FieldNamesType"),
		Limit:      aws.Int64(1),
		Marker:     aws.String("PageMarkerType"),
	}
	resp, err := svc.GetDocumentPath(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkDocs_GetDocumentVersion() {
	sess := session.Must(session.NewSession())

	svc := workdocs.New(sess)

	params := &workdocs.GetDocumentVersionInput{
		DocumentId: aws.String("ResourceIdType"),        // Required
		VersionId:  aws.String("DocumentVersionIdType"), // Required
		Fields:     aws.String("FieldNamesType"),
	}
	resp, err := svc.GetDocumentVersion(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkDocs_GetFolder() {
	sess := session.Must(session.NewSession())

	svc := workdocs.New(sess)

	params := &workdocs.GetFolderInput{
		FolderId: aws.String("ResourceIdType"), // Required
	}
	resp, err := svc.GetFolder(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkDocs_GetFolderPath() {
	sess := session.Must(session.NewSession())

	svc := workdocs.New(sess)

	params := &workdocs.GetFolderPathInput{
		FolderId: aws.String("IdType"), // Required
		Fields:   aws.String("FieldNamesType"),
		Limit:    aws.Int64(1),
		Marker:   aws.String("PageMarkerType"),
	}
	resp, err := svc.GetFolderPath(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkDocs_InitiateDocumentVersionUpload() {
	sess := session.Must(session.NewSession())

	svc := workdocs.New(sess)

	params := &workdocs.InitiateDocumentVersionUploadInput{
		ParentFolderId:           aws.String("ResourceIdType"), // Required
		ContentCreatedTimestamp:  aws.Time(time.Now()),
		ContentModifiedTimestamp: aws.Time(time.Now()),
		ContentType:              aws.String("DocumentContentType"),
		DocumentSizeInBytes:      aws.Int64(1),
		Id:                       aws.String("ResourceIdType"),
		Name:                     aws.String("ResourceNameType"),
	}
	resp, err := svc.InitiateDocumentVersionUpload(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkDocs_RemoveAllResourcePermissions() {
	sess := session.Must(session.NewSession())

	svc := workdocs.New(sess)

	params := &workdocs.RemoveAllResourcePermissionsInput{
		ResourceId: aws.String("ResourceIdType"), // Required
	}
	resp, err := svc.RemoveAllResourcePermissions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkDocs_RemoveResourcePermission() {
	sess := session.Must(session.NewSession())

	svc := workdocs.New(sess)

	params := &workdocs.RemoveResourcePermissionInput{
		PrincipalId:   aws.String("IdType"),         // Required
		ResourceId:    aws.String("ResourceIdType"), // Required
		PrincipalType: aws.String("PrincipalType"),
	}
	resp, err := svc.RemoveResourcePermission(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkDocs_UpdateDocument() {
	sess := session.Must(session.NewSession())

	svc := workdocs.New(sess)

	params := &workdocs.UpdateDocumentInput{
		DocumentId:     aws.String("ResourceIdType"), // Required
		Name:           aws.String("ResourceNameType"),
		ParentFolderId: aws.String("ResourceIdType"),
		ResourceState:  aws.String("ResourceStateType"),
	}
	resp, err := svc.UpdateDocument(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkDocs_UpdateDocumentVersion() {
	sess := session.Must(session.NewSession())

	svc := workdocs.New(sess)

	params := &workdocs.UpdateDocumentVersionInput{
		DocumentId:    aws.String("ResourceIdType"),        // Required
		VersionId:     aws.String("DocumentVersionIdType"), // Required
		VersionStatus: aws.String("DocumentVersionStatus"),
	}
	resp, err := svc.UpdateDocumentVersion(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkDocs_UpdateFolder() {
	sess := session.Must(session.NewSession())

	svc := workdocs.New(sess)

	params := &workdocs.UpdateFolderInput{
		FolderId:       aws.String("ResourceIdType"), // Required
		Name:           aws.String("ResourceNameType"),
		ParentFolderId: aws.String("ResourceIdType"),
		ResourceState:  aws.String("ResourceStateType"),
	}
	resp, err := svc.UpdateFolder(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkDocs_UpdateUser() {
	sess := session.Must(session.NewSession())

	svc := workdocs.New(sess)

	params := &workdocs.UpdateUserInput{
		UserId:    aws.String("IdType"), // Required
		GivenName: aws.String("UserAttributeValueType"),
		Locale:    aws.String("LocaleType"),
		StorageRule: &workdocs.StorageRuleType{
			StorageAllocatedInBytes: aws.Int64(1),
			StorageType:             aws.String("StorageType"),
		},
		Surname:    aws.String("UserAttributeValueType"),
		TimeZoneId: aws.String("TimeZoneIdType"),
		Type:       aws.String("UserType"),
	}
	resp, err := svc.UpdateUser(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
