// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package batch

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/client"
	"github.com/aws/aws-sdk-go/aws/client/metadata"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/aws/signer/v4"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

// AWS Batch enables you to run batch computing workloads on the AWS Cloud.
// Batch computing is a common way for developers, scientists, and engineers
// to access large amounts of compute resources, and AWS Batch removes the undifferentiated
// heavy lifting of configuring and managing the required infrastructure. AWS
// Batch will be familiar to users of traditional batch computing software.
// This service can efficiently provision resources in response to jobs submitted
// in order to eliminate capacity constraints, reduce compute costs, and deliver
// results quickly.
//
// As a fully managed service, AWS Batch enables developers, scientists, and
// engineers to run batch computing workloads of any scale. AWS Batch automatically
// provisions compute resources and optimizes the workload distribution based
// on the quantity and scale of the workloads. With AWS Batch, there is no need
// to install or manage batch computing software, which allows you to focus
// on analyzing results and solving problems. AWS Batch reduces operational
// complexities, saves time, and reduces costs, which makes it easy for developers,
// scientists, and engineers to run their batch jobs in the AWS Cloud.
// The service client's operations are safe to be used concurrently.
// It is not safe to mutate any of the client's properties though.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10
type Batch struct {
	*client.Client
}

// Used for custom client initialization logic
var initClient func(*client.Client)

// Used for custom request initialization logic
var initRequest func(*request.Request)

// Service information constants
const (
	ServiceName = "batch"     // Service endpoint prefix API calls made to.
	EndpointsID = ServiceName // Service ID for Regions and Endpoints metadata.
)

// New creates a new instance of the Batch client with a session.
// If additional configuration is needed for the client instance use the optional
// aws.Config parameter to add your extra config.
//
// Example:
//     // Create a Batch client from just a session.
//     svc := batch.New(mySession)
//
//     // Create a Batch client with additional configuration
//     svc := batch.New(mySession, aws.NewConfig().WithRegion("us-west-2"))
func New(p client.ConfigProvider, cfgs ...*aws.Config) *Batch {
	c := p.ClientConfig(EndpointsID, cfgs...)
	return newClient(*c.Config, c.Handlers, c.Endpoint, c.SigningRegion, c.SigningName)
}

// newClient creates, initializes and returns a new service client instance.
func newClient(cfg aws.Config, handlers request.Handlers, endpoint, signingRegion, signingName string) *Batch {
	svc := &Batch{
		Client: client.New(
			cfg,
			metadata.ClientInfo{
				ServiceName:   ServiceName,
				SigningName:   signingName,
				SigningRegion: signingRegion,
				Endpoint:      endpoint,
				APIVersion:    "2016-08-10",
				JSONVersion:   "1.1",
			},
			handlers,
		),
	}

	// Handlers
	svc.Handlers.Sign.PushBackNamed(v4.SignRequestHandler)
	svc.Handlers.Build.PushBackNamed(restjson.BuildHandler)
	svc.Handlers.Unmarshal.PushBackNamed(restjson.UnmarshalHandler)
	svc.Handlers.UnmarshalMeta.PushBackNamed(restjson.UnmarshalMetaHandler)
	svc.Handlers.UnmarshalError.PushBackNamed(restjson.UnmarshalErrorHandler)

	// Run custom client initialization if present
	if initClient != nil {
		initClient(svc.Client)
	}

	return svc
}

// newRequest creates a new request for a Batch operation and runs any
// custom request initialization.
func (c *Batch) newRequest(op *request.Operation, params, data interface{}) *request.Request {
	req := c.NewRequest(op, params, data)

	// Run custom request initialization if present
	if initRequest != nil {
		initRequest(req)
	}

	return req
}
