// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package cloudwatch provides a client for Amazon CloudWatch.
package cloudwatch

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/query"
)

const opDeleteAlarms = "DeleteAlarms"

// DeleteAlarmsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAlarms operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteAlarms for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteAlarms method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteAlarmsRequest method.
//    req, resp := client.DeleteAlarmsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DeleteAlarms
func (c *CloudWatch) DeleteAlarmsRequest(input *DeleteAlarmsInput) (req *request.Request, output *DeleteAlarmsOutput) {
	op := &request.Operation{
		Name:       opDeleteAlarms,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAlarmsInput{}
	}

	output = &DeleteAlarmsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAlarms API operation for Amazon CloudWatch.
//
// Deletes the specified alarms. In the event of an error, no alarms are deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation DeleteAlarms for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFound "ResourceNotFound"
//   The named resource does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DeleteAlarms
func (c *CloudWatch) DeleteAlarms(input *DeleteAlarmsInput) (*DeleteAlarmsOutput, error) {
	req, out := c.DeleteAlarmsRequest(input)
	return out, req.Send()
}

// DeleteAlarmsWithContext is the same as DeleteAlarms with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAlarms for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DeleteAlarmsWithContext(ctx aws.Context, input *DeleteAlarmsInput, opts ...request.Option) (*DeleteAlarmsOutput, error) {
	req, out := c.DeleteAlarmsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAlarmHistory = "DescribeAlarmHistory"

// DescribeAlarmHistoryRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAlarmHistory operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeAlarmHistory for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeAlarmHistory method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeAlarmHistoryRequest method.
//    req, resp := client.DescribeAlarmHistoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarmHistory
func (c *CloudWatch) DescribeAlarmHistoryRequest(input *DescribeAlarmHistoryInput) (req *request.Request, output *DescribeAlarmHistoryOutput) {
	op := &request.Operation{
		Name:       opDescribeAlarmHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAlarmHistoryInput{}
	}

	output = &DescribeAlarmHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAlarmHistory API operation for Amazon CloudWatch.
//
// Retrieves the history for the specified alarm. You can filter the results
// by date range or item type. If an alarm name is not specified, the histories
// for all alarms are returned.
//
// Note that Amazon CloudWatch retains the history of an alarm even if you delete
// the alarm.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation DescribeAlarmHistory for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The next token specified is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarmHistory
func (c *CloudWatch) DescribeAlarmHistory(input *DescribeAlarmHistoryInput) (*DescribeAlarmHistoryOutput, error) {
	req, out := c.DescribeAlarmHistoryRequest(input)
	return out, req.Send()
}

// DescribeAlarmHistoryWithContext is the same as DescribeAlarmHistory with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAlarmHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DescribeAlarmHistoryWithContext(ctx aws.Context, input *DescribeAlarmHistoryInput, opts ...request.Option) (*DescribeAlarmHistoryOutput, error) {
	req, out := c.DescribeAlarmHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAlarmHistoryPages iterates over the pages of a DescribeAlarmHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAlarmHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeAlarmHistory operation.
//    pageNum := 0
//    err := client.DescribeAlarmHistoryPages(params,
//        func(page *DescribeAlarmHistoryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudWatch) DescribeAlarmHistoryPages(input *DescribeAlarmHistoryInput, fn func(*DescribeAlarmHistoryOutput, bool) bool) error {
	return c.DescribeAlarmHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAlarmHistoryPagesWithContext same as DescribeAlarmHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DescribeAlarmHistoryPagesWithContext(ctx aws.Context, input *DescribeAlarmHistoryInput, fn func(*DescribeAlarmHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAlarmHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAlarmHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeAlarmHistoryOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeAlarms = "DescribeAlarms"

// DescribeAlarmsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAlarms operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeAlarms for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeAlarms method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeAlarmsRequest method.
//    req, resp := client.DescribeAlarmsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarms
func (c *CloudWatch) DescribeAlarmsRequest(input *DescribeAlarmsInput) (req *request.Request, output *DescribeAlarmsOutput) {
	op := &request.Operation{
		Name:       opDescribeAlarms,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAlarmsInput{}
	}

	output = &DescribeAlarmsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAlarms API operation for Amazon CloudWatch.
//
// Retrieves the specified alarms. If no alarms are specified, all alarms are
// returned. Alarms can be retrieved by using only a prefix for the alarm name,
// the alarm state, or a prefix for any action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation DescribeAlarms for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The next token specified is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarms
func (c *CloudWatch) DescribeAlarms(input *DescribeAlarmsInput) (*DescribeAlarmsOutput, error) {
	req, out := c.DescribeAlarmsRequest(input)
	return out, req.Send()
}

// DescribeAlarmsWithContext is the same as DescribeAlarms with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAlarms for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DescribeAlarmsWithContext(ctx aws.Context, input *DescribeAlarmsInput, opts ...request.Option) (*DescribeAlarmsOutput, error) {
	req, out := c.DescribeAlarmsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAlarmsPages iterates over the pages of a DescribeAlarms operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAlarms method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeAlarms operation.
//    pageNum := 0
//    err := client.DescribeAlarmsPages(params,
//        func(page *DescribeAlarmsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudWatch) DescribeAlarmsPages(input *DescribeAlarmsInput, fn func(*DescribeAlarmsOutput, bool) bool) error {
	return c.DescribeAlarmsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAlarmsPagesWithContext same as DescribeAlarmsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DescribeAlarmsPagesWithContext(ctx aws.Context, input *DescribeAlarmsInput, fn func(*DescribeAlarmsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAlarmsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAlarmsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeAlarmsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeAlarmsForMetric = "DescribeAlarmsForMetric"

// DescribeAlarmsForMetricRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAlarmsForMetric operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeAlarmsForMetric for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeAlarmsForMetric method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeAlarmsForMetricRequest method.
//    req, resp := client.DescribeAlarmsForMetricRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarmsForMetric
func (c *CloudWatch) DescribeAlarmsForMetricRequest(input *DescribeAlarmsForMetricInput) (req *request.Request, output *DescribeAlarmsForMetricOutput) {
	op := &request.Operation{
		Name:       opDescribeAlarmsForMetric,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAlarmsForMetricInput{}
	}

	output = &DescribeAlarmsForMetricOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAlarmsForMetric API operation for Amazon CloudWatch.
//
// Retrieves the alarms for the specified metric. Specify a statistic, period,
// or unit to filter the results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation DescribeAlarmsForMetric for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarmsForMetric
func (c *CloudWatch) DescribeAlarmsForMetric(input *DescribeAlarmsForMetricInput) (*DescribeAlarmsForMetricOutput, error) {
	req, out := c.DescribeAlarmsForMetricRequest(input)
	return out, req.Send()
}

// DescribeAlarmsForMetricWithContext is the same as DescribeAlarmsForMetric with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAlarmsForMetric for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DescribeAlarmsForMetricWithContext(ctx aws.Context, input *DescribeAlarmsForMetricInput, opts ...request.Option) (*DescribeAlarmsForMetricOutput, error) {
	req, out := c.DescribeAlarmsForMetricRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableAlarmActions = "DisableAlarmActions"

// DisableAlarmActionsRequest generates a "aws/request.Request" representing the
// client's request for the DisableAlarmActions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisableAlarmActions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisableAlarmActions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisableAlarmActionsRequest method.
//    req, resp := client.DisableAlarmActionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DisableAlarmActions
func (c *CloudWatch) DisableAlarmActionsRequest(input *DisableAlarmActionsInput) (req *request.Request, output *DisableAlarmActionsOutput) {
	op := &request.Operation{
		Name:       opDisableAlarmActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableAlarmActionsInput{}
	}

	output = &DisableAlarmActionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableAlarmActions API operation for Amazon CloudWatch.
//
// Disables the actions for the specified alarms. When an alarm's actions are
// disabled, the alarm actions do not execute when the alarm state changes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation DisableAlarmActions for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DisableAlarmActions
func (c *CloudWatch) DisableAlarmActions(input *DisableAlarmActionsInput) (*DisableAlarmActionsOutput, error) {
	req, out := c.DisableAlarmActionsRequest(input)
	return out, req.Send()
}

// DisableAlarmActionsWithContext is the same as DisableAlarmActions with the addition of
// the ability to pass a context and additional request options.
//
// See DisableAlarmActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DisableAlarmActionsWithContext(ctx aws.Context, input *DisableAlarmActionsInput, opts ...request.Option) (*DisableAlarmActionsOutput, error) {
	req, out := c.DisableAlarmActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableAlarmActions = "EnableAlarmActions"

// EnableAlarmActionsRequest generates a "aws/request.Request" representing the
// client's request for the EnableAlarmActions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See EnableAlarmActions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the EnableAlarmActions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the EnableAlarmActionsRequest method.
//    req, resp := client.EnableAlarmActionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/EnableAlarmActions
func (c *CloudWatch) EnableAlarmActionsRequest(input *EnableAlarmActionsInput) (req *request.Request, output *EnableAlarmActionsOutput) {
	op := &request.Operation{
		Name:       opEnableAlarmActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableAlarmActionsInput{}
	}

	output = &EnableAlarmActionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableAlarmActions API operation for Amazon CloudWatch.
//
// Enables the actions for the specified alarms.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation EnableAlarmActions for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/EnableAlarmActions
func (c *CloudWatch) EnableAlarmActions(input *EnableAlarmActionsInput) (*EnableAlarmActionsOutput, error) {
	req, out := c.EnableAlarmActionsRequest(input)
	return out, req.Send()
}

// EnableAlarmActionsWithContext is the same as EnableAlarmActions with the addition of
// the ability to pass a context and additional request options.
//
// See EnableAlarmActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) EnableAlarmActionsWithContext(ctx aws.Context, input *EnableAlarmActionsInput, opts ...request.Option) (*EnableAlarmActionsOutput, error) {
	req, out := c.EnableAlarmActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMetricStatistics = "GetMetricStatistics"

// GetMetricStatisticsRequest generates a "aws/request.Request" representing the
// client's request for the GetMetricStatistics operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetMetricStatistics for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetMetricStatistics method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetMetricStatisticsRequest method.
//    req, resp := client.GetMetricStatisticsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/GetMetricStatistics
func (c *CloudWatch) GetMetricStatisticsRequest(input *GetMetricStatisticsInput) (req *request.Request, output *GetMetricStatisticsOutput) {
	op := &request.Operation{
		Name:       opGetMetricStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMetricStatisticsInput{}
	}

	output = &GetMetricStatisticsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMetricStatistics API operation for Amazon CloudWatch.
//
// Gets statistics for the specified metric.
//
// Amazon CloudWatch retains metric data as follows:
//
//    * Data points with a period of 60 seconds (1 minute) are available for
//    15 days
//
//    * Data points with a period of 300 seconds (5 minute) are available for
//    63 days
//
//    * Data points with a period of 3600 seconds (1 hour) are available for
//    455 days (15 months)
//
// Note that CloudWatch started retaining 5-minute and 1-hour metric data as
// of 9 July 2016.
//
// The maximum number of data points returned from a single call is 1,440. If
// you request more than 1,440 data points, Amazon CloudWatch returns an error.
// To reduce the number of data points, you can narrow the specified time range
// and make multiple requests across adjacent time ranges, or you can increase
// the specified period. A period can be as short as one minute (60 seconds).
// Note that data points are not returned in chronological order.
//
// Amazon CloudWatch aggregates data points based on the length of the period
// that you specify. For example, if you request statistics with a one-hour
// period, Amazon CloudWatch aggregates all data points with time stamps that
// fall within each one-hour period. Therefore, the number of values aggregated
// by CloudWatch is larger than the number of data points returned.
//
// CloudWatch needs raw data points to calculate percentile statistics. If you
// publish data using a statistic set instead, you cannot retrieve percentile
// statistics for this data unless one of the following conditions is true:
//
//    * The SampleCount of the statistic set is 1
//
//    * The Min and the Max of the statistic set are equal
//
// For a list of metrics and dimensions supported by AWS services, see the Amazon
// CloudWatch Metrics and Dimensions Reference (http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CW_Support_For_AWS.html)
// in the Amazon CloudWatch User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation GetMetricStatistics for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value of an input parameter is bad or out-of-range.
//
//   * ErrCodeMissingRequiredParameterException "MissingParameter"
//   An input parameter that is required is missing.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Parameters that cannot be used together were used together.
//
//   * ErrCodeInternalServiceFault "InternalServiceError"
//   Request processing has failed due to some unknown error, exception, or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/GetMetricStatistics
func (c *CloudWatch) GetMetricStatistics(input *GetMetricStatisticsInput) (*GetMetricStatisticsOutput, error) {
	req, out := c.GetMetricStatisticsRequest(input)
	return out, req.Send()
}

// GetMetricStatisticsWithContext is the same as GetMetricStatistics with the addition of
// the ability to pass a context and additional request options.
//
// See GetMetricStatistics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) GetMetricStatisticsWithContext(ctx aws.Context, input *GetMetricStatisticsInput, opts ...request.Option) (*GetMetricStatisticsOutput, error) {
	req, out := c.GetMetricStatisticsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListMetrics = "ListMetrics"

// ListMetricsRequest generates a "aws/request.Request" representing the
// client's request for the ListMetrics operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListMetrics for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListMetrics method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListMetricsRequest method.
//    req, resp := client.ListMetricsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/ListMetrics
func (c *CloudWatch) ListMetricsRequest(input *ListMetricsInput) (req *request.Request, output *ListMetricsOutput) {
	op := &request.Operation{
		Name:       opListMetrics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMetricsInput{}
	}

	output = &ListMetricsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMetrics API operation for Amazon CloudWatch.
//
// List the specified metrics. You can use the returned metrics with GetMetricStatistics
// to obtain statistical data.
//
// Up to 500 results are returned for any one call. To retrieve additional results,
// use the returned token with subsequent calls.
//
// After you create a metric, allow up to fifteen minutes before the metric
// appears. Statistics about the metric, however, are available sooner using
// GetMetricStatistics.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation ListMetrics for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceFault "InternalServiceError"
//   Request processing has failed due to some unknown error, exception, or failure.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value of an input parameter is bad or out-of-range.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/ListMetrics
func (c *CloudWatch) ListMetrics(input *ListMetricsInput) (*ListMetricsOutput, error) {
	req, out := c.ListMetricsRequest(input)
	return out, req.Send()
}

// ListMetricsWithContext is the same as ListMetrics with the addition of
// the ability to pass a context and additional request options.
//
// See ListMetrics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) ListMetricsWithContext(ctx aws.Context, input *ListMetricsInput, opts ...request.Option) (*ListMetricsOutput, error) {
	req, out := c.ListMetricsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMetricsPages iterates over the pages of a ListMetrics operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMetrics method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMetrics operation.
//    pageNum := 0
//    err := client.ListMetricsPages(params,
//        func(page *ListMetricsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudWatch) ListMetricsPages(input *ListMetricsInput, fn func(*ListMetricsOutput, bool) bool) error {
	return c.ListMetricsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMetricsPagesWithContext same as ListMetricsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) ListMetricsPagesWithContext(ctx aws.Context, input *ListMetricsInput, fn func(*ListMetricsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMetricsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMetricsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListMetricsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opPutMetricAlarm = "PutMetricAlarm"

// PutMetricAlarmRequest generates a "aws/request.Request" representing the
// client's request for the PutMetricAlarm operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutMetricAlarm for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutMetricAlarm method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutMetricAlarmRequest method.
//    req, resp := client.PutMetricAlarmRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutMetricAlarm
func (c *CloudWatch) PutMetricAlarmRequest(input *PutMetricAlarmInput) (req *request.Request, output *PutMetricAlarmOutput) {
	op := &request.Operation{
		Name:       opPutMetricAlarm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutMetricAlarmInput{}
	}

	output = &PutMetricAlarmOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutMetricAlarm API operation for Amazon CloudWatch.
//
// Creates or updates an alarm and associates it with the specified metric.
// Optionally, this operation can associate one or more Amazon SNS resources
// with the alarm.
//
// When this operation creates an alarm, the alarm state is immediately set
// to INSUFFICIENT_DATA. The alarm is evaluated and its state is set appropriately.
// Any actions associated with the state are then executed.
//
// When you update an existing alarm, its state is left unchanged, but the update
// completely overwrites the previous configuration of the alarm.
//
// If you are an AWS Identity and Access Management (IAM) user, you must have
// Amazon EC2 permissions for some operations:
//
//    * ec2:DescribeInstanceStatus and ec2:DescribeInstances for all alarms
//    on EC2 instance status metrics
//
//    * ec2:StopInstances for alarms with stop actions
//
//    * ec2:TerminateInstances for alarms with terminate actions
//
//    * ec2:DescribeInstanceRecoveryAttribute and ec2:RecoverInstances for alarms
//    with recover actions
//
// If you have read/write permissions for Amazon CloudWatch but not for Amazon
// EC2, you can still create an alarm, but the stop or terminate actions won't
// be performed. However, if you are later granted the required permissions,
// the alarm actions that you created earlier will be performed.
//
// If you are using an IAM role (for example, an Amazon EC2 instance profile),
// you cannot stop or terminate the instance using alarm actions. However, you
// can still see the alarm state and perform any other actions such as Amazon
// SNS notifications or Auto Scaling policies.
//
// If you are using temporary security credentials granted using the AWS Security
// Token Service (AWS STS), you cannot stop or terminate an Amazon EC2 instance
// using alarm actions.
//
// Note that you must create at least one stop, terminate, or reboot alarm using
// the Amazon EC2 or CloudWatch console to create the EC2ActionsAccess IAM role.
// After this IAM role is created, you can create stop, terminate, or reboot
// alarms using a command-line interface or an API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation PutMetricAlarm for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededFault "LimitExceeded"
//   The quota for alarms for this customer has already been reached.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutMetricAlarm
func (c *CloudWatch) PutMetricAlarm(input *PutMetricAlarmInput) (*PutMetricAlarmOutput, error) {
	req, out := c.PutMetricAlarmRequest(input)
	return out, req.Send()
}

// PutMetricAlarmWithContext is the same as PutMetricAlarm with the addition of
// the ability to pass a context and additional request options.
//
// See PutMetricAlarm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) PutMetricAlarmWithContext(ctx aws.Context, input *PutMetricAlarmInput, opts ...request.Option) (*PutMetricAlarmOutput, error) {
	req, out := c.PutMetricAlarmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutMetricData = "PutMetricData"

// PutMetricDataRequest generates a "aws/request.Request" representing the
// client's request for the PutMetricData operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutMetricData for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutMetricData method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutMetricDataRequest method.
//    req, resp := client.PutMetricDataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutMetricData
func (c *CloudWatch) PutMetricDataRequest(input *PutMetricDataInput) (req *request.Request, output *PutMetricDataOutput) {
	op := &request.Operation{
		Name:       opPutMetricData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutMetricDataInput{}
	}

	output = &PutMetricDataOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutMetricData API operation for Amazon CloudWatch.
//
// Publishes metric data points to Amazon CloudWatch. Amazon CloudWatch associates
// the data points with the specified metric. If the specified metric does not
// exist, Amazon CloudWatch creates the metric. When Amazon CloudWatch creates
// a metric, it can take up to fifteen minutes for the metric to appear in calls
// to ListMetrics.
//
// Each PutMetricData request is limited to 40 KB in size for HTTP POST requests.
//
// Although the Value parameter accepts numbers of type Double, Amazon CloudWatch
// rejects values that are either too small or too large. Values must be in
// the range of 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360
// (Base 2). In addition, special values (e.g., NaN, +Infinity, -Infinity) are
// not supported.
//
// You can use up to 10 dimensions per metric to further clarify what data the
// metric collects. For more information on specifying dimensions, see Publishing
// Metrics (http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html)
// in the Amazon CloudWatch User Guide.
//
// Data points with time stamps from 24 hours ago or longer can take at least
// 48 hours to become available for GetMetricStatistics from the time they are
// submitted.
//
// CloudWatch needs raw data points to calculate percentile statistics. If you
// publish data using a statistic set instead, you cannot retrieve percentile
// statistics for this data unless one of the following conditions is true:
//
//    * The SampleCount of the statistic set is 1
//
//    * The Min and the Max of the statistic set are equal
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation PutMetricData for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value of an input parameter is bad or out-of-range.
//
//   * ErrCodeMissingRequiredParameterException "MissingParameter"
//   An input parameter that is required is missing.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Parameters that cannot be used together were used together.
//
//   * ErrCodeInternalServiceFault "InternalServiceError"
//   Request processing has failed due to some unknown error, exception, or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutMetricData
func (c *CloudWatch) PutMetricData(input *PutMetricDataInput) (*PutMetricDataOutput, error) {
	req, out := c.PutMetricDataRequest(input)
	return out, req.Send()
}

// PutMetricDataWithContext is the same as PutMetricData with the addition of
// the ability to pass a context and additional request options.
//
// See PutMetricData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) PutMetricDataWithContext(ctx aws.Context, input *PutMetricDataInput, opts ...request.Option) (*PutMetricDataOutput, error) {
	req, out := c.PutMetricDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetAlarmState = "SetAlarmState"

// SetAlarmStateRequest generates a "aws/request.Request" representing the
// client's request for the SetAlarmState operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetAlarmState for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetAlarmState method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetAlarmStateRequest method.
//    req, resp := client.SetAlarmStateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/SetAlarmState
func (c *CloudWatch) SetAlarmStateRequest(input *SetAlarmStateInput) (req *request.Request, output *SetAlarmStateOutput) {
	op := &request.Operation{
		Name:       opSetAlarmState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetAlarmStateInput{}
	}

	output = &SetAlarmStateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetAlarmState API operation for Amazon CloudWatch.
//
// Temporarily sets the state of an alarm for testing purposes. When the updated
// state differs from the previous value, the action configured for the appropriate
// state is invoked. For example, if your alarm is configured to send an Amazon
// SNS message when an alarm is triggered, temporarily changing the alarm state
// to ALARM sends an Amazon SNS message. The alarm returns to its actual state
// (often within seconds). Because the alarm state change happens very quickly,
// it is typically only visible in the alarm's History tab in the Amazon CloudWatch
// console or through DescribeAlarmHistory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation SetAlarmState for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFound "ResourceNotFound"
//   The named resource does not exist.
//
//   * ErrCodeInvalidFormatFault "InvalidFormat"
//   Data was not syntactically valid JSON.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/SetAlarmState
func (c *CloudWatch) SetAlarmState(input *SetAlarmStateInput) (*SetAlarmStateOutput, error) {
	req, out := c.SetAlarmStateRequest(input)
	return out, req.Send()
}

// SetAlarmStateWithContext is the same as SetAlarmState with the addition of
// the ability to pass a context and additional request options.
//
// See SetAlarmState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) SetAlarmStateWithContext(ctx aws.Context, input *SetAlarmStateInput, opts ...request.Option) (*SetAlarmStateOutput, error) {
	req, out := c.SetAlarmStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Represents the history of a specific alarm.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/AlarmHistoryItem
type AlarmHistoryItem struct {
	_ struct{} `type:"structure"`

	// The descriptive name for the alarm.
	AlarmName *string `min:"1" type:"string"`

	// Data about the alarm, in JSON format.
	HistoryData *string `min:"1" type:"string"`

	// The type of alarm history item.
	HistoryItemType *string `type:"string" enum:"HistoryItemType"`

	// A summary of the alarm history, in text format.
	HistorySummary *string `min:"1" type:"string"`

	// The time stamp for the alarm history item.
	Timestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s AlarmHistoryItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AlarmHistoryItem) GoString() string {
	return s.String()
}

// SetAlarmName sets the AlarmName field's value.
func (s *AlarmHistoryItem) SetAlarmName(v string) *AlarmHistoryItem {
	s.AlarmName = &v
	return s
}

// SetHistoryData sets the HistoryData field's value.
func (s *AlarmHistoryItem) SetHistoryData(v string) *AlarmHistoryItem {
	s.HistoryData = &v
	return s
}

// SetHistoryItemType sets the HistoryItemType field's value.
func (s *AlarmHistoryItem) SetHistoryItemType(v string) *AlarmHistoryItem {
	s.HistoryItemType = &v
	return s
}

// SetHistorySummary sets the HistorySummary field's value.
func (s *AlarmHistoryItem) SetHistorySummary(v string) *AlarmHistoryItem {
	s.HistorySummary = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *AlarmHistoryItem) SetTimestamp(v time.Time) *AlarmHistoryItem {
	s.Timestamp = &v
	return s
}

// Encapsulates the statistical data that Amazon CloudWatch computes from metric
// data.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/Datapoint
type Datapoint struct {
	_ struct{} `type:"structure"`

	// The average of the metric values that correspond to the data point.
	Average *float64 `type:"double"`

	// The percentile statistic for the data point.
	ExtendedStatistics map[string]*float64 `type:"map"`

	// The maximum metric value for the data point.
	Maximum *float64 `type:"double"`

	// The minimum metric value for the data point.
	Minimum *float64 `type:"double"`

	// The number of metric values that contributed to the aggregate value of this
	// data point.
	SampleCount *float64 `type:"double"`

	// The sum of the metric values for the data point.
	Sum *float64 `type:"double"`

	// The time stamp used for the data point.
	Timestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The standard unit for the data point.
	Unit *string `type:"string" enum:"StandardUnit"`
}

// String returns the string representation
func (s Datapoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Datapoint) GoString() string {
	return s.String()
}

// SetAverage sets the Average field's value.
func (s *Datapoint) SetAverage(v float64) *Datapoint {
	s.Average = &v
	return s
}

// SetExtendedStatistics sets the ExtendedStatistics field's value.
func (s *Datapoint) SetExtendedStatistics(v map[string]*float64) *Datapoint {
	s.ExtendedStatistics = v
	return s
}

// SetMaximum sets the Maximum field's value.
func (s *Datapoint) SetMaximum(v float64) *Datapoint {
	s.Maximum = &v
	return s
}

// SetMinimum sets the Minimum field's value.
func (s *Datapoint) SetMinimum(v float64) *Datapoint {
	s.Minimum = &v
	return s
}

// SetSampleCount sets the SampleCount field's value.
func (s *Datapoint) SetSampleCount(v float64) *Datapoint {
	s.SampleCount = &v
	return s
}

// SetSum sets the Sum field's value.
func (s *Datapoint) SetSum(v float64) *Datapoint {
	s.Sum = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *Datapoint) SetTimestamp(v time.Time) *Datapoint {
	s.Timestamp = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *Datapoint) SetUnit(v string) *Datapoint {
	s.Unit = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DeleteAlarmsInput
type DeleteAlarmsInput struct {
	_ struct{} `type:"structure"`

	// The alarms to be deleted.
	//
	// AlarmNames is a required field
	AlarmNames []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteAlarmsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAlarmsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAlarmsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAlarmsInput"}
	if s.AlarmNames == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmNames sets the AlarmNames field's value.
func (s *DeleteAlarmsInput) SetAlarmNames(v []*string) *DeleteAlarmsInput {
	s.AlarmNames = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DeleteAlarmsOutput
type DeleteAlarmsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAlarmsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAlarmsOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarmHistoryInput
type DescribeAlarmHistoryInput struct {
	_ struct{} `type:"structure"`

	// The name of the alarm.
	AlarmName *string `min:"1" type:"string"`

	// The ending date to retrieve alarm history.
	EndDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The type of alarm histories to retrieve.
	HistoryItemType *string `type:"string" enum:"HistoryItemType"`

	// The maximum number of alarm history records to retrieve.
	MaxRecords *int64 `min:"1" type:"integer"`

	// The token returned by a previous call to indicate that there is more data
	// available.
	NextToken *string `type:"string"`

	// The starting date to retrieve alarm history.
	StartDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s DescribeAlarmHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAlarmHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAlarmHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAlarmHistoryInput"}
	if s.AlarmName != nil && len(*s.AlarmName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlarmName", 1))
	}
	if s.MaxRecords != nil && *s.MaxRecords < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxRecords", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmName sets the AlarmName field's value.
func (s *DescribeAlarmHistoryInput) SetAlarmName(v string) *DescribeAlarmHistoryInput {
	s.AlarmName = &v
	return s
}

// SetEndDate sets the EndDate field's value.
func (s *DescribeAlarmHistoryInput) SetEndDate(v time.Time) *DescribeAlarmHistoryInput {
	s.EndDate = &v
	return s
}

// SetHistoryItemType sets the HistoryItemType field's value.
func (s *DescribeAlarmHistoryInput) SetHistoryItemType(v string) *DescribeAlarmHistoryInput {
	s.HistoryItemType = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeAlarmHistoryInput) SetMaxRecords(v int64) *DescribeAlarmHistoryInput {
	s.MaxRecords = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAlarmHistoryInput) SetNextToken(v string) *DescribeAlarmHistoryInput {
	s.NextToken = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *DescribeAlarmHistoryInput) SetStartDate(v time.Time) *DescribeAlarmHistoryInput {
	s.StartDate = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarmHistoryOutput
type DescribeAlarmHistoryOutput struct {
	_ struct{} `type:"structure"`

	// The alarm histories, in JSON format.
	AlarmHistoryItems []*AlarmHistoryItem `type:"list"`

	// The token that marks the start of the next batch of returned results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAlarmHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAlarmHistoryOutput) GoString() string {
	return s.String()
}

// SetAlarmHistoryItems sets the AlarmHistoryItems field's value.
func (s *DescribeAlarmHistoryOutput) SetAlarmHistoryItems(v []*AlarmHistoryItem) *DescribeAlarmHistoryOutput {
	s.AlarmHistoryItems = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAlarmHistoryOutput) SetNextToken(v string) *DescribeAlarmHistoryOutput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarmsForMetricInput
type DescribeAlarmsForMetricInput struct {
	_ struct{} `type:"structure"`

	// The dimensions associated with the metric. If the metric has any associated
	// dimensions, you must specify them in order for the call to succeed.
	Dimensions []*Dimension `type:"list"`

	// The percentile statistic for the metric. Specify a value between p0.0 and
	// p100.
	ExtendedStatistic *string `type:"string"`

	// The name of the metric.
	//
	// MetricName is a required field
	MetricName *string `min:"1" type:"string" required:"true"`

	// The namespace of the metric.
	//
	// Namespace is a required field
	Namespace *string `min:"1" type:"string" required:"true"`

	// The period, in seconds, over which the statistic is applied.
	Period *int64 `min:"60" type:"integer"`

	// The statistic for the metric, other than percentiles. For percentile statistics,
	// use ExtendedStatistics.
	Statistic *string `type:"string" enum:"Statistic"`

	// The unit for the metric.
	Unit *string `type:"string" enum:"StandardUnit"`
}

// String returns the string representation
func (s DescribeAlarmsForMetricInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAlarmsForMetricInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAlarmsForMetricInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAlarmsForMetricInput"}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Period != nil && *s.Period < 60 {
		invalidParams.Add(request.NewErrParamMinValue("Period", 60))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *DescribeAlarmsForMetricInput) SetDimensions(v []*Dimension) *DescribeAlarmsForMetricInput {
	s.Dimensions = v
	return s
}

// SetExtendedStatistic sets the ExtendedStatistic field's value.
func (s *DescribeAlarmsForMetricInput) SetExtendedStatistic(v string) *DescribeAlarmsForMetricInput {
	s.ExtendedStatistic = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *DescribeAlarmsForMetricInput) SetMetricName(v string) *DescribeAlarmsForMetricInput {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DescribeAlarmsForMetricInput) SetNamespace(v string) *DescribeAlarmsForMetricInput {
	s.Namespace = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *DescribeAlarmsForMetricInput) SetPeriod(v int64) *DescribeAlarmsForMetricInput {
	s.Period = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *DescribeAlarmsForMetricInput) SetStatistic(v string) *DescribeAlarmsForMetricInput {
	s.Statistic = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *DescribeAlarmsForMetricInput) SetUnit(v string) *DescribeAlarmsForMetricInput {
	s.Unit = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarmsForMetricOutput
type DescribeAlarmsForMetricOutput struct {
	_ struct{} `type:"structure"`

	// The information for each alarm with the specified metric.
	MetricAlarms []*MetricAlarm `type:"list"`
}

// String returns the string representation
func (s DescribeAlarmsForMetricOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAlarmsForMetricOutput) GoString() string {
	return s.String()
}

// SetMetricAlarms sets the MetricAlarms field's value.
func (s *DescribeAlarmsForMetricOutput) SetMetricAlarms(v []*MetricAlarm) *DescribeAlarmsForMetricOutput {
	s.MetricAlarms = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarmsInput
type DescribeAlarmsInput struct {
	_ struct{} `type:"structure"`

	// The action name prefix.
	ActionPrefix *string `min:"1" type:"string"`

	// The alarm name prefix. You cannot specify AlarmNames if this parameter is
	// specified.
	AlarmNamePrefix *string `min:"1" type:"string"`

	// The names of the alarms.
	AlarmNames []*string `type:"list"`

	// The maximum number of alarm descriptions to retrieve.
	MaxRecords *int64 `min:"1" type:"integer"`

	// The token returned by a previous call to indicate that there is more data
	// available.
	NextToken *string `type:"string"`

	// The state value to be used in matching alarms.
	StateValue *string `type:"string" enum:"StateValue"`
}

// String returns the string representation
func (s DescribeAlarmsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAlarmsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAlarmsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAlarmsInput"}
	if s.ActionPrefix != nil && len(*s.ActionPrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionPrefix", 1))
	}
	if s.AlarmNamePrefix != nil && len(*s.AlarmNamePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlarmNamePrefix", 1))
	}
	if s.MaxRecords != nil && *s.MaxRecords < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxRecords", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionPrefix sets the ActionPrefix field's value.
func (s *DescribeAlarmsInput) SetActionPrefix(v string) *DescribeAlarmsInput {
	s.ActionPrefix = &v
	return s
}

// SetAlarmNamePrefix sets the AlarmNamePrefix field's value.
func (s *DescribeAlarmsInput) SetAlarmNamePrefix(v string) *DescribeAlarmsInput {
	s.AlarmNamePrefix = &v
	return s
}

// SetAlarmNames sets the AlarmNames field's value.
func (s *DescribeAlarmsInput) SetAlarmNames(v []*string) *DescribeAlarmsInput {
	s.AlarmNames = v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeAlarmsInput) SetMaxRecords(v int64) *DescribeAlarmsInput {
	s.MaxRecords = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAlarmsInput) SetNextToken(v string) *DescribeAlarmsInput {
	s.NextToken = &v
	return s
}

// SetStateValue sets the StateValue field's value.
func (s *DescribeAlarmsInput) SetStateValue(v string) *DescribeAlarmsInput {
	s.StateValue = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarmsOutput
type DescribeAlarmsOutput struct {
	_ struct{} `type:"structure"`

	// The information for the specified alarms.
	MetricAlarms []*MetricAlarm `type:"list"`

	// The token that marks the start of the next batch of returned results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAlarmsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAlarmsOutput) GoString() string {
	return s.String()
}

// SetMetricAlarms sets the MetricAlarms field's value.
func (s *DescribeAlarmsOutput) SetMetricAlarms(v []*MetricAlarm) *DescribeAlarmsOutput {
	s.MetricAlarms = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAlarmsOutput) SetNextToken(v string) *DescribeAlarmsOutput {
	s.NextToken = &v
	return s
}

// Expands the identity of a metric.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/Dimension
type Dimension struct {
	_ struct{} `type:"structure"`

	// The name of the dimension.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The value representing the dimension measurement.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Dimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Dimension) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Dimension) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Dimension"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Dimension) SetName(v string) *Dimension {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Dimension) SetValue(v string) *Dimension {
	s.Value = &v
	return s
}

// Represents filters for a dimension.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DimensionFilter
type DimensionFilter struct {
	_ struct{} `type:"structure"`

	// The dimension name to be matched.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The value of the dimension to be matched.
	Value *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DimensionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DimensionFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DimensionFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DimensionFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DimensionFilter) SetName(v string) *DimensionFilter {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *DimensionFilter) SetValue(v string) *DimensionFilter {
	s.Value = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DisableAlarmActionsInput
type DisableAlarmActionsInput struct {
	_ struct{} `type:"structure"`

	// The names of the alarms.
	//
	// AlarmNames is a required field
	AlarmNames []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DisableAlarmActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableAlarmActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableAlarmActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableAlarmActionsInput"}
	if s.AlarmNames == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmNames sets the AlarmNames field's value.
func (s *DisableAlarmActionsInput) SetAlarmNames(v []*string) *DisableAlarmActionsInput {
	s.AlarmNames = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DisableAlarmActionsOutput
type DisableAlarmActionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableAlarmActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableAlarmActionsOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/EnableAlarmActionsInput
type EnableAlarmActionsInput struct {
	_ struct{} `type:"structure"`

	// The names of the alarms.
	//
	// AlarmNames is a required field
	AlarmNames []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s EnableAlarmActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableAlarmActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableAlarmActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableAlarmActionsInput"}
	if s.AlarmNames == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmNames sets the AlarmNames field's value.
func (s *EnableAlarmActionsInput) SetAlarmNames(v []*string) *EnableAlarmActionsInput {
	s.AlarmNames = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/EnableAlarmActionsOutput
type EnableAlarmActionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableAlarmActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableAlarmActionsOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/GetMetricStatisticsInput
type GetMetricStatisticsInput struct {
	_ struct{} `type:"structure"`

	// The dimensions. If the metric contains multiple dimensions, you must include
	// a value for each dimension. CloudWatch treats each unique combination of
	// dimensions as a separate metric. You can't retrieve statistics using combinations
	// of dimensions that were not specially published. You must specify the same
	// dimensions that were used when the metrics were created. For an example,
	// see Dimension Combinations (http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#dimension-combinations)
	// in the Amazon CloudWatch User Guide. For more information on specifying dimensions,
	// see Publishing Metrics (http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html)
	// in the Amazon CloudWatch User Guide.
	Dimensions []*Dimension `type:"list"`

	// The time stamp that determines the last data point to return.
	//
	// The value specified is exclusive; results will include data points up to
	// the specified time stamp. The time stamp must be in ISO 8601 UTC format (for
	// example, 2016-10-10T23:00:00Z).
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The percentile statistics. Specify values between p0.0 and p100.
	ExtendedStatistics []*string `min:"1" type:"list"`

	// The name of the metric, with or without spaces.
	//
	// MetricName is a required field
	MetricName *string `min:"1" type:"string" required:"true"`

	// The namespace of the metric, with or without spaces.
	//
	// Namespace is a required field
	Namespace *string `min:"1" type:"string" required:"true"`

	// The granularity, in seconds, of the returned data points. A period can be
	// as short as one minute (60 seconds) and must be a multiple of 60. The default
	// value is 60.
	//
	// If the StartTime parameter specifies a time stamp that is greater than 15
	// days ago, you must specify the period as follows or no data points in that
	// time range is returned:
	//
	//    * Start time between 15 and 63 days ago - Use a multiple of 300 seconds
	//    (5 minutes).
	//
	//    * Start time greater than 63 days ago - Use a multiple of 3600 seconds
	//    (1 hour).
	//
	// Period is a required field
	Period *int64 `min:"60" type:"integer" required:"true"`

	// The time stamp that determines the first data point to return. Note that
	// start times are evaluated relative to the time that CloudWatch receives the
	// request.
	//
	// The value specified is inclusive; results include data points with the specified
	// time stamp. The time stamp must be in ISO 8601 UTC format (for example, 2016-10-03T23:00:00Z).
	//
	// CloudWatch rounds the specified time stamp as follows:
	//
	//    * Start time less than 15 days ago - Round down to the nearest whole minute.
	//    For example, 12:32:34 is rounded down to 12:32:00.
	//
	//    * Start time between 15 and 63 days ago - Round down to the nearest 5-minute
	//    clock interval. For example, 12:32:34 is rounded down to 12:30:00.
	//
	//    * Start time greater than 63 days ago - Round down to the nearest 1-hour
	//    clock interval. For example, 12:32:34 is rounded down to 12:00:00.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The metric statistics, other than percentile. For percentile statistics,
	// use ExtendedStatistic.
	Statistics []*string `min:"1" type:"list"`

	// The unit for a given metric. Metrics may be reported in multiple units. Not
	// supplying a unit results in all units being returned. If the metric only
	// ever reports one unit, specifying a unit has no effect.
	Unit *string `type:"string" enum:"StandardUnit"`
}

// String returns the string representation
func (s GetMetricStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMetricStatisticsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMetricStatisticsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMetricStatisticsInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.ExtendedStatistics != nil && len(s.ExtendedStatistics) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExtendedStatistics", 1))
	}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Period == nil {
		invalidParams.Add(request.NewErrParamRequired("Period"))
	}
	if s.Period != nil && *s.Period < 60 {
		invalidParams.Add(request.NewErrParamMinValue("Period", 60))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.Statistics != nil && len(s.Statistics) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Statistics", 1))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *GetMetricStatisticsInput) SetDimensions(v []*Dimension) *GetMetricStatisticsInput {
	s.Dimensions = v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *GetMetricStatisticsInput) SetEndTime(v time.Time) *GetMetricStatisticsInput {
	s.EndTime = &v
	return s
}

// SetExtendedStatistics sets the ExtendedStatistics field's value.
func (s *GetMetricStatisticsInput) SetExtendedStatistics(v []*string) *GetMetricStatisticsInput {
	s.ExtendedStatistics = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *GetMetricStatisticsInput) SetMetricName(v string) *GetMetricStatisticsInput {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *GetMetricStatisticsInput) SetNamespace(v string) *GetMetricStatisticsInput {
	s.Namespace = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *GetMetricStatisticsInput) SetPeriod(v int64) *GetMetricStatisticsInput {
	s.Period = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetMetricStatisticsInput) SetStartTime(v time.Time) *GetMetricStatisticsInput {
	s.StartTime = &v
	return s
}

// SetStatistics sets the Statistics field's value.
func (s *GetMetricStatisticsInput) SetStatistics(v []*string) *GetMetricStatisticsInput {
	s.Statistics = v
	return s
}

// SetUnit sets the Unit field's value.
func (s *GetMetricStatisticsInput) SetUnit(v string) *GetMetricStatisticsInput {
	s.Unit = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/GetMetricStatisticsOutput
type GetMetricStatisticsOutput struct {
	_ struct{} `type:"structure"`

	// The data points for the specified metric.
	Datapoints []*Datapoint `type:"list"`

	// A label for the specified metric.
	Label *string `type:"string"`
}

// String returns the string representation
func (s GetMetricStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMetricStatisticsOutput) GoString() string {
	return s.String()
}

// SetDatapoints sets the Datapoints field's value.
func (s *GetMetricStatisticsOutput) SetDatapoints(v []*Datapoint) *GetMetricStatisticsOutput {
	s.Datapoints = v
	return s
}

// SetLabel sets the Label field's value.
func (s *GetMetricStatisticsOutput) SetLabel(v string) *GetMetricStatisticsOutput {
	s.Label = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/ListMetricsInput
type ListMetricsInput struct {
	_ struct{} `type:"structure"`

	// The dimensions to filter against.
	Dimensions []*DimensionFilter `type:"list"`

	// The name of the metric to filter against.
	MetricName *string `min:"1" type:"string"`

	// The namespace to filter against.
	Namespace *string `min:"1" type:"string"`

	// The token returned by a previous call to indicate that there is more data
	// available.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListMetricsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMetricsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMetricsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMetricsInput"}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *ListMetricsInput) SetDimensions(v []*DimensionFilter) *ListMetricsInput {
	s.Dimensions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *ListMetricsInput) SetMetricName(v string) *ListMetricsInput {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ListMetricsInput) SetNamespace(v string) *ListMetricsInput {
	s.Namespace = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMetricsInput) SetNextToken(v string) *ListMetricsInput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/ListMetricsOutput
type ListMetricsOutput struct {
	_ struct{} `type:"structure"`

	// The metrics.
	Metrics []*Metric `type:"list"`

	// The token that marks the start of the next batch of returned results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListMetricsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMetricsOutput) GoString() string {
	return s.String()
}

// SetMetrics sets the Metrics field's value.
func (s *ListMetricsOutput) SetMetrics(v []*Metric) *ListMetricsOutput {
	s.Metrics = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMetricsOutput) SetNextToken(v string) *ListMetricsOutput {
	s.NextToken = &v
	return s
}

// Represents a specific metric.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/Metric
type Metric struct {
	_ struct{} `type:"structure"`

	// The dimensions for the metric.
	Dimensions []*Dimension `type:"list"`

	// The name of the metric.
	MetricName *string `min:"1" type:"string"`

	// The namespace of the metric.
	Namespace *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Metric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Metric) GoString() string {
	return s.String()
}

// SetDimensions sets the Dimensions field's value.
func (s *Metric) SetDimensions(v []*Dimension) *Metric {
	s.Dimensions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *Metric) SetMetricName(v string) *Metric {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *Metric) SetNamespace(v string) *Metric {
	s.Namespace = &v
	return s
}

// Represents an alarm.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/MetricAlarm
type MetricAlarm struct {
	_ struct{} `type:"structure"`

	// Indicates whether actions should be executed during any changes to the alarm
	// state.
	ActionsEnabled *bool `type:"boolean"`

	// The actions to execute when this alarm transitions to the ALARM state from
	// any other state. Each action is specified as an Amazon Resource Name (ARN).
	AlarmActions []*string `type:"list"`

	// The Amazon Resource Name (ARN) of the alarm.
	AlarmArn *string `min:"1" type:"string"`

	// The time stamp of the last update to the alarm configuration.
	AlarmConfigurationUpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The description of the alarm.
	AlarmDescription *string `type:"string"`

	// The name of the alarm.
	AlarmName *string `min:"1" type:"string"`

	// The arithmetic operation to use when comparing the specified statistic and
	// threshold. The specified statistic value is used as the first operand.
	ComparisonOperator *string `type:"string" enum:"ComparisonOperator"`

	// The dimensions for the metric associated with the alarm.
	Dimensions []*Dimension `type:"list"`

	EvaluateLowSampleCountPercentile *string `min:"1" type:"string"`

	// The number of periods over which data is compared to the specified threshold.
	EvaluationPeriods *int64 `min:"1" type:"integer"`

	// The percentile statistic for the metric associated with the alarm. Specify
	// a value between p0.0 and p100.
	ExtendedStatistic *string `type:"string"`

	// The actions to execute when this alarm transitions to the INSUFFICIENT_DATA
	// state from any other state. Each action is specified as an Amazon Resource
	// Name (ARN).
	InsufficientDataActions []*string `type:"list"`

	// The name of the metric associated with the alarm.
	MetricName *string `min:"1" type:"string"`

	// The namespace of the metric associated with the alarm.
	Namespace *string `min:"1" type:"string"`

	// The actions to execute when this alarm transitions to the OK state from any
	// other state. Each action is specified as an Amazon Resource Name (ARN).
	OKActions []*string `type:"list"`

	// The period, in seconds, over which the statistic is applied.
	Period *int64 `min:"60" type:"integer"`

	// An explanation for the alarm state, in text format.
	StateReason *string `type:"string"`

	// An explanation for the alarm state, in JSON format.
	StateReasonData *string `type:"string"`

	// The time stamp of the last update to the alarm state.
	StateUpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The state value for the alarm.
	StateValue *string `type:"string" enum:"StateValue"`

	// The statistic for the metric associated with the alarm, other than percentile.
	// For percentile statistics, use ExtendedStatistic.
	Statistic *string `type:"string" enum:"Statistic"`

	// The value to compare with the specified statistic.
	Threshold *float64 `type:"double"`

	TreatMissingData *string `min:"1" type:"string"`

	// The unit of the metric associated with the alarm.
	Unit *string `type:"string" enum:"StandardUnit"`
}

// String returns the string representation
func (s MetricAlarm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricAlarm) GoString() string {
	return s.String()
}

// SetActionsEnabled sets the ActionsEnabled field's value.
func (s *MetricAlarm) SetActionsEnabled(v bool) *MetricAlarm {
	s.ActionsEnabled = &v
	return s
}

// SetAlarmActions sets the AlarmActions field's value.
func (s *MetricAlarm) SetAlarmActions(v []*string) *MetricAlarm {
	s.AlarmActions = v
	return s
}

// SetAlarmArn sets the AlarmArn field's value.
func (s *MetricAlarm) SetAlarmArn(v string) *MetricAlarm {
	s.AlarmArn = &v
	return s
}

// SetAlarmConfigurationUpdatedTimestamp sets the AlarmConfigurationUpdatedTimestamp field's value.
func (s *MetricAlarm) SetAlarmConfigurationUpdatedTimestamp(v time.Time) *MetricAlarm {
	s.AlarmConfigurationUpdatedTimestamp = &v
	return s
}

// SetAlarmDescription sets the AlarmDescription field's value.
func (s *MetricAlarm) SetAlarmDescription(v string) *MetricAlarm {
	s.AlarmDescription = &v
	return s
}

// SetAlarmName sets the AlarmName field's value.
func (s *MetricAlarm) SetAlarmName(v string) *MetricAlarm {
	s.AlarmName = &v
	return s
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *MetricAlarm) SetComparisonOperator(v string) *MetricAlarm {
	s.ComparisonOperator = &v
	return s
}

// SetDimensions sets the Dimensions field's value.
func (s *MetricAlarm) SetDimensions(v []*Dimension) *MetricAlarm {
	s.Dimensions = v
	return s
}

// SetEvaluateLowSampleCountPercentile sets the EvaluateLowSampleCountPercentile field's value.
func (s *MetricAlarm) SetEvaluateLowSampleCountPercentile(v string) *MetricAlarm {
	s.EvaluateLowSampleCountPercentile = &v
	return s
}

// SetEvaluationPeriods sets the EvaluationPeriods field's value.
func (s *MetricAlarm) SetEvaluationPeriods(v int64) *MetricAlarm {
	s.EvaluationPeriods = &v
	return s
}

// SetExtendedStatistic sets the ExtendedStatistic field's value.
func (s *MetricAlarm) SetExtendedStatistic(v string) *MetricAlarm {
	s.ExtendedStatistic = &v
	return s
}

// SetInsufficientDataActions sets the InsufficientDataActions field's value.
func (s *MetricAlarm) SetInsufficientDataActions(v []*string) *MetricAlarm {
	s.InsufficientDataActions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *MetricAlarm) SetMetricName(v string) *MetricAlarm {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *MetricAlarm) SetNamespace(v string) *MetricAlarm {
	s.Namespace = &v
	return s
}

// SetOKActions sets the OKActions field's value.
func (s *MetricAlarm) SetOKActions(v []*string) *MetricAlarm {
	s.OKActions = v
	return s
}

// SetPeriod sets the Period field's value.
func (s *MetricAlarm) SetPeriod(v int64) *MetricAlarm {
	s.Period = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *MetricAlarm) SetStateReason(v string) *MetricAlarm {
	s.StateReason = &v
	return s
}

// SetStateReasonData sets the StateReasonData field's value.
func (s *MetricAlarm) SetStateReasonData(v string) *MetricAlarm {
	s.StateReasonData = &v
	return s
}

// SetStateUpdatedTimestamp sets the StateUpdatedTimestamp field's value.
func (s *MetricAlarm) SetStateUpdatedTimestamp(v time.Time) *MetricAlarm {
	s.StateUpdatedTimestamp = &v
	return s
}

// SetStateValue sets the StateValue field's value.
func (s *MetricAlarm) SetStateValue(v string) *MetricAlarm {
	s.StateValue = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *MetricAlarm) SetStatistic(v string) *MetricAlarm {
	s.Statistic = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *MetricAlarm) SetThreshold(v float64) *MetricAlarm {
	s.Threshold = &v
	return s
}

// SetTreatMissingData sets the TreatMissingData field's value.
func (s *MetricAlarm) SetTreatMissingData(v string) *MetricAlarm {
	s.TreatMissingData = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *MetricAlarm) SetUnit(v string) *MetricAlarm {
	s.Unit = &v
	return s
}

// Encapsulates the information sent to either create a metric or add new values
// to be aggregated into an existing metric.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/MetricDatum
type MetricDatum struct {
	_ struct{} `type:"structure"`

	// The dimensions associated with the metric.
	Dimensions []*Dimension `type:"list"`

	// The name of the metric.
	//
	// MetricName is a required field
	MetricName *string `min:"1" type:"string" required:"true"`

	// The statistical values for the metric.
	StatisticValues *StatisticSet `type:"structure"`

	// The time the metric data was received, expressed as the number of milliseconds
	// since Jan 1, 1970 00:00:00 UTC.
	Timestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The unit of the metric.
	Unit *string `type:"string" enum:"StandardUnit"`

	// The value for the metric.
	//
	// Although the parameter accepts numbers of type Double, Amazon CloudWatch
	// rejects values that are either too small or too large. Values must be in
	// the range of 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360
	// (Base 2). In addition, special values (for example, NaN, +Infinity, -Infinity)
	// are not supported.
	Value *float64 `type:"double"`
}

// String returns the string representation
func (s MetricDatum) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricDatum) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricDatum) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricDatum"}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.StatisticValues != nil {
		if err := s.StatisticValues.Validate(); err != nil {
			invalidParams.AddNested("StatisticValues", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *MetricDatum) SetDimensions(v []*Dimension) *MetricDatum {
	s.Dimensions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *MetricDatum) SetMetricName(v string) *MetricDatum {
	s.MetricName = &v
	return s
}

// SetStatisticValues sets the StatisticValues field's value.
func (s *MetricDatum) SetStatisticValues(v *StatisticSet) *MetricDatum {
	s.StatisticValues = v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *MetricDatum) SetTimestamp(v time.Time) *MetricDatum {
	s.Timestamp = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *MetricDatum) SetUnit(v string) *MetricDatum {
	s.Unit = &v
	return s
}

// SetValue sets the Value field's value.
func (s *MetricDatum) SetValue(v float64) *MetricDatum {
	s.Value = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutMetricAlarmInput
type PutMetricAlarmInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether actions should be executed during any changes to the alarm
	// state.
	ActionsEnabled *bool `type:"boolean"`

	// The actions to execute when this alarm transitions to the ALARM state from
	// any other state. Each action is specified as an Amazon Resource Name (ARN).
	//
	// Valid Values: arn:aws:automate:region:ec2:stop | arn:aws:automate:region:ec2:terminate
	// | arn:aws:automate:region:ec2:recover
	//
	// Valid Values (for use with IAM roles): arn:aws:swf:us-east-1:{customer-account}:action/actions/AWS_EC2.InstanceId.Stop/1.0
	// | arn:aws:swf:us-east-1:{customer-account}:action/actions/AWS_EC2.InstanceId.Terminate/1.0
	// | arn:aws:swf:us-east-1:{customer-account}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
	AlarmActions []*string `type:"list"`

	// The description for the alarm.
	AlarmDescription *string `type:"string"`

	// The name for the alarm. This name must be unique within the AWS account.
	//
	// AlarmName is a required field
	AlarmName *string `min:"1" type:"string" required:"true"`

	// The arithmetic operation to use when comparing the specified statistic and
	// threshold. The specified statistic value is used as the first operand.
	//
	// ComparisonOperator is a required field
	ComparisonOperator *string `type:"string" required:"true" enum:"ComparisonOperator"`

	// The dimensions for the metric associated with the alarm.
	Dimensions []*Dimension `type:"list"`

	// Used only for alarms based on percentiles. If you specify ignore, the alarm
	// state will not change during periods with too few data points to be statistically
	// significant. If you specify evaluate or omit this parameter, the alarm will
	// always be evaluated and possibly change state no matter how many data points
	// are available. For more information, see Percentile-Based CloudWatch Alarms
	// and Low Data Samples (http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#percentiles-with-low-samples).
	//
	// Valid Values: evaluate | ignore
	EvaluateLowSampleCountPercentile *string `min:"1" type:"string"`

	// The number of periods over which data is compared to the specified threshold.
	//
	// EvaluationPeriods is a required field
	EvaluationPeriods *int64 `min:"1" type:"integer" required:"true"`

	// The percentile statistic for the metric associated with the alarm. Specify
	// a value between p0.0 and p100.
	ExtendedStatistic *string `type:"string"`

	// The actions to execute when this alarm transitions to the INSUFFICIENT_DATA
	// state from any other state. Each action is specified as an Amazon Resource
	// Name (ARN).
	//
	// Valid Values: arn:aws:automate:region:ec2:stop | arn:aws:automate:region:ec2:terminate
	// | arn:aws:automate:region:ec2:recover
	//
	// Valid Values (for use with IAM roles): arn:aws:swf:us-east-1:{customer-account}:action/actions/AWS_EC2.InstanceId.Stop/1.0
	// | arn:aws:swf:us-east-1:{customer-account}:action/actions/AWS_EC2.InstanceId.Terminate/1.0
	// | arn:aws:swf:us-east-1:{customer-account}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
	InsufficientDataActions []*string `type:"list"`

	// The name for the metric associated with the alarm.
	//
	// MetricName is a required field
	MetricName *string `min:"1" type:"string" required:"true"`

	// The namespace for the metric associated with the alarm.
	//
	// Namespace is a required field
	Namespace *string `min:"1" type:"string" required:"true"`

	// The actions to execute when this alarm transitions to an OK state from any
	// other state. Each action is specified as an Amazon Resource Name (ARN).
	//
	// Valid Values: arn:aws:automate:region:ec2:stop | arn:aws:automate:region:ec2:terminate
	// | arn:aws:automate:region:ec2:recover
	//
	// Valid Values (for use with IAM roles): arn:aws:swf:us-east-1:{customer-account}:action/actions/AWS_EC2.InstanceId.Stop/1.0
	// | arn:aws:swf:us-east-1:{customer-account}:action/actions/AWS_EC2.InstanceId.Terminate/1.0
	// | arn:aws:swf:us-east-1:{customer-account}:action/actions/AWS_EC2.InstanceId.Reboot/1.0
	OKActions []*string `type:"list"`

	// The period, in seconds, over which the specified statistic is applied.
	//
	// Period is a required field
	Period *int64 `min:"60" type:"integer" required:"true"`

	// The statistic for the metric associated with the alarm, other than percentile.
	// For percentile statistics, use ExtendedStatistic.
	Statistic *string `type:"string" enum:"Statistic"`

	// The value against which the specified statistic is compared.
	//
	// Threshold is a required field
	Threshold *float64 `type:"double" required:"true"`

	// Sets how this alarm is to handle missing data points. If TreatMissingData
	// is omitted, the default behavior of missing is used. For more information,
	// see Configuring How CloudWatch Alarms Treats Missing Data (http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarms-and-missing-data).
	//
	// Valid Values: breaching | notBreaching | ignore | missing
	TreatMissingData *string `min:"1" type:"string"`

	// The unit of measure for the statistic. For example, the units for the Amazon
	// EC2 NetworkIn metric are Bytes because NetworkIn tracks the number of bytes
	// that an instance receives on all network interfaces. You can also specify
	// a unit when you create a custom metric. Units help provide conceptual meaning
	// to your data. Metric data points that specify a unit of measure, such as
	// Percent, are aggregated separately.
	//
	// If you specify a unit, you must use a unit that is appropriate for the metric.
	// Otherwise, the Amazon CloudWatch alarm can get stuck in the INSUFFICIENT
	// DATA state.
	Unit *string `type:"string" enum:"StandardUnit"`
}

// String returns the string representation
func (s PutMetricAlarmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutMetricAlarmInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutMetricAlarmInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutMetricAlarmInput"}
	if s.AlarmName == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmName"))
	}
	if s.AlarmName != nil && len(*s.AlarmName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlarmName", 1))
	}
	if s.ComparisonOperator == nil {
		invalidParams.Add(request.NewErrParamRequired("ComparisonOperator"))
	}
	if s.EvaluateLowSampleCountPercentile != nil && len(*s.EvaluateLowSampleCountPercentile) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EvaluateLowSampleCountPercentile", 1))
	}
	if s.EvaluationPeriods == nil {
		invalidParams.Add(request.NewErrParamRequired("EvaluationPeriods"))
	}
	if s.EvaluationPeriods != nil && *s.EvaluationPeriods < 1 {
		invalidParams.Add(request.NewErrParamMinValue("EvaluationPeriods", 1))
	}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Period == nil {
		invalidParams.Add(request.NewErrParamRequired("Period"))
	}
	if s.Period != nil && *s.Period < 60 {
		invalidParams.Add(request.NewErrParamMinValue("Period", 60))
	}
	if s.Threshold == nil {
		invalidParams.Add(request.NewErrParamRequired("Threshold"))
	}
	if s.TreatMissingData != nil && len(*s.TreatMissingData) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TreatMissingData", 1))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionsEnabled sets the ActionsEnabled field's value.
func (s *PutMetricAlarmInput) SetActionsEnabled(v bool) *PutMetricAlarmInput {
	s.ActionsEnabled = &v
	return s
}

// SetAlarmActions sets the AlarmActions field's value.
func (s *PutMetricAlarmInput) SetAlarmActions(v []*string) *PutMetricAlarmInput {
	s.AlarmActions = v
	return s
}

// SetAlarmDescription sets the AlarmDescription field's value.
func (s *PutMetricAlarmInput) SetAlarmDescription(v string) *PutMetricAlarmInput {
	s.AlarmDescription = &v
	return s
}

// SetAlarmName sets the AlarmName field's value.
func (s *PutMetricAlarmInput) SetAlarmName(v string) *PutMetricAlarmInput {
	s.AlarmName = &v
	return s
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *PutMetricAlarmInput) SetComparisonOperator(v string) *PutMetricAlarmInput {
	s.ComparisonOperator = &v
	return s
}

// SetDimensions sets the Dimensions field's value.
func (s *PutMetricAlarmInput) SetDimensions(v []*Dimension) *PutMetricAlarmInput {
	s.Dimensions = v
	return s
}

// SetEvaluateLowSampleCountPercentile sets the EvaluateLowSampleCountPercentile field's value.
func (s *PutMetricAlarmInput) SetEvaluateLowSampleCountPercentile(v string) *PutMetricAlarmInput {
	s.EvaluateLowSampleCountPercentile = &v
	return s
}

// SetEvaluationPeriods sets the EvaluationPeriods field's value.
func (s *PutMetricAlarmInput) SetEvaluationPeriods(v int64) *PutMetricAlarmInput {
	s.EvaluationPeriods = &v
	return s
}

// SetExtendedStatistic sets the ExtendedStatistic field's value.
func (s *PutMetricAlarmInput) SetExtendedStatistic(v string) *PutMetricAlarmInput {
	s.ExtendedStatistic = &v
	return s
}

// SetInsufficientDataActions sets the InsufficientDataActions field's value.
func (s *PutMetricAlarmInput) SetInsufficientDataActions(v []*string) *PutMetricAlarmInput {
	s.InsufficientDataActions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *PutMetricAlarmInput) SetMetricName(v string) *PutMetricAlarmInput {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *PutMetricAlarmInput) SetNamespace(v string) *PutMetricAlarmInput {
	s.Namespace = &v
	return s
}

// SetOKActions sets the OKActions field's value.
func (s *PutMetricAlarmInput) SetOKActions(v []*string) *PutMetricAlarmInput {
	s.OKActions = v
	return s
}

// SetPeriod sets the Period field's value.
func (s *PutMetricAlarmInput) SetPeriod(v int64) *PutMetricAlarmInput {
	s.Period = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *PutMetricAlarmInput) SetStatistic(v string) *PutMetricAlarmInput {
	s.Statistic = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *PutMetricAlarmInput) SetThreshold(v float64) *PutMetricAlarmInput {
	s.Threshold = &v
	return s
}

// SetTreatMissingData sets the TreatMissingData field's value.
func (s *PutMetricAlarmInput) SetTreatMissingData(v string) *PutMetricAlarmInput {
	s.TreatMissingData = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *PutMetricAlarmInput) SetUnit(v string) *PutMetricAlarmInput {
	s.Unit = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutMetricAlarmOutput
type PutMetricAlarmOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutMetricAlarmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutMetricAlarmOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutMetricDataInput
type PutMetricDataInput struct {
	_ struct{} `type:"structure"`

	// The data for the metric.
	//
	// MetricData is a required field
	MetricData []*MetricDatum `type:"list" required:"true"`

	// The namespace for the metric data.
	//
	// You cannot specify a namespace that begins with "AWS/". Namespaces that begin
	// with "AWS/" are reserved for use by Amazon Web Services products.
	//
	// Namespace is a required field
	Namespace *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutMetricDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutMetricDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutMetricDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutMetricDataInput"}
	if s.MetricData == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricData"))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.MetricData != nil {
		for i, v := range s.MetricData {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricData", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetricData sets the MetricData field's value.
func (s *PutMetricDataInput) SetMetricData(v []*MetricDatum) *PutMetricDataInput {
	s.MetricData = v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *PutMetricDataInput) SetNamespace(v string) *PutMetricDataInput {
	s.Namespace = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutMetricDataOutput
type PutMetricDataOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutMetricDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutMetricDataOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/SetAlarmStateInput
type SetAlarmStateInput struct {
	_ struct{} `type:"structure"`

	// The name for the alarm. This name must be unique within the AWS account.
	// The maximum length is 255 characters.
	//
	// AlarmName is a required field
	AlarmName *string `min:"1" type:"string" required:"true"`

	// The reason that this alarm is set to this specific state, in text format.
	//
	// StateReason is a required field
	StateReason *string `type:"string" required:"true"`

	// The reason that this alarm is set to this specific state, in JSON format.
	StateReasonData *string `type:"string"`

	// The value of the state.
	//
	// StateValue is a required field
	StateValue *string `type:"string" required:"true" enum:"StateValue"`
}

// String returns the string representation
func (s SetAlarmStateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetAlarmStateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetAlarmStateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetAlarmStateInput"}
	if s.AlarmName == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmName"))
	}
	if s.AlarmName != nil && len(*s.AlarmName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlarmName", 1))
	}
	if s.StateReason == nil {
		invalidParams.Add(request.NewErrParamRequired("StateReason"))
	}
	if s.StateValue == nil {
		invalidParams.Add(request.NewErrParamRequired("StateValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmName sets the AlarmName field's value.
func (s *SetAlarmStateInput) SetAlarmName(v string) *SetAlarmStateInput {
	s.AlarmName = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *SetAlarmStateInput) SetStateReason(v string) *SetAlarmStateInput {
	s.StateReason = &v
	return s
}

// SetStateReasonData sets the StateReasonData field's value.
func (s *SetAlarmStateInput) SetStateReasonData(v string) *SetAlarmStateInput {
	s.StateReasonData = &v
	return s
}

// SetStateValue sets the StateValue field's value.
func (s *SetAlarmStateInput) SetStateValue(v string) *SetAlarmStateInput {
	s.StateValue = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/SetAlarmStateOutput
type SetAlarmStateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetAlarmStateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetAlarmStateOutput) GoString() string {
	return s.String()
}

// Represents a set of statistics that describes a specific metric.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/StatisticSet
type StatisticSet struct {
	_ struct{} `type:"structure"`

	// The maximum value of the sample set.
	//
	// Maximum is a required field
	Maximum *float64 `type:"double" required:"true"`

	// The minimum value of the sample set.
	//
	// Minimum is a required field
	Minimum *float64 `type:"double" required:"true"`

	// The number of samples used for the statistic set.
	//
	// SampleCount is a required field
	SampleCount *float64 `type:"double" required:"true"`

	// The sum of values for the sample set.
	//
	// Sum is a required field
	Sum *float64 `type:"double" required:"true"`
}

// String returns the string representation
func (s StatisticSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StatisticSet) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StatisticSet) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StatisticSet"}
	if s.Maximum == nil {
		invalidParams.Add(request.NewErrParamRequired("Maximum"))
	}
	if s.Minimum == nil {
		invalidParams.Add(request.NewErrParamRequired("Minimum"))
	}
	if s.SampleCount == nil {
		invalidParams.Add(request.NewErrParamRequired("SampleCount"))
	}
	if s.Sum == nil {
		invalidParams.Add(request.NewErrParamRequired("Sum"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaximum sets the Maximum field's value.
func (s *StatisticSet) SetMaximum(v float64) *StatisticSet {
	s.Maximum = &v
	return s
}

// SetMinimum sets the Minimum field's value.
func (s *StatisticSet) SetMinimum(v float64) *StatisticSet {
	s.Minimum = &v
	return s
}

// SetSampleCount sets the SampleCount field's value.
func (s *StatisticSet) SetSampleCount(v float64) *StatisticSet {
	s.SampleCount = &v
	return s
}

// SetSum sets the Sum field's value.
func (s *StatisticSet) SetSum(v float64) *StatisticSet {
	s.Sum = &v
	return s
}

const (
	// ComparisonOperatorGreaterThanOrEqualToThreshold is a ComparisonOperator enum value
	ComparisonOperatorGreaterThanOrEqualToThreshold = "GreaterThanOrEqualToThreshold"

	// ComparisonOperatorGreaterThanThreshold is a ComparisonOperator enum value
	ComparisonOperatorGreaterThanThreshold = "GreaterThanThreshold"

	// ComparisonOperatorLessThanThreshold is a ComparisonOperator enum value
	ComparisonOperatorLessThanThreshold = "LessThanThreshold"

	// ComparisonOperatorLessThanOrEqualToThreshold is a ComparisonOperator enum value
	ComparisonOperatorLessThanOrEqualToThreshold = "LessThanOrEqualToThreshold"
)

const (
	// HistoryItemTypeConfigurationUpdate is a HistoryItemType enum value
	HistoryItemTypeConfigurationUpdate = "ConfigurationUpdate"

	// HistoryItemTypeStateUpdate is a HistoryItemType enum value
	HistoryItemTypeStateUpdate = "StateUpdate"

	// HistoryItemTypeAction is a HistoryItemType enum value
	HistoryItemTypeAction = "Action"
)

const (
	// StandardUnitSeconds is a StandardUnit enum value
	StandardUnitSeconds = "Seconds"

	// StandardUnitMicroseconds is a StandardUnit enum value
	StandardUnitMicroseconds = "Microseconds"

	// StandardUnitMilliseconds is a StandardUnit enum value
	StandardUnitMilliseconds = "Milliseconds"

	// StandardUnitBytes is a StandardUnit enum value
	StandardUnitBytes = "Bytes"

	// StandardUnitKilobytes is a StandardUnit enum value
	StandardUnitKilobytes = "Kilobytes"

	// StandardUnitMegabytes is a StandardUnit enum value
	StandardUnitMegabytes = "Megabytes"

	// StandardUnitGigabytes is a StandardUnit enum value
	StandardUnitGigabytes = "Gigabytes"

	// StandardUnitTerabytes is a StandardUnit enum value
	StandardUnitTerabytes = "Terabytes"

	// StandardUnitBits is a StandardUnit enum value
	StandardUnitBits = "Bits"

	// StandardUnitKilobits is a StandardUnit enum value
	StandardUnitKilobits = "Kilobits"

	// StandardUnitMegabits is a StandardUnit enum value
	StandardUnitMegabits = "Megabits"

	// StandardUnitGigabits is a StandardUnit enum value
	StandardUnitGigabits = "Gigabits"

	// StandardUnitTerabits is a StandardUnit enum value
	StandardUnitTerabits = "Terabits"

	// StandardUnitPercent is a StandardUnit enum value
	StandardUnitPercent = "Percent"

	// StandardUnitCount is a StandardUnit enum value
	StandardUnitCount = "Count"

	// StandardUnitBytesSecond is a StandardUnit enum value
	StandardUnitBytesSecond = "Bytes/Second"

	// StandardUnitKilobytesSecond is a StandardUnit enum value
	StandardUnitKilobytesSecond = "Kilobytes/Second"

	// StandardUnitMegabytesSecond is a StandardUnit enum value
	StandardUnitMegabytesSecond = "Megabytes/Second"

	// StandardUnitGigabytesSecond is a StandardUnit enum value
	StandardUnitGigabytesSecond = "Gigabytes/Second"

	// StandardUnitTerabytesSecond is a StandardUnit enum value
	StandardUnitTerabytesSecond = "Terabytes/Second"

	// StandardUnitBitsSecond is a StandardUnit enum value
	StandardUnitBitsSecond = "Bits/Second"

	// StandardUnitKilobitsSecond is a StandardUnit enum value
	StandardUnitKilobitsSecond = "Kilobits/Second"

	// StandardUnitMegabitsSecond is a StandardUnit enum value
	StandardUnitMegabitsSecond = "Megabits/Second"

	// StandardUnitGigabitsSecond is a StandardUnit enum value
	StandardUnitGigabitsSecond = "Gigabits/Second"

	// StandardUnitTerabitsSecond is a StandardUnit enum value
	StandardUnitTerabitsSecond = "Terabits/Second"

	// StandardUnitCountSecond is a StandardUnit enum value
	StandardUnitCountSecond = "Count/Second"

	// StandardUnitNone is a StandardUnit enum value
	StandardUnitNone = "None"
)

const (
	// StateValueOk is a StateValue enum value
	StateValueOk = "OK"

	// StateValueAlarm is a StateValue enum value
	StateValueAlarm = "ALARM"

	// StateValueInsufficientData is a StateValue enum value
	StateValueInsufficientData = "INSUFFICIENT_DATA"
)

const (
	// StatisticSampleCount is a Statistic enum value
	StatisticSampleCount = "SampleCount"

	// StatisticAverage is a Statistic enum value
	StatisticAverage = "Average"

	// StatisticSum is a Statistic enum value
	StatisticSum = "Sum"

	// StatisticMinimum is a Statistic enum value
	StatisticMinimum = "Minimum"

	// StatisticMaximum is a Statistic enum value
	StatisticMaximum = "Maximum"
)
