// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elb_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/elb"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleELB_AddTags() {
	sess := session.Must(session.NewSession())

	svc := elb.New(sess)

	params := &elb.AddTagsInput{
		LoadBalancerNames: []*string{ // Required
			aws.String("AccessPointName"), // Required
			// More values...
		},
		Tags: []*elb.Tag{ // Required
			{ // Required
				Key:   aws.String("TagKey"), // Required
				Value: aws.String("TagValue"),
			},
			// More values...
		},
	}
	resp, err := svc.AddTags(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleELB_ApplySecurityGroupsToLoadBalancer() {
	sess := session.Must(session.NewSession())

	svc := elb.New(sess)

	params := &elb.ApplySecurityGroupsToLoadBalancerInput{
		LoadBalancerName: aws.String("AccessPointName"), // Required
		SecurityGroups: []*string{ // Required
			aws.String("SecurityGroupId"), // Required
			// More values...
		},
	}
	resp, err := svc.ApplySecurityGroupsToLoadBalancer(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleELB_AttachLoadBalancerToSubnets() {
	sess := session.Must(session.NewSession())

	svc := elb.New(sess)

	params := &elb.AttachLoadBalancerToSubnetsInput{
		LoadBalancerName: aws.String("AccessPointName"), // Required
		Subnets: []*string{ // Required
			aws.String("SubnetId"), // Required
			// More values...
		},
	}
	resp, err := svc.AttachLoadBalancerToSubnets(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleELB_ConfigureHealthCheck() {
	sess := session.Must(session.NewSession())

	svc := elb.New(sess)

	params := &elb.ConfigureHealthCheckInput{
		HealthCheck: &elb.HealthCheck{ // Required
			HealthyThreshold:   aws.Int64(1),                    // Required
			Interval:           aws.Int64(1),                    // Required
			Target:             aws.String("HealthCheckTarget"), // Required
			Timeout:            aws.Int64(1),                    // Required
			UnhealthyThreshold: aws.Int64(1),                    // Required
		},
		LoadBalancerName: aws.String("AccessPointName"), // Required
	}
	resp, err := svc.ConfigureHealthCheck(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleELB_CreateAppCookieStickinessPolicy() {
	sess := session.Must(session.NewSession())

	svc := elb.New(sess)

	params := &elb.CreateAppCookieStickinessPolicyInput{
		CookieName:       aws.String("CookieName"),      // Required
		LoadBalancerName: aws.String("AccessPointName"), // Required
		PolicyName:       aws.String("PolicyName"),      // Required
	}
	resp, err := svc.CreateAppCookieStickinessPolicy(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleELB_CreateLBCookieStickinessPolicy() {
	sess := session.Must(session.NewSession())

	svc := elb.New(sess)

	params := &elb.CreateLBCookieStickinessPolicyInput{
		LoadBalancerName:       aws.String("AccessPointName"), // Required
		PolicyName:             aws.String("PolicyName"),      // Required
		CookieExpirationPeriod: aws.Int64(1),
	}
	resp, err := svc.CreateLBCookieStickinessPolicy(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleELB_CreateLoadBalancer() {
	sess := session.Must(session.NewSession())

	svc := elb.New(sess)

	params := &elb.CreateLoadBalancerInput{
		Listeners: []*elb.Listener{ // Required
			{ // Required
				InstancePort:     aws.Int64(1),           // Required
				LoadBalancerPort: aws.Int64(1),           // Required
				Protocol:         aws.String("Protocol"), // Required
				InstanceProtocol: aws.String("Protocol"),
				SSLCertificateId: aws.String("SSLCertificateId"),
			},
			// More values...
		},
		LoadBalancerName: aws.String("AccessPointName"), // Required
		AvailabilityZones: []*string{
			aws.String("AvailabilityZone"), // Required
			// More values...
		},
		Scheme: aws.String("LoadBalancerScheme"),
		SecurityGroups: []*string{
			aws.String("SecurityGroupId"), // Required
			// More values...
		},
		Subnets: []*string{
			aws.String("SubnetId"), // Required
			// More values...
		},
		Tags: []*elb.Tag{
			{ // Required
				Key:   aws.String("TagKey"), // Required
				Value: aws.String("TagValue"),
			},
			// More values...
		},
	}
	resp, err := svc.CreateLoadBalancer(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleELB_CreateLoadBalancerListeners() {
	sess := session.Must(session.NewSession())

	svc := elb.New(sess)

	params := &elb.CreateLoadBalancerListenersInput{
		Listeners: []*elb.Listener{ // Required
			{ // Required
				InstancePort:     aws.Int64(1),           // Required
				LoadBalancerPort: aws.Int64(1),           // Required
				Protocol:         aws.String("Protocol"), // Required
				InstanceProtocol: aws.String("Protocol"),
				SSLCertificateId: aws.String("SSLCertificateId"),
			},
			// More values...
		},
		LoadBalancerName: aws.String("AccessPointName"), // Required
	}
	resp, err := svc.CreateLoadBalancerListeners(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleELB_CreateLoadBalancerPolicy() {
	sess := session.Must(session.NewSession())

	svc := elb.New(sess)

	params := &elb.CreateLoadBalancerPolicyInput{
		LoadBalancerName: aws.String("AccessPointName"), // Required
		PolicyName:       aws.String("PolicyName"),      // Required
		PolicyTypeName:   aws.String("PolicyTypeName"),  // Required
		PolicyAttributes: []*elb.PolicyAttribute{
			{ // Required
				AttributeName:  aws.String("AttributeName"),
				AttributeValue: aws.String("AttributeValue"),
			},
			// More values...
		},
	}
	resp, err := svc.CreateLoadBalancerPolicy(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleELB_DeleteLoadBalancer() {
	sess := session.Must(session.NewSession())

	svc := elb.New(sess)

	params := &elb.DeleteLoadBalancerInput{
		LoadBalancerName: aws.String("AccessPointName"), // Required
	}
	resp, err := svc.DeleteLoadBalancer(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleELB_DeleteLoadBalancerListeners() {
	sess := session.Must(session.NewSession())

	svc := elb.New(sess)

	params := &elb.DeleteLoadBalancerListenersInput{
		LoadBalancerName: aws.String("AccessPointName"), // Required
		LoadBalancerPorts: []*int64{ // Required
			aws.Int64(1), // Required
			// More values...
		},
	}
	resp, err := svc.DeleteLoadBalancerListeners(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleELB_DeleteLoadBalancerPolicy() {
	sess := session.Must(session.NewSession())

	svc := elb.New(sess)

	params := &elb.DeleteLoadBalancerPolicyInput{
		LoadBalancerName: aws.String("AccessPointName"), // Required
		PolicyName:       aws.String("PolicyName"),      // Required
	}
	resp, err := svc.DeleteLoadBalancerPolicy(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleELB_DeregisterInstancesFromLoadBalancer() {
	sess := session.Must(session.NewSession())

	svc := elb.New(sess)

	params := &elb.DeregisterInstancesFromLoadBalancerInput{
		Instances: []*elb.Instance{ // Required
			{ // Required
				InstanceId: aws.String("InstanceId"),
			},
			// More values...
		},
		LoadBalancerName: aws.String("AccessPointName"), // Required
	}
	resp, err := svc.DeregisterInstancesFromLoadBalancer(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleELB_DescribeInstanceHealth() {
	sess := session.Must(session.NewSession())

	svc := elb.New(sess)

	params := &elb.DescribeInstanceHealthInput{
		LoadBalancerName: aws.String("AccessPointName"), // Required
		Instances: []*elb.Instance{
			{ // Required
				InstanceId: aws.String("InstanceId"),
			},
			// More values...
		},
	}
	resp, err := svc.DescribeInstanceHealth(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleELB_DescribeLoadBalancerAttributes() {
	sess := session.Must(session.NewSession())

	svc := elb.New(sess)

	params := &elb.DescribeLoadBalancerAttributesInput{
		LoadBalancerName: aws.String("AccessPointName"), // Required
	}
	resp, err := svc.DescribeLoadBalancerAttributes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleELB_DescribeLoadBalancerPolicies() {
	sess := session.Must(session.NewSession())

	svc := elb.New(sess)

	params := &elb.DescribeLoadBalancerPoliciesInput{
		LoadBalancerName: aws.String("AccessPointName"),
		PolicyNames: []*string{
			aws.String("PolicyName"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeLoadBalancerPolicies(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleELB_DescribeLoadBalancerPolicyTypes() {
	sess := session.Must(session.NewSession())

	svc := elb.New(sess)

	params := &elb.DescribeLoadBalancerPolicyTypesInput{
		PolicyTypeNames: []*string{
			aws.String("PolicyTypeName"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeLoadBalancerPolicyTypes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleELB_DescribeLoadBalancers() {
	sess := session.Must(session.NewSession())

	svc := elb.New(sess)

	params := &elb.DescribeLoadBalancersInput{
		LoadBalancerNames: []*string{
			aws.String("AccessPointName"), // Required
			// More values...
		},
		Marker:   aws.String("Marker"),
		PageSize: aws.Int64(1),
	}
	resp, err := svc.DescribeLoadBalancers(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleELB_DescribeTags() {
	sess := session.Must(session.NewSession())

	svc := elb.New(sess)

	params := &elb.DescribeTagsInput{
		LoadBalancerNames: []*string{ // Required
			aws.String("AccessPointName"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeTags(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleELB_DetachLoadBalancerFromSubnets() {
	sess := session.Must(session.NewSession())

	svc := elb.New(sess)

	params := &elb.DetachLoadBalancerFromSubnetsInput{
		LoadBalancerName: aws.String("AccessPointName"), // Required
		Subnets: []*string{ // Required
			aws.String("SubnetId"), // Required
			// More values...
		},
	}
	resp, err := svc.DetachLoadBalancerFromSubnets(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleELB_DisableAvailabilityZonesForLoadBalancer() {
	sess := session.Must(session.NewSession())

	svc := elb.New(sess)

	params := &elb.DisableAvailabilityZonesForLoadBalancerInput{
		AvailabilityZones: []*string{ // Required
			aws.String("AvailabilityZone"), // Required
			// More values...
		},
		LoadBalancerName: aws.String("AccessPointName"), // Required
	}
	resp, err := svc.DisableAvailabilityZonesForLoadBalancer(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleELB_EnableAvailabilityZonesForLoadBalancer() {
	sess := session.Must(session.NewSession())

	svc := elb.New(sess)

	params := &elb.EnableAvailabilityZonesForLoadBalancerInput{
		AvailabilityZones: []*string{ // Required
			aws.String("AvailabilityZone"), // Required
			// More values...
		},
		LoadBalancerName: aws.String("AccessPointName"), // Required
	}
	resp, err := svc.EnableAvailabilityZonesForLoadBalancer(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleELB_ModifyLoadBalancerAttributes() {
	sess := session.Must(session.NewSession())

	svc := elb.New(sess)

	params := &elb.ModifyLoadBalancerAttributesInput{
		LoadBalancerAttributes: &elb.LoadBalancerAttributes{ // Required
			AccessLog: &elb.AccessLog{
				Enabled:        aws.Bool(true), // Required
				EmitInterval:   aws.Int64(1),
				S3BucketName:   aws.String("S3BucketName"),
				S3BucketPrefix: aws.String("AccessLogPrefix"),
			},
			AdditionalAttributes: []*elb.AdditionalAttribute{
				{ // Required
					Key:   aws.String("AdditionalAttributeKey"),
					Value: aws.String("AdditionalAttributeValue"),
				},
				// More values...
			},
			ConnectionDraining: &elb.ConnectionDraining{
				Enabled: aws.Bool(true), // Required
				Timeout: aws.Int64(1),
			},
			ConnectionSettings: &elb.ConnectionSettings{
				IdleTimeout: aws.Int64(1), // Required
			},
			CrossZoneLoadBalancing: &elb.CrossZoneLoadBalancing{
				Enabled: aws.Bool(true), // Required
			},
		},
		LoadBalancerName: aws.String("AccessPointName"), // Required
	}
	resp, err := svc.ModifyLoadBalancerAttributes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleELB_RegisterInstancesWithLoadBalancer() {
	sess := session.Must(session.NewSession())

	svc := elb.New(sess)

	params := &elb.RegisterInstancesWithLoadBalancerInput{
		Instances: []*elb.Instance{ // Required
			{ // Required
				InstanceId: aws.String("InstanceId"),
			},
			// More values...
		},
		LoadBalancerName: aws.String("AccessPointName"), // Required
	}
	resp, err := svc.RegisterInstancesWithLoadBalancer(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleELB_RemoveTags() {
	sess := session.Must(session.NewSession())

	svc := elb.New(sess)

	params := &elb.RemoveTagsInput{
		LoadBalancerNames: []*string{ // Required
			aws.String("AccessPointName"), // Required
			// More values...
		},
		Tags: []*elb.TagKeyOnly{ // Required
			{ // Required
				Key: aws.String("TagKey"),
			},
			// More values...
		},
	}
	resp, err := svc.RemoveTags(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleELB_SetLoadBalancerListenerSSLCertificate() {
	sess := session.Must(session.NewSession())

	svc := elb.New(sess)

	params := &elb.SetLoadBalancerListenerSSLCertificateInput{
		LoadBalancerName: aws.String("AccessPointName"),  // Required
		LoadBalancerPort: aws.Int64(1),                   // Required
		SSLCertificateId: aws.String("SSLCertificateId"), // Required
	}
	resp, err := svc.SetLoadBalancerListenerSSLCertificate(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleELB_SetLoadBalancerPoliciesForBackendServer() {
	sess := session.Must(session.NewSession())

	svc := elb.New(sess)

	params := &elb.SetLoadBalancerPoliciesForBackendServerInput{
		InstancePort:     aws.Int64(1),                  // Required
		LoadBalancerName: aws.String("AccessPointName"), // Required
		PolicyNames: []*string{ // Required
			aws.String("PolicyName"), // Required
			// More values...
		},
	}
	resp, err := svc.SetLoadBalancerPoliciesForBackendServer(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleELB_SetLoadBalancerPoliciesOfListener() {
	sess := session.Must(session.NewSession())

	svc := elb.New(sess)

	params := &elb.SetLoadBalancerPoliciesOfListenerInput{
		LoadBalancerName: aws.String("AccessPointName"), // Required
		LoadBalancerPort: aws.Int64(1),                  // Required
		PolicyNames: []*string{ // Required
			aws.String("PolicyName"), // Required
			// More values...
		},
	}
	resp, err := svc.SetLoadBalancerPoliciesOfListener(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
