// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package iot provides a client for AWS IoT.
package iot

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAcceptCertificateTransfer = "AcceptCertificateTransfer"

// AcceptCertificateTransferRequest generates a "aws/request.Request" representing the
// client's request for the AcceptCertificateTransfer operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AcceptCertificateTransfer for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AcceptCertificateTransfer method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AcceptCertificateTransferRequest method.
//    req, resp := client.AcceptCertificateTransferRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) AcceptCertificateTransferRequest(input *AcceptCertificateTransferInput) (req *request.Request, output *AcceptCertificateTransferOutput) {
	op := &request.Operation{
		Name:       opAcceptCertificateTransfer,
		HTTPMethod: "PATCH",
		HTTPPath:   "/accept-certificate-transfer/{certificateId}",
	}

	if input == nil {
		input = &AcceptCertificateTransferInput{}
	}

	output = &AcceptCertificateTransferOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// AcceptCertificateTransfer API operation for AWS IoT.
//
// Accepts a pending certificate transfer. The default state of the certificate
// is INACTIVE.
//
// To check for pending certificate transfers, call ListCertificates to enumerate
// your certificates.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation AcceptCertificateTransfer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeTransferAlreadyCompletedException "TransferAlreadyCompletedException"
//   You can't revert the certificate transfer because the transfer is already
//   complete.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) AcceptCertificateTransfer(input *AcceptCertificateTransferInput) (*AcceptCertificateTransferOutput, error) {
	req, out := c.AcceptCertificateTransferRequest(input)
	return out, req.Send()
}

// AcceptCertificateTransferWithContext is the same as AcceptCertificateTransfer with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptCertificateTransfer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) AcceptCertificateTransferWithContext(ctx aws.Context, input *AcceptCertificateTransferInput, opts ...request.Option) (*AcceptCertificateTransferOutput, error) {
	req, out := c.AcceptCertificateTransferRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachPrincipalPolicy = "AttachPrincipalPolicy"

// AttachPrincipalPolicyRequest generates a "aws/request.Request" representing the
// client's request for the AttachPrincipalPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AttachPrincipalPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AttachPrincipalPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AttachPrincipalPolicyRequest method.
//    req, resp := client.AttachPrincipalPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) AttachPrincipalPolicyRequest(input *AttachPrincipalPolicyInput) (req *request.Request, output *AttachPrincipalPolicyOutput) {
	op := &request.Operation{
		Name:       opAttachPrincipalPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/principal-policies/{policyName}",
	}

	if input == nil {
		input = &AttachPrincipalPolicyInput{}
	}

	output = &AttachPrincipalPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// AttachPrincipalPolicy API operation for AWS IoT.
//
// Attaches the specified policy to the specified principal (certificate or
// other credential).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation AttachPrincipalPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The number of attached entities exceeds the limit.
//
func (c *IoT) AttachPrincipalPolicy(input *AttachPrincipalPolicyInput) (*AttachPrincipalPolicyOutput, error) {
	req, out := c.AttachPrincipalPolicyRequest(input)
	return out, req.Send()
}

// AttachPrincipalPolicyWithContext is the same as AttachPrincipalPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See AttachPrincipalPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) AttachPrincipalPolicyWithContext(ctx aws.Context, input *AttachPrincipalPolicyInput, opts ...request.Option) (*AttachPrincipalPolicyOutput, error) {
	req, out := c.AttachPrincipalPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachThingPrincipal = "AttachThingPrincipal"

// AttachThingPrincipalRequest generates a "aws/request.Request" representing the
// client's request for the AttachThingPrincipal operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AttachThingPrincipal for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AttachThingPrincipal method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AttachThingPrincipalRequest method.
//    req, resp := client.AttachThingPrincipalRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) AttachThingPrincipalRequest(input *AttachThingPrincipalInput) (req *request.Request, output *AttachThingPrincipalOutput) {
	op := &request.Operation{
		Name:       opAttachThingPrincipal,
		HTTPMethod: "PUT",
		HTTPPath:   "/things/{thingName}/principals",
	}

	if input == nil {
		input = &AttachThingPrincipalInput{}
	}

	output = &AttachThingPrincipalOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AttachThingPrincipal API operation for AWS IoT.
//
// Attaches the specified principal to the specified thing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation AttachThingPrincipal for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) AttachThingPrincipal(input *AttachThingPrincipalInput) (*AttachThingPrincipalOutput, error) {
	req, out := c.AttachThingPrincipalRequest(input)
	return out, req.Send()
}

// AttachThingPrincipalWithContext is the same as AttachThingPrincipal with the addition of
// the ability to pass a context and additional request options.
//
// See AttachThingPrincipal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) AttachThingPrincipalWithContext(ctx aws.Context, input *AttachThingPrincipalInput, opts ...request.Option) (*AttachThingPrincipalOutput, error) {
	req, out := c.AttachThingPrincipalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelCertificateTransfer = "CancelCertificateTransfer"

// CancelCertificateTransferRequest generates a "aws/request.Request" representing the
// client's request for the CancelCertificateTransfer operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CancelCertificateTransfer for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CancelCertificateTransfer method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CancelCertificateTransferRequest method.
//    req, resp := client.CancelCertificateTransferRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CancelCertificateTransferRequest(input *CancelCertificateTransferInput) (req *request.Request, output *CancelCertificateTransferOutput) {
	op := &request.Operation{
		Name:       opCancelCertificateTransfer,
		HTTPMethod: "PATCH",
		HTTPPath:   "/cancel-certificate-transfer/{certificateId}",
	}

	if input == nil {
		input = &CancelCertificateTransferInput{}
	}

	output = &CancelCertificateTransferOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelCertificateTransfer API operation for AWS IoT.
//
// Cancels a pending transfer for the specified certificate.
//
// Note Only the transfer source account can use this operation to cancel a
// transfer. (Transfer destinations can use RejectCertificateTransfer instead.)
// After transfer, AWS IoT returns the certificate to the source account in
// the INACTIVE state. After the destination account has accepted the transfer,
// the transfer cannot be cancelled.
//
// After a certificate transfer is cancelled, the status of the certificate
// changes from PENDING_TRANSFER to INACTIVE.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CancelCertificateTransfer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeTransferAlreadyCompletedException "TransferAlreadyCompletedException"
//   You can't revert the certificate transfer because the transfer is already
//   complete.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) CancelCertificateTransfer(input *CancelCertificateTransferInput) (*CancelCertificateTransferOutput, error) {
	req, out := c.CancelCertificateTransferRequest(input)
	return out, req.Send()
}

// CancelCertificateTransferWithContext is the same as CancelCertificateTransfer with the addition of
// the ability to pass a context and additional request options.
//
// See CancelCertificateTransfer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CancelCertificateTransferWithContext(ctx aws.Context, input *CancelCertificateTransferInput, opts ...request.Option) (*CancelCertificateTransferOutput, error) {
	req, out := c.CancelCertificateTransferRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCertificateFromCsr = "CreateCertificateFromCsr"

// CreateCertificateFromCsrRequest generates a "aws/request.Request" representing the
// client's request for the CreateCertificateFromCsr operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateCertificateFromCsr for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateCertificateFromCsr method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateCertificateFromCsrRequest method.
//    req, resp := client.CreateCertificateFromCsrRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateCertificateFromCsrRequest(input *CreateCertificateFromCsrInput) (req *request.Request, output *CreateCertificateFromCsrOutput) {
	op := &request.Operation{
		Name:       opCreateCertificateFromCsr,
		HTTPMethod: "POST",
		HTTPPath:   "/certificates",
	}

	if input == nil {
		input = &CreateCertificateFromCsrInput{}
	}

	output = &CreateCertificateFromCsrOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCertificateFromCsr API operation for AWS IoT.
//
// Creates an X.509 certificate using the specified certificate signing request.
//
// Note Reusing the same certificate signing request (CSR) results in a distinct
// certificate.
//
// You can create multiple certificates in a batch by creating a directory,
// copying multiple .csr files into that directory, and then specifying that
// directory on the command line. The following commands show how to create
// a batch of certificates given a batch of CSRs.
//
// Assuming a set of CSRs are located inside of the directory my-csr-directory:
//
// On Linux and OS X, the command is:
//
// $ ls my-csr-directory/ | xargs -I {} aws iot create-certificate-from-csr
// --certificate-signing-request file://my-csr-directory/{}
//
// This command lists all of the CSRs in my-csr-directory and pipes each CSR
// file name to the aws iot create-certificate-from-csr AWS CLI command to create
// a certificate for the corresponding CSR.
//
// The aws iot create-certificate-from-csr part of the command can also be run
// in parallel to speed up the certificate creation process:
//
// $ ls my-csr-directory/ | xargs -P 10 -I {} aws iot create-certificate-from-csr
// --certificate-signing-request file://my-csr-directory/{}
//
// On Windows PowerShell, the command to create certificates for all CSRs in
// my-csr-directory is:
//
// > ls -Name my-csr-directory | %{aws iot create-certificate-from-csr --certificate-signing-request
// file://my-csr-directory/$_}
//
// On a Windows command prompt, the command to create certificates for all CSRs
// in my-csr-directory is:
//
// > forfiles /p my-csr-directory /c "cmd /c aws iot create-certificate-from-csr
// --certificate-signing-request file://@path"
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateCertificateFromCsr for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) CreateCertificateFromCsr(input *CreateCertificateFromCsrInput) (*CreateCertificateFromCsrOutput, error) {
	req, out := c.CreateCertificateFromCsrRequest(input)
	return out, req.Send()
}

// CreateCertificateFromCsrWithContext is the same as CreateCertificateFromCsr with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCertificateFromCsr for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateCertificateFromCsrWithContext(ctx aws.Context, input *CreateCertificateFromCsrInput, opts ...request.Option) (*CreateCertificateFromCsrOutput, error) {
	req, out := c.CreateCertificateFromCsrRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateKeysAndCertificate = "CreateKeysAndCertificate"

// CreateKeysAndCertificateRequest generates a "aws/request.Request" representing the
// client's request for the CreateKeysAndCertificate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateKeysAndCertificate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateKeysAndCertificate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateKeysAndCertificateRequest method.
//    req, resp := client.CreateKeysAndCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateKeysAndCertificateRequest(input *CreateKeysAndCertificateInput) (req *request.Request, output *CreateKeysAndCertificateOutput) {
	op := &request.Operation{
		Name:       opCreateKeysAndCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/keys-and-certificate",
	}

	if input == nil {
		input = &CreateKeysAndCertificateInput{}
	}

	output = &CreateKeysAndCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateKeysAndCertificate API operation for AWS IoT.
//
// Creates a 2048-bit RSA key pair and issues an X.509 certificate using the
// issued public key.
//
// Note This is the only time AWS IoT issues the private key for this certificate,
// so it is important to keep it in a secure location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateKeysAndCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) CreateKeysAndCertificate(input *CreateKeysAndCertificateInput) (*CreateKeysAndCertificateOutput, error) {
	req, out := c.CreateKeysAndCertificateRequest(input)
	return out, req.Send()
}

// CreateKeysAndCertificateWithContext is the same as CreateKeysAndCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKeysAndCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateKeysAndCertificateWithContext(ctx aws.Context, input *CreateKeysAndCertificateInput, opts ...request.Option) (*CreateKeysAndCertificateOutput, error) {
	req, out := c.CreateKeysAndCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePolicy = "CreatePolicy"

// CreatePolicyRequest generates a "aws/request.Request" representing the
// client's request for the CreatePolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreatePolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreatePolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreatePolicyRequest method.
//    req, resp := client.CreatePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreatePolicyRequest(input *CreatePolicyInput) (req *request.Request, output *CreatePolicyOutput) {
	op := &request.Operation{
		Name:       opCreatePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/policies/{policyName}",
	}

	if input == nil {
		input = &CreatePolicyInput{}
	}

	output = &CreatePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePolicy API operation for AWS IoT.
//
// Creates an AWS IoT policy.
//
// The created policy is the default version for the policy. This operation
// creates a policy version with a version identifier of 1 and sets 1 as the
// policy's default version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreatePolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The resource already exists.
//
//   * ErrCodeMalformedPolicyException "MalformedPolicyException"
//   The policy documentation is not valid.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) CreatePolicy(input *CreatePolicyInput) (*CreatePolicyOutput, error) {
	req, out := c.CreatePolicyRequest(input)
	return out, req.Send()
}

// CreatePolicyWithContext is the same as CreatePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreatePolicyWithContext(ctx aws.Context, input *CreatePolicyInput, opts ...request.Option) (*CreatePolicyOutput, error) {
	req, out := c.CreatePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePolicyVersion = "CreatePolicyVersion"

// CreatePolicyVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreatePolicyVersion operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreatePolicyVersion for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreatePolicyVersion method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreatePolicyVersionRequest method.
//    req, resp := client.CreatePolicyVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreatePolicyVersionRequest(input *CreatePolicyVersionInput) (req *request.Request, output *CreatePolicyVersionOutput) {
	op := &request.Operation{
		Name:       opCreatePolicyVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/policies/{policyName}/version",
	}

	if input == nil {
		input = &CreatePolicyVersionInput{}
	}

	output = &CreatePolicyVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePolicyVersion API operation for AWS IoT.
//
// Creates a new version of the specified AWS IoT policy. To update a policy,
// create a new policy version. A managed policy can have up to five versions.
// If the policy has five versions, you must use DeletePolicyVersion to delete
// an existing version before you create a new one.
//
// Optionally, you can set the new version as the policy's default version.
// The default version is the operative version (that is, the version that is
// in effect for the certificates to which the policy is attached).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreatePolicyVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeMalformedPolicyException "MalformedPolicyException"
//   The policy documentation is not valid.
//
//   * ErrCodeVersionsLimitExceededException "VersionsLimitExceededException"
//   The number of policy versions exceeds the limit.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) CreatePolicyVersion(input *CreatePolicyVersionInput) (*CreatePolicyVersionOutput, error) {
	req, out := c.CreatePolicyVersionRequest(input)
	return out, req.Send()
}

// CreatePolicyVersionWithContext is the same as CreatePolicyVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePolicyVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreatePolicyVersionWithContext(ctx aws.Context, input *CreatePolicyVersionInput, opts ...request.Option) (*CreatePolicyVersionOutput, error) {
	req, out := c.CreatePolicyVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateThing = "CreateThing"

// CreateThingRequest generates a "aws/request.Request" representing the
// client's request for the CreateThing operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateThing for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateThing method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateThingRequest method.
//    req, resp := client.CreateThingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateThingRequest(input *CreateThingInput) (req *request.Request, output *CreateThingOutput) {
	op := &request.Operation{
		Name:       opCreateThing,
		HTTPMethod: "POST",
		HTTPPath:   "/things/{thingName}",
	}

	if input == nil {
		input = &CreateThingInput{}
	}

	output = &CreateThingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateThing API operation for AWS IoT.
//
// Creates a thing record in the thing registry.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateThing for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The resource already exists.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) CreateThing(input *CreateThingInput) (*CreateThingOutput, error) {
	req, out := c.CreateThingRequest(input)
	return out, req.Send()
}

// CreateThingWithContext is the same as CreateThing with the addition of
// the ability to pass a context and additional request options.
//
// See CreateThing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateThingWithContext(ctx aws.Context, input *CreateThingInput, opts ...request.Option) (*CreateThingOutput, error) {
	req, out := c.CreateThingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateThingType = "CreateThingType"

// CreateThingTypeRequest generates a "aws/request.Request" representing the
// client's request for the CreateThingType operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateThingType for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateThingType method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateThingTypeRequest method.
//    req, resp := client.CreateThingTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateThingTypeRequest(input *CreateThingTypeInput) (req *request.Request, output *CreateThingTypeOutput) {
	op := &request.Operation{
		Name:       opCreateThingType,
		HTTPMethod: "POST",
		HTTPPath:   "/thing-types/{thingTypeName}",
	}

	if input == nil {
		input = &CreateThingTypeInput{}
	}

	output = &CreateThingTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateThingType API operation for AWS IoT.
//
// Creates a new thing type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateThingType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The resource already exists.
//
func (c *IoT) CreateThingType(input *CreateThingTypeInput) (*CreateThingTypeOutput, error) {
	req, out := c.CreateThingTypeRequest(input)
	return out, req.Send()
}

// CreateThingTypeWithContext is the same as CreateThingType with the addition of
// the ability to pass a context and additional request options.
//
// See CreateThingType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateThingTypeWithContext(ctx aws.Context, input *CreateThingTypeInput, opts ...request.Option) (*CreateThingTypeOutput, error) {
	req, out := c.CreateThingTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTopicRule = "CreateTopicRule"

// CreateTopicRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateTopicRule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateTopicRule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateTopicRule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateTopicRuleRequest method.
//    req, resp := client.CreateTopicRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) CreateTopicRuleRequest(input *CreateTopicRuleInput) (req *request.Request, output *CreateTopicRuleOutput) {
	op := &request.Operation{
		Name:       opCreateTopicRule,
		HTTPMethod: "POST",
		HTTPPath:   "/rules/{ruleName}",
	}

	if input == nil {
		input = &CreateTopicRuleInput{}
	}

	output = &CreateTopicRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateTopicRule API operation for AWS IoT.
//
// Creates a rule. Creating rules is an administrator-level action. Any user
// who has permission to create rules will be able to access data processed
// by the rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation CreateTopicRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSqlParseException "SqlParseException"
//   The Rule-SQL expression can't be parsed correctly.
//
//   * ErrCodeInternalException "InternalException"
//   An unexpected error has occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The resource already exists.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
func (c *IoT) CreateTopicRule(input *CreateTopicRuleInput) (*CreateTopicRuleOutput, error) {
	req, out := c.CreateTopicRuleRequest(input)
	return out, req.Send()
}

// CreateTopicRuleWithContext is the same as CreateTopicRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTopicRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) CreateTopicRuleWithContext(ctx aws.Context, input *CreateTopicRuleInput, opts ...request.Option) (*CreateTopicRuleOutput, error) {
	req, out := c.CreateTopicRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCACertificate = "DeleteCACertificate"

// DeleteCACertificateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCACertificate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteCACertificate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteCACertificate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteCACertificateRequest method.
//    req, resp := client.DeleteCACertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteCACertificateRequest(input *DeleteCACertificateInput) (req *request.Request, output *DeleteCACertificateOutput) {
	op := &request.Operation{
		Name:       opDeleteCACertificate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/cacertificate/{caCertificateId}",
	}

	if input == nil {
		input = &DeleteCACertificateInput{}
	}

	output = &DeleteCACertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCACertificate API operation for AWS IoT.
//
// Deletes a registered CA certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteCACertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeCertificateStateException "CertificateStateException"
//   The certificate operation is not allowed.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) DeleteCACertificate(input *DeleteCACertificateInput) (*DeleteCACertificateOutput, error) {
	req, out := c.DeleteCACertificateRequest(input)
	return out, req.Send()
}

// DeleteCACertificateWithContext is the same as DeleteCACertificate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCACertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteCACertificateWithContext(ctx aws.Context, input *DeleteCACertificateInput, opts ...request.Option) (*DeleteCACertificateOutput, error) {
	req, out := c.DeleteCACertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCertificate = "DeleteCertificate"

// DeleteCertificateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCertificate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteCertificate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteCertificate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteCertificateRequest method.
//    req, resp := client.DeleteCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteCertificateRequest(input *DeleteCertificateInput) (req *request.Request, output *DeleteCertificateOutput) {
	op := &request.Operation{
		Name:       opDeleteCertificate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/certificates/{certificateId}",
	}

	if input == nil {
		input = &DeleteCertificateInput{}
	}

	output = &DeleteCertificateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCertificate API operation for AWS IoT.
//
// Deletes the specified certificate.
//
// A certificate cannot be deleted if it has a policy attached to it or if its
// status is set to ACTIVE. To delete a certificate, first use the DetachPrincipalPolicy
// API to detach all policies. Next, use the UpdateCertificate API to set the
// certificate to the INACTIVE status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCertificateStateException "CertificateStateException"
//   The certificate operation is not allowed.
//
//   * ErrCodeDeleteConflictException "DeleteConflictException"
//   You can't delete the resource because it is attached to one or more resources.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) DeleteCertificate(input *DeleteCertificateInput) (*DeleteCertificateOutput, error) {
	req, out := c.DeleteCertificateRequest(input)
	return out, req.Send()
}

// DeleteCertificateWithContext is the same as DeleteCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteCertificateWithContext(ctx aws.Context, input *DeleteCertificateInput, opts ...request.Option) (*DeleteCertificateOutput, error) {
	req, out := c.DeleteCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePolicy = "DeletePolicy"

// DeletePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeletePolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeletePolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeletePolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeletePolicyRequest method.
//    req, resp := client.DeletePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeletePolicyRequest(input *DeletePolicyInput) (req *request.Request, output *DeletePolicyOutput) {
	op := &request.Operation{
		Name:       opDeletePolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/policies/{policyName}",
	}

	if input == nil {
		input = &DeletePolicyInput{}
	}

	output = &DeletePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePolicy API operation for AWS IoT.
//
// Deletes the specified policy.
//
// A policy cannot be deleted if it has non-default versions or it is attached
// to any certificate.
//
// To delete a policy, use the DeletePolicyVersion API to delete all non-default
// versions of the policy; use the DetachPrincipalPolicy API to detach the policy
// from any certificate; and then use the DeletePolicy API to delete the policy.
//
// When a policy is deleted using DeletePolicy, its default version is deleted
// with it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeletePolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDeleteConflictException "DeleteConflictException"
//   You can't delete the resource because it is attached to one or more resources.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DeletePolicy(input *DeletePolicyInput) (*DeletePolicyOutput, error) {
	req, out := c.DeletePolicyRequest(input)
	return out, req.Send()
}

// DeletePolicyWithContext is the same as DeletePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeletePolicyWithContext(ctx aws.Context, input *DeletePolicyInput, opts ...request.Option) (*DeletePolicyOutput, error) {
	req, out := c.DeletePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePolicyVersion = "DeletePolicyVersion"

// DeletePolicyVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeletePolicyVersion operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeletePolicyVersion for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeletePolicyVersion method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeletePolicyVersionRequest method.
//    req, resp := client.DeletePolicyVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeletePolicyVersionRequest(input *DeletePolicyVersionInput) (req *request.Request, output *DeletePolicyVersionOutput) {
	op := &request.Operation{
		Name:       opDeletePolicyVersion,
		HTTPMethod: "DELETE",
		HTTPPath:   "/policies/{policyName}/version/{policyVersionId}",
	}

	if input == nil {
		input = &DeletePolicyVersionInput{}
	}

	output = &DeletePolicyVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePolicyVersion API operation for AWS IoT.
//
// Deletes the specified version of the specified policy. You cannot delete
// the default version of a policy using this API. To delete the default version
// of a policy, use DeletePolicy. To find out which version of a policy is marked
// as the default version, use ListPolicyVersions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeletePolicyVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDeleteConflictException "DeleteConflictException"
//   You can't delete the resource because it is attached to one or more resources.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DeletePolicyVersion(input *DeletePolicyVersionInput) (*DeletePolicyVersionOutput, error) {
	req, out := c.DeletePolicyVersionRequest(input)
	return out, req.Send()
}

// DeletePolicyVersionWithContext is the same as DeletePolicyVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePolicyVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeletePolicyVersionWithContext(ctx aws.Context, input *DeletePolicyVersionInput, opts ...request.Option) (*DeletePolicyVersionOutput, error) {
	req, out := c.DeletePolicyVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRegistrationCode = "DeleteRegistrationCode"

// DeleteRegistrationCodeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRegistrationCode operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteRegistrationCode for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteRegistrationCode method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteRegistrationCodeRequest method.
//    req, resp := client.DeleteRegistrationCodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteRegistrationCodeRequest(input *DeleteRegistrationCodeInput) (req *request.Request, output *DeleteRegistrationCodeOutput) {
	op := &request.Operation{
		Name:       opDeleteRegistrationCode,
		HTTPMethod: "DELETE",
		HTTPPath:   "/registrationcode",
	}

	if input == nil {
		input = &DeleteRegistrationCodeInput{}
	}

	output = &DeleteRegistrationCodeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRegistrationCode API operation for AWS IoT.
//
// Deletes a CA certificate registration code.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteRegistrationCode for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DeleteRegistrationCode(input *DeleteRegistrationCodeInput) (*DeleteRegistrationCodeOutput, error) {
	req, out := c.DeleteRegistrationCodeRequest(input)
	return out, req.Send()
}

// DeleteRegistrationCodeWithContext is the same as DeleteRegistrationCode with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRegistrationCode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteRegistrationCodeWithContext(ctx aws.Context, input *DeleteRegistrationCodeInput, opts ...request.Option) (*DeleteRegistrationCodeOutput, error) {
	req, out := c.DeleteRegistrationCodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteThing = "DeleteThing"

// DeleteThingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteThing operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteThing for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteThing method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteThingRequest method.
//    req, resp := client.DeleteThingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteThingRequest(input *DeleteThingInput) (req *request.Request, output *DeleteThingOutput) {
	op := &request.Operation{
		Name:       opDeleteThing,
		HTTPMethod: "DELETE",
		HTTPPath:   "/things/{thingName}",
	}

	if input == nil {
		input = &DeleteThingInput{}
	}

	output = &DeleteThingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteThing API operation for AWS IoT.
//
// Deletes the specified thing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteThing for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeVersionConflictException "VersionConflictException"
//   An exception thrown when the version of a thing passed to a command is different
//   than the version specified with the --version parameter.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DeleteThing(input *DeleteThingInput) (*DeleteThingOutput, error) {
	req, out := c.DeleteThingRequest(input)
	return out, req.Send()
}

// DeleteThingWithContext is the same as DeleteThing with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteThing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteThingWithContext(ctx aws.Context, input *DeleteThingInput, opts ...request.Option) (*DeleteThingOutput, error) {
	req, out := c.DeleteThingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteThingType = "DeleteThingType"

// DeleteThingTypeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteThingType operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteThingType for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteThingType method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteThingTypeRequest method.
//    req, resp := client.DeleteThingTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteThingTypeRequest(input *DeleteThingTypeInput) (req *request.Request, output *DeleteThingTypeOutput) {
	op := &request.Operation{
		Name:       opDeleteThingType,
		HTTPMethod: "DELETE",
		HTTPPath:   "/thing-types/{thingTypeName}",
	}

	if input == nil {
		input = &DeleteThingTypeInput{}
	}

	output = &DeleteThingTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteThingType API operation for AWS IoT.
//
// Deletes the specified thing type . You cannot delete a thing type if it has
// things associated with it. To delete a thing type, first mark it as deprecated
// by calling DeprecateThingType, then remove any associated things by calling
// UpdateThing to change the thing type on any associated thing, and finally
// use DeleteThingType to delete the thing type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteThingType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DeleteThingType(input *DeleteThingTypeInput) (*DeleteThingTypeOutput, error) {
	req, out := c.DeleteThingTypeRequest(input)
	return out, req.Send()
}

// DeleteThingTypeWithContext is the same as DeleteThingType with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteThingType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteThingTypeWithContext(ctx aws.Context, input *DeleteThingTypeInput, opts ...request.Option) (*DeleteThingTypeOutput, error) {
	req, out := c.DeleteThingTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTopicRule = "DeleteTopicRule"

// DeleteTopicRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTopicRule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteTopicRule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteTopicRule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteTopicRuleRequest method.
//    req, resp := client.DeleteTopicRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeleteTopicRuleRequest(input *DeleteTopicRuleInput) (req *request.Request, output *DeleteTopicRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteTopicRule,
		HTTPMethod: "DELETE",
		HTTPPath:   "/rules/{ruleName}",
	}

	if input == nil {
		input = &DeleteTopicRuleInput{}
	}

	output = &DeleteTopicRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTopicRule API operation for AWS IoT.
//
// Deletes the specified rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeleteTopicRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   An unexpected error has occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
func (c *IoT) DeleteTopicRule(input *DeleteTopicRuleInput) (*DeleteTopicRuleOutput, error) {
	req, out := c.DeleteTopicRuleRequest(input)
	return out, req.Send()
}

// DeleteTopicRuleWithContext is the same as DeleteTopicRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTopicRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeleteTopicRuleWithContext(ctx aws.Context, input *DeleteTopicRuleInput, opts ...request.Option) (*DeleteTopicRuleOutput, error) {
	req, out := c.DeleteTopicRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeprecateThingType = "DeprecateThingType"

// DeprecateThingTypeRequest generates a "aws/request.Request" representing the
// client's request for the DeprecateThingType operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeprecateThingType for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeprecateThingType method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeprecateThingTypeRequest method.
//    req, resp := client.DeprecateThingTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DeprecateThingTypeRequest(input *DeprecateThingTypeInput) (req *request.Request, output *DeprecateThingTypeOutput) {
	op := &request.Operation{
		Name:       opDeprecateThingType,
		HTTPMethod: "POST",
		HTTPPath:   "/thing-types/{thingTypeName}/deprecate",
	}

	if input == nil {
		input = &DeprecateThingTypeInput{}
	}

	output = &DeprecateThingTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeprecateThingType API operation for AWS IoT.
//
// Deprecates a thing type. You can not associate new things with deprecated
// thing type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DeprecateThingType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DeprecateThingType(input *DeprecateThingTypeInput) (*DeprecateThingTypeOutput, error) {
	req, out := c.DeprecateThingTypeRequest(input)
	return out, req.Send()
}

// DeprecateThingTypeWithContext is the same as DeprecateThingType with the addition of
// the ability to pass a context and additional request options.
//
// See DeprecateThingType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DeprecateThingTypeWithContext(ctx aws.Context, input *DeprecateThingTypeInput, opts ...request.Option) (*DeprecateThingTypeOutput, error) {
	req, out := c.DeprecateThingTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCACertificate = "DescribeCACertificate"

// DescribeCACertificateRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCACertificate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeCACertificate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeCACertificate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeCACertificateRequest method.
//    req, resp := client.DescribeCACertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeCACertificateRequest(input *DescribeCACertificateInput) (req *request.Request, output *DescribeCACertificateOutput) {
	op := &request.Operation{
		Name:       opDescribeCACertificate,
		HTTPMethod: "GET",
		HTTPPath:   "/cacertificate/{caCertificateId}",
	}

	if input == nil {
		input = &DescribeCACertificateInput{}
	}

	output = &DescribeCACertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCACertificate API operation for AWS IoT.
//
// Describes a registered CA certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeCACertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) DescribeCACertificate(input *DescribeCACertificateInput) (*DescribeCACertificateOutput, error) {
	req, out := c.DescribeCACertificateRequest(input)
	return out, req.Send()
}

// DescribeCACertificateWithContext is the same as DescribeCACertificate with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCACertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeCACertificateWithContext(ctx aws.Context, input *DescribeCACertificateInput, opts ...request.Option) (*DescribeCACertificateOutput, error) {
	req, out := c.DescribeCACertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCertificate = "DescribeCertificate"

// DescribeCertificateRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCertificate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeCertificate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeCertificate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeCertificateRequest method.
//    req, resp := client.DescribeCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeCertificateRequest(input *DescribeCertificateInput) (req *request.Request, output *DescribeCertificateOutput) {
	op := &request.Operation{
		Name:       opDescribeCertificate,
		HTTPMethod: "GET",
		HTTPPath:   "/certificates/{certificateId}",
	}

	if input == nil {
		input = &DescribeCertificateInput{}
	}

	output = &DescribeCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCertificate API operation for AWS IoT.
//
// Gets information about the specified certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) DescribeCertificate(input *DescribeCertificateInput) (*DescribeCertificateOutput, error) {
	req, out := c.DescribeCertificateRequest(input)
	return out, req.Send()
}

// DescribeCertificateWithContext is the same as DescribeCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeCertificateWithContext(ctx aws.Context, input *DescribeCertificateInput, opts ...request.Option) (*DescribeCertificateOutput, error) {
	req, out := c.DescribeCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEndpoint = "DescribeEndpoint"

// DescribeEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEndpoint operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeEndpoint for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeEndpoint method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeEndpointRequest method.
//    req, resp := client.DescribeEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeEndpointRequest(input *DescribeEndpointInput) (req *request.Request, output *DescribeEndpointOutput) {
	op := &request.Operation{
		Name:       opDescribeEndpoint,
		HTTPMethod: "GET",
		HTTPPath:   "/endpoint",
	}

	if input == nil {
		input = &DescribeEndpointInput{}
	}

	output = &DescribeEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEndpoint API operation for AWS IoT.
//
// Returns a unique endpoint specific to the AWS account making the call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeEndpoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
func (c *IoT) DescribeEndpoint(input *DescribeEndpointInput) (*DescribeEndpointOutput, error) {
	req, out := c.DescribeEndpointRequest(input)
	return out, req.Send()
}

// DescribeEndpointWithContext is the same as DescribeEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeEndpointWithContext(ctx aws.Context, input *DescribeEndpointInput, opts ...request.Option) (*DescribeEndpointOutput, error) {
	req, out := c.DescribeEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeThing = "DescribeThing"

// DescribeThingRequest generates a "aws/request.Request" representing the
// client's request for the DescribeThing operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeThing for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeThing method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeThingRequest method.
//    req, resp := client.DescribeThingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeThingRequest(input *DescribeThingInput) (req *request.Request, output *DescribeThingOutput) {
	op := &request.Operation{
		Name:       opDescribeThing,
		HTTPMethod: "GET",
		HTTPPath:   "/things/{thingName}",
	}

	if input == nil {
		input = &DescribeThingInput{}
	}

	output = &DescribeThingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeThing API operation for AWS IoT.
//
// Gets information about the specified thing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeThing for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DescribeThing(input *DescribeThingInput) (*DescribeThingOutput, error) {
	req, out := c.DescribeThingRequest(input)
	return out, req.Send()
}

// DescribeThingWithContext is the same as DescribeThing with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeThing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeThingWithContext(ctx aws.Context, input *DescribeThingInput, opts ...request.Option) (*DescribeThingOutput, error) {
	req, out := c.DescribeThingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeThingType = "DescribeThingType"

// DescribeThingTypeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeThingType operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeThingType for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeThingType method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeThingTypeRequest method.
//    req, resp := client.DescribeThingTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DescribeThingTypeRequest(input *DescribeThingTypeInput) (req *request.Request, output *DescribeThingTypeOutput) {
	op := &request.Operation{
		Name:       opDescribeThingType,
		HTTPMethod: "GET",
		HTTPPath:   "/thing-types/{thingTypeName}",
	}

	if input == nil {
		input = &DescribeThingTypeInput{}
	}

	output = &DescribeThingTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeThingType API operation for AWS IoT.
//
// Gets information about the specified thing type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DescribeThingType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DescribeThingType(input *DescribeThingTypeInput) (*DescribeThingTypeOutput, error) {
	req, out := c.DescribeThingTypeRequest(input)
	return out, req.Send()
}

// DescribeThingTypeWithContext is the same as DescribeThingType with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeThingType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DescribeThingTypeWithContext(ctx aws.Context, input *DescribeThingTypeInput, opts ...request.Option) (*DescribeThingTypeOutput, error) {
	req, out := c.DescribeThingTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachPrincipalPolicy = "DetachPrincipalPolicy"

// DetachPrincipalPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DetachPrincipalPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DetachPrincipalPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DetachPrincipalPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DetachPrincipalPolicyRequest method.
//    req, resp := client.DetachPrincipalPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DetachPrincipalPolicyRequest(input *DetachPrincipalPolicyInput) (req *request.Request, output *DetachPrincipalPolicyOutput) {
	op := &request.Operation{
		Name:       opDetachPrincipalPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/principal-policies/{policyName}",
	}

	if input == nil {
		input = &DetachPrincipalPolicyInput{}
	}

	output = &DetachPrincipalPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DetachPrincipalPolicy API operation for AWS IoT.
//
// Removes the specified policy from the specified certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DetachPrincipalPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DetachPrincipalPolicy(input *DetachPrincipalPolicyInput) (*DetachPrincipalPolicyOutput, error) {
	req, out := c.DetachPrincipalPolicyRequest(input)
	return out, req.Send()
}

// DetachPrincipalPolicyWithContext is the same as DetachPrincipalPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DetachPrincipalPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DetachPrincipalPolicyWithContext(ctx aws.Context, input *DetachPrincipalPolicyInput, opts ...request.Option) (*DetachPrincipalPolicyOutput, error) {
	req, out := c.DetachPrincipalPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachThingPrincipal = "DetachThingPrincipal"

// DetachThingPrincipalRequest generates a "aws/request.Request" representing the
// client's request for the DetachThingPrincipal operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DetachThingPrincipal for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DetachThingPrincipal method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DetachThingPrincipalRequest method.
//    req, resp := client.DetachThingPrincipalRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DetachThingPrincipalRequest(input *DetachThingPrincipalInput) (req *request.Request, output *DetachThingPrincipalOutput) {
	op := &request.Operation{
		Name:       opDetachThingPrincipal,
		HTTPMethod: "DELETE",
		HTTPPath:   "/things/{thingName}/principals",
	}

	if input == nil {
		input = &DetachThingPrincipalInput{}
	}

	output = &DetachThingPrincipalOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetachThingPrincipal API operation for AWS IoT.
//
// Detaches the specified principal from the specified thing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DetachThingPrincipal for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) DetachThingPrincipal(input *DetachThingPrincipalInput) (*DetachThingPrincipalOutput, error) {
	req, out := c.DetachThingPrincipalRequest(input)
	return out, req.Send()
}

// DetachThingPrincipalWithContext is the same as DetachThingPrincipal with the addition of
// the ability to pass a context and additional request options.
//
// See DetachThingPrincipal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DetachThingPrincipalWithContext(ctx aws.Context, input *DetachThingPrincipalInput, opts ...request.Option) (*DetachThingPrincipalOutput, error) {
	req, out := c.DetachThingPrincipalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableTopicRule = "DisableTopicRule"

// DisableTopicRuleRequest generates a "aws/request.Request" representing the
// client's request for the DisableTopicRule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisableTopicRule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisableTopicRule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisableTopicRuleRequest method.
//    req, resp := client.DisableTopicRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) DisableTopicRuleRequest(input *DisableTopicRuleInput) (req *request.Request, output *DisableTopicRuleOutput) {
	op := &request.Operation{
		Name:       opDisableTopicRule,
		HTTPMethod: "POST",
		HTTPPath:   "/rules/{ruleName}/disable",
	}

	if input == nil {
		input = &DisableTopicRuleInput{}
	}

	output = &DisableTopicRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableTopicRule API operation for AWS IoT.
//
// Disables the specified rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation DisableTopicRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   An unexpected error has occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
func (c *IoT) DisableTopicRule(input *DisableTopicRuleInput) (*DisableTopicRuleOutput, error) {
	req, out := c.DisableTopicRuleRequest(input)
	return out, req.Send()
}

// DisableTopicRuleWithContext is the same as DisableTopicRule with the addition of
// the ability to pass a context and additional request options.
//
// See DisableTopicRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) DisableTopicRuleWithContext(ctx aws.Context, input *DisableTopicRuleInput, opts ...request.Option) (*DisableTopicRuleOutput, error) {
	req, out := c.DisableTopicRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableTopicRule = "EnableTopicRule"

// EnableTopicRuleRequest generates a "aws/request.Request" representing the
// client's request for the EnableTopicRule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See EnableTopicRule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the EnableTopicRule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the EnableTopicRuleRequest method.
//    req, resp := client.EnableTopicRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) EnableTopicRuleRequest(input *EnableTopicRuleInput) (req *request.Request, output *EnableTopicRuleOutput) {
	op := &request.Operation{
		Name:       opEnableTopicRule,
		HTTPMethod: "POST",
		HTTPPath:   "/rules/{ruleName}/enable",
	}

	if input == nil {
		input = &EnableTopicRuleInput{}
	}

	output = &EnableTopicRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableTopicRule API operation for AWS IoT.
//
// Enables the specified rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation EnableTopicRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   An unexpected error has occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
func (c *IoT) EnableTopicRule(input *EnableTopicRuleInput) (*EnableTopicRuleOutput, error) {
	req, out := c.EnableTopicRuleRequest(input)
	return out, req.Send()
}

// EnableTopicRuleWithContext is the same as EnableTopicRule with the addition of
// the ability to pass a context and additional request options.
//
// See EnableTopicRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) EnableTopicRuleWithContext(ctx aws.Context, input *EnableTopicRuleInput, opts ...request.Option) (*EnableTopicRuleOutput, error) {
	req, out := c.EnableTopicRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLoggingOptions = "GetLoggingOptions"

// GetLoggingOptionsRequest generates a "aws/request.Request" representing the
// client's request for the GetLoggingOptions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetLoggingOptions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetLoggingOptions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetLoggingOptionsRequest method.
//    req, resp := client.GetLoggingOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) GetLoggingOptionsRequest(input *GetLoggingOptionsInput) (req *request.Request, output *GetLoggingOptionsOutput) {
	op := &request.Operation{
		Name:       opGetLoggingOptions,
		HTTPMethod: "GET",
		HTTPPath:   "/loggingOptions",
	}

	if input == nil {
		input = &GetLoggingOptionsInput{}
	}

	output = &GetLoggingOptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLoggingOptions API operation for AWS IoT.
//
// Gets the logging options.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation GetLoggingOptions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   An unexpected error has occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
func (c *IoT) GetLoggingOptions(input *GetLoggingOptionsInput) (*GetLoggingOptionsOutput, error) {
	req, out := c.GetLoggingOptionsRequest(input)
	return out, req.Send()
}

// GetLoggingOptionsWithContext is the same as GetLoggingOptions with the addition of
// the ability to pass a context and additional request options.
//
// See GetLoggingOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) GetLoggingOptionsWithContext(ctx aws.Context, input *GetLoggingOptionsInput, opts ...request.Option) (*GetLoggingOptionsOutput, error) {
	req, out := c.GetLoggingOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPolicy = "GetPolicy"

// GetPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetPolicyRequest method.
//    req, resp := client.GetPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) GetPolicyRequest(input *GetPolicyInput) (req *request.Request, output *GetPolicyOutput) {
	op := &request.Operation{
		Name:       opGetPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/policies/{policyName}",
	}

	if input == nil {
		input = &GetPolicyInput{}
	}

	output = &GetPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPolicy API operation for AWS IoT.
//
// Gets information about the specified policy with the policy document of the
// default version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation GetPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) GetPolicy(input *GetPolicyInput) (*GetPolicyOutput, error) {
	req, out := c.GetPolicyRequest(input)
	return out, req.Send()
}

// GetPolicyWithContext is the same as GetPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) GetPolicyWithContext(ctx aws.Context, input *GetPolicyInput, opts ...request.Option) (*GetPolicyOutput, error) {
	req, out := c.GetPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPolicyVersion = "GetPolicyVersion"

// GetPolicyVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetPolicyVersion operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetPolicyVersion for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetPolicyVersion method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetPolicyVersionRequest method.
//    req, resp := client.GetPolicyVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) GetPolicyVersionRequest(input *GetPolicyVersionInput) (req *request.Request, output *GetPolicyVersionOutput) {
	op := &request.Operation{
		Name:       opGetPolicyVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/policies/{policyName}/version/{policyVersionId}",
	}

	if input == nil {
		input = &GetPolicyVersionInput{}
	}

	output = &GetPolicyVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPolicyVersion API operation for AWS IoT.
//
// Gets information about the specified policy version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation GetPolicyVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) GetPolicyVersion(input *GetPolicyVersionInput) (*GetPolicyVersionOutput, error) {
	req, out := c.GetPolicyVersionRequest(input)
	return out, req.Send()
}

// GetPolicyVersionWithContext is the same as GetPolicyVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetPolicyVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) GetPolicyVersionWithContext(ctx aws.Context, input *GetPolicyVersionInput, opts ...request.Option) (*GetPolicyVersionOutput, error) {
	req, out := c.GetPolicyVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRegistrationCode = "GetRegistrationCode"

// GetRegistrationCodeRequest generates a "aws/request.Request" representing the
// client's request for the GetRegistrationCode operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetRegistrationCode for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetRegistrationCode method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetRegistrationCodeRequest method.
//    req, resp := client.GetRegistrationCodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) GetRegistrationCodeRequest(input *GetRegistrationCodeInput) (req *request.Request, output *GetRegistrationCodeOutput) {
	op := &request.Operation{
		Name:       opGetRegistrationCode,
		HTTPMethod: "GET",
		HTTPPath:   "/registrationcode",
	}

	if input == nil {
		input = &GetRegistrationCodeInput{}
	}

	output = &GetRegistrationCodeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRegistrationCode API operation for AWS IoT.
//
// Gets a registration code used to register a CA certificate with AWS IoT.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation GetRegistrationCode for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
func (c *IoT) GetRegistrationCode(input *GetRegistrationCodeInput) (*GetRegistrationCodeOutput, error) {
	req, out := c.GetRegistrationCodeRequest(input)
	return out, req.Send()
}

// GetRegistrationCodeWithContext is the same as GetRegistrationCode with the addition of
// the ability to pass a context and additional request options.
//
// See GetRegistrationCode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) GetRegistrationCodeWithContext(ctx aws.Context, input *GetRegistrationCodeInput, opts ...request.Option) (*GetRegistrationCodeOutput, error) {
	req, out := c.GetRegistrationCodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTopicRule = "GetTopicRule"

// GetTopicRuleRequest generates a "aws/request.Request" representing the
// client's request for the GetTopicRule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetTopicRule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetTopicRule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetTopicRuleRequest method.
//    req, resp := client.GetTopicRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) GetTopicRuleRequest(input *GetTopicRuleInput) (req *request.Request, output *GetTopicRuleOutput) {
	op := &request.Operation{
		Name:       opGetTopicRule,
		HTTPMethod: "GET",
		HTTPPath:   "/rules/{ruleName}",
	}

	if input == nil {
		input = &GetTopicRuleInput{}
	}

	output = &GetTopicRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTopicRule API operation for AWS IoT.
//
// Gets information about the specified rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation GetTopicRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   An unexpected error has occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
func (c *IoT) GetTopicRule(input *GetTopicRuleInput) (*GetTopicRuleOutput, error) {
	req, out := c.GetTopicRuleRequest(input)
	return out, req.Send()
}

// GetTopicRuleWithContext is the same as GetTopicRule with the addition of
// the ability to pass a context and additional request options.
//
// See GetTopicRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) GetTopicRuleWithContext(ctx aws.Context, input *GetTopicRuleInput, opts ...request.Option) (*GetTopicRuleOutput, error) {
	req, out := c.GetTopicRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCACertificates = "ListCACertificates"

// ListCACertificatesRequest generates a "aws/request.Request" representing the
// client's request for the ListCACertificates operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListCACertificates for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListCACertificates method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListCACertificatesRequest method.
//    req, resp := client.ListCACertificatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListCACertificatesRequest(input *ListCACertificatesInput) (req *request.Request, output *ListCACertificatesOutput) {
	op := &request.Operation{
		Name:       opListCACertificates,
		HTTPMethod: "GET",
		HTTPPath:   "/cacertificates",
	}

	if input == nil {
		input = &ListCACertificatesInput{}
	}

	output = &ListCACertificatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCACertificates API operation for AWS IoT.
//
// Lists the CA certificates registered for your AWS account.
//
// The results are paginated with a default page size of 25. You can use the
// returned marker to retrieve additional results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListCACertificates for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListCACertificates(input *ListCACertificatesInput) (*ListCACertificatesOutput, error) {
	req, out := c.ListCACertificatesRequest(input)
	return out, req.Send()
}

// ListCACertificatesWithContext is the same as ListCACertificates with the addition of
// the ability to pass a context and additional request options.
//
// See ListCACertificates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListCACertificatesWithContext(ctx aws.Context, input *ListCACertificatesInput, opts ...request.Option) (*ListCACertificatesOutput, error) {
	req, out := c.ListCACertificatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCertificates = "ListCertificates"

// ListCertificatesRequest generates a "aws/request.Request" representing the
// client's request for the ListCertificates operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListCertificates for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListCertificates method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListCertificatesRequest method.
//    req, resp := client.ListCertificatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListCertificatesRequest(input *ListCertificatesInput) (req *request.Request, output *ListCertificatesOutput) {
	op := &request.Operation{
		Name:       opListCertificates,
		HTTPMethod: "GET",
		HTTPPath:   "/certificates",
	}

	if input == nil {
		input = &ListCertificatesInput{}
	}

	output = &ListCertificatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCertificates API operation for AWS IoT.
//
// Lists the certificates registered in your AWS account.
//
// The results are paginated with a default page size of 25. You can use the
// returned marker to retrieve additional results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListCertificates for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListCertificates(input *ListCertificatesInput) (*ListCertificatesOutput, error) {
	req, out := c.ListCertificatesRequest(input)
	return out, req.Send()
}

// ListCertificatesWithContext is the same as ListCertificates with the addition of
// the ability to pass a context and additional request options.
//
// See ListCertificates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListCertificatesWithContext(ctx aws.Context, input *ListCertificatesInput, opts ...request.Option) (*ListCertificatesOutput, error) {
	req, out := c.ListCertificatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCertificatesByCA = "ListCertificatesByCA"

// ListCertificatesByCARequest generates a "aws/request.Request" representing the
// client's request for the ListCertificatesByCA operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListCertificatesByCA for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListCertificatesByCA method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListCertificatesByCARequest method.
//    req, resp := client.ListCertificatesByCARequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListCertificatesByCARequest(input *ListCertificatesByCAInput) (req *request.Request, output *ListCertificatesByCAOutput) {
	op := &request.Operation{
		Name:       opListCertificatesByCA,
		HTTPMethod: "GET",
		HTTPPath:   "/certificates-by-ca/{caCertificateId}",
	}

	if input == nil {
		input = &ListCertificatesByCAInput{}
	}

	output = &ListCertificatesByCAOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCertificatesByCA API operation for AWS IoT.
//
// List the device certificates signed by the specified CA certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListCertificatesByCA for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListCertificatesByCA(input *ListCertificatesByCAInput) (*ListCertificatesByCAOutput, error) {
	req, out := c.ListCertificatesByCARequest(input)
	return out, req.Send()
}

// ListCertificatesByCAWithContext is the same as ListCertificatesByCA with the addition of
// the ability to pass a context and additional request options.
//
// See ListCertificatesByCA for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListCertificatesByCAWithContext(ctx aws.Context, input *ListCertificatesByCAInput, opts ...request.Option) (*ListCertificatesByCAOutput, error) {
	req, out := c.ListCertificatesByCARequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListOutgoingCertificates = "ListOutgoingCertificates"

// ListOutgoingCertificatesRequest generates a "aws/request.Request" representing the
// client's request for the ListOutgoingCertificates operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListOutgoingCertificates for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListOutgoingCertificates method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListOutgoingCertificatesRequest method.
//    req, resp := client.ListOutgoingCertificatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListOutgoingCertificatesRequest(input *ListOutgoingCertificatesInput) (req *request.Request, output *ListOutgoingCertificatesOutput) {
	op := &request.Operation{
		Name:       opListOutgoingCertificates,
		HTTPMethod: "GET",
		HTTPPath:   "/certificates-out-going",
	}

	if input == nil {
		input = &ListOutgoingCertificatesInput{}
	}

	output = &ListOutgoingCertificatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOutgoingCertificates API operation for AWS IoT.
//
// Lists certificates that are being transfered but not yet accepted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListOutgoingCertificates for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListOutgoingCertificates(input *ListOutgoingCertificatesInput) (*ListOutgoingCertificatesOutput, error) {
	req, out := c.ListOutgoingCertificatesRequest(input)
	return out, req.Send()
}

// ListOutgoingCertificatesWithContext is the same as ListOutgoingCertificates with the addition of
// the ability to pass a context and additional request options.
//
// See ListOutgoingCertificates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListOutgoingCertificatesWithContext(ctx aws.Context, input *ListOutgoingCertificatesInput, opts ...request.Option) (*ListOutgoingCertificatesOutput, error) {
	req, out := c.ListOutgoingCertificatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPolicies = "ListPolicies"

// ListPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListPolicies operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListPolicies for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListPolicies method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListPoliciesRequest method.
//    req, resp := client.ListPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListPoliciesRequest(input *ListPoliciesInput) (req *request.Request, output *ListPoliciesOutput) {
	op := &request.Operation{
		Name:       opListPolicies,
		HTTPMethod: "GET",
		HTTPPath:   "/policies",
	}

	if input == nil {
		input = &ListPoliciesInput{}
	}

	output = &ListPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPolicies API operation for AWS IoT.
//
// Lists your policies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListPolicies for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListPolicies(input *ListPoliciesInput) (*ListPoliciesOutput, error) {
	req, out := c.ListPoliciesRequest(input)
	return out, req.Send()
}

// ListPoliciesWithContext is the same as ListPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListPoliciesWithContext(ctx aws.Context, input *ListPoliciesInput, opts ...request.Option) (*ListPoliciesOutput, error) {
	req, out := c.ListPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPolicyPrincipals = "ListPolicyPrincipals"

// ListPolicyPrincipalsRequest generates a "aws/request.Request" representing the
// client's request for the ListPolicyPrincipals operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListPolicyPrincipals for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListPolicyPrincipals method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListPolicyPrincipalsRequest method.
//    req, resp := client.ListPolicyPrincipalsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListPolicyPrincipalsRequest(input *ListPolicyPrincipalsInput) (req *request.Request, output *ListPolicyPrincipalsOutput) {
	op := &request.Operation{
		Name:       opListPolicyPrincipals,
		HTTPMethod: "GET",
		HTTPPath:   "/policy-principals",
	}

	if input == nil {
		input = &ListPolicyPrincipalsInput{}
	}

	output = &ListPolicyPrincipalsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPolicyPrincipals API operation for AWS IoT.
//
// Lists the principals associated with the specified policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListPolicyPrincipals for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListPolicyPrincipals(input *ListPolicyPrincipalsInput) (*ListPolicyPrincipalsOutput, error) {
	req, out := c.ListPolicyPrincipalsRequest(input)
	return out, req.Send()
}

// ListPolicyPrincipalsWithContext is the same as ListPolicyPrincipals with the addition of
// the ability to pass a context and additional request options.
//
// See ListPolicyPrincipals for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListPolicyPrincipalsWithContext(ctx aws.Context, input *ListPolicyPrincipalsInput, opts ...request.Option) (*ListPolicyPrincipalsOutput, error) {
	req, out := c.ListPolicyPrincipalsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPolicyVersions = "ListPolicyVersions"

// ListPolicyVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListPolicyVersions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListPolicyVersions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListPolicyVersions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListPolicyVersionsRequest method.
//    req, resp := client.ListPolicyVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListPolicyVersionsRequest(input *ListPolicyVersionsInput) (req *request.Request, output *ListPolicyVersionsOutput) {
	op := &request.Operation{
		Name:       opListPolicyVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/policies/{policyName}/version",
	}

	if input == nil {
		input = &ListPolicyVersionsInput{}
	}

	output = &ListPolicyVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPolicyVersions API operation for AWS IoT.
//
// Lists the versions of the specified policy and identifies the default version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListPolicyVersions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListPolicyVersions(input *ListPolicyVersionsInput) (*ListPolicyVersionsOutput, error) {
	req, out := c.ListPolicyVersionsRequest(input)
	return out, req.Send()
}

// ListPolicyVersionsWithContext is the same as ListPolicyVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListPolicyVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListPolicyVersionsWithContext(ctx aws.Context, input *ListPolicyVersionsInput, opts ...request.Option) (*ListPolicyVersionsOutput, error) {
	req, out := c.ListPolicyVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPrincipalPolicies = "ListPrincipalPolicies"

// ListPrincipalPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListPrincipalPolicies operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListPrincipalPolicies for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListPrincipalPolicies method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListPrincipalPoliciesRequest method.
//    req, resp := client.ListPrincipalPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListPrincipalPoliciesRequest(input *ListPrincipalPoliciesInput) (req *request.Request, output *ListPrincipalPoliciesOutput) {
	op := &request.Operation{
		Name:       opListPrincipalPolicies,
		HTTPMethod: "GET",
		HTTPPath:   "/principal-policies",
	}

	if input == nil {
		input = &ListPrincipalPoliciesInput{}
	}

	output = &ListPrincipalPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPrincipalPolicies API operation for AWS IoT.
//
// Lists the policies attached to the specified principal. If you use an Cognito
// identity, the ID must be in AmazonCognito Identity format (http://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetCredentialsForIdentity.html#API_GetCredentialsForIdentity_RequestSyntax).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListPrincipalPolicies for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListPrincipalPolicies(input *ListPrincipalPoliciesInput) (*ListPrincipalPoliciesOutput, error) {
	req, out := c.ListPrincipalPoliciesRequest(input)
	return out, req.Send()
}

// ListPrincipalPoliciesWithContext is the same as ListPrincipalPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListPrincipalPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListPrincipalPoliciesWithContext(ctx aws.Context, input *ListPrincipalPoliciesInput, opts ...request.Option) (*ListPrincipalPoliciesOutput, error) {
	req, out := c.ListPrincipalPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPrincipalThings = "ListPrincipalThings"

// ListPrincipalThingsRequest generates a "aws/request.Request" representing the
// client's request for the ListPrincipalThings operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListPrincipalThings for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListPrincipalThings method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListPrincipalThingsRequest method.
//    req, resp := client.ListPrincipalThingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListPrincipalThingsRequest(input *ListPrincipalThingsInput) (req *request.Request, output *ListPrincipalThingsOutput) {
	op := &request.Operation{
		Name:       opListPrincipalThings,
		HTTPMethod: "GET",
		HTTPPath:   "/principals/things",
	}

	if input == nil {
		input = &ListPrincipalThingsInput{}
	}

	output = &ListPrincipalThingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPrincipalThings API operation for AWS IoT.
//
// Lists the things associated with the specified principal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListPrincipalThings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) ListPrincipalThings(input *ListPrincipalThingsInput) (*ListPrincipalThingsOutput, error) {
	req, out := c.ListPrincipalThingsRequest(input)
	return out, req.Send()
}

// ListPrincipalThingsWithContext is the same as ListPrincipalThings with the addition of
// the ability to pass a context and additional request options.
//
// See ListPrincipalThings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListPrincipalThingsWithContext(ctx aws.Context, input *ListPrincipalThingsInput, opts ...request.Option) (*ListPrincipalThingsOutput, error) {
	req, out := c.ListPrincipalThingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListThingPrincipals = "ListThingPrincipals"

// ListThingPrincipalsRequest generates a "aws/request.Request" representing the
// client's request for the ListThingPrincipals operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListThingPrincipals for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListThingPrincipals method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListThingPrincipalsRequest method.
//    req, resp := client.ListThingPrincipalsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListThingPrincipalsRequest(input *ListThingPrincipalsInput) (req *request.Request, output *ListThingPrincipalsOutput) {
	op := &request.Operation{
		Name:       opListThingPrincipals,
		HTTPMethod: "GET",
		HTTPPath:   "/things/{thingName}/principals",
	}

	if input == nil {
		input = &ListThingPrincipalsInput{}
	}

	output = &ListThingPrincipalsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThingPrincipals API operation for AWS IoT.
//
// Lists the principals associated with the specified thing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListThingPrincipals for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) ListThingPrincipals(input *ListThingPrincipalsInput) (*ListThingPrincipalsOutput, error) {
	req, out := c.ListThingPrincipalsRequest(input)
	return out, req.Send()
}

// ListThingPrincipalsWithContext is the same as ListThingPrincipals with the addition of
// the ability to pass a context and additional request options.
//
// See ListThingPrincipals for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListThingPrincipalsWithContext(ctx aws.Context, input *ListThingPrincipalsInput, opts ...request.Option) (*ListThingPrincipalsOutput, error) {
	req, out := c.ListThingPrincipalsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListThingTypes = "ListThingTypes"

// ListThingTypesRequest generates a "aws/request.Request" representing the
// client's request for the ListThingTypes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListThingTypes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListThingTypes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListThingTypesRequest method.
//    req, resp := client.ListThingTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListThingTypesRequest(input *ListThingTypesInput) (req *request.Request, output *ListThingTypesOutput) {
	op := &request.Operation{
		Name:       opListThingTypes,
		HTTPMethod: "GET",
		HTTPPath:   "/thing-types",
	}

	if input == nil {
		input = &ListThingTypesInput{}
	}

	output = &ListThingTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThingTypes API operation for AWS IoT.
//
// Lists the existing thing types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListThingTypes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListThingTypes(input *ListThingTypesInput) (*ListThingTypesOutput, error) {
	req, out := c.ListThingTypesRequest(input)
	return out, req.Send()
}

// ListThingTypesWithContext is the same as ListThingTypes with the addition of
// the ability to pass a context and additional request options.
//
// See ListThingTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListThingTypesWithContext(ctx aws.Context, input *ListThingTypesInput, opts ...request.Option) (*ListThingTypesOutput, error) {
	req, out := c.ListThingTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListThings = "ListThings"

// ListThingsRequest generates a "aws/request.Request" representing the
// client's request for the ListThings operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListThings for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListThings method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListThingsRequest method.
//    req, resp := client.ListThingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListThingsRequest(input *ListThingsInput) (req *request.Request, output *ListThingsOutput) {
	op := &request.Operation{
		Name:       opListThings,
		HTTPMethod: "GET",
		HTTPPath:   "/things",
	}

	if input == nil {
		input = &ListThingsInput{}
	}

	output = &ListThingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThings API operation for AWS IoT.
//
// Lists your things. Use the attributeName and attributeValue parameters to
// filter your things. For example, calling ListThings with attributeName=Color
// and attributeValue=Red retrieves all things in the registry that contain
// an attribute Color with the value Red.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListThings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) ListThings(input *ListThingsInput) (*ListThingsOutput, error) {
	req, out := c.ListThingsRequest(input)
	return out, req.Send()
}

// ListThingsWithContext is the same as ListThings with the addition of
// the ability to pass a context and additional request options.
//
// See ListThings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListThingsWithContext(ctx aws.Context, input *ListThingsInput, opts ...request.Option) (*ListThingsOutput, error) {
	req, out := c.ListThingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTopicRules = "ListTopicRules"

// ListTopicRulesRequest generates a "aws/request.Request" representing the
// client's request for the ListTopicRules operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListTopicRules for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListTopicRules method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListTopicRulesRequest method.
//    req, resp := client.ListTopicRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ListTopicRulesRequest(input *ListTopicRulesInput) (req *request.Request, output *ListTopicRulesOutput) {
	op := &request.Operation{
		Name:       opListTopicRules,
		HTTPMethod: "GET",
		HTTPPath:   "/rules",
	}

	if input == nil {
		input = &ListTopicRulesInput{}
	}

	output = &ListTopicRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTopicRules API operation for AWS IoT.
//
// Lists the rules for the specific topic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ListTopicRules for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   An unexpected error has occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
func (c *IoT) ListTopicRules(input *ListTopicRulesInput) (*ListTopicRulesOutput, error) {
	req, out := c.ListTopicRulesRequest(input)
	return out, req.Send()
}

// ListTopicRulesWithContext is the same as ListTopicRules with the addition of
// the ability to pass a context and additional request options.
//
// See ListTopicRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ListTopicRulesWithContext(ctx aws.Context, input *ListTopicRulesInput, opts ...request.Option) (*ListTopicRulesOutput, error) {
	req, out := c.ListTopicRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterCACertificate = "RegisterCACertificate"

// RegisterCACertificateRequest generates a "aws/request.Request" representing the
// client's request for the RegisterCACertificate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RegisterCACertificate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RegisterCACertificate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RegisterCACertificateRequest method.
//    req, resp := client.RegisterCACertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) RegisterCACertificateRequest(input *RegisterCACertificateInput) (req *request.Request, output *RegisterCACertificateOutput) {
	op := &request.Operation{
		Name:       opRegisterCACertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/cacertificate",
	}

	if input == nil {
		input = &RegisterCACertificateInput{}
	}

	output = &RegisterCACertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterCACertificate API operation for AWS IoT.
//
// Registers a CA certificate with AWS IoT. This CA certificate can then be
// used to sign device certificates, which can be then registered with AWS IoT.
// You can register up to 10 CA certificates per AWS account that have the same
// subject field and public key. This enables you to have up to 10 certificate
// authorities sign your device certificates. If you have more than one CA certificate
// registered, make sure you pass the CA certificate when you register your
// device certificates with the RegisterCertificate API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation RegisterCACertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The resource already exists.
//
//   * ErrCodeRegistrationCodeValidationException "RegistrationCodeValidationException"
//   The registration code is invalid.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeCertificateValidationException "CertificateValidationException"
//   The certificate is invalid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The number of attached entities exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) RegisterCACertificate(input *RegisterCACertificateInput) (*RegisterCACertificateOutput, error) {
	req, out := c.RegisterCACertificateRequest(input)
	return out, req.Send()
}

// RegisterCACertificateWithContext is the same as RegisterCACertificate with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterCACertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) RegisterCACertificateWithContext(ctx aws.Context, input *RegisterCACertificateInput, opts ...request.Option) (*RegisterCACertificateOutput, error) {
	req, out := c.RegisterCACertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterCertificate = "RegisterCertificate"

// RegisterCertificateRequest generates a "aws/request.Request" representing the
// client's request for the RegisterCertificate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RegisterCertificate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RegisterCertificate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RegisterCertificateRequest method.
//    req, resp := client.RegisterCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) RegisterCertificateRequest(input *RegisterCertificateInput) (req *request.Request, output *RegisterCertificateOutput) {
	op := &request.Operation{
		Name:       opRegisterCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/certificate/register",
	}

	if input == nil {
		input = &RegisterCertificateInput{}
	}

	output = &RegisterCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterCertificate API operation for AWS IoT.
//
// Registers a device certificate with AWS IoT. If you have more than one CA
// certificate that has the same subject field, you must specify the CA certificate
// that was used to sign the device certificate being registered.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation RegisterCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The resource already exists.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeCertificateValidationException "CertificateValidationException"
//   The certificate is invalid.
//
//   * ErrCodeCertificateStateException "CertificateStateException"
//   The certificate operation is not allowed.
//
//   * ErrCodeCertificateConflictException "CertificateConflictException"
//   Unable to verify the CA certificate used to sign the device certificate you
//   are attempting to register. This is happens when you have registered more
//   than one CA certificate that has the same subject field and public key.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) RegisterCertificate(input *RegisterCertificateInput) (*RegisterCertificateOutput, error) {
	req, out := c.RegisterCertificateRequest(input)
	return out, req.Send()
}

// RegisterCertificateWithContext is the same as RegisterCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) RegisterCertificateWithContext(ctx aws.Context, input *RegisterCertificateInput, opts ...request.Option) (*RegisterCertificateOutput, error) {
	req, out := c.RegisterCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRejectCertificateTransfer = "RejectCertificateTransfer"

// RejectCertificateTransferRequest generates a "aws/request.Request" representing the
// client's request for the RejectCertificateTransfer operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RejectCertificateTransfer for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RejectCertificateTransfer method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RejectCertificateTransferRequest method.
//    req, resp := client.RejectCertificateTransferRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) RejectCertificateTransferRequest(input *RejectCertificateTransferInput) (req *request.Request, output *RejectCertificateTransferOutput) {
	op := &request.Operation{
		Name:       opRejectCertificateTransfer,
		HTTPMethod: "PATCH",
		HTTPPath:   "/reject-certificate-transfer/{certificateId}",
	}

	if input == nil {
		input = &RejectCertificateTransferInput{}
	}

	output = &RejectCertificateTransferOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// RejectCertificateTransfer API operation for AWS IoT.
//
// Rejects a pending certificate transfer. After AWS IoT rejects a certificate
// transfer, the certificate status changes from PENDING_TRANSFER to INACTIVE.
//
// To check for pending certificate transfers, call ListCertificates to enumerate
// your certificates.
//
// This operation can only be called by the transfer destination. After it is
// called, the certificate will be returned to the source's account in the INACTIVE
// state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation RejectCertificateTransfer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeTransferAlreadyCompletedException "TransferAlreadyCompletedException"
//   You can't revert the certificate transfer because the transfer is already
//   complete.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) RejectCertificateTransfer(input *RejectCertificateTransferInput) (*RejectCertificateTransferOutput, error) {
	req, out := c.RejectCertificateTransferRequest(input)
	return out, req.Send()
}

// RejectCertificateTransferWithContext is the same as RejectCertificateTransfer with the addition of
// the ability to pass a context and additional request options.
//
// See RejectCertificateTransfer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) RejectCertificateTransferWithContext(ctx aws.Context, input *RejectCertificateTransferInput, opts ...request.Option) (*RejectCertificateTransferOutput, error) {
	req, out := c.RejectCertificateTransferRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opReplaceTopicRule = "ReplaceTopicRule"

// ReplaceTopicRuleRequest generates a "aws/request.Request" representing the
// client's request for the ReplaceTopicRule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ReplaceTopicRule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ReplaceTopicRule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ReplaceTopicRuleRequest method.
//    req, resp := client.ReplaceTopicRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) ReplaceTopicRuleRequest(input *ReplaceTopicRuleInput) (req *request.Request, output *ReplaceTopicRuleOutput) {
	op := &request.Operation{
		Name:       opReplaceTopicRule,
		HTTPMethod: "PATCH",
		HTTPPath:   "/rules/{ruleName}",
	}

	if input == nil {
		input = &ReplaceTopicRuleInput{}
	}

	output = &ReplaceTopicRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// ReplaceTopicRule API operation for AWS IoT.
//
// Replaces the specified rule. You must specify all parameters for the new
// rule. Creating rules is an administrator-level action. Any user who has permission
// to create rules will be able to access data processed by the rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation ReplaceTopicRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSqlParseException "SqlParseException"
//   The Rule-SQL expression can't be parsed correctly.
//
//   * ErrCodeInternalException "InternalException"
//   An unexpected error has occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
func (c *IoT) ReplaceTopicRule(input *ReplaceTopicRuleInput) (*ReplaceTopicRuleOutput, error) {
	req, out := c.ReplaceTopicRuleRequest(input)
	return out, req.Send()
}

// ReplaceTopicRuleWithContext is the same as ReplaceTopicRule with the addition of
// the ability to pass a context and additional request options.
//
// See ReplaceTopicRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) ReplaceTopicRuleWithContext(ctx aws.Context, input *ReplaceTopicRuleInput, opts ...request.Option) (*ReplaceTopicRuleOutput, error) {
	req, out := c.ReplaceTopicRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetDefaultPolicyVersion = "SetDefaultPolicyVersion"

// SetDefaultPolicyVersionRequest generates a "aws/request.Request" representing the
// client's request for the SetDefaultPolicyVersion operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetDefaultPolicyVersion for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetDefaultPolicyVersion method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetDefaultPolicyVersionRequest method.
//    req, resp := client.SetDefaultPolicyVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) SetDefaultPolicyVersionRequest(input *SetDefaultPolicyVersionInput) (req *request.Request, output *SetDefaultPolicyVersionOutput) {
	op := &request.Operation{
		Name:       opSetDefaultPolicyVersion,
		HTTPMethod: "PATCH",
		HTTPPath:   "/policies/{policyName}/version/{policyVersionId}",
	}

	if input == nil {
		input = &SetDefaultPolicyVersionInput{}
	}

	output = &SetDefaultPolicyVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetDefaultPolicyVersion API operation for AWS IoT.
//
// Sets the specified version of the specified policy as the policy's default
// (operative) version. This action affects all certificates to which the policy
// is attached. To list the principals the policy is attached to, use the ListPrincipalPolicy
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation SetDefaultPolicyVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) SetDefaultPolicyVersion(input *SetDefaultPolicyVersionInput) (*SetDefaultPolicyVersionOutput, error) {
	req, out := c.SetDefaultPolicyVersionRequest(input)
	return out, req.Send()
}

// SetDefaultPolicyVersionWithContext is the same as SetDefaultPolicyVersion with the addition of
// the ability to pass a context and additional request options.
//
// See SetDefaultPolicyVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) SetDefaultPolicyVersionWithContext(ctx aws.Context, input *SetDefaultPolicyVersionInput, opts ...request.Option) (*SetDefaultPolicyVersionOutput, error) {
	req, out := c.SetDefaultPolicyVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetLoggingOptions = "SetLoggingOptions"

// SetLoggingOptionsRequest generates a "aws/request.Request" representing the
// client's request for the SetLoggingOptions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetLoggingOptions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetLoggingOptions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetLoggingOptionsRequest method.
//    req, resp := client.SetLoggingOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) SetLoggingOptionsRequest(input *SetLoggingOptionsInput) (req *request.Request, output *SetLoggingOptionsOutput) {
	op := &request.Operation{
		Name:       opSetLoggingOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/loggingOptions",
	}

	if input == nil {
		input = &SetLoggingOptionsInput{}
	}

	output = &SetLoggingOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetLoggingOptions API operation for AWS IoT.
//
// Sets the logging options.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation SetLoggingOptions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   An unexpected error has occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
func (c *IoT) SetLoggingOptions(input *SetLoggingOptionsInput) (*SetLoggingOptionsOutput, error) {
	req, out := c.SetLoggingOptionsRequest(input)
	return out, req.Send()
}

// SetLoggingOptionsWithContext is the same as SetLoggingOptions with the addition of
// the ability to pass a context and additional request options.
//
// See SetLoggingOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) SetLoggingOptionsWithContext(ctx aws.Context, input *SetLoggingOptionsInput, opts ...request.Option) (*SetLoggingOptionsOutput, error) {
	req, out := c.SetLoggingOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTransferCertificate = "TransferCertificate"

// TransferCertificateRequest generates a "aws/request.Request" representing the
// client's request for the TransferCertificate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See TransferCertificate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the TransferCertificate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the TransferCertificateRequest method.
//    req, resp := client.TransferCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) TransferCertificateRequest(input *TransferCertificateInput) (req *request.Request, output *TransferCertificateOutput) {
	op := &request.Operation{
		Name:       opTransferCertificate,
		HTTPMethod: "PATCH",
		HTTPPath:   "/transfer-certificate/{certificateId}",
	}

	if input == nil {
		input = &TransferCertificateInput{}
	}

	output = &TransferCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TransferCertificate API operation for AWS IoT.
//
// Transfers the specified certificate to the specified AWS account.
//
// You can cancel the transfer until it is acknowledged by the recipient.
//
// No notification is sent to the transfer destination's account. It is up to
// the caller to notify the transfer target.
//
// The certificate being transferred must not be in the ACTIVE state. You can
// use the UpdateCertificate API to deactivate it.
//
// The certificate must not have any policies attached to it. You can use the
// DetachPrincipalPolicy API to detach them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation TransferCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeCertificateStateException "CertificateStateException"
//   The certificate operation is not allowed.
//
//   * ErrCodeTransferConflictException "TransferConflictException"
//   You can't transfer the certificate because authorization policies are still
//   attached.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) TransferCertificate(input *TransferCertificateInput) (*TransferCertificateOutput, error) {
	req, out := c.TransferCertificateRequest(input)
	return out, req.Send()
}

// TransferCertificateWithContext is the same as TransferCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See TransferCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) TransferCertificateWithContext(ctx aws.Context, input *TransferCertificateInput, opts ...request.Option) (*TransferCertificateOutput, error) {
	req, out := c.TransferCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCACertificate = "UpdateCACertificate"

// UpdateCACertificateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCACertificate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateCACertificate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateCACertificate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateCACertificateRequest method.
//    req, resp := client.UpdateCACertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateCACertificateRequest(input *UpdateCACertificateInput) (req *request.Request, output *UpdateCACertificateOutput) {
	op := &request.Operation{
		Name:       opUpdateCACertificate,
		HTTPMethod: "PUT",
		HTTPPath:   "/cacertificate/{caCertificateId}",
	}

	if input == nil {
		input = &UpdateCACertificateInput{}
	}

	output = &UpdateCACertificateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateCACertificate API operation for AWS IoT.
//
// Updates a registered CA certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateCACertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) UpdateCACertificate(input *UpdateCACertificateInput) (*UpdateCACertificateOutput, error) {
	req, out := c.UpdateCACertificateRequest(input)
	return out, req.Send()
}

// UpdateCACertificateWithContext is the same as UpdateCACertificate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCACertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateCACertificateWithContext(ctx aws.Context, input *UpdateCACertificateInput, opts ...request.Option) (*UpdateCACertificateOutput, error) {
	req, out := c.UpdateCACertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCertificate = "UpdateCertificate"

// UpdateCertificateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCertificate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateCertificate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateCertificate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateCertificateRequest method.
//    req, resp := client.UpdateCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateCertificateRequest(input *UpdateCertificateInput) (req *request.Request, output *UpdateCertificateOutput) {
	op := &request.Operation{
		Name:       opUpdateCertificate,
		HTTPMethod: "PUT",
		HTTPPath:   "/certificates/{certificateId}",
	}

	if input == nil {
		input = &UpdateCertificateInput{}
	}

	output = &UpdateCertificateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateCertificate API operation for AWS IoT.
//
// Updates the status of the specified certificate. This operation is idempotent.
//
// Moving a certificate from the ACTIVE state (including REVOKED) will not disconnect
// currently connected devices, but these devices will be unable to reconnect.
//
// The ACTIVE state is required to authenticate devices connecting to AWS IoT
// using a certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
//   * ErrCodeCertificateStateException "CertificateStateException"
//   The certificate operation is not allowed.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
func (c *IoT) UpdateCertificate(input *UpdateCertificateInput) (*UpdateCertificateOutput, error) {
	req, out := c.UpdateCertificateRequest(input)
	return out, req.Send()
}

// UpdateCertificateWithContext is the same as UpdateCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateCertificateWithContext(ctx aws.Context, input *UpdateCertificateInput, opts ...request.Option) (*UpdateCertificateOutput, error) {
	req, out := c.UpdateCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateThing = "UpdateThing"

// UpdateThingRequest generates a "aws/request.Request" representing the
// client's request for the UpdateThing operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateThing for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateThing method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateThingRequest method.
//    req, resp := client.UpdateThingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IoT) UpdateThingRequest(input *UpdateThingInput) (req *request.Request, output *UpdateThingOutput) {
	op := &request.Operation{
		Name:       opUpdateThing,
		HTTPMethod: "PATCH",
		HTTPPath:   "/things/{thingName}",
	}

	if input == nil {
		input = &UpdateThingInput{}
	}

	output = &UpdateThingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateThing API operation for AWS IoT.
//
// Updates the data for a thing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT's
// API operation UpdateThing for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeVersionConflictException "VersionConflictException"
//   An exception thrown when the version of a thing passed to a command is different
//   than the version specified with the --version parameter.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The rate exceeds the limit.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is temporarily unavailable.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An unexpected error has occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource does not exist.
//
func (c *IoT) UpdateThing(input *UpdateThingInput) (*UpdateThingOutput, error) {
	req, out := c.UpdateThingRequest(input)
	return out, req.Send()
}

// UpdateThingWithContext is the same as UpdateThing with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateThing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT) UpdateThingWithContext(ctx aws.Context, input *UpdateThingInput, opts ...request.Option) (*UpdateThingOutput, error) {
	req, out := c.UpdateThingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The input for the AcceptCertificateTransfer operation.
type AcceptCertificateTransferInput struct {
	_ struct{} `type:"structure"`

	// The ID of the certificate.
	//
	// CertificateId is a required field
	CertificateId *string `location:"uri" locationName:"certificateId" min:"64" type:"string" required:"true"`

	// Specifies whether the certificate is active.
	SetAsActive *bool `location:"querystring" locationName:"setAsActive" type:"boolean"`
}

// String returns the string representation
func (s AcceptCertificateTransferInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptCertificateTransferInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptCertificateTransferInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptCertificateTransferInput"}
	if s.CertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateId"))
	}
	if s.CertificateId != nil && len(*s.CertificateId) < 64 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateId", 64))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateId sets the CertificateId field's value.
func (s *AcceptCertificateTransferInput) SetCertificateId(v string) *AcceptCertificateTransferInput {
	s.CertificateId = &v
	return s
}

// SetSetAsActive sets the SetAsActive field's value.
func (s *AcceptCertificateTransferInput) SetSetAsActive(v bool) *AcceptCertificateTransferInput {
	s.SetAsActive = &v
	return s
}

type AcceptCertificateTransferOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AcceptCertificateTransferOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptCertificateTransferOutput) GoString() string {
	return s.String()
}

// Describes the actions associated with a rule.
type Action struct {
	_ struct{} `type:"structure"`

	// Change the state of a CloudWatch alarm.
	CloudwatchAlarm *CloudwatchAlarmAction `locationName:"cloudwatchAlarm" type:"structure"`

	// Capture a CloudWatch metric.
	CloudwatchMetric *CloudwatchMetricAction `locationName:"cloudwatchMetric" type:"structure"`

	// Write to a DynamoDB table.
	DynamoDB *DynamoDBAction `locationName:"dynamoDB" type:"structure"`

	// Write to a DynamoDB table. This is a new version of the DynamoDB action.
	// It allows you to write each attribute in an MQTT message payload into a separate
	// DynamoDB column.
	DynamoDBv2 *DynamoDBv2Action `locationName:"dynamoDBv2" type:"structure"`

	// Write data to an Amazon Elasticsearch Service domain.
	Elasticsearch *ElasticsearchAction `locationName:"elasticsearch" type:"structure"`

	// Write to an Amazon Kinesis Firehose stream.
	Firehose *FirehoseAction `locationName:"firehose" type:"structure"`

	// Write data to an Amazon Kinesis stream.
	Kinesis *KinesisAction `locationName:"kinesis" type:"structure"`

	// Invoke a Lambda function.
	Lambda *LambdaAction `locationName:"lambda" type:"structure"`

	// Publish to another MQTT topic.
	Republish *RepublishAction `locationName:"republish" type:"structure"`

	// Write to an Amazon S3 bucket.
	S3 *S3Action `locationName:"s3" type:"structure"`

	// Publish to an Amazon SNS topic.
	Sns *SnsAction `locationName:"sns" type:"structure"`

	// Publish to an Amazon SQS queue.
	Sqs *SqsAction `locationName:"sqs" type:"structure"`
}

// String returns the string representation
func (s Action) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Action) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Action) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Action"}
	if s.CloudwatchAlarm != nil {
		if err := s.CloudwatchAlarm.Validate(); err != nil {
			invalidParams.AddNested("CloudwatchAlarm", err.(request.ErrInvalidParams))
		}
	}
	if s.CloudwatchMetric != nil {
		if err := s.CloudwatchMetric.Validate(); err != nil {
			invalidParams.AddNested("CloudwatchMetric", err.(request.ErrInvalidParams))
		}
	}
	if s.DynamoDB != nil {
		if err := s.DynamoDB.Validate(); err != nil {
			invalidParams.AddNested("DynamoDB", err.(request.ErrInvalidParams))
		}
	}
	if s.DynamoDBv2 != nil {
		if err := s.DynamoDBv2.Validate(); err != nil {
			invalidParams.AddNested("DynamoDBv2", err.(request.ErrInvalidParams))
		}
	}
	if s.Elasticsearch != nil {
		if err := s.Elasticsearch.Validate(); err != nil {
			invalidParams.AddNested("Elasticsearch", err.(request.ErrInvalidParams))
		}
	}
	if s.Firehose != nil {
		if err := s.Firehose.Validate(); err != nil {
			invalidParams.AddNested("Firehose", err.(request.ErrInvalidParams))
		}
	}
	if s.Kinesis != nil {
		if err := s.Kinesis.Validate(); err != nil {
			invalidParams.AddNested("Kinesis", err.(request.ErrInvalidParams))
		}
	}
	if s.Lambda != nil {
		if err := s.Lambda.Validate(); err != nil {
			invalidParams.AddNested("Lambda", err.(request.ErrInvalidParams))
		}
	}
	if s.Republish != nil {
		if err := s.Republish.Validate(); err != nil {
			invalidParams.AddNested("Republish", err.(request.ErrInvalidParams))
		}
	}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(request.ErrInvalidParams))
		}
	}
	if s.Sns != nil {
		if err := s.Sns.Validate(); err != nil {
			invalidParams.AddNested("Sns", err.(request.ErrInvalidParams))
		}
	}
	if s.Sqs != nil {
		if err := s.Sqs.Validate(); err != nil {
			invalidParams.AddNested("Sqs", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudwatchAlarm sets the CloudwatchAlarm field's value.
func (s *Action) SetCloudwatchAlarm(v *CloudwatchAlarmAction) *Action {
	s.CloudwatchAlarm = v
	return s
}

// SetCloudwatchMetric sets the CloudwatchMetric field's value.
func (s *Action) SetCloudwatchMetric(v *CloudwatchMetricAction) *Action {
	s.CloudwatchMetric = v
	return s
}

// SetDynamoDB sets the DynamoDB field's value.
func (s *Action) SetDynamoDB(v *DynamoDBAction) *Action {
	s.DynamoDB = v
	return s
}

// SetDynamoDBv2 sets the DynamoDBv2 field's value.
func (s *Action) SetDynamoDBv2(v *DynamoDBv2Action) *Action {
	s.DynamoDBv2 = v
	return s
}

// SetElasticsearch sets the Elasticsearch field's value.
func (s *Action) SetElasticsearch(v *ElasticsearchAction) *Action {
	s.Elasticsearch = v
	return s
}

// SetFirehose sets the Firehose field's value.
func (s *Action) SetFirehose(v *FirehoseAction) *Action {
	s.Firehose = v
	return s
}

// SetKinesis sets the Kinesis field's value.
func (s *Action) SetKinesis(v *KinesisAction) *Action {
	s.Kinesis = v
	return s
}

// SetLambda sets the Lambda field's value.
func (s *Action) SetLambda(v *LambdaAction) *Action {
	s.Lambda = v
	return s
}

// SetRepublish sets the Republish field's value.
func (s *Action) SetRepublish(v *RepublishAction) *Action {
	s.Republish = v
	return s
}

// SetS3 sets the S3 field's value.
func (s *Action) SetS3(v *S3Action) *Action {
	s.S3 = v
	return s
}

// SetSns sets the Sns field's value.
func (s *Action) SetSns(v *SnsAction) *Action {
	s.Sns = v
	return s
}

// SetSqs sets the Sqs field's value.
func (s *Action) SetSqs(v *SqsAction) *Action {
	s.Sqs = v
	return s
}

// The input for the AttachPrincipalPolicy operation.
type AttachPrincipalPolicyInput struct {
	_ struct{} `type:"structure"`

	// The policy name.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`

	// The principal, which can be a certificate ARN (as returned from the CreateCertificate
	// operation) or an Amazon Cognito ID.
	//
	// Principal is a required field
	Principal *string `location:"header" locationName:"x-amzn-iot-principal" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachPrincipalPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachPrincipalPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachPrincipalPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachPrincipalPolicyInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *AttachPrincipalPolicyInput) SetPolicyName(v string) *AttachPrincipalPolicyInput {
	s.PolicyName = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *AttachPrincipalPolicyInput) SetPrincipal(v string) *AttachPrincipalPolicyInput {
	s.Principal = &v
	return s
}

type AttachPrincipalPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachPrincipalPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachPrincipalPolicyOutput) GoString() string {
	return s.String()
}

// The input for the AttachThingPrincipal operation.
type AttachThingPrincipalInput struct {
	_ struct{} `type:"structure"`

	// The principal, such as a certificate or other credential.
	//
	// Principal is a required field
	Principal *string `location:"header" locationName:"x-amzn-principal" type:"string" required:"true"`

	// The name of the thing.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachThingPrincipalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachThingPrincipalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachThingPrincipalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachThingPrincipalInput"}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrincipal sets the Principal field's value.
func (s *AttachThingPrincipalInput) SetPrincipal(v string) *AttachThingPrincipalInput {
	s.Principal = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *AttachThingPrincipalInput) SetThingName(v string) *AttachThingPrincipalInput {
	s.ThingName = &v
	return s
}

// The output from the AttachThingPrincipal operation.
type AttachThingPrincipalOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachThingPrincipalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachThingPrincipalOutput) GoString() string {
	return s.String()
}

// The attribute payload.
type AttributePayload struct {
	_ struct{} `type:"structure"`

	// A JSON string containing up to three key-value pair in JSON format. For example:
	//
	// {\"attributes\":{\"string1\":\"string2\"}})
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// Specifies whether the list of attributes provided in the AttributePayload
	// is merged with the attributes stored in the registry, instead of overwriting
	// them.
	//
	// To remove an attribute, call UpdateThing with an empty attribute value.
	//
	// The merge attribute is only valid when calling UpdateThing.
	Merge *bool `locationName:"merge" type:"boolean"`
}

// String returns the string representation
func (s AttributePayload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttributePayload) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *AttributePayload) SetAttributes(v map[string]*string) *AttributePayload {
	s.Attributes = v
	return s
}

// SetMerge sets the Merge field's value.
func (s *AttributePayload) SetMerge(v bool) *AttributePayload {
	s.Merge = &v
	return s
}

// A CA certificate.
type CACertificate struct {
	_ struct{} `type:"structure"`

	// The ARN of the CA certificate.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The ID of the CA certificate.
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`

	// The date the CA certificate was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix"`

	// The status of the CA certificate.
	//
	// The status value REGISTER_INACTIVE is deprecated and should not be used.
	Status *string `locationName:"status" type:"string" enum:"CACertificateStatus"`
}

// String returns the string representation
func (s CACertificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CACertificate) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *CACertificate) SetCertificateArn(v string) *CACertificate {
	s.CertificateArn = &v
	return s
}

// SetCertificateId sets the CertificateId field's value.
func (s *CACertificate) SetCertificateId(v string) *CACertificate {
	s.CertificateId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *CACertificate) SetCreationDate(v time.Time) *CACertificate {
	s.CreationDate = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CACertificate) SetStatus(v string) *CACertificate {
	s.Status = &v
	return s
}

// Describes a CA certificate.
type CACertificateDescription struct {
	_ struct{} `type:"structure"`

	// Whether the CA certificate configured for auto registration of device certificates.
	// Valid values are "ENABLE" and "DISABLE"
	AutoRegistrationStatus *string `locationName:"autoRegistrationStatus" type:"string" enum:"AutoRegistrationStatus"`

	// The CA certificate ARN.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The CA certificate ID.
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`

	// The CA certificate data, in PEM format.
	CertificatePem *string `locationName:"certificatePem" min:"1" type:"string"`

	// The date the CA certificate was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix"`

	// The owner of the CA certificate.
	OwnedBy *string `locationName:"ownedBy" type:"string"`

	// The status of a CA certificate.
	Status *string `locationName:"status" type:"string" enum:"CACertificateStatus"`
}

// String returns the string representation
func (s CACertificateDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CACertificateDescription) GoString() string {
	return s.String()
}

// SetAutoRegistrationStatus sets the AutoRegistrationStatus field's value.
func (s *CACertificateDescription) SetAutoRegistrationStatus(v string) *CACertificateDescription {
	s.AutoRegistrationStatus = &v
	return s
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *CACertificateDescription) SetCertificateArn(v string) *CACertificateDescription {
	s.CertificateArn = &v
	return s
}

// SetCertificateId sets the CertificateId field's value.
func (s *CACertificateDescription) SetCertificateId(v string) *CACertificateDescription {
	s.CertificateId = &v
	return s
}

// SetCertificatePem sets the CertificatePem field's value.
func (s *CACertificateDescription) SetCertificatePem(v string) *CACertificateDescription {
	s.CertificatePem = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *CACertificateDescription) SetCreationDate(v time.Time) *CACertificateDescription {
	s.CreationDate = &v
	return s
}

// SetOwnedBy sets the OwnedBy field's value.
func (s *CACertificateDescription) SetOwnedBy(v string) *CACertificateDescription {
	s.OwnedBy = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CACertificateDescription) SetStatus(v string) *CACertificateDescription {
	s.Status = &v
	return s
}

// The input for the CancelCertificateTransfer operation.
type CancelCertificateTransferInput struct {
	_ struct{} `type:"structure"`

	// The ID of the certificate.
	//
	// CertificateId is a required field
	CertificateId *string `location:"uri" locationName:"certificateId" min:"64" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelCertificateTransferInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelCertificateTransferInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelCertificateTransferInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelCertificateTransferInput"}
	if s.CertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateId"))
	}
	if s.CertificateId != nil && len(*s.CertificateId) < 64 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateId", 64))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateId sets the CertificateId field's value.
func (s *CancelCertificateTransferInput) SetCertificateId(v string) *CancelCertificateTransferInput {
	s.CertificateId = &v
	return s
}

type CancelCertificateTransferOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelCertificateTransferOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelCertificateTransferOutput) GoString() string {
	return s.String()
}

// Information about a certificate.
type Certificate struct {
	_ struct{} `type:"structure"`

	// The ARN of the certificate.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The ID of the certificate.
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`

	// The date and time the certificate was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix"`

	// The status of the certificate.
	//
	// The status value REGISTER_INACTIVE is deprecated and should not be used.
	Status *string `locationName:"status" type:"string" enum:"CertificateStatus"`
}

// String returns the string representation
func (s Certificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Certificate) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *Certificate) SetCertificateArn(v string) *Certificate {
	s.CertificateArn = &v
	return s
}

// SetCertificateId sets the CertificateId field's value.
func (s *Certificate) SetCertificateId(v string) *Certificate {
	s.CertificateId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *Certificate) SetCreationDate(v time.Time) *Certificate {
	s.CreationDate = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Certificate) SetStatus(v string) *Certificate {
	s.Status = &v
	return s
}

// Describes a certificate.
type CertificateDescription struct {
	_ struct{} `type:"structure"`

	// The certificate ID of the CA certificate used to sign this certificate.
	CaCertificateId *string `locationName:"caCertificateId" min:"64" type:"string"`

	// The ARN of the certificate.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The ID of the certificate.
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`

	// The certificate data, in PEM format.
	CertificatePem *string `locationName:"certificatePem" min:"1" type:"string"`

	// The date and time the certificate was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix"`

	// The date and time the certificate was last modified.
	LastModifiedDate *time.Time `locationName:"lastModifiedDate" type:"timestamp" timestampFormat:"unix"`

	// The ID of the AWS account that owns the certificate.
	OwnedBy *string `locationName:"ownedBy" type:"string"`

	// The ID of the AWS account of the previous owner of the certificate.
	PreviousOwnedBy *string `locationName:"previousOwnedBy" type:"string"`

	// The status of the certificate.
	Status *string `locationName:"status" type:"string" enum:"CertificateStatus"`

	// The transfer data.
	TransferData *TransferData `locationName:"transferData" type:"structure"`
}

// String returns the string representation
func (s CertificateDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CertificateDescription) GoString() string {
	return s.String()
}

// SetCaCertificateId sets the CaCertificateId field's value.
func (s *CertificateDescription) SetCaCertificateId(v string) *CertificateDescription {
	s.CaCertificateId = &v
	return s
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *CertificateDescription) SetCertificateArn(v string) *CertificateDescription {
	s.CertificateArn = &v
	return s
}

// SetCertificateId sets the CertificateId field's value.
func (s *CertificateDescription) SetCertificateId(v string) *CertificateDescription {
	s.CertificateId = &v
	return s
}

// SetCertificatePem sets the CertificatePem field's value.
func (s *CertificateDescription) SetCertificatePem(v string) *CertificateDescription {
	s.CertificatePem = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *CertificateDescription) SetCreationDate(v time.Time) *CertificateDescription {
	s.CreationDate = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *CertificateDescription) SetLastModifiedDate(v time.Time) *CertificateDescription {
	s.LastModifiedDate = &v
	return s
}

// SetOwnedBy sets the OwnedBy field's value.
func (s *CertificateDescription) SetOwnedBy(v string) *CertificateDescription {
	s.OwnedBy = &v
	return s
}

// SetPreviousOwnedBy sets the PreviousOwnedBy field's value.
func (s *CertificateDescription) SetPreviousOwnedBy(v string) *CertificateDescription {
	s.PreviousOwnedBy = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CertificateDescription) SetStatus(v string) *CertificateDescription {
	s.Status = &v
	return s
}

// SetTransferData sets the TransferData field's value.
func (s *CertificateDescription) SetTransferData(v *TransferData) *CertificateDescription {
	s.TransferData = v
	return s
}

// Describes an action that updates a CloudWatch alarm.
type CloudwatchAlarmAction struct {
	_ struct{} `type:"structure"`

	// The CloudWatch alarm name.
	//
	// AlarmName is a required field
	AlarmName *string `locationName:"alarmName" type:"string" required:"true"`

	// The IAM role that allows access to the CloudWatch alarm.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The reason for the alarm change.
	//
	// StateReason is a required field
	StateReason *string `locationName:"stateReason" type:"string" required:"true"`

	// The value of the alarm state. Acceptable values are: OK, ALARM, INSUFFICIENT_DATA.
	//
	// StateValue is a required field
	StateValue *string `locationName:"stateValue" type:"string" required:"true"`
}

// String returns the string representation
func (s CloudwatchAlarmAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudwatchAlarmAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudwatchAlarmAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudwatchAlarmAction"}
	if s.AlarmName == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmName"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.StateReason == nil {
		invalidParams.Add(request.NewErrParamRequired("StateReason"))
	}
	if s.StateValue == nil {
		invalidParams.Add(request.NewErrParamRequired("StateValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmName sets the AlarmName field's value.
func (s *CloudwatchAlarmAction) SetAlarmName(v string) *CloudwatchAlarmAction {
	s.AlarmName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CloudwatchAlarmAction) SetRoleArn(v string) *CloudwatchAlarmAction {
	s.RoleArn = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *CloudwatchAlarmAction) SetStateReason(v string) *CloudwatchAlarmAction {
	s.StateReason = &v
	return s
}

// SetStateValue sets the StateValue field's value.
func (s *CloudwatchAlarmAction) SetStateValue(v string) *CloudwatchAlarmAction {
	s.StateValue = &v
	return s
}

// Describes an action that captures a CloudWatch metric.
type CloudwatchMetricAction struct {
	_ struct{} `type:"structure"`

	// The CloudWatch metric name.
	//
	// MetricName is a required field
	MetricName *string `locationName:"metricName" type:"string" required:"true"`

	// The CloudWatch metric namespace name.
	//
	// MetricNamespace is a required field
	MetricNamespace *string `locationName:"metricNamespace" type:"string" required:"true"`

	// An optional Unix timestamp (http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#about_timestamp).
	MetricTimestamp *string `locationName:"metricTimestamp" type:"string"`

	// The metric unit (http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#Unit)
	// supported by CloudWatch.
	//
	// MetricUnit is a required field
	MetricUnit *string `locationName:"metricUnit" type:"string" required:"true"`

	// The CloudWatch metric value.
	//
	// MetricValue is a required field
	MetricValue *string `locationName:"metricValue" type:"string" required:"true"`

	// The IAM role that allows access to the CloudWatch metric.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`
}

// String returns the string representation
func (s CloudwatchMetricAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudwatchMetricAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudwatchMetricAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudwatchMetricAction"}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.MetricNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricNamespace"))
	}
	if s.MetricUnit == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricUnit"))
	}
	if s.MetricValue == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricValue"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetricName sets the MetricName field's value.
func (s *CloudwatchMetricAction) SetMetricName(v string) *CloudwatchMetricAction {
	s.MetricName = &v
	return s
}

// SetMetricNamespace sets the MetricNamespace field's value.
func (s *CloudwatchMetricAction) SetMetricNamespace(v string) *CloudwatchMetricAction {
	s.MetricNamespace = &v
	return s
}

// SetMetricTimestamp sets the MetricTimestamp field's value.
func (s *CloudwatchMetricAction) SetMetricTimestamp(v string) *CloudwatchMetricAction {
	s.MetricTimestamp = &v
	return s
}

// SetMetricUnit sets the MetricUnit field's value.
func (s *CloudwatchMetricAction) SetMetricUnit(v string) *CloudwatchMetricAction {
	s.MetricUnit = &v
	return s
}

// SetMetricValue sets the MetricValue field's value.
func (s *CloudwatchMetricAction) SetMetricValue(v string) *CloudwatchMetricAction {
	s.MetricValue = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CloudwatchMetricAction) SetRoleArn(v string) *CloudwatchMetricAction {
	s.RoleArn = &v
	return s
}

// The input for the CreateCertificateFromCsr operation.
type CreateCertificateFromCsrInput struct {
	_ struct{} `type:"structure"`

	// The certificate signing request (CSR).
	//
	// CertificateSigningRequest is a required field
	CertificateSigningRequest *string `locationName:"certificateSigningRequest" min:"1" type:"string" required:"true"`

	// Specifies whether the certificate is active.
	SetAsActive *bool `location:"querystring" locationName:"setAsActive" type:"boolean"`
}

// String returns the string representation
func (s CreateCertificateFromCsrInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCertificateFromCsrInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCertificateFromCsrInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCertificateFromCsrInput"}
	if s.CertificateSigningRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateSigningRequest"))
	}
	if s.CertificateSigningRequest != nil && len(*s.CertificateSigningRequest) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateSigningRequest", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateSigningRequest sets the CertificateSigningRequest field's value.
func (s *CreateCertificateFromCsrInput) SetCertificateSigningRequest(v string) *CreateCertificateFromCsrInput {
	s.CertificateSigningRequest = &v
	return s
}

// SetSetAsActive sets the SetAsActive field's value.
func (s *CreateCertificateFromCsrInput) SetSetAsActive(v bool) *CreateCertificateFromCsrInput {
	s.SetAsActive = &v
	return s
}

// The output from the CreateCertificateFromCsr operation.
type CreateCertificateFromCsrOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the certificate. You can use the ARN as
	// a principal for policy operations.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The ID of the certificate. Certificate management operations only take a
	// certificateId.
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`

	// The certificate data, in PEM format.
	CertificatePem *string `locationName:"certificatePem" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateCertificateFromCsrOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCertificateFromCsrOutput) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *CreateCertificateFromCsrOutput) SetCertificateArn(v string) *CreateCertificateFromCsrOutput {
	s.CertificateArn = &v
	return s
}

// SetCertificateId sets the CertificateId field's value.
func (s *CreateCertificateFromCsrOutput) SetCertificateId(v string) *CreateCertificateFromCsrOutput {
	s.CertificateId = &v
	return s
}

// SetCertificatePem sets the CertificatePem field's value.
func (s *CreateCertificateFromCsrOutput) SetCertificatePem(v string) *CreateCertificateFromCsrOutput {
	s.CertificatePem = &v
	return s
}

// The input for the CreateKeysAndCertificate operation.
type CreateKeysAndCertificateInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the certificate is active.
	SetAsActive *bool `location:"querystring" locationName:"setAsActive" type:"boolean"`
}

// String returns the string representation
func (s CreateKeysAndCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeysAndCertificateInput) GoString() string {
	return s.String()
}

// SetSetAsActive sets the SetAsActive field's value.
func (s *CreateKeysAndCertificateInput) SetSetAsActive(v bool) *CreateKeysAndCertificateInput {
	s.SetAsActive = &v
	return s
}

// The output of the CreateKeysAndCertificate operation.
type CreateKeysAndCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the certificate.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The ID of the certificate. AWS IoT issues a default subject name for the
	// certificate (for example, AWS IoT Certificate).
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`

	// The certificate data, in PEM format.
	CertificatePem *string `locationName:"certificatePem" min:"1" type:"string"`

	// The generated key pair.
	KeyPair *KeyPair `locationName:"keyPair" type:"structure"`
}

// String returns the string representation
func (s CreateKeysAndCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeysAndCertificateOutput) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *CreateKeysAndCertificateOutput) SetCertificateArn(v string) *CreateKeysAndCertificateOutput {
	s.CertificateArn = &v
	return s
}

// SetCertificateId sets the CertificateId field's value.
func (s *CreateKeysAndCertificateOutput) SetCertificateId(v string) *CreateKeysAndCertificateOutput {
	s.CertificateId = &v
	return s
}

// SetCertificatePem sets the CertificatePem field's value.
func (s *CreateKeysAndCertificateOutput) SetCertificatePem(v string) *CreateKeysAndCertificateOutput {
	s.CertificatePem = &v
	return s
}

// SetKeyPair sets the KeyPair field's value.
func (s *CreateKeysAndCertificateOutput) SetKeyPair(v *KeyPair) *CreateKeysAndCertificateOutput {
	s.KeyPair = v
	return s
}

// The input for the CreatePolicy operation.
type CreatePolicyInput struct {
	_ struct{} `type:"structure"`

	// The JSON document that describes the policy. policyDocument must have a minimum
	// length of 1, with a maximum length of 2048, excluding whitespace.
	//
	// PolicyDocument is a required field
	PolicyDocument *string `locationName:"policyDocument" type:"string" required:"true"`

	// The policy name.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePolicyInput"}
	if s.PolicyDocument == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyDocument"))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *CreatePolicyInput) SetPolicyDocument(v string) *CreatePolicyInput {
	s.PolicyDocument = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *CreatePolicyInput) SetPolicyName(v string) *CreatePolicyInput {
	s.PolicyName = &v
	return s
}

// The output from the CreatePolicy operation.
type CreatePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The policy ARN.
	PolicyArn *string `locationName:"policyArn" type:"string"`

	// The JSON document that describes the policy.
	PolicyDocument *string `locationName:"policyDocument" type:"string"`

	// The policy name.
	PolicyName *string `locationName:"policyName" min:"1" type:"string"`

	// The policy version ID.
	PolicyVersionId *string `locationName:"policyVersionId" type:"string"`
}

// String returns the string representation
func (s CreatePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *CreatePolicyOutput) SetPolicyArn(v string) *CreatePolicyOutput {
	s.PolicyArn = &v
	return s
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *CreatePolicyOutput) SetPolicyDocument(v string) *CreatePolicyOutput {
	s.PolicyDocument = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *CreatePolicyOutput) SetPolicyName(v string) *CreatePolicyOutput {
	s.PolicyName = &v
	return s
}

// SetPolicyVersionId sets the PolicyVersionId field's value.
func (s *CreatePolicyOutput) SetPolicyVersionId(v string) *CreatePolicyOutput {
	s.PolicyVersionId = &v
	return s
}

// The input for the CreatePolicyVersion operation.
type CreatePolicyVersionInput struct {
	_ struct{} `type:"structure"`

	// The JSON document that describes the policy. Minimum length of 1. Maximum
	// length of 2048, excluding whitespaces
	//
	// PolicyDocument is a required field
	PolicyDocument *string `locationName:"policyDocument" type:"string" required:"true"`

	// The policy name.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`

	// Specifies whether the policy version is set as the default. When this parameter
	// is true, the new policy version becomes the operative version (that is, the
	// version that is in effect for the certificates to which the policy is attached).
	SetAsDefault *bool `location:"querystring" locationName:"setAsDefault" type:"boolean"`
}

// String returns the string representation
func (s CreatePolicyVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePolicyVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePolicyVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePolicyVersionInput"}
	if s.PolicyDocument == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyDocument"))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *CreatePolicyVersionInput) SetPolicyDocument(v string) *CreatePolicyVersionInput {
	s.PolicyDocument = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *CreatePolicyVersionInput) SetPolicyName(v string) *CreatePolicyVersionInput {
	s.PolicyName = &v
	return s
}

// SetSetAsDefault sets the SetAsDefault field's value.
func (s *CreatePolicyVersionInput) SetSetAsDefault(v bool) *CreatePolicyVersionInput {
	s.SetAsDefault = &v
	return s
}

// The output of the CreatePolicyVersion operation.
type CreatePolicyVersionOutput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the policy version is the default.
	IsDefaultVersion *bool `locationName:"isDefaultVersion" type:"boolean"`

	// The policy ARN.
	PolicyArn *string `locationName:"policyArn" type:"string"`

	// The JSON document that describes the policy.
	PolicyDocument *string `locationName:"policyDocument" type:"string"`

	// The policy version ID.
	PolicyVersionId *string `locationName:"policyVersionId" type:"string"`
}

// String returns the string representation
func (s CreatePolicyVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePolicyVersionOutput) GoString() string {
	return s.String()
}

// SetIsDefaultVersion sets the IsDefaultVersion field's value.
func (s *CreatePolicyVersionOutput) SetIsDefaultVersion(v bool) *CreatePolicyVersionOutput {
	s.IsDefaultVersion = &v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *CreatePolicyVersionOutput) SetPolicyArn(v string) *CreatePolicyVersionOutput {
	s.PolicyArn = &v
	return s
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *CreatePolicyVersionOutput) SetPolicyDocument(v string) *CreatePolicyVersionOutput {
	s.PolicyDocument = &v
	return s
}

// SetPolicyVersionId sets the PolicyVersionId field's value.
func (s *CreatePolicyVersionOutput) SetPolicyVersionId(v string) *CreatePolicyVersionOutput {
	s.PolicyVersionId = &v
	return s
}

// The input for the CreateThing operation.
type CreateThingInput struct {
	_ struct{} `type:"structure"`

	// The attribute payload, which consists of up to three name/value pairs in
	// a JSON document. For example:
	//
	// {\"attributes\":{\"string1\":\"string2\"}})
	AttributePayload *AttributePayload `locationName:"attributePayload" type:"structure"`

	// The name of the thing to create.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`

	// The name of the thing type associated with the new thing.
	ThingTypeName *string `locationName:"thingTypeName" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateThingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateThingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateThingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateThingInput"}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}
	if s.ThingTypeName != nil && len(*s.ThingTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingTypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributePayload sets the AttributePayload field's value.
func (s *CreateThingInput) SetAttributePayload(v *AttributePayload) *CreateThingInput {
	s.AttributePayload = v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *CreateThingInput) SetThingName(v string) *CreateThingInput {
	s.ThingName = &v
	return s
}

// SetThingTypeName sets the ThingTypeName field's value.
func (s *CreateThingInput) SetThingTypeName(v string) *CreateThingInput {
	s.ThingTypeName = &v
	return s
}

// The output of the CreateThing operation.
type CreateThingOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the new thing.
	ThingArn *string `locationName:"thingArn" type:"string"`

	// The name of the new thing.
	ThingName *string `locationName:"thingName" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateThingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateThingOutput) GoString() string {
	return s.String()
}

// SetThingArn sets the ThingArn field's value.
func (s *CreateThingOutput) SetThingArn(v string) *CreateThingOutput {
	s.ThingArn = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *CreateThingOutput) SetThingName(v string) *CreateThingOutput {
	s.ThingName = &v
	return s
}

// The input for the CreateThingType operation.
type CreateThingTypeInput struct {
	_ struct{} `type:"structure"`

	// The name of the thing type.
	//
	// ThingTypeName is a required field
	ThingTypeName *string `location:"uri" locationName:"thingTypeName" min:"1" type:"string" required:"true"`

	// The ThingTypeProperties for the thing type to create. It contains information
	// about the new thing type including a description, and a list of searchable
	// thing attribute names.
	ThingTypeProperties *ThingTypeProperties `locationName:"thingTypeProperties" type:"structure"`
}

// String returns the string representation
func (s CreateThingTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateThingTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateThingTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateThingTypeInput"}
	if s.ThingTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingTypeName"))
	}
	if s.ThingTypeName != nil && len(*s.ThingTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingTypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetThingTypeName sets the ThingTypeName field's value.
func (s *CreateThingTypeInput) SetThingTypeName(v string) *CreateThingTypeInput {
	s.ThingTypeName = &v
	return s
}

// SetThingTypeProperties sets the ThingTypeProperties field's value.
func (s *CreateThingTypeInput) SetThingTypeProperties(v *ThingTypeProperties) *CreateThingTypeInput {
	s.ThingTypeProperties = v
	return s
}

// The output of the CreateThingType operation.
type CreateThingTypeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the thing type.
	ThingTypeArn *string `locationName:"thingTypeArn" type:"string"`

	// The name of the thing type.
	ThingTypeName *string `locationName:"thingTypeName" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateThingTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateThingTypeOutput) GoString() string {
	return s.String()
}

// SetThingTypeArn sets the ThingTypeArn field's value.
func (s *CreateThingTypeOutput) SetThingTypeArn(v string) *CreateThingTypeOutput {
	s.ThingTypeArn = &v
	return s
}

// SetThingTypeName sets the ThingTypeName field's value.
func (s *CreateThingTypeOutput) SetThingTypeName(v string) *CreateThingTypeOutput {
	s.ThingTypeName = &v
	return s
}

// The input for the CreateTopicRule operation.
type CreateTopicRuleInput struct {
	_ struct{} `type:"structure" payload:"TopicRulePayload"`

	// The name of the rule.
	//
	// RuleName is a required field
	RuleName *string `location:"uri" locationName:"ruleName" min:"1" type:"string" required:"true"`

	// The rule payload.
	//
	// TopicRulePayload is a required field
	TopicRulePayload *TopicRulePayload `locationName:"topicRulePayload" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateTopicRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTopicRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTopicRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTopicRuleInput"}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}
	if s.TopicRulePayload == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicRulePayload"))
	}
	if s.TopicRulePayload != nil {
		if err := s.TopicRulePayload.Validate(); err != nil {
			invalidParams.AddNested("TopicRulePayload", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleName sets the RuleName field's value.
func (s *CreateTopicRuleInput) SetRuleName(v string) *CreateTopicRuleInput {
	s.RuleName = &v
	return s
}

// SetTopicRulePayload sets the TopicRulePayload field's value.
func (s *CreateTopicRuleInput) SetTopicRulePayload(v *TopicRulePayload) *CreateTopicRuleInput {
	s.TopicRulePayload = v
	return s
}

type CreateTopicRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateTopicRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTopicRuleOutput) GoString() string {
	return s.String()
}

// Input for the DeleteCACertificate operation.
type DeleteCACertificateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the certificate to delete.
	//
	// CertificateId is a required field
	CertificateId *string `location:"uri" locationName:"caCertificateId" min:"64" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCACertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCACertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCACertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCACertificateInput"}
	if s.CertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateId"))
	}
	if s.CertificateId != nil && len(*s.CertificateId) < 64 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateId", 64))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateId sets the CertificateId field's value.
func (s *DeleteCACertificateInput) SetCertificateId(v string) *DeleteCACertificateInput {
	s.CertificateId = &v
	return s
}

// The output for the DeleteCACertificate operation.
type DeleteCACertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCACertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCACertificateOutput) GoString() string {
	return s.String()
}

// The input for the DeleteCertificate operation.
type DeleteCertificateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the certificate.
	//
	// CertificateId is a required field
	CertificateId *string `location:"uri" locationName:"certificateId" min:"64" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCertificateInput"}
	if s.CertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateId"))
	}
	if s.CertificateId != nil && len(*s.CertificateId) < 64 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateId", 64))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateId sets the CertificateId field's value.
func (s *DeleteCertificateInput) SetCertificateId(v string) *DeleteCertificateInput {
	s.CertificateId = &v
	return s
}

type DeleteCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCertificateOutput) GoString() string {
	return s.String()
}

// The input for the DeletePolicy operation.
type DeletePolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the policy to delete.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePolicyInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *DeletePolicyInput) SetPolicyName(v string) *DeletePolicyInput {
	s.PolicyName = &v
	return s
}

type DeletePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyOutput) GoString() string {
	return s.String()
}

// The input for the DeletePolicyVersion operation.
type DeletePolicyVersionInput struct {
	_ struct{} `type:"structure"`

	// The name of the policy.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`

	// The policy version ID.
	//
	// PolicyVersionId is a required field
	PolicyVersionId *string `location:"uri" locationName:"policyVersionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePolicyVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePolicyVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePolicyVersionInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.PolicyVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyVersionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *DeletePolicyVersionInput) SetPolicyName(v string) *DeletePolicyVersionInput {
	s.PolicyName = &v
	return s
}

// SetPolicyVersionId sets the PolicyVersionId field's value.
func (s *DeletePolicyVersionInput) SetPolicyVersionId(v string) *DeletePolicyVersionInput {
	s.PolicyVersionId = &v
	return s
}

type DeletePolicyVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePolicyVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyVersionOutput) GoString() string {
	return s.String()
}

// The input for the DeleteRegistrationCode operation.
type DeleteRegistrationCodeInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRegistrationCodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRegistrationCodeInput) GoString() string {
	return s.String()
}

// The output for the DeleteRegistrationCode operation.
type DeleteRegistrationCodeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRegistrationCodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRegistrationCodeOutput) GoString() string {
	return s.String()
}

// The input for the DeleteThing operation.
type DeleteThingInput struct {
	_ struct{} `type:"structure"`

	// The expected version of the thing record in the registry. If the version
	// of the record in the registry does not match the expected version specified
	// in the request, the DeleteThing request is rejected with a VersionConflictException.
	ExpectedVersion *int64 `location:"querystring" locationName:"expectedVersion" type:"long"`

	// The name of the thing to delete.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteThingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteThingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteThingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteThingInput"}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpectedVersion sets the ExpectedVersion field's value.
func (s *DeleteThingInput) SetExpectedVersion(v int64) *DeleteThingInput {
	s.ExpectedVersion = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *DeleteThingInput) SetThingName(v string) *DeleteThingInput {
	s.ThingName = &v
	return s
}

// The output of the DeleteThing operation.
type DeleteThingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteThingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteThingOutput) GoString() string {
	return s.String()
}

// The input for the DeleteThingType operation.
type DeleteThingTypeInput struct {
	_ struct{} `type:"structure"`

	// The name of the thing type.
	//
	// ThingTypeName is a required field
	ThingTypeName *string `location:"uri" locationName:"thingTypeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteThingTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteThingTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteThingTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteThingTypeInput"}
	if s.ThingTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingTypeName"))
	}
	if s.ThingTypeName != nil && len(*s.ThingTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingTypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetThingTypeName sets the ThingTypeName field's value.
func (s *DeleteThingTypeInput) SetThingTypeName(v string) *DeleteThingTypeInput {
	s.ThingTypeName = &v
	return s
}

// The output for the DeleteThingType operation.
type DeleteThingTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteThingTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteThingTypeOutput) GoString() string {
	return s.String()
}

// The input for the DeleteTopicRule operation.
type DeleteTopicRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the rule.
	//
	// RuleName is a required field
	RuleName *string `location:"uri" locationName:"ruleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTopicRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTopicRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTopicRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTopicRuleInput"}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleName sets the RuleName field's value.
func (s *DeleteTopicRuleInput) SetRuleName(v string) *DeleteTopicRuleInput {
	s.RuleName = &v
	return s
}

type DeleteTopicRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTopicRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTopicRuleOutput) GoString() string {
	return s.String()
}

// The input for the DeprecateThingType operation.
type DeprecateThingTypeInput struct {
	_ struct{} `type:"structure"`

	// The name of the thing type to deprecate.
	//
	// ThingTypeName is a required field
	ThingTypeName *string `location:"uri" locationName:"thingTypeName" min:"1" type:"string" required:"true"`

	// Whether to undeprecate a deprecated thing type. If true, the thing type will
	// not be deprecated anymore and you can associate it with things.
	UndoDeprecate *bool `locationName:"undoDeprecate" type:"boolean"`
}

// String returns the string representation
func (s DeprecateThingTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeprecateThingTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeprecateThingTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeprecateThingTypeInput"}
	if s.ThingTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingTypeName"))
	}
	if s.ThingTypeName != nil && len(*s.ThingTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingTypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetThingTypeName sets the ThingTypeName field's value.
func (s *DeprecateThingTypeInput) SetThingTypeName(v string) *DeprecateThingTypeInput {
	s.ThingTypeName = &v
	return s
}

// SetUndoDeprecate sets the UndoDeprecate field's value.
func (s *DeprecateThingTypeInput) SetUndoDeprecate(v bool) *DeprecateThingTypeInput {
	s.UndoDeprecate = &v
	return s
}

// The output for the DeprecateThingType operation.
type DeprecateThingTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeprecateThingTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeprecateThingTypeOutput) GoString() string {
	return s.String()
}

// The input for the DescribeCACertificate operation.
type DescribeCACertificateInput struct {
	_ struct{} `type:"structure"`

	// The CA certificate identifier.
	//
	// CertificateId is a required field
	CertificateId *string `location:"uri" locationName:"caCertificateId" min:"64" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeCACertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCACertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCACertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCACertificateInput"}
	if s.CertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateId"))
	}
	if s.CertificateId != nil && len(*s.CertificateId) < 64 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateId", 64))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateId sets the CertificateId field's value.
func (s *DescribeCACertificateInput) SetCertificateId(v string) *DescribeCACertificateInput {
	s.CertificateId = &v
	return s
}

// The output from the DescribeCACertificate operation.
type DescribeCACertificateOutput struct {
	_ struct{} `type:"structure"`

	// The CA certificate description.
	CertificateDescription *CACertificateDescription `locationName:"certificateDescription" type:"structure"`
}

// String returns the string representation
func (s DescribeCACertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCACertificateOutput) GoString() string {
	return s.String()
}

// SetCertificateDescription sets the CertificateDescription field's value.
func (s *DescribeCACertificateOutput) SetCertificateDescription(v *CACertificateDescription) *DescribeCACertificateOutput {
	s.CertificateDescription = v
	return s
}

// The input for the DescribeCertificate operation.
type DescribeCertificateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the certificate.
	//
	// CertificateId is a required field
	CertificateId *string `location:"uri" locationName:"certificateId" min:"64" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCertificateInput"}
	if s.CertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateId"))
	}
	if s.CertificateId != nil && len(*s.CertificateId) < 64 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateId", 64))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateId sets the CertificateId field's value.
func (s *DescribeCertificateInput) SetCertificateId(v string) *DescribeCertificateInput {
	s.CertificateId = &v
	return s
}

// The output of the DescribeCertificate operation.
type DescribeCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The description of the certificate.
	CertificateDescription *CertificateDescription `locationName:"certificateDescription" type:"structure"`
}

// String returns the string representation
func (s DescribeCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificateOutput) GoString() string {
	return s.String()
}

// SetCertificateDescription sets the CertificateDescription field's value.
func (s *DescribeCertificateOutput) SetCertificateDescription(v *CertificateDescription) *DescribeCertificateOutput {
	s.CertificateDescription = v
	return s
}

// The input for the DescribeEndpoint operation.
type DescribeEndpointInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointInput) GoString() string {
	return s.String()
}

// The output from the DescribeEndpoint operation.
type DescribeEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The endpoint. The format of the endpoint is as follows: identifier.iot.region.amazonaws.com.
	EndpointAddress *string `locationName:"endpointAddress" type:"string"`
}

// String returns the string representation
func (s DescribeEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpointAddress sets the EndpointAddress field's value.
func (s *DescribeEndpointOutput) SetEndpointAddress(v string) *DescribeEndpointOutput {
	s.EndpointAddress = &v
	return s
}

// The input for the DescribeThing operation.
type DescribeThingInput struct {
	_ struct{} `type:"structure"`

	// The name of the thing.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeThingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeThingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeThingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeThingInput"}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetThingName sets the ThingName field's value.
func (s *DescribeThingInput) SetThingName(v string) *DescribeThingInput {
	s.ThingName = &v
	return s
}

// The output from the DescribeThing operation.
type DescribeThingOutput struct {
	_ struct{} `type:"structure"`

	// The thing attributes.
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// The default client ID.
	DefaultClientId *string `locationName:"defaultClientId" type:"string"`

	// The name of the thing.
	ThingName *string `locationName:"thingName" min:"1" type:"string"`

	// The thing type name.
	ThingTypeName *string `locationName:"thingTypeName" min:"1" type:"string"`

	// The current version of the thing record in the registry.
	//
	// To avoid unintentional changes to the information in the registry, you can
	// pass the version information in the expectedVersion parameter of the UpdateThing
	// and DeleteThing calls.
	Version *int64 `locationName:"version" type:"long"`
}

// String returns the string representation
func (s DescribeThingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeThingOutput) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *DescribeThingOutput) SetAttributes(v map[string]*string) *DescribeThingOutput {
	s.Attributes = v
	return s
}

// SetDefaultClientId sets the DefaultClientId field's value.
func (s *DescribeThingOutput) SetDefaultClientId(v string) *DescribeThingOutput {
	s.DefaultClientId = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *DescribeThingOutput) SetThingName(v string) *DescribeThingOutput {
	s.ThingName = &v
	return s
}

// SetThingTypeName sets the ThingTypeName field's value.
func (s *DescribeThingOutput) SetThingTypeName(v string) *DescribeThingOutput {
	s.ThingTypeName = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *DescribeThingOutput) SetVersion(v int64) *DescribeThingOutput {
	s.Version = &v
	return s
}

// The input for the DescribeThingType operation.
type DescribeThingTypeInput struct {
	_ struct{} `type:"structure"`

	// The name of the thing type.
	//
	// ThingTypeName is a required field
	ThingTypeName *string `location:"uri" locationName:"thingTypeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeThingTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeThingTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeThingTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeThingTypeInput"}
	if s.ThingTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingTypeName"))
	}
	if s.ThingTypeName != nil && len(*s.ThingTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingTypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetThingTypeName sets the ThingTypeName field's value.
func (s *DescribeThingTypeInput) SetThingTypeName(v string) *DescribeThingTypeInput {
	s.ThingTypeName = &v
	return s
}

// The output for the DescribeThingType operation.
type DescribeThingTypeOutput struct {
	_ struct{} `type:"structure"`

	// The ThingTypeMetadata contains additional information about the thing type
	// including: creation date and time, a value indicating whether the thing type
	// is deprecated, and a date and time when time was deprecated.
	ThingTypeMetadata *ThingTypeMetadata `locationName:"thingTypeMetadata" type:"structure"`

	// The name of the thing type.
	ThingTypeName *string `locationName:"thingTypeName" min:"1" type:"string"`

	// The ThingTypeProperties contains information about the thing type including
	// description, and a list of searchable thing attribute names.
	ThingTypeProperties *ThingTypeProperties `locationName:"thingTypeProperties" type:"structure"`
}

// String returns the string representation
func (s DescribeThingTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeThingTypeOutput) GoString() string {
	return s.String()
}

// SetThingTypeMetadata sets the ThingTypeMetadata field's value.
func (s *DescribeThingTypeOutput) SetThingTypeMetadata(v *ThingTypeMetadata) *DescribeThingTypeOutput {
	s.ThingTypeMetadata = v
	return s
}

// SetThingTypeName sets the ThingTypeName field's value.
func (s *DescribeThingTypeOutput) SetThingTypeName(v string) *DescribeThingTypeOutput {
	s.ThingTypeName = &v
	return s
}

// SetThingTypeProperties sets the ThingTypeProperties field's value.
func (s *DescribeThingTypeOutput) SetThingTypeProperties(v *ThingTypeProperties) *DescribeThingTypeOutput {
	s.ThingTypeProperties = v
	return s
}

// The input for the DetachPrincipalPolicy operation.
type DetachPrincipalPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the policy to detach.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`

	// The principal.
	//
	// If the principal is a certificate, specify the certificate ARN. If the principal
	// is an Amazon Cognito identity, specify the identity ID.
	//
	// Principal is a required field
	Principal *string `location:"header" locationName:"x-amzn-iot-principal" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachPrincipalPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachPrincipalPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachPrincipalPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachPrincipalPolicyInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *DetachPrincipalPolicyInput) SetPolicyName(v string) *DetachPrincipalPolicyInput {
	s.PolicyName = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *DetachPrincipalPolicyInput) SetPrincipal(v string) *DetachPrincipalPolicyInput {
	s.Principal = &v
	return s
}

type DetachPrincipalPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachPrincipalPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachPrincipalPolicyOutput) GoString() string {
	return s.String()
}

// The input for the DetachThingPrincipal operation.
type DetachThingPrincipalInput struct {
	_ struct{} `type:"structure"`

	// If the principal is a certificate, this value must be ARN of the certificate.
	// If the principal is an Amazon Cognito identity, this value must be the ID
	// of the Amazon Cognito identity.
	//
	// Principal is a required field
	Principal *string `location:"header" locationName:"x-amzn-principal" type:"string" required:"true"`

	// The name of the thing.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachThingPrincipalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachThingPrincipalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachThingPrincipalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachThingPrincipalInput"}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrincipal sets the Principal field's value.
func (s *DetachThingPrincipalInput) SetPrincipal(v string) *DetachThingPrincipalInput {
	s.Principal = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *DetachThingPrincipalInput) SetThingName(v string) *DetachThingPrincipalInput {
	s.ThingName = &v
	return s
}

// The output from the DetachThingPrincipal operation.
type DetachThingPrincipalOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachThingPrincipalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachThingPrincipalOutput) GoString() string {
	return s.String()
}

// The input for the DisableTopicRuleRequest operation.
type DisableTopicRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the rule to disable.
	//
	// RuleName is a required field
	RuleName *string `location:"uri" locationName:"ruleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableTopicRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableTopicRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableTopicRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableTopicRuleInput"}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleName sets the RuleName field's value.
func (s *DisableTopicRuleInput) SetRuleName(v string) *DisableTopicRuleInput {
	s.RuleName = &v
	return s
}

type DisableTopicRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableTopicRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableTopicRuleOutput) GoString() string {
	return s.String()
}

// Describes an action to write to a DynamoDB table.
//
// The tableName, hashKeyField, and rangeKeyField values must match the values
// used when you created the table.
//
// The hashKeyValue and rangeKeyvalue fields use a substitution template syntax.
// These templates provide data at runtime. The syntax is as follows: ${sql-expression}.
//
// You can specify any valid expression in a WHERE or SELECT clause, including
// JSON properties, comparisons, calculations, and functions. For example, the
// following field uses the third level of the topic:
//
// "hashKeyValue": "${topic(3)}"
//
// The following field uses the timestamp:
//
// "rangeKeyValue": "${timestamp()}"
type DynamoDBAction struct {
	_ struct{} `type:"structure"`

	// The hash key name.
	//
	// HashKeyField is a required field
	HashKeyField *string `locationName:"hashKeyField" type:"string" required:"true"`

	// The hash key type. Valid values are "STRING" or "NUMBER"
	HashKeyType *string `locationName:"hashKeyType" type:"string" enum:"DynamoKeyType"`

	// The hash key value.
	//
	// HashKeyValue is a required field
	HashKeyValue *string `locationName:"hashKeyValue" type:"string" required:"true"`

	// The type of operation to be performed. This follows the substitution template,
	// so it can be ${operation}, but the substitution must result in one of the
	// following: INSERT, UPDATE, or DELETE.
	Operation *string `locationName:"operation" type:"string"`

	// The action payload. This name can be customized.
	PayloadField *string `locationName:"payloadField" type:"string"`

	// The range key name.
	RangeKeyField *string `locationName:"rangeKeyField" type:"string"`

	// The range key type. Valid values are "STRING" or "NUMBER"
	RangeKeyType *string `locationName:"rangeKeyType" type:"string" enum:"DynamoKeyType"`

	// The range key value.
	RangeKeyValue *string `locationName:"rangeKeyValue" type:"string"`

	// The ARN of the IAM role that grants access to the DynamoDB table.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The name of the DynamoDB table.
	//
	// TableName is a required field
	TableName *string `locationName:"tableName" type:"string" required:"true"`
}

// String returns the string representation
func (s DynamoDBAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DynamoDBAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DynamoDBAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DynamoDBAction"}
	if s.HashKeyField == nil {
		invalidParams.Add(request.NewErrParamRequired("HashKeyField"))
	}
	if s.HashKeyValue == nil {
		invalidParams.Add(request.NewErrParamRequired("HashKeyValue"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHashKeyField sets the HashKeyField field's value.
func (s *DynamoDBAction) SetHashKeyField(v string) *DynamoDBAction {
	s.HashKeyField = &v
	return s
}

// SetHashKeyType sets the HashKeyType field's value.
func (s *DynamoDBAction) SetHashKeyType(v string) *DynamoDBAction {
	s.HashKeyType = &v
	return s
}

// SetHashKeyValue sets the HashKeyValue field's value.
func (s *DynamoDBAction) SetHashKeyValue(v string) *DynamoDBAction {
	s.HashKeyValue = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *DynamoDBAction) SetOperation(v string) *DynamoDBAction {
	s.Operation = &v
	return s
}

// SetPayloadField sets the PayloadField field's value.
func (s *DynamoDBAction) SetPayloadField(v string) *DynamoDBAction {
	s.PayloadField = &v
	return s
}

// SetRangeKeyField sets the RangeKeyField field's value.
func (s *DynamoDBAction) SetRangeKeyField(v string) *DynamoDBAction {
	s.RangeKeyField = &v
	return s
}

// SetRangeKeyType sets the RangeKeyType field's value.
func (s *DynamoDBAction) SetRangeKeyType(v string) *DynamoDBAction {
	s.RangeKeyType = &v
	return s
}

// SetRangeKeyValue sets the RangeKeyValue field's value.
func (s *DynamoDBAction) SetRangeKeyValue(v string) *DynamoDBAction {
	s.RangeKeyValue = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DynamoDBAction) SetRoleArn(v string) *DynamoDBAction {
	s.RoleArn = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *DynamoDBAction) SetTableName(v string) *DynamoDBAction {
	s.TableName = &v
	return s
}

// Describes an action to write to a DynamoDB table.
//
// This DynamoDB action writes each attribute in the message payload into it's
// own column in the DynamoDB table.
type DynamoDBv2Action struct {
	_ struct{} `type:"structure"`

	// Specifies the DynamoDB table to which the message data will be written. For
	// example:
	//
	// { "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": { "tableName":
	// "my-table" } } }
	//
	// Each attribute in the message payload will be written to a separate column
	// in the DynamoDB database.
	PutItem *PutItemInput `locationName:"putItem" type:"structure"`

	// The ARN of the IAM role that grants access to the DynamoDB table.
	RoleArn *string `locationName:"roleArn" type:"string"`
}

// String returns the string representation
func (s DynamoDBv2Action) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DynamoDBv2Action) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DynamoDBv2Action) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DynamoDBv2Action"}
	if s.PutItem != nil {
		if err := s.PutItem.Validate(); err != nil {
			invalidParams.AddNested("PutItem", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPutItem sets the PutItem field's value.
func (s *DynamoDBv2Action) SetPutItem(v *PutItemInput) *DynamoDBv2Action {
	s.PutItem = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DynamoDBv2Action) SetRoleArn(v string) *DynamoDBv2Action {
	s.RoleArn = &v
	return s
}

// Describes an action that writes data to an Amazon Elasticsearch Service domain.
type ElasticsearchAction struct {
	_ struct{} `type:"structure"`

	// The endpoint of your Elasticsearch domain.
	//
	// Endpoint is a required field
	Endpoint *string `locationName:"endpoint" type:"string" required:"true"`

	// The unique identifier for the document you are storing.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The Elasticsearch index where you want to store your data.
	//
	// Index is a required field
	Index *string `locationName:"index" type:"string" required:"true"`

	// The IAM role ARN that has access to Elasticsearch.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The type of document you are storing.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true"`
}

// String returns the string representation
func (s ElasticsearchAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticsearchAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ElasticsearchAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ElasticsearchAction"}
	if s.Endpoint == nil {
		invalidParams.Add(request.NewErrParamRequired("Endpoint"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Index == nil {
		invalidParams.Add(request.NewErrParamRequired("Index"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpoint sets the Endpoint field's value.
func (s *ElasticsearchAction) SetEndpoint(v string) *ElasticsearchAction {
	s.Endpoint = &v
	return s
}

// SetId sets the Id field's value.
func (s *ElasticsearchAction) SetId(v string) *ElasticsearchAction {
	s.Id = &v
	return s
}

// SetIndex sets the Index field's value.
func (s *ElasticsearchAction) SetIndex(v string) *ElasticsearchAction {
	s.Index = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ElasticsearchAction) SetRoleArn(v string) *ElasticsearchAction {
	s.RoleArn = &v
	return s
}

// SetType sets the Type field's value.
func (s *ElasticsearchAction) SetType(v string) *ElasticsearchAction {
	s.Type = &v
	return s
}

// The input for the EnableTopicRuleRequest operation.
type EnableTopicRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the topic rule to enable.
	//
	// RuleName is a required field
	RuleName *string `location:"uri" locationName:"ruleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s EnableTopicRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableTopicRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableTopicRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableTopicRuleInput"}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleName sets the RuleName field's value.
func (s *EnableTopicRuleInput) SetRuleName(v string) *EnableTopicRuleInput {
	s.RuleName = &v
	return s
}

type EnableTopicRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableTopicRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableTopicRuleOutput) GoString() string {
	return s.String()
}

// Describes an action that writes data to an Amazon Kinesis Firehose stream.
type FirehoseAction struct {
	_ struct{} `type:"structure"`

	// The delivery stream name.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `locationName:"deliveryStreamName" type:"string" required:"true"`

	// The IAM role that grants access to the Amazon Kinesis Firehost stream.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// A character separator that will be used to separate records written to the
	// Firehose stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows
	// newline), ',' (comma).
	Separator *string `locationName:"separator" type:"string"`
}

// String returns the string representation
func (s FirehoseAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FirehoseAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FirehoseAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FirehoseAction"}
	if s.DeliveryStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamName"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryStreamName sets the DeliveryStreamName field's value.
func (s *FirehoseAction) SetDeliveryStreamName(v string) *FirehoseAction {
	s.DeliveryStreamName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *FirehoseAction) SetRoleArn(v string) *FirehoseAction {
	s.RoleArn = &v
	return s
}

// SetSeparator sets the Separator field's value.
func (s *FirehoseAction) SetSeparator(v string) *FirehoseAction {
	s.Separator = &v
	return s
}

// The input for the GetLoggingOptions operation.
type GetLoggingOptionsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetLoggingOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLoggingOptionsInput) GoString() string {
	return s.String()
}

// The output from the GetLoggingOptions operation.
type GetLoggingOptionsOutput struct {
	_ struct{} `type:"structure"`

	// The logging level.
	LogLevel *string `locationName:"logLevel" type:"string" enum:"LogLevel"`

	// The ARN of the IAM role that grants access.
	RoleArn *string `locationName:"roleArn" type:"string"`
}

// String returns the string representation
func (s GetLoggingOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLoggingOptionsOutput) GoString() string {
	return s.String()
}

// SetLogLevel sets the LogLevel field's value.
func (s *GetLoggingOptionsOutput) SetLogLevel(v string) *GetLoggingOptionsOutput {
	s.LogLevel = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetLoggingOptionsOutput) SetRoleArn(v string) *GetLoggingOptionsOutput {
	s.RoleArn = &v
	return s
}

// The input for the GetPolicy operation.
type GetPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the policy.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPolicyInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *GetPolicyInput) SetPolicyName(v string) *GetPolicyInput {
	s.PolicyName = &v
	return s
}

// The output from the GetPolicy operation.
type GetPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The default policy version ID.
	DefaultVersionId *string `locationName:"defaultVersionId" type:"string"`

	// The policy ARN.
	PolicyArn *string `locationName:"policyArn" type:"string"`

	// The JSON document that describes the policy.
	PolicyDocument *string `locationName:"policyDocument" type:"string"`

	// The policy name.
	PolicyName *string `locationName:"policyName" min:"1" type:"string"`
}

// String returns the string representation
func (s GetPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyOutput) GoString() string {
	return s.String()
}

// SetDefaultVersionId sets the DefaultVersionId field's value.
func (s *GetPolicyOutput) SetDefaultVersionId(v string) *GetPolicyOutput {
	s.DefaultVersionId = &v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *GetPolicyOutput) SetPolicyArn(v string) *GetPolicyOutput {
	s.PolicyArn = &v
	return s
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *GetPolicyOutput) SetPolicyDocument(v string) *GetPolicyOutput {
	s.PolicyDocument = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *GetPolicyOutput) SetPolicyName(v string) *GetPolicyOutput {
	s.PolicyName = &v
	return s
}

// The input for the GetPolicyVersion operation.
type GetPolicyVersionInput struct {
	_ struct{} `type:"structure"`

	// The name of the policy.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`

	// The policy version ID.
	//
	// PolicyVersionId is a required field
	PolicyVersionId *string `location:"uri" locationName:"policyVersionId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPolicyVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPolicyVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPolicyVersionInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.PolicyVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyVersionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *GetPolicyVersionInput) SetPolicyName(v string) *GetPolicyVersionInput {
	s.PolicyName = &v
	return s
}

// SetPolicyVersionId sets the PolicyVersionId field's value.
func (s *GetPolicyVersionInput) SetPolicyVersionId(v string) *GetPolicyVersionInput {
	s.PolicyVersionId = &v
	return s
}

// The output from the GetPolicyVersion operation.
type GetPolicyVersionOutput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the policy version is the default.
	IsDefaultVersion *bool `locationName:"isDefaultVersion" type:"boolean"`

	// The policy ARN.
	PolicyArn *string `locationName:"policyArn" type:"string"`

	// The JSON document that describes the policy.
	PolicyDocument *string `locationName:"policyDocument" type:"string"`

	// The policy name.
	PolicyName *string `locationName:"policyName" min:"1" type:"string"`

	// The policy version ID.
	PolicyVersionId *string `locationName:"policyVersionId" type:"string"`
}

// String returns the string representation
func (s GetPolicyVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyVersionOutput) GoString() string {
	return s.String()
}

// SetIsDefaultVersion sets the IsDefaultVersion field's value.
func (s *GetPolicyVersionOutput) SetIsDefaultVersion(v bool) *GetPolicyVersionOutput {
	s.IsDefaultVersion = &v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *GetPolicyVersionOutput) SetPolicyArn(v string) *GetPolicyVersionOutput {
	s.PolicyArn = &v
	return s
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *GetPolicyVersionOutput) SetPolicyDocument(v string) *GetPolicyVersionOutput {
	s.PolicyDocument = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *GetPolicyVersionOutput) SetPolicyName(v string) *GetPolicyVersionOutput {
	s.PolicyName = &v
	return s
}

// SetPolicyVersionId sets the PolicyVersionId field's value.
func (s *GetPolicyVersionOutput) SetPolicyVersionId(v string) *GetPolicyVersionOutput {
	s.PolicyVersionId = &v
	return s
}

// The input to the GetRegistrationCode operation.
type GetRegistrationCodeInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetRegistrationCodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRegistrationCodeInput) GoString() string {
	return s.String()
}

// The output from the GetRegistrationCode operation.
type GetRegistrationCodeOutput struct {
	_ struct{} `type:"structure"`

	// The CA certificate registration code.
	RegistrationCode *string `locationName:"registrationCode" min:"64" type:"string"`
}

// String returns the string representation
func (s GetRegistrationCodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRegistrationCodeOutput) GoString() string {
	return s.String()
}

// SetRegistrationCode sets the RegistrationCode field's value.
func (s *GetRegistrationCodeOutput) SetRegistrationCode(v string) *GetRegistrationCodeOutput {
	s.RegistrationCode = &v
	return s
}

// The input for the GetTopicRule operation.
type GetTopicRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the rule.
	//
	// RuleName is a required field
	RuleName *string `location:"uri" locationName:"ruleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetTopicRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTopicRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTopicRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTopicRuleInput"}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleName sets the RuleName field's value.
func (s *GetTopicRuleInput) SetRuleName(v string) *GetTopicRuleInput {
	s.RuleName = &v
	return s
}

// The output from the GetTopicRule operation.
type GetTopicRuleOutput struct {
	_ struct{} `type:"structure"`

	// The rule.
	Rule *TopicRule `locationName:"rule" type:"structure"`

	// The rule ARN.
	RuleArn *string `locationName:"ruleArn" type:"string"`
}

// String returns the string representation
func (s GetTopicRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTopicRuleOutput) GoString() string {
	return s.String()
}

// SetRule sets the Rule field's value.
func (s *GetTopicRuleOutput) SetRule(v *TopicRule) *GetTopicRuleOutput {
	s.Rule = v
	return s
}

// SetRuleArn sets the RuleArn field's value.
func (s *GetTopicRuleOutput) SetRuleArn(v string) *GetTopicRuleOutput {
	s.RuleArn = &v
	return s
}

// Describes a key pair.
type KeyPair struct {
	_ struct{} `type:"structure"`

	// The private key.
	PrivateKey *string `min:"1" type:"string"`

	// The public key.
	PublicKey *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KeyPair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyPair) GoString() string {
	return s.String()
}

// SetPrivateKey sets the PrivateKey field's value.
func (s *KeyPair) SetPrivateKey(v string) *KeyPair {
	s.PrivateKey = &v
	return s
}

// SetPublicKey sets the PublicKey field's value.
func (s *KeyPair) SetPublicKey(v string) *KeyPair {
	s.PublicKey = &v
	return s
}

// Describes an action to write data to an Amazon Kinesis stream.
type KinesisAction struct {
	_ struct{} `type:"structure"`

	// The partition key.
	PartitionKey *string `locationName:"partitionKey" type:"string"`

	// The ARN of the IAM role that grants access to the Amazon Kinesis stream.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The name of the Amazon Kinesis stream.
	//
	// StreamName is a required field
	StreamName *string `locationName:"streamName" type:"string" required:"true"`
}

// String returns the string representation
func (s KinesisAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KinesisAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisAction"}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.StreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPartitionKey sets the PartitionKey field's value.
func (s *KinesisAction) SetPartitionKey(v string) *KinesisAction {
	s.PartitionKey = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *KinesisAction) SetRoleArn(v string) *KinesisAction {
	s.RoleArn = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *KinesisAction) SetStreamName(v string) *KinesisAction {
	s.StreamName = &v
	return s
}

// Describes an action to invoke a Lambda function.
type LambdaAction struct {
	_ struct{} `type:"structure"`

	// The ARN of the Lambda function.
	//
	// FunctionArn is a required field
	FunctionArn *string `locationName:"functionArn" type:"string" required:"true"`
}

// String returns the string representation
func (s LambdaAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaAction"}
	if s.FunctionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionArn sets the FunctionArn field's value.
func (s *LambdaAction) SetFunctionArn(v string) *LambdaAction {
	s.FunctionArn = &v
	return s
}

// Input for the ListCACertificates operation.
type ListCACertificatesInput struct {
	_ struct{} `type:"structure"`

	// Determines the order of the results.
	AscendingOrder *bool `location:"querystring" locationName:"isAscendingOrder" type:"boolean"`

	// The marker for the next set of results.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The result page size.
	PageSize *int64 `location:"querystring" locationName:"pageSize" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListCACertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCACertificatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCACertificatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCACertificatesInput"}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAscendingOrder sets the AscendingOrder field's value.
func (s *ListCACertificatesInput) SetAscendingOrder(v bool) *ListCACertificatesInput {
	s.AscendingOrder = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListCACertificatesInput) SetMarker(v string) *ListCACertificatesInput {
	s.Marker = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListCACertificatesInput) SetPageSize(v int64) *ListCACertificatesInput {
	s.PageSize = &v
	return s
}

// The output from the ListCACertificates operation.
type ListCACertificatesOutput struct {
	_ struct{} `type:"structure"`

	// The CA certificates registered in your AWS account.
	Certificates []*CACertificate `locationName:"certificates" type:"list"`

	// The current position within the list of CA certificates.
	NextMarker *string `locationName:"nextMarker" type:"string"`
}

// String returns the string representation
func (s ListCACertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCACertificatesOutput) GoString() string {
	return s.String()
}

// SetCertificates sets the Certificates field's value.
func (s *ListCACertificatesOutput) SetCertificates(v []*CACertificate) *ListCACertificatesOutput {
	s.Certificates = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListCACertificatesOutput) SetNextMarker(v string) *ListCACertificatesOutput {
	s.NextMarker = &v
	return s
}

// The input to the ListCertificatesByCA operation.
type ListCertificatesByCAInput struct {
	_ struct{} `type:"structure"`

	// Specifies the order for results. If True, the results are returned in ascending
	// order, based on the creation date.
	AscendingOrder *bool `location:"querystring" locationName:"isAscendingOrder" type:"boolean"`

	// The ID of the CA certificate. This operation will list all registered device
	// certificate that were signed by this CA certificate.
	//
	// CaCertificateId is a required field
	CaCertificateId *string `location:"uri" locationName:"caCertificateId" min:"64" type:"string" required:"true"`

	// The marker for the next set of results.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The result page size.
	PageSize *int64 `location:"querystring" locationName:"pageSize" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListCertificatesByCAInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCertificatesByCAInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCertificatesByCAInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCertificatesByCAInput"}
	if s.CaCertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("CaCertificateId"))
	}
	if s.CaCertificateId != nil && len(*s.CaCertificateId) < 64 {
		invalidParams.Add(request.NewErrParamMinLen("CaCertificateId", 64))
	}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAscendingOrder sets the AscendingOrder field's value.
func (s *ListCertificatesByCAInput) SetAscendingOrder(v bool) *ListCertificatesByCAInput {
	s.AscendingOrder = &v
	return s
}

// SetCaCertificateId sets the CaCertificateId field's value.
func (s *ListCertificatesByCAInput) SetCaCertificateId(v string) *ListCertificatesByCAInput {
	s.CaCertificateId = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListCertificatesByCAInput) SetMarker(v string) *ListCertificatesByCAInput {
	s.Marker = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListCertificatesByCAInput) SetPageSize(v int64) *ListCertificatesByCAInput {
	s.PageSize = &v
	return s
}

// The output of the ListCertificatesByCA operation.
type ListCertificatesByCAOutput struct {
	_ struct{} `type:"structure"`

	// The device certificates signed by the specified CA certificate.
	Certificates []*Certificate `locationName:"certificates" type:"list"`

	// The marker for the next set of results, or null if there are no additional
	// results.
	NextMarker *string `locationName:"nextMarker" type:"string"`
}

// String returns the string representation
func (s ListCertificatesByCAOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCertificatesByCAOutput) GoString() string {
	return s.String()
}

// SetCertificates sets the Certificates field's value.
func (s *ListCertificatesByCAOutput) SetCertificates(v []*Certificate) *ListCertificatesByCAOutput {
	s.Certificates = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListCertificatesByCAOutput) SetNextMarker(v string) *ListCertificatesByCAOutput {
	s.NextMarker = &v
	return s
}

// The input for the ListCertificates operation.
type ListCertificatesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the order for results. If True, the results are returned in ascending
	// order, based on the creation date.
	AscendingOrder *bool `location:"querystring" locationName:"isAscendingOrder" type:"boolean"`

	// The marker for the next set of results.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The result page size.
	PageSize *int64 `location:"querystring" locationName:"pageSize" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCertificatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCertificatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCertificatesInput"}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAscendingOrder sets the AscendingOrder field's value.
func (s *ListCertificatesInput) SetAscendingOrder(v bool) *ListCertificatesInput {
	s.AscendingOrder = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListCertificatesInput) SetMarker(v string) *ListCertificatesInput {
	s.Marker = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListCertificatesInput) SetPageSize(v int64) *ListCertificatesInput {
	s.PageSize = &v
	return s
}

// The output of the ListCertificates operation.
type ListCertificatesOutput struct {
	_ struct{} `type:"structure"`

	// The descriptions of the certificates.
	Certificates []*Certificate `locationName:"certificates" type:"list"`

	// The marker for the next set of results, or null if there are no additional
	// results.
	NextMarker *string `locationName:"nextMarker" type:"string"`
}

// String returns the string representation
func (s ListCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCertificatesOutput) GoString() string {
	return s.String()
}

// SetCertificates sets the Certificates field's value.
func (s *ListCertificatesOutput) SetCertificates(v []*Certificate) *ListCertificatesOutput {
	s.Certificates = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListCertificatesOutput) SetNextMarker(v string) *ListCertificatesOutput {
	s.NextMarker = &v
	return s
}

// The input to the ListOutgoingCertificates operation.
type ListOutgoingCertificatesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the order for results. If True, the results are returned in ascending
	// order, based on the creation date.
	AscendingOrder *bool `location:"querystring" locationName:"isAscendingOrder" type:"boolean"`

	// The marker for the next set of results.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The result page size.
	PageSize *int64 `location:"querystring" locationName:"pageSize" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListOutgoingCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOutgoingCertificatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOutgoingCertificatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOutgoingCertificatesInput"}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAscendingOrder sets the AscendingOrder field's value.
func (s *ListOutgoingCertificatesInput) SetAscendingOrder(v bool) *ListOutgoingCertificatesInput {
	s.AscendingOrder = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListOutgoingCertificatesInput) SetMarker(v string) *ListOutgoingCertificatesInput {
	s.Marker = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListOutgoingCertificatesInput) SetPageSize(v int64) *ListOutgoingCertificatesInput {
	s.PageSize = &v
	return s
}

// The output from the ListOutgoingCertificates operation.
type ListOutgoingCertificatesOutput struct {
	_ struct{} `type:"structure"`

	// The marker for the next set of results.
	NextMarker *string `locationName:"nextMarker" type:"string"`

	// The certificates that are being transfered but not yet accepted.
	OutgoingCertificates []*OutgoingCertificate `locationName:"outgoingCertificates" type:"list"`
}

// String returns the string representation
func (s ListOutgoingCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOutgoingCertificatesOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListOutgoingCertificatesOutput) SetNextMarker(v string) *ListOutgoingCertificatesOutput {
	s.NextMarker = &v
	return s
}

// SetOutgoingCertificates sets the OutgoingCertificates field's value.
func (s *ListOutgoingCertificatesOutput) SetOutgoingCertificates(v []*OutgoingCertificate) *ListOutgoingCertificatesOutput {
	s.OutgoingCertificates = v
	return s
}

// The input for the ListPolicies operation.
type ListPoliciesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the order for results. If true, the results are returned in ascending
	// creation order.
	AscendingOrder *bool `location:"querystring" locationName:"isAscendingOrder" type:"boolean"`

	// The marker for the next set of results.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The result page size.
	PageSize *int64 `location:"querystring" locationName:"pageSize" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPoliciesInput"}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAscendingOrder sets the AscendingOrder field's value.
func (s *ListPoliciesInput) SetAscendingOrder(v bool) *ListPoliciesInput {
	s.AscendingOrder = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListPoliciesInput) SetMarker(v string) *ListPoliciesInput {
	s.Marker = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListPoliciesInput) SetPageSize(v int64) *ListPoliciesInput {
	s.PageSize = &v
	return s
}

// The output from the ListPolicies operation.
type ListPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// The marker for the next set of results, or null if there are no additional
	// results.
	NextMarker *string `locationName:"nextMarker" type:"string"`

	// The descriptions of the policies.
	Policies []*Policy `locationName:"policies" type:"list"`
}

// String returns the string representation
func (s ListPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPoliciesOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListPoliciesOutput) SetNextMarker(v string) *ListPoliciesOutput {
	s.NextMarker = &v
	return s
}

// SetPolicies sets the Policies field's value.
func (s *ListPoliciesOutput) SetPolicies(v []*Policy) *ListPoliciesOutput {
	s.Policies = v
	return s
}

// The input for the ListPolicyPrincipals operation.
type ListPolicyPrincipalsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the order for results. If true, the results are returned in ascending
	// creation order.
	AscendingOrder *bool `location:"querystring" locationName:"isAscendingOrder" type:"boolean"`

	// The marker for the next set of results.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The result page size.
	PageSize *int64 `location:"querystring" locationName:"pageSize" min:"1" type:"integer"`

	// The policy name.
	//
	// PolicyName is a required field
	PolicyName *string `location:"header" locationName:"x-amzn-iot-policy" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPolicyPrincipalsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPolicyPrincipalsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPolicyPrincipalsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPolicyPrincipalsInput"}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAscendingOrder sets the AscendingOrder field's value.
func (s *ListPolicyPrincipalsInput) SetAscendingOrder(v bool) *ListPolicyPrincipalsInput {
	s.AscendingOrder = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListPolicyPrincipalsInput) SetMarker(v string) *ListPolicyPrincipalsInput {
	s.Marker = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListPolicyPrincipalsInput) SetPageSize(v int64) *ListPolicyPrincipalsInput {
	s.PageSize = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *ListPolicyPrincipalsInput) SetPolicyName(v string) *ListPolicyPrincipalsInput {
	s.PolicyName = &v
	return s
}

// The output from the ListPolicyPrincipals operation.
type ListPolicyPrincipalsOutput struct {
	_ struct{} `type:"structure"`

	// The marker for the next set of results, or null if there are no additional
	// results.
	NextMarker *string `locationName:"nextMarker" type:"string"`

	// The descriptions of the principals.
	Principals []*string `locationName:"principals" type:"list"`
}

// String returns the string representation
func (s ListPolicyPrincipalsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPolicyPrincipalsOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListPolicyPrincipalsOutput) SetNextMarker(v string) *ListPolicyPrincipalsOutput {
	s.NextMarker = &v
	return s
}

// SetPrincipals sets the Principals field's value.
func (s *ListPolicyPrincipalsOutput) SetPrincipals(v []*string) *ListPolicyPrincipalsOutput {
	s.Principals = v
	return s
}

// The input for the ListPolicyVersions operation.
type ListPolicyVersionsInput struct {
	_ struct{} `type:"structure"`

	// The policy name.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPolicyVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPolicyVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPolicyVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPolicyVersionsInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *ListPolicyVersionsInput) SetPolicyName(v string) *ListPolicyVersionsInput {
	s.PolicyName = &v
	return s
}

// The output from the ListPolicyVersions operation.
type ListPolicyVersionsOutput struct {
	_ struct{} `type:"structure"`

	// The policy versions.
	PolicyVersions []*PolicyVersion `locationName:"policyVersions" type:"list"`
}

// String returns the string representation
func (s ListPolicyVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPolicyVersionsOutput) GoString() string {
	return s.String()
}

// SetPolicyVersions sets the PolicyVersions field's value.
func (s *ListPolicyVersionsOutput) SetPolicyVersions(v []*PolicyVersion) *ListPolicyVersionsOutput {
	s.PolicyVersions = v
	return s
}

// The input for the ListPrincipalPolicies operation.
type ListPrincipalPoliciesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the order for results. If true, results are returned in ascending
	// creation order.
	AscendingOrder *bool `location:"querystring" locationName:"isAscendingOrder" type:"boolean"`

	// The marker for the next set of results.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The result page size.
	PageSize *int64 `location:"querystring" locationName:"pageSize" min:"1" type:"integer"`

	// The principal.
	//
	// Principal is a required field
	Principal *string `location:"header" locationName:"x-amzn-iot-principal" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPrincipalPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPrincipalPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPrincipalPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPrincipalPoliciesInput"}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAscendingOrder sets the AscendingOrder field's value.
func (s *ListPrincipalPoliciesInput) SetAscendingOrder(v bool) *ListPrincipalPoliciesInput {
	s.AscendingOrder = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListPrincipalPoliciesInput) SetMarker(v string) *ListPrincipalPoliciesInput {
	s.Marker = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListPrincipalPoliciesInput) SetPageSize(v int64) *ListPrincipalPoliciesInput {
	s.PageSize = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *ListPrincipalPoliciesInput) SetPrincipal(v string) *ListPrincipalPoliciesInput {
	s.Principal = &v
	return s
}

// The output from the ListPrincipalPolicies operation.
type ListPrincipalPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// The marker for the next set of results, or null if there are no additional
	// results.
	NextMarker *string `locationName:"nextMarker" type:"string"`

	// The policies.
	Policies []*Policy `locationName:"policies" type:"list"`
}

// String returns the string representation
func (s ListPrincipalPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPrincipalPoliciesOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListPrincipalPoliciesOutput) SetNextMarker(v string) *ListPrincipalPoliciesOutput {
	s.NextMarker = &v
	return s
}

// SetPolicies sets the Policies field's value.
func (s *ListPrincipalPoliciesOutput) SetPolicies(v []*Policy) *ListPrincipalPoliciesOutput {
	s.Policies = v
	return s
}

// The input for the ListPrincipalThings operation.
type ListPrincipalThingsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in this operation.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The principal.
	//
	// Principal is a required field
	Principal *string `location:"header" locationName:"x-amzn-principal" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPrincipalThingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPrincipalThingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPrincipalThingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPrincipalThingsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPrincipalThingsInput) SetMaxResults(v int64) *ListPrincipalThingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPrincipalThingsInput) SetNextToken(v string) *ListPrincipalThingsInput {
	s.NextToken = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *ListPrincipalThingsInput) SetPrincipal(v string) *ListPrincipalThingsInput {
	s.Principal = &v
	return s
}

// The output from the ListPrincipalThings operation.
type ListPrincipalThingsOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The things.
	Things []*string `locationName:"things" type:"list"`
}

// String returns the string representation
func (s ListPrincipalThingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPrincipalThingsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPrincipalThingsOutput) SetNextToken(v string) *ListPrincipalThingsOutput {
	s.NextToken = &v
	return s
}

// SetThings sets the Things field's value.
func (s *ListPrincipalThingsOutput) SetThings(v []*string) *ListPrincipalThingsOutput {
	s.Things = v
	return s
}

// The input for the ListThingPrincipal operation.
type ListThingPrincipalsInput struct {
	_ struct{} `type:"structure"`

	// The name of the thing.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListThingPrincipalsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListThingPrincipalsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListThingPrincipalsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListThingPrincipalsInput"}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetThingName sets the ThingName field's value.
func (s *ListThingPrincipalsInput) SetThingName(v string) *ListThingPrincipalsInput {
	s.ThingName = &v
	return s
}

// The output from the ListThingPrincipals operation.
type ListThingPrincipalsOutput struct {
	_ struct{} `type:"structure"`

	// The principals associated with the thing.
	Principals []*string `locationName:"principals" type:"list"`
}

// String returns the string representation
func (s ListThingPrincipalsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListThingPrincipalsOutput) GoString() string {
	return s.String()
}

// SetPrincipals sets the Principals field's value.
func (s *ListThingPrincipalsOutput) SetPrincipals(v []*string) *ListThingPrincipalsOutput {
	s.Principals = v
	return s
}

// The input for the ListThingTypes operation.
type ListThingTypesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in this operation.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The name of the thing type.
	ThingTypeName *string `location:"querystring" locationName:"thingTypeName" min:"1" type:"string"`
}

// String returns the string representation
func (s ListThingTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListThingTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListThingTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListThingTypesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ThingTypeName != nil && len(*s.ThingTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingTypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListThingTypesInput) SetMaxResults(v int64) *ListThingTypesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListThingTypesInput) SetNextToken(v string) *ListThingTypesInput {
	s.NextToken = &v
	return s
}

// SetThingTypeName sets the ThingTypeName field's value.
func (s *ListThingTypesInput) SetThingTypeName(v string) *ListThingTypesInput {
	s.ThingTypeName = &v
	return s
}

// The output for the ListThingTypes operation.
type ListThingTypesOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The thing types.
	ThingTypes []*ThingTypeDefinition `locationName:"thingTypes" type:"list"`
}

// String returns the string representation
func (s ListThingTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListThingTypesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListThingTypesOutput) SetNextToken(v string) *ListThingTypesOutput {
	s.NextToken = &v
	return s
}

// SetThingTypes sets the ThingTypes field's value.
func (s *ListThingTypesOutput) SetThingTypes(v []*ThingTypeDefinition) *ListThingTypesOutput {
	s.ThingTypes = v
	return s
}

// The input for the ListThings operation.
type ListThingsInput struct {
	_ struct{} `type:"structure"`

	// The attribute name used to search for things.
	AttributeName *string `location:"querystring" locationName:"attributeName" type:"string"`

	// The attribute value used to search for things.
	AttributeValue *string `location:"querystring" locationName:"attributeValue" type:"string"`

	// The maximum number of results to return in this operation.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The name of the thing type used to search for things.
	ThingTypeName *string `location:"querystring" locationName:"thingTypeName" min:"1" type:"string"`
}

// String returns the string representation
func (s ListThingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListThingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListThingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListThingsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ThingTypeName != nil && len(*s.ThingTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingTypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeName sets the AttributeName field's value.
func (s *ListThingsInput) SetAttributeName(v string) *ListThingsInput {
	s.AttributeName = &v
	return s
}

// SetAttributeValue sets the AttributeValue field's value.
func (s *ListThingsInput) SetAttributeValue(v string) *ListThingsInput {
	s.AttributeValue = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListThingsInput) SetMaxResults(v int64) *ListThingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListThingsInput) SetNextToken(v string) *ListThingsInput {
	s.NextToken = &v
	return s
}

// SetThingTypeName sets the ThingTypeName field's value.
func (s *ListThingsInput) SetThingTypeName(v string) *ListThingsInput {
	s.ThingTypeName = &v
	return s
}

// The output from the ListThings operation.
type ListThingsOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The things.
	Things []*ThingAttribute `locationName:"things" type:"list"`
}

// String returns the string representation
func (s ListThingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListThingsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListThingsOutput) SetNextToken(v string) *ListThingsOutput {
	s.NextToken = &v
	return s
}

// SetThings sets the Things field's value.
func (s *ListThingsOutput) SetThings(v []*ThingAttribute) *ListThingsOutput {
	s.Things = v
	return s
}

// The input for the ListTopicRules operation.
type ListTopicRulesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A token used to retrieve the next value.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// Specifies whether the rule is disabled.
	RuleDisabled *bool `location:"querystring" locationName:"ruleDisabled" type:"boolean"`

	// The topic.
	Topic *string `location:"querystring" locationName:"topic" type:"string"`
}

// String returns the string representation
func (s ListTopicRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTopicRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTopicRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTopicRulesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTopicRulesInput) SetMaxResults(v int64) *ListTopicRulesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTopicRulesInput) SetNextToken(v string) *ListTopicRulesInput {
	s.NextToken = &v
	return s
}

// SetRuleDisabled sets the RuleDisabled field's value.
func (s *ListTopicRulesInput) SetRuleDisabled(v bool) *ListTopicRulesInput {
	s.RuleDisabled = &v
	return s
}

// SetTopic sets the Topic field's value.
func (s *ListTopicRulesInput) SetTopic(v string) *ListTopicRulesInput {
	s.Topic = &v
	return s
}

// The output from the ListTopicRules operation.
type ListTopicRulesOutput struct {
	_ struct{} `type:"structure"`

	// A token used to retrieve the next value.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The rules.
	Rules []*TopicRuleListItem `locationName:"rules" type:"list"`
}

// String returns the string representation
func (s ListTopicRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTopicRulesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTopicRulesOutput) SetNextToken(v string) *ListTopicRulesOutput {
	s.NextToken = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *ListTopicRulesOutput) SetRules(v []*TopicRuleListItem) *ListTopicRulesOutput {
	s.Rules = v
	return s
}

// Describes the logging options payload.
type LoggingOptionsPayload struct {
	_ struct{} `type:"structure"`

	// The logging level.
	LogLevel *string `locationName:"logLevel" type:"string" enum:"LogLevel"`

	// The ARN of the IAM role that grants access.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`
}

// String returns the string representation
func (s LoggingOptionsPayload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoggingOptionsPayload) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingOptionsPayload) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LoggingOptionsPayload"}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogLevel sets the LogLevel field's value.
func (s *LoggingOptionsPayload) SetLogLevel(v string) *LoggingOptionsPayload {
	s.LogLevel = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *LoggingOptionsPayload) SetRoleArn(v string) *LoggingOptionsPayload {
	s.RoleArn = &v
	return s
}

// A certificate that has been transfered but not yet accepted.
type OutgoingCertificate struct {
	_ struct{} `type:"structure"`

	// The certificate ARN.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The certificate ID.
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`

	// The certificate creation date.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix"`

	// The date the transfer was initiated.
	TransferDate *time.Time `locationName:"transferDate" type:"timestamp" timestampFormat:"unix"`

	// The transfer message.
	TransferMessage *string `locationName:"transferMessage" type:"string"`

	// The AWS account to which the transfer was made.
	TransferredTo *string `locationName:"transferredTo" type:"string"`
}

// String returns the string representation
func (s OutgoingCertificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutgoingCertificate) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *OutgoingCertificate) SetCertificateArn(v string) *OutgoingCertificate {
	s.CertificateArn = &v
	return s
}

// SetCertificateId sets the CertificateId field's value.
func (s *OutgoingCertificate) SetCertificateId(v string) *OutgoingCertificate {
	s.CertificateId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *OutgoingCertificate) SetCreationDate(v time.Time) *OutgoingCertificate {
	s.CreationDate = &v
	return s
}

// SetTransferDate sets the TransferDate field's value.
func (s *OutgoingCertificate) SetTransferDate(v time.Time) *OutgoingCertificate {
	s.TransferDate = &v
	return s
}

// SetTransferMessage sets the TransferMessage field's value.
func (s *OutgoingCertificate) SetTransferMessage(v string) *OutgoingCertificate {
	s.TransferMessage = &v
	return s
}

// SetTransferredTo sets the TransferredTo field's value.
func (s *OutgoingCertificate) SetTransferredTo(v string) *OutgoingCertificate {
	s.TransferredTo = &v
	return s
}

// Describes an AWS IoT policy.
type Policy struct {
	_ struct{} `type:"structure"`

	// The policy ARN.
	PolicyArn *string `locationName:"policyArn" type:"string"`

	// The policy name.
	PolicyName *string `locationName:"policyName" min:"1" type:"string"`
}

// String returns the string representation
func (s Policy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Policy) GoString() string {
	return s.String()
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *Policy) SetPolicyArn(v string) *Policy {
	s.PolicyArn = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *Policy) SetPolicyName(v string) *Policy {
	s.PolicyName = &v
	return s
}

// Describes a policy version.
type PolicyVersion struct {
	_ struct{} `type:"structure"`

	// The date and time the policy was created.
	CreateDate *time.Time `locationName:"createDate" type:"timestamp" timestampFormat:"unix"`

	// Specifies whether the policy version is the default.
	IsDefaultVersion *bool `locationName:"isDefaultVersion" type:"boolean"`

	// The policy version ID.
	VersionId *string `locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s PolicyVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyVersion) GoString() string {
	return s.String()
}

// SetCreateDate sets the CreateDate field's value.
func (s *PolicyVersion) SetCreateDate(v time.Time) *PolicyVersion {
	s.CreateDate = &v
	return s
}

// SetIsDefaultVersion sets the IsDefaultVersion field's value.
func (s *PolicyVersion) SetIsDefaultVersion(v bool) *PolicyVersion {
	s.IsDefaultVersion = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *PolicyVersion) SetVersionId(v string) *PolicyVersion {
	s.VersionId = &v
	return s
}

// The input for the DynamoActionVS action that specifies the DynamoDB table
// to which the message data will be written.
type PutItemInput struct {
	_ struct{} `type:"structure"`

	// The table where the message data will be written
	//
	// TableName is a required field
	TableName *string `locationName:"tableName" type:"string" required:"true"`
}

// String returns the string representation
func (s PutItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutItemInput"}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTableName sets the TableName field's value.
func (s *PutItemInput) SetTableName(v string) *PutItemInput {
	s.TableName = &v
	return s
}

// The input to the RegisterCACertificate operation.
type RegisterCACertificateInput struct {
	_ struct{} `type:"structure"`

	// Allows this CA certificate to be used for auto registration of device certificates.
	AllowAutoRegistration *bool `location:"querystring" locationName:"allowAutoRegistration" type:"boolean"`

	// The CA certificate.
	//
	// CaCertificate is a required field
	CaCertificate *string `locationName:"caCertificate" min:"1" type:"string" required:"true"`

	// A boolean value that specifies if the CA certificate is set to active.
	SetAsActive *bool `location:"querystring" locationName:"setAsActive" type:"boolean"`

	// The private key verification certificate.
	//
	// VerificationCertificate is a required field
	VerificationCertificate *string `locationName:"verificationCertificate" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterCACertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterCACertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterCACertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterCACertificateInput"}
	if s.CaCertificate == nil {
		invalidParams.Add(request.NewErrParamRequired("CaCertificate"))
	}
	if s.CaCertificate != nil && len(*s.CaCertificate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CaCertificate", 1))
	}
	if s.VerificationCertificate == nil {
		invalidParams.Add(request.NewErrParamRequired("VerificationCertificate"))
	}
	if s.VerificationCertificate != nil && len(*s.VerificationCertificate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VerificationCertificate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowAutoRegistration sets the AllowAutoRegistration field's value.
func (s *RegisterCACertificateInput) SetAllowAutoRegistration(v bool) *RegisterCACertificateInput {
	s.AllowAutoRegistration = &v
	return s
}

// SetCaCertificate sets the CaCertificate field's value.
func (s *RegisterCACertificateInput) SetCaCertificate(v string) *RegisterCACertificateInput {
	s.CaCertificate = &v
	return s
}

// SetSetAsActive sets the SetAsActive field's value.
func (s *RegisterCACertificateInput) SetSetAsActive(v bool) *RegisterCACertificateInput {
	s.SetAsActive = &v
	return s
}

// SetVerificationCertificate sets the VerificationCertificate field's value.
func (s *RegisterCACertificateInput) SetVerificationCertificate(v string) *RegisterCACertificateInput {
	s.VerificationCertificate = &v
	return s
}

// The output from the RegisterCACertificateResponse operation.
type RegisterCACertificateOutput struct {
	_ struct{} `type:"structure"`

	// The CA certificate ARN.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The CA certificate identifier.
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`
}

// String returns the string representation
func (s RegisterCACertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterCACertificateOutput) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *RegisterCACertificateOutput) SetCertificateArn(v string) *RegisterCACertificateOutput {
	s.CertificateArn = &v
	return s
}

// SetCertificateId sets the CertificateId field's value.
func (s *RegisterCACertificateOutput) SetCertificateId(v string) *RegisterCACertificateOutput {
	s.CertificateId = &v
	return s
}

// The input to the RegisterCertificate operation.
type RegisterCertificateInput struct {
	_ struct{} `type:"structure"`

	// The CA certificate used to sign the device certificate being registered.
	CaCertificatePem *string `locationName:"caCertificatePem" min:"1" type:"string"`

	// The certificate data, in PEM format.
	//
	// CertificatePem is a required field
	CertificatePem *string `locationName:"certificatePem" min:"1" type:"string" required:"true"`

	// A boolean value that specifies if the CA certificate is set to active.
	SetAsActive *bool `location:"querystring" locationName:"setAsActive" deprecated:"true" type:"boolean"`

	Status *string `locationName:"status" type:"string" enum:"CertificateStatus"`
}

// String returns the string representation
func (s RegisterCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterCertificateInput"}
	if s.CaCertificatePem != nil && len(*s.CaCertificatePem) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CaCertificatePem", 1))
	}
	if s.CertificatePem == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificatePem"))
	}
	if s.CertificatePem != nil && len(*s.CertificatePem) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CertificatePem", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCaCertificatePem sets the CaCertificatePem field's value.
func (s *RegisterCertificateInput) SetCaCertificatePem(v string) *RegisterCertificateInput {
	s.CaCertificatePem = &v
	return s
}

// SetCertificatePem sets the CertificatePem field's value.
func (s *RegisterCertificateInput) SetCertificatePem(v string) *RegisterCertificateInput {
	s.CertificatePem = &v
	return s
}

// SetSetAsActive sets the SetAsActive field's value.
func (s *RegisterCertificateInput) SetSetAsActive(v bool) *RegisterCertificateInput {
	s.SetAsActive = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RegisterCertificateInput) SetStatus(v string) *RegisterCertificateInput {
	s.Status = &v
	return s
}

// The output from the RegisterCertificate operation.
type RegisterCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The certificate ARN.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The certificate identifier.
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`
}

// String returns the string representation
func (s RegisterCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterCertificateOutput) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *RegisterCertificateOutput) SetCertificateArn(v string) *RegisterCertificateOutput {
	s.CertificateArn = &v
	return s
}

// SetCertificateId sets the CertificateId field's value.
func (s *RegisterCertificateOutput) SetCertificateId(v string) *RegisterCertificateOutput {
	s.CertificateId = &v
	return s
}

// The input for the RejectCertificateTransfer operation.
type RejectCertificateTransferInput struct {
	_ struct{} `type:"structure"`

	// The ID of the certificate.
	//
	// CertificateId is a required field
	CertificateId *string `location:"uri" locationName:"certificateId" min:"64" type:"string" required:"true"`

	// The reason the certificate transfer was rejected.
	RejectReason *string `locationName:"rejectReason" type:"string"`
}

// String returns the string representation
func (s RejectCertificateTransferInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RejectCertificateTransferInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RejectCertificateTransferInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RejectCertificateTransferInput"}
	if s.CertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateId"))
	}
	if s.CertificateId != nil && len(*s.CertificateId) < 64 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateId", 64))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateId sets the CertificateId field's value.
func (s *RejectCertificateTransferInput) SetCertificateId(v string) *RejectCertificateTransferInput {
	s.CertificateId = &v
	return s
}

// SetRejectReason sets the RejectReason field's value.
func (s *RejectCertificateTransferInput) SetRejectReason(v string) *RejectCertificateTransferInput {
	s.RejectReason = &v
	return s
}

type RejectCertificateTransferOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RejectCertificateTransferOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RejectCertificateTransferOutput) GoString() string {
	return s.String()
}

// The input for the ReplaceTopicRule operation.
type ReplaceTopicRuleInput struct {
	_ struct{} `type:"structure" payload:"TopicRulePayload"`

	// The name of the rule.
	//
	// RuleName is a required field
	RuleName *string `location:"uri" locationName:"ruleName" min:"1" type:"string" required:"true"`

	// The rule payload.
	//
	// TopicRulePayload is a required field
	TopicRulePayload *TopicRulePayload `locationName:"topicRulePayload" type:"structure" required:"true"`
}

// String returns the string representation
func (s ReplaceTopicRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplaceTopicRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplaceTopicRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReplaceTopicRuleInput"}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}
	if s.TopicRulePayload == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicRulePayload"))
	}
	if s.TopicRulePayload != nil {
		if err := s.TopicRulePayload.Validate(); err != nil {
			invalidParams.AddNested("TopicRulePayload", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleName sets the RuleName field's value.
func (s *ReplaceTopicRuleInput) SetRuleName(v string) *ReplaceTopicRuleInput {
	s.RuleName = &v
	return s
}

// SetTopicRulePayload sets the TopicRulePayload field's value.
func (s *ReplaceTopicRuleInput) SetTopicRulePayload(v *TopicRulePayload) *ReplaceTopicRuleInput {
	s.TopicRulePayload = v
	return s
}

type ReplaceTopicRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ReplaceTopicRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplaceTopicRuleOutput) GoString() string {
	return s.String()
}

// Describes an action to republish to another topic.
type RepublishAction struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM role that grants access.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The name of the MQTT topic.
	//
	// Topic is a required field
	Topic *string `locationName:"topic" type:"string" required:"true"`
}

// String returns the string representation
func (s RepublishAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RepublishAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RepublishAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RepublishAction"}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.Topic == nil {
		invalidParams.Add(request.NewErrParamRequired("Topic"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleArn sets the RoleArn field's value.
func (s *RepublishAction) SetRoleArn(v string) *RepublishAction {
	s.RoleArn = &v
	return s
}

// SetTopic sets the Topic field's value.
func (s *RepublishAction) SetTopic(v string) *RepublishAction {
	s.Topic = &v
	return s
}

// Describes an action to write data to an Amazon S3 bucket.
type S3Action struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" type:"string" required:"true"`

	// The Amazon S3 canned ACL that controls access to the object identified by
	// the object key. For more information, see S3 canned ACLs (http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl).
	CannedAcl *string `locationName:"cannedAcl" type:"string" enum:"CannedAccessControlList"`

	// The object key.
	//
	// Key is a required field
	Key *string `locationName:"key" type:"string" required:"true"`

	// The ARN of the IAM role that grants access.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`
}

// String returns the string representation
func (s S3Action) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Action) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Action) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Action"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *S3Action) SetBucketName(v string) *S3Action {
	s.BucketName = &v
	return s
}

// SetCannedAcl sets the CannedAcl field's value.
func (s *S3Action) SetCannedAcl(v string) *S3Action {
	s.CannedAcl = &v
	return s
}

// SetKey sets the Key field's value.
func (s *S3Action) SetKey(v string) *S3Action {
	s.Key = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *S3Action) SetRoleArn(v string) *S3Action {
	s.RoleArn = &v
	return s
}

// The input for the SetDefaultPolicyVersion operation.
type SetDefaultPolicyVersionInput struct {
	_ struct{} `type:"structure"`

	// The policy name.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`

	// The policy version ID.
	//
	// PolicyVersionId is a required field
	PolicyVersionId *string `location:"uri" locationName:"policyVersionId" type:"string" required:"true"`
}

// String returns the string representation
func (s SetDefaultPolicyVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetDefaultPolicyVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetDefaultPolicyVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetDefaultPolicyVersionInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.PolicyVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyVersionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *SetDefaultPolicyVersionInput) SetPolicyName(v string) *SetDefaultPolicyVersionInput {
	s.PolicyName = &v
	return s
}

// SetPolicyVersionId sets the PolicyVersionId field's value.
func (s *SetDefaultPolicyVersionInput) SetPolicyVersionId(v string) *SetDefaultPolicyVersionInput {
	s.PolicyVersionId = &v
	return s
}

type SetDefaultPolicyVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetDefaultPolicyVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetDefaultPolicyVersionOutput) GoString() string {
	return s.String()
}

// The input for the SetLoggingOptions operation.
type SetLoggingOptionsInput struct {
	_ struct{} `type:"structure" payload:"LoggingOptionsPayload"`

	// The logging options payload.
	//
	// LoggingOptionsPayload is a required field
	LoggingOptionsPayload *LoggingOptionsPayload `locationName:"loggingOptionsPayload" type:"structure" required:"true"`
}

// String returns the string representation
func (s SetLoggingOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetLoggingOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetLoggingOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetLoggingOptionsInput"}
	if s.LoggingOptionsPayload == nil {
		invalidParams.Add(request.NewErrParamRequired("LoggingOptionsPayload"))
	}
	if s.LoggingOptionsPayload != nil {
		if err := s.LoggingOptionsPayload.Validate(); err != nil {
			invalidParams.AddNested("LoggingOptionsPayload", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoggingOptionsPayload sets the LoggingOptionsPayload field's value.
func (s *SetLoggingOptionsInput) SetLoggingOptionsPayload(v *LoggingOptionsPayload) *SetLoggingOptionsInput {
	s.LoggingOptionsPayload = v
	return s
}

type SetLoggingOptionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetLoggingOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetLoggingOptionsOutput) GoString() string {
	return s.String()
}

// Describes an action to publish to an Amazon SNS topic.
type SnsAction struct {
	_ struct{} `type:"structure"`

	// The message format of the message to publish. Optional. Accepted values are
	// "JSON" and "RAW". The default value of the attribute is "RAW". SNS uses this
	// setting to determine if the payload should be parsed and relevant platform-specific
	// bits of the payload should be extracted. To read more about SNS message formats,
	// see  refer to their official documentation. (http://docs.aws.amazon.com/sns/latest/dg/json-formats.html)
	MessageFormat *string `locationName:"messageFormat" type:"string" enum:"MessageFormat"`

	// The ARN of the IAM role that grants access.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The ARN of the SNS topic.
	//
	// TargetArn is a required field
	TargetArn *string `locationName:"targetArn" type:"string" required:"true"`
}

// String returns the string representation
func (s SnsAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnsAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SnsAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SnsAction"}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.TargetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMessageFormat sets the MessageFormat field's value.
func (s *SnsAction) SetMessageFormat(v string) *SnsAction {
	s.MessageFormat = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *SnsAction) SetRoleArn(v string) *SnsAction {
	s.RoleArn = &v
	return s
}

// SetTargetArn sets the TargetArn field's value.
func (s *SnsAction) SetTargetArn(v string) *SnsAction {
	s.TargetArn = &v
	return s
}

// Describes an action to publish data to an Amazon SQS queue.
type SqsAction struct {
	_ struct{} `type:"structure"`

	// The URL of the Amazon SQS queue.
	//
	// QueueUrl is a required field
	QueueUrl *string `locationName:"queueUrl" type:"string" required:"true"`

	// The ARN of the IAM role that grants access.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// Specifies whether to use Base64 encoding.
	UseBase64 *bool `locationName:"useBase64" type:"boolean"`
}

// String returns the string representation
func (s SqsAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SqsAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SqsAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SqsAction"}
	if s.QueueUrl == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueUrl"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueueUrl sets the QueueUrl field's value.
func (s *SqsAction) SetQueueUrl(v string) *SqsAction {
	s.QueueUrl = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *SqsAction) SetRoleArn(v string) *SqsAction {
	s.RoleArn = &v
	return s
}

// SetUseBase64 sets the UseBase64 field's value.
func (s *SqsAction) SetUseBase64(v bool) *SqsAction {
	s.UseBase64 = &v
	return s
}

// The properties of the thing, including thing name, thing type name, and a
// list of thing attributes.
type ThingAttribute struct {
	_ struct{} `type:"structure"`

	// A list of thing attributes which are name-value pairs.
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// The name of the thing.
	ThingName *string `locationName:"thingName" min:"1" type:"string"`

	// The name of the thing type, if the thing has been associated with a type.
	ThingTypeName *string `locationName:"thingTypeName" min:"1" type:"string"`

	// The version of the thing record in the registry.
	Version *int64 `locationName:"version" type:"long"`
}

// String returns the string representation
func (s ThingAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThingAttribute) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *ThingAttribute) SetAttributes(v map[string]*string) *ThingAttribute {
	s.Attributes = v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *ThingAttribute) SetThingName(v string) *ThingAttribute {
	s.ThingName = &v
	return s
}

// SetThingTypeName sets the ThingTypeName field's value.
func (s *ThingAttribute) SetThingTypeName(v string) *ThingAttribute {
	s.ThingTypeName = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ThingAttribute) SetVersion(v int64) *ThingAttribute {
	s.Version = &v
	return s
}

// The definition of the thing type, including thing type name and description.
type ThingTypeDefinition struct {
	_ struct{} `type:"structure"`

	// The ThingTypeMetadata contains additional information about the thing type
	// including: creation date and time, a value indicating whether the thing type
	// is deprecated, and a date and time when time was deprecated.
	ThingTypeMetadata *ThingTypeMetadata `locationName:"thingTypeMetadata" type:"structure"`

	// The name of the thing type.
	ThingTypeName *string `locationName:"thingTypeName" min:"1" type:"string"`

	// The ThingTypeProperties for the thing type.
	ThingTypeProperties *ThingTypeProperties `locationName:"thingTypeProperties" type:"structure"`
}

// String returns the string representation
func (s ThingTypeDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThingTypeDefinition) GoString() string {
	return s.String()
}

// SetThingTypeMetadata sets the ThingTypeMetadata field's value.
func (s *ThingTypeDefinition) SetThingTypeMetadata(v *ThingTypeMetadata) *ThingTypeDefinition {
	s.ThingTypeMetadata = v
	return s
}

// SetThingTypeName sets the ThingTypeName field's value.
func (s *ThingTypeDefinition) SetThingTypeName(v string) *ThingTypeDefinition {
	s.ThingTypeName = &v
	return s
}

// SetThingTypeProperties sets the ThingTypeProperties field's value.
func (s *ThingTypeDefinition) SetThingTypeProperties(v *ThingTypeProperties) *ThingTypeDefinition {
	s.ThingTypeProperties = v
	return s
}

// The ThingTypeMetadata contains additional information about the thing type
// including: creation date and time, a value indicating whether the thing type
// is deprecated, and a date and time when time was deprecated.
type ThingTypeMetadata struct {
	_ struct{} `type:"structure"`

	// The date and time when the thing type was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix"`

	// Whether the thing type is deprecated. If true, no new things could be associated
	// with this type.
	Deprecated *bool `locationName:"deprecated" type:"boolean"`

	// The date and time when the thing type was deprecated.
	DeprecationDate *time.Time `locationName:"deprecationDate" type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s ThingTypeMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThingTypeMetadata) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *ThingTypeMetadata) SetCreationDate(v time.Time) *ThingTypeMetadata {
	s.CreationDate = &v
	return s
}

// SetDeprecated sets the Deprecated field's value.
func (s *ThingTypeMetadata) SetDeprecated(v bool) *ThingTypeMetadata {
	s.Deprecated = &v
	return s
}

// SetDeprecationDate sets the DeprecationDate field's value.
func (s *ThingTypeMetadata) SetDeprecationDate(v time.Time) *ThingTypeMetadata {
	s.DeprecationDate = &v
	return s
}

// The ThingTypeProperties contains information about the thing type including:
// a thing type description, and a list of searchable thing attribute names.
type ThingTypeProperties struct {
	_ struct{} `type:"structure"`

	// A list of searchable thing attribute names.
	SearchableAttributes []*string `locationName:"searchableAttributes" type:"list"`

	// The description of the thing type.
	ThingTypeDescription *string `locationName:"thingTypeDescription" type:"string"`
}

// String returns the string representation
func (s ThingTypeProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThingTypeProperties) GoString() string {
	return s.String()
}

// SetSearchableAttributes sets the SearchableAttributes field's value.
func (s *ThingTypeProperties) SetSearchableAttributes(v []*string) *ThingTypeProperties {
	s.SearchableAttributes = v
	return s
}

// SetThingTypeDescription sets the ThingTypeDescription field's value.
func (s *ThingTypeProperties) SetThingTypeDescription(v string) *ThingTypeProperties {
	s.ThingTypeDescription = &v
	return s
}

// Describes a rule.
type TopicRule struct {
	_ struct{} `type:"structure"`

	// The actions associated with the rule.
	Actions []*Action `locationName:"actions" type:"list"`

	// The version of the SQL rules engine to use when evaluating the rule.
	AwsIotSqlVersion *string `locationName:"awsIotSqlVersion" type:"string"`

	// The date and time the rule was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"unix"`

	// The description of the rule.
	Description *string `locationName:"description" type:"string"`

	// Specifies whether the rule is disabled.
	RuleDisabled *bool `locationName:"ruleDisabled" type:"boolean"`

	// The name of the rule.
	RuleName *string `locationName:"ruleName" min:"1" type:"string"`

	// The SQL statement used to query the topic. When using a SQL query with multiple
	// lines, be sure to escape the newline characters.
	Sql *string `locationName:"sql" type:"string"`
}

// String returns the string representation
func (s TopicRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TopicRule) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *TopicRule) SetActions(v []*Action) *TopicRule {
	s.Actions = v
	return s
}

// SetAwsIotSqlVersion sets the AwsIotSqlVersion field's value.
func (s *TopicRule) SetAwsIotSqlVersion(v string) *TopicRule {
	s.AwsIotSqlVersion = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *TopicRule) SetCreatedAt(v time.Time) *TopicRule {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *TopicRule) SetDescription(v string) *TopicRule {
	s.Description = &v
	return s
}

// SetRuleDisabled sets the RuleDisabled field's value.
func (s *TopicRule) SetRuleDisabled(v bool) *TopicRule {
	s.RuleDisabled = &v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *TopicRule) SetRuleName(v string) *TopicRule {
	s.RuleName = &v
	return s
}

// SetSql sets the Sql field's value.
func (s *TopicRule) SetSql(v string) *TopicRule {
	s.Sql = &v
	return s
}

// Describes a rule.
type TopicRuleListItem struct {
	_ struct{} `type:"structure"`

	// The date and time the rule was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"unix"`

	// The rule ARN.
	RuleArn *string `locationName:"ruleArn" type:"string"`

	// Specifies whether the rule is disabled.
	RuleDisabled *bool `locationName:"ruleDisabled" type:"boolean"`

	// The name of the rule.
	RuleName *string `locationName:"ruleName" min:"1" type:"string"`

	// The pattern for the topic names that apply.
	TopicPattern *string `locationName:"topicPattern" type:"string"`
}

// String returns the string representation
func (s TopicRuleListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TopicRuleListItem) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *TopicRuleListItem) SetCreatedAt(v time.Time) *TopicRuleListItem {
	s.CreatedAt = &v
	return s
}

// SetRuleArn sets the RuleArn field's value.
func (s *TopicRuleListItem) SetRuleArn(v string) *TopicRuleListItem {
	s.RuleArn = &v
	return s
}

// SetRuleDisabled sets the RuleDisabled field's value.
func (s *TopicRuleListItem) SetRuleDisabled(v bool) *TopicRuleListItem {
	s.RuleDisabled = &v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *TopicRuleListItem) SetRuleName(v string) *TopicRuleListItem {
	s.RuleName = &v
	return s
}

// SetTopicPattern sets the TopicPattern field's value.
func (s *TopicRuleListItem) SetTopicPattern(v string) *TopicRuleListItem {
	s.TopicPattern = &v
	return s
}

// Describes a rule.
type TopicRulePayload struct {
	_ struct{} `type:"structure"`

	// The actions associated with the rule.
	//
	// Actions is a required field
	Actions []*Action `locationName:"actions" type:"list" required:"true"`

	// The version of the SQL rules engine to use when evaluating the rule.
	AwsIotSqlVersion *string `locationName:"awsIotSqlVersion" type:"string"`

	// The description of the rule.
	Description *string `locationName:"description" type:"string"`

	// Specifies whether the rule is disabled.
	RuleDisabled *bool `locationName:"ruleDisabled" type:"boolean"`

	// The SQL statement used to query the topic. For more information, see AWS
	// IoT SQL Reference (http://docs.aws.amazon.com/iot/latest/developerguide/iot-rules.html#aws-iot-sql-reference)
	// in the AWS IoT Developer Guide.
	//
	// Sql is a required field
	Sql *string `locationName:"sql" type:"string" required:"true"`
}

// String returns the string representation
func (s TopicRulePayload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TopicRulePayload) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TopicRulePayload) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TopicRulePayload"}
	if s.Actions == nil {
		invalidParams.Add(request.NewErrParamRequired("Actions"))
	}
	if s.Sql == nil {
		invalidParams.Add(request.NewErrParamRequired("Sql"))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *TopicRulePayload) SetActions(v []*Action) *TopicRulePayload {
	s.Actions = v
	return s
}

// SetAwsIotSqlVersion sets the AwsIotSqlVersion field's value.
func (s *TopicRulePayload) SetAwsIotSqlVersion(v string) *TopicRulePayload {
	s.AwsIotSqlVersion = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *TopicRulePayload) SetDescription(v string) *TopicRulePayload {
	s.Description = &v
	return s
}

// SetRuleDisabled sets the RuleDisabled field's value.
func (s *TopicRulePayload) SetRuleDisabled(v bool) *TopicRulePayload {
	s.RuleDisabled = &v
	return s
}

// SetSql sets the Sql field's value.
func (s *TopicRulePayload) SetSql(v string) *TopicRulePayload {
	s.Sql = &v
	return s
}

// The input for the TransferCertificate operation.
type TransferCertificateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the certificate.
	//
	// CertificateId is a required field
	CertificateId *string `location:"uri" locationName:"certificateId" min:"64" type:"string" required:"true"`

	// The AWS account.
	//
	// TargetAwsAccount is a required field
	TargetAwsAccount *string `location:"querystring" locationName:"targetAwsAccount" type:"string" required:"true"`

	// The transfer message.
	TransferMessage *string `locationName:"transferMessage" type:"string"`
}

// String returns the string representation
func (s TransferCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TransferCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransferCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TransferCertificateInput"}
	if s.CertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateId"))
	}
	if s.CertificateId != nil && len(*s.CertificateId) < 64 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateId", 64))
	}
	if s.TargetAwsAccount == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetAwsAccount"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateId sets the CertificateId field's value.
func (s *TransferCertificateInput) SetCertificateId(v string) *TransferCertificateInput {
	s.CertificateId = &v
	return s
}

// SetTargetAwsAccount sets the TargetAwsAccount field's value.
func (s *TransferCertificateInput) SetTargetAwsAccount(v string) *TransferCertificateInput {
	s.TargetAwsAccount = &v
	return s
}

// SetTransferMessage sets the TransferMessage field's value.
func (s *TransferCertificateInput) SetTransferMessage(v string) *TransferCertificateInput {
	s.TransferMessage = &v
	return s
}

// The output from the TransferCertificate operation.
type TransferCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the certificate.
	TransferredCertificateArn *string `locationName:"transferredCertificateArn" type:"string"`
}

// String returns the string representation
func (s TransferCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TransferCertificateOutput) GoString() string {
	return s.String()
}

// SetTransferredCertificateArn sets the TransferredCertificateArn field's value.
func (s *TransferCertificateOutput) SetTransferredCertificateArn(v string) *TransferCertificateOutput {
	s.TransferredCertificateArn = &v
	return s
}

// Data used to transfer a certificate to an AWS account.
type TransferData struct {
	_ struct{} `type:"structure"`

	// The date the transfer was accepted.
	AcceptDate *time.Time `locationName:"acceptDate" type:"timestamp" timestampFormat:"unix"`

	// The date the transfer was rejected.
	RejectDate *time.Time `locationName:"rejectDate" type:"timestamp" timestampFormat:"unix"`

	// The reason why the transfer was rejected.
	RejectReason *string `locationName:"rejectReason" type:"string"`

	// The date the transfer took place.
	TransferDate *time.Time `locationName:"transferDate" type:"timestamp" timestampFormat:"unix"`

	// The transfer message.
	TransferMessage *string `locationName:"transferMessage" type:"string"`
}

// String returns the string representation
func (s TransferData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TransferData) GoString() string {
	return s.String()
}

// SetAcceptDate sets the AcceptDate field's value.
func (s *TransferData) SetAcceptDate(v time.Time) *TransferData {
	s.AcceptDate = &v
	return s
}

// SetRejectDate sets the RejectDate field's value.
func (s *TransferData) SetRejectDate(v time.Time) *TransferData {
	s.RejectDate = &v
	return s
}

// SetRejectReason sets the RejectReason field's value.
func (s *TransferData) SetRejectReason(v string) *TransferData {
	s.RejectReason = &v
	return s
}

// SetTransferDate sets the TransferDate field's value.
func (s *TransferData) SetTransferDate(v time.Time) *TransferData {
	s.TransferDate = &v
	return s
}

// SetTransferMessage sets the TransferMessage field's value.
func (s *TransferData) SetTransferMessage(v string) *TransferData {
	s.TransferMessage = &v
	return s
}

// The input to the UpdateCACertificate operation.
type UpdateCACertificateInput struct {
	_ struct{} `type:"structure"`

	// The CA certificate identifier.
	//
	// CertificateId is a required field
	CertificateId *string `location:"uri" locationName:"caCertificateId" min:"64" type:"string" required:"true"`

	// The new value for the auto registration status. Valid values are: "ENABLE"
	// or "DISABLE".
	NewAutoRegistrationStatus *string `location:"querystring" locationName:"newAutoRegistrationStatus" type:"string" enum:"AutoRegistrationStatus"`

	// The updated status of the CA certificate.
	//
	// Note: The status value REGISTER_INACTIVE is deprecated and should not be
	// used.
	NewStatus *string `location:"querystring" locationName:"newStatus" type:"string" enum:"CACertificateStatus"`
}

// String returns the string representation
func (s UpdateCACertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCACertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCACertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCACertificateInput"}
	if s.CertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateId"))
	}
	if s.CertificateId != nil && len(*s.CertificateId) < 64 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateId", 64))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateId sets the CertificateId field's value.
func (s *UpdateCACertificateInput) SetCertificateId(v string) *UpdateCACertificateInput {
	s.CertificateId = &v
	return s
}

// SetNewAutoRegistrationStatus sets the NewAutoRegistrationStatus field's value.
func (s *UpdateCACertificateInput) SetNewAutoRegistrationStatus(v string) *UpdateCACertificateInput {
	s.NewAutoRegistrationStatus = &v
	return s
}

// SetNewStatus sets the NewStatus field's value.
func (s *UpdateCACertificateInput) SetNewStatus(v string) *UpdateCACertificateInput {
	s.NewStatus = &v
	return s
}

type UpdateCACertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateCACertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCACertificateOutput) GoString() string {
	return s.String()
}

// The input for the UpdateCertificate operation.
type UpdateCertificateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the certificate.
	//
	// CertificateId is a required field
	CertificateId *string `location:"uri" locationName:"certificateId" min:"64" type:"string" required:"true"`

	// The new status.
	//
	// Note: Setting the status to PENDING_TRANSFER will result in an exception
	// being thrown. PENDING_TRANSFER is a status used internally by AWS IoT. It
	// is not intended for developer use.
	//
	// Note: The status value REGISTER_INACTIVE is deprecated and should not be
	// used.
	//
	// NewStatus is a required field
	NewStatus *string `location:"querystring" locationName:"newStatus" type:"string" required:"true" enum:"CertificateStatus"`
}

// String returns the string representation
func (s UpdateCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCertificateInput"}
	if s.CertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateId"))
	}
	if s.CertificateId != nil && len(*s.CertificateId) < 64 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateId", 64))
	}
	if s.NewStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("NewStatus"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateId sets the CertificateId field's value.
func (s *UpdateCertificateInput) SetCertificateId(v string) *UpdateCertificateInput {
	s.CertificateId = &v
	return s
}

// SetNewStatus sets the NewStatus field's value.
func (s *UpdateCertificateInput) SetNewStatus(v string) *UpdateCertificateInput {
	s.NewStatus = &v
	return s
}

type UpdateCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCertificateOutput) GoString() string {
	return s.String()
}

// The input for the UpdateThing operation.
type UpdateThingInput struct {
	_ struct{} `type:"structure"`

	// A list of thing attributes, a JSON string containing name-value pairs. For
	// example:
	//
	// {\"attributes\":{\"name1\":\"value2\"}})
	//
	// This data is used to add new attributes or update existing attributes.
	AttributePayload *AttributePayload `locationName:"attributePayload" type:"structure"`

	// The expected version of the thing record in the registry. If the version
	// of the record in the registry does not match the expected version specified
	// in the request, the UpdateThing request is rejected with a VersionConflictException.
	ExpectedVersion *int64 `locationName:"expectedVersion" type:"long"`

	// Remove a thing type association. If true, the assocation is removed.
	RemoveThingType *bool `locationName:"removeThingType" type:"boolean"`

	// The name of the thing to update.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`

	// The name of the thing type.
	ThingTypeName *string `locationName:"thingTypeName" min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateThingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateThingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateThingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateThingInput"}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}
	if s.ThingTypeName != nil && len(*s.ThingTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingTypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributePayload sets the AttributePayload field's value.
func (s *UpdateThingInput) SetAttributePayload(v *AttributePayload) *UpdateThingInput {
	s.AttributePayload = v
	return s
}

// SetExpectedVersion sets the ExpectedVersion field's value.
func (s *UpdateThingInput) SetExpectedVersion(v int64) *UpdateThingInput {
	s.ExpectedVersion = &v
	return s
}

// SetRemoveThingType sets the RemoveThingType field's value.
func (s *UpdateThingInput) SetRemoveThingType(v bool) *UpdateThingInput {
	s.RemoveThingType = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *UpdateThingInput) SetThingName(v string) *UpdateThingInput {
	s.ThingName = &v
	return s
}

// SetThingTypeName sets the ThingTypeName field's value.
func (s *UpdateThingInput) SetThingTypeName(v string) *UpdateThingInput {
	s.ThingTypeName = &v
	return s
}

// The output from the UpdateThing operation.
type UpdateThingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateThingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateThingOutput) GoString() string {
	return s.String()
}

const (
	// AutoRegistrationStatusEnable is a AutoRegistrationStatus enum value
	AutoRegistrationStatusEnable = "ENABLE"

	// AutoRegistrationStatusDisable is a AutoRegistrationStatus enum value
	AutoRegistrationStatusDisable = "DISABLE"
)

const (
	// CACertificateStatusActive is a CACertificateStatus enum value
	CACertificateStatusActive = "ACTIVE"

	// CACertificateStatusInactive is a CACertificateStatus enum value
	CACertificateStatusInactive = "INACTIVE"
)

const (
	// CannedAccessControlListPrivate is a CannedAccessControlList enum value
	CannedAccessControlListPrivate = "private"

	// CannedAccessControlListPublicRead is a CannedAccessControlList enum value
	CannedAccessControlListPublicRead = "public-read"

	// CannedAccessControlListPublicReadWrite is a CannedAccessControlList enum value
	CannedAccessControlListPublicReadWrite = "public-read-write"

	// CannedAccessControlListAwsExecRead is a CannedAccessControlList enum value
	CannedAccessControlListAwsExecRead = "aws-exec-read"

	// CannedAccessControlListAuthenticatedRead is a CannedAccessControlList enum value
	CannedAccessControlListAuthenticatedRead = "authenticated-read"

	// CannedAccessControlListBucketOwnerRead is a CannedAccessControlList enum value
	CannedAccessControlListBucketOwnerRead = "bucket-owner-read"

	// CannedAccessControlListBucketOwnerFullControl is a CannedAccessControlList enum value
	CannedAccessControlListBucketOwnerFullControl = "bucket-owner-full-control"

	// CannedAccessControlListLogDeliveryWrite is a CannedAccessControlList enum value
	CannedAccessControlListLogDeliveryWrite = "log-delivery-write"
)

const (
	// CertificateStatusActive is a CertificateStatus enum value
	CertificateStatusActive = "ACTIVE"

	// CertificateStatusInactive is a CertificateStatus enum value
	CertificateStatusInactive = "INACTIVE"

	// CertificateStatusRevoked is a CertificateStatus enum value
	CertificateStatusRevoked = "REVOKED"

	// CertificateStatusPendingTransfer is a CertificateStatus enum value
	CertificateStatusPendingTransfer = "PENDING_TRANSFER"

	// CertificateStatusRegisterInactive is a CertificateStatus enum value
	CertificateStatusRegisterInactive = "REGISTER_INACTIVE"

	// CertificateStatusPendingActivation is a CertificateStatus enum value
	CertificateStatusPendingActivation = "PENDING_ACTIVATION"
)

const (
	// DynamoKeyTypeString is a DynamoKeyType enum value
	DynamoKeyTypeString = "STRING"

	// DynamoKeyTypeNumber is a DynamoKeyType enum value
	DynamoKeyTypeNumber = "NUMBER"
)

const (
	// LogLevelDebug is a LogLevel enum value
	LogLevelDebug = "DEBUG"

	// LogLevelInfo is a LogLevel enum value
	LogLevelInfo = "INFO"

	// LogLevelError is a LogLevel enum value
	LogLevelError = "ERROR"

	// LogLevelWarn is a LogLevel enum value
	LogLevelWarn = "WARN"

	// LogLevelDisabled is a LogLevel enum value
	LogLevelDisabled = "DISABLED"
)

const (
	// MessageFormatRaw is a MessageFormat enum value
	MessageFormatRaw = "RAW"

	// MessageFormatJson is a MessageFormat enum value
	MessageFormatJson = "JSON"
)
