// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/opsworks"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleOpsWorks_AssignInstance() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.AssignInstanceInput{
		InstanceId: aws.String("String"), // Required
		LayerIds: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.AssignInstance(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_AssignVolume() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.AssignVolumeInput{
		VolumeId:   aws.String("String"), // Required
		InstanceId: aws.String("String"),
	}
	resp, err := svc.AssignVolume(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_AssociateElasticIp() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.AssociateElasticIpInput{
		ElasticIp:  aws.String("String"), // Required
		InstanceId: aws.String("String"),
	}
	resp, err := svc.AssociateElasticIp(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_AttachElasticLoadBalancer() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.AttachElasticLoadBalancerInput{
		ElasticLoadBalancerName: aws.String("String"), // Required
		LayerId:                 aws.String("String"), // Required
	}
	resp, err := svc.AttachElasticLoadBalancer(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_CloneStack() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.CloneStackInput{
		ServiceRoleArn: aws.String("String"), // Required
		SourceStackId:  aws.String("String"), // Required
		AgentVersion:   aws.String("String"),
		Attributes: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
		ChefConfiguration: &opsworks.ChefConfiguration{
			BerkshelfVersion: aws.String("String"),
			ManageBerkshelf:  aws.Bool(true),
		},
		CloneAppIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		ClonePermissions: aws.Bool(true),
		ConfigurationManager: &opsworks.StackConfigurationManager{
			Name:    aws.String("String"),
			Version: aws.String("String"),
		},
		CustomCookbooksSource: &opsworks.Source{
			Password: aws.String("String"),
			Revision: aws.String("String"),
			SshKey:   aws.String("String"),
			Type:     aws.String("SourceType"),
			Url:      aws.String("String"),
			Username: aws.String("String"),
		},
		CustomJson:                aws.String("String"),
		DefaultAvailabilityZone:   aws.String("String"),
		DefaultInstanceProfileArn: aws.String("String"),
		DefaultOs:                 aws.String("String"),
		DefaultRootDeviceType:     aws.String("RootDeviceType"),
		DefaultSshKeyName:         aws.String("String"),
		DefaultSubnetId:           aws.String("String"),
		HostnameTheme:             aws.String("String"),
		Name:                      aws.String("String"),
		Region:                    aws.String("String"),
		UseCustomCookbooks:        aws.Bool(true),
		UseOpsworksSecurityGroups: aws.Bool(true),
		VpcId: aws.String("String"),
	}
	resp, err := svc.CloneStack(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_CreateApp() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.CreateAppInput{
		Name:    aws.String("String"),  // Required
		StackId: aws.String("String"),  // Required
		Type:    aws.String("AppType"), // Required
		AppSource: &opsworks.Source{
			Password: aws.String("String"),
			Revision: aws.String("String"),
			SshKey:   aws.String("String"),
			Type:     aws.String("SourceType"),
			Url:      aws.String("String"),
			Username: aws.String("String"),
		},
		Attributes: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
		DataSources: []*opsworks.DataSource{
			{ // Required
				Arn:          aws.String("String"),
				DatabaseName: aws.String("String"),
				Type:         aws.String("String"),
			},
			// More values...
		},
		Description: aws.String("String"),
		Domains: []*string{
			aws.String("String"), // Required
			// More values...
		},
		EnableSsl: aws.Bool(true),
		Environment: []*opsworks.EnvironmentVariable{
			{ // Required
				Key:    aws.String("String"), // Required
				Value:  aws.String("String"), // Required
				Secure: aws.Bool(true),
			},
			// More values...
		},
		Shortname: aws.String("String"),
		SslConfiguration: &opsworks.SslConfiguration{
			Certificate: aws.String("String"), // Required
			PrivateKey:  aws.String("String"), // Required
			Chain:       aws.String("String"),
		},
	}
	resp, err := svc.CreateApp(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_CreateDeployment() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.CreateDeploymentInput{
		Command: &opsworks.DeploymentCommand{ // Required
			Name: aws.String("DeploymentCommandName"), // Required
			Args: map[string][]*string{
				"Key": { // Required
					aws.String("String"), // Required
					// More values...
				},
				// More values...
			},
		},
		StackId:    aws.String("String"), // Required
		AppId:      aws.String("String"),
		Comment:    aws.String("String"),
		CustomJson: aws.String("String"),
		InstanceIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		LayerIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.CreateDeployment(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_CreateInstance() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.CreateInstanceInput{
		InstanceType: aws.String("String"), // Required
		LayerIds: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		StackId:          aws.String("String"), // Required
		AgentVersion:     aws.String("String"),
		AmiId:            aws.String("String"),
		Architecture:     aws.String("Architecture"),
		AutoScalingType:  aws.String("AutoScalingType"),
		AvailabilityZone: aws.String("String"),
		BlockDeviceMappings: []*opsworks.BlockDeviceMapping{
			{ // Required
				DeviceName: aws.String("String"),
				Ebs: &opsworks.EbsBlockDevice{
					DeleteOnTermination: aws.Bool(true),
					Iops:                aws.Int64(1),
					SnapshotId:          aws.String("String"),
					VolumeSize:          aws.Int64(1),
					VolumeType:          aws.String("VolumeType"),
				},
				NoDevice:    aws.String("String"),
				VirtualName: aws.String("String"),
			},
			// More values...
		},
		EbsOptimized:         aws.Bool(true),
		Hostname:             aws.String("String"),
		InstallUpdatesOnBoot: aws.Bool(true),
		Os:                   aws.String("String"),
		RootDeviceType:       aws.String("RootDeviceType"),
		SshKeyName:           aws.String("String"),
		SubnetId:             aws.String("String"),
		Tenancy:              aws.String("String"),
		VirtualizationType:   aws.String("String"),
	}
	resp, err := svc.CreateInstance(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_CreateLayer() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.CreateLayerInput{
		Name:      aws.String("String"),    // Required
		Shortname: aws.String("String"),    // Required
		StackId:   aws.String("String"),    // Required
		Type:      aws.String("LayerType"), // Required
		Attributes: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
		AutoAssignElasticIps:     aws.Bool(true),
		AutoAssignPublicIps:      aws.Bool(true),
		CustomInstanceProfileArn: aws.String("String"),
		CustomJson:               aws.String("String"),
		CustomRecipes: &opsworks.Recipes{
			Configure: []*string{
				aws.String("String"), // Required
				// More values...
			},
			Deploy: []*string{
				aws.String("String"), // Required
				// More values...
			},
			Setup: []*string{
				aws.String("String"), // Required
				// More values...
			},
			Shutdown: []*string{
				aws.String("String"), // Required
				// More values...
			},
			Undeploy: []*string{
				aws.String("String"), // Required
				// More values...
			},
		},
		CustomSecurityGroupIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		EnableAutoHealing:    aws.Bool(true),
		InstallUpdatesOnBoot: aws.Bool(true),
		LifecycleEventConfiguration: &opsworks.LifecycleEventConfiguration{
			Shutdown: &opsworks.ShutdownEventConfiguration{
				DelayUntilElbConnectionsDrained: aws.Bool(true),
				ExecutionTimeout:                aws.Int64(1),
			},
		},
		Packages: []*string{
			aws.String("String"), // Required
			// More values...
		},
		UseEbsOptimizedInstances: aws.Bool(true),
		VolumeConfigurations: []*opsworks.VolumeConfiguration{
			{ // Required
				MountPoint:    aws.String("String"), // Required
				NumberOfDisks: aws.Int64(1),         // Required
				Size:          aws.Int64(1),         // Required
				Iops:          aws.Int64(1),
				RaidLevel:     aws.Int64(1),
				VolumeType:    aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.CreateLayer(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_CreateStack() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.CreateStackInput{
		DefaultInstanceProfileArn: aws.String("String"), // Required
		Name:           aws.String("String"), // Required
		Region:         aws.String("String"), // Required
		ServiceRoleArn: aws.String("String"), // Required
		AgentVersion:   aws.String("String"),
		Attributes: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
		ChefConfiguration: &opsworks.ChefConfiguration{
			BerkshelfVersion: aws.String("String"),
			ManageBerkshelf:  aws.Bool(true),
		},
		ConfigurationManager: &opsworks.StackConfigurationManager{
			Name:    aws.String("String"),
			Version: aws.String("String"),
		},
		CustomCookbooksSource: &opsworks.Source{
			Password: aws.String("String"),
			Revision: aws.String("String"),
			SshKey:   aws.String("String"),
			Type:     aws.String("SourceType"),
			Url:      aws.String("String"),
			Username: aws.String("String"),
		},
		CustomJson:                aws.String("String"),
		DefaultAvailabilityZone:   aws.String("String"),
		DefaultOs:                 aws.String("String"),
		DefaultRootDeviceType:     aws.String("RootDeviceType"),
		DefaultSshKeyName:         aws.String("String"),
		DefaultSubnetId:           aws.String("String"),
		HostnameTheme:             aws.String("String"),
		UseCustomCookbooks:        aws.Bool(true),
		UseOpsworksSecurityGroups: aws.Bool(true),
		VpcId: aws.String("String"),
	}
	resp, err := svc.CreateStack(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_CreateUserProfile() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.CreateUserProfileInput{
		IamUserArn:          aws.String("String"), // Required
		AllowSelfManagement: aws.Bool(true),
		SshPublicKey:        aws.String("String"),
		SshUsername:         aws.String("String"),
	}
	resp, err := svc.CreateUserProfile(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DeleteApp() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DeleteAppInput{
		AppId: aws.String("String"), // Required
	}
	resp, err := svc.DeleteApp(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DeleteInstance() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DeleteInstanceInput{
		InstanceId:      aws.String("String"), // Required
		DeleteElasticIp: aws.Bool(true),
		DeleteVolumes:   aws.Bool(true),
	}
	resp, err := svc.DeleteInstance(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DeleteLayer() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DeleteLayerInput{
		LayerId: aws.String("String"), // Required
	}
	resp, err := svc.DeleteLayer(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DeleteStack() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DeleteStackInput{
		StackId: aws.String("String"), // Required
	}
	resp, err := svc.DeleteStack(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DeleteUserProfile() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DeleteUserProfileInput{
		IamUserArn: aws.String("String"), // Required
	}
	resp, err := svc.DeleteUserProfile(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DeregisterEcsCluster() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DeregisterEcsClusterInput{
		EcsClusterArn: aws.String("String"), // Required
	}
	resp, err := svc.DeregisterEcsCluster(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DeregisterElasticIp() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DeregisterElasticIpInput{
		ElasticIp: aws.String("String"), // Required
	}
	resp, err := svc.DeregisterElasticIp(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DeregisterInstance() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DeregisterInstanceInput{
		InstanceId: aws.String("String"), // Required
	}
	resp, err := svc.DeregisterInstance(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DeregisterRdsDbInstance() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DeregisterRdsDbInstanceInput{
		RdsDbInstanceArn: aws.String("String"), // Required
	}
	resp, err := svc.DeregisterRdsDbInstance(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DeregisterVolume() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DeregisterVolumeInput{
		VolumeId: aws.String("String"), // Required
	}
	resp, err := svc.DeregisterVolume(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DescribeAgentVersions() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DescribeAgentVersionsInput{
		ConfigurationManager: &opsworks.StackConfigurationManager{
			Name:    aws.String("String"),
			Version: aws.String("String"),
		},
		StackId: aws.String("String"),
	}
	resp, err := svc.DescribeAgentVersions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DescribeApps() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DescribeAppsInput{
		AppIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		StackId: aws.String("String"),
	}
	resp, err := svc.DescribeApps(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DescribeCommands() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DescribeCommandsInput{
		CommandIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		DeploymentId: aws.String("String"),
		InstanceId:   aws.String("String"),
	}
	resp, err := svc.DescribeCommands(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DescribeDeployments() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DescribeDeploymentsInput{
		AppId: aws.String("String"),
		DeploymentIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		StackId: aws.String("String"),
	}
	resp, err := svc.DescribeDeployments(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DescribeEcsClusters() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DescribeEcsClustersInput{
		EcsClusterArns: []*string{
			aws.String("String"), // Required
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("String"),
		StackId:    aws.String("String"),
	}
	resp, err := svc.DescribeEcsClusters(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DescribeElasticIps() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DescribeElasticIpsInput{
		InstanceId: aws.String("String"),
		Ips: []*string{
			aws.String("String"), // Required
			// More values...
		},
		StackId: aws.String("String"),
	}
	resp, err := svc.DescribeElasticIps(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DescribeElasticLoadBalancers() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DescribeElasticLoadBalancersInput{
		LayerIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		StackId: aws.String("String"),
	}
	resp, err := svc.DescribeElasticLoadBalancers(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DescribeInstances() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DescribeInstancesInput{
		InstanceIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		LayerId: aws.String("String"),
		StackId: aws.String("String"),
	}
	resp, err := svc.DescribeInstances(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DescribeLayers() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DescribeLayersInput{
		LayerIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		StackId: aws.String("String"),
	}
	resp, err := svc.DescribeLayers(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DescribeLoadBasedAutoScaling() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DescribeLoadBasedAutoScalingInput{
		LayerIds: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeLoadBasedAutoScaling(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DescribeMyUserProfile() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	var params *opsworks.DescribeMyUserProfileInput
	resp, err := svc.DescribeMyUserProfile(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DescribePermissions() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DescribePermissionsInput{
		IamUserArn: aws.String("String"),
		StackId:    aws.String("String"),
	}
	resp, err := svc.DescribePermissions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DescribeRaidArrays() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DescribeRaidArraysInput{
		InstanceId: aws.String("String"),
		RaidArrayIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		StackId: aws.String("String"),
	}
	resp, err := svc.DescribeRaidArrays(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DescribeRdsDbInstances() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DescribeRdsDbInstancesInput{
		StackId: aws.String("String"), // Required
		RdsDbInstanceArns: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeRdsDbInstances(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DescribeServiceErrors() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DescribeServiceErrorsInput{
		InstanceId: aws.String("String"),
		ServiceErrorIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		StackId: aws.String("String"),
	}
	resp, err := svc.DescribeServiceErrors(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DescribeStackProvisioningParameters() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DescribeStackProvisioningParametersInput{
		StackId: aws.String("String"), // Required
	}
	resp, err := svc.DescribeStackProvisioningParameters(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DescribeStackSummary() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DescribeStackSummaryInput{
		StackId: aws.String("String"), // Required
	}
	resp, err := svc.DescribeStackSummary(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DescribeStacks() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DescribeStacksInput{
		StackIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeStacks(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DescribeTimeBasedAutoScaling() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DescribeTimeBasedAutoScalingInput{
		InstanceIds: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeTimeBasedAutoScaling(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DescribeUserProfiles() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DescribeUserProfilesInput{
		IamUserArns: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeUserProfiles(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DescribeVolumes() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DescribeVolumesInput{
		InstanceId:  aws.String("String"),
		RaidArrayId: aws.String("String"),
		StackId:     aws.String("String"),
		VolumeIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeVolumes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DetachElasticLoadBalancer() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DetachElasticLoadBalancerInput{
		ElasticLoadBalancerName: aws.String("String"), // Required
		LayerId:                 aws.String("String"), // Required
	}
	resp, err := svc.DetachElasticLoadBalancer(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_DisassociateElasticIp() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.DisassociateElasticIpInput{
		ElasticIp: aws.String("String"), // Required
	}
	resp, err := svc.DisassociateElasticIp(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_GetHostnameSuggestion() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.GetHostnameSuggestionInput{
		LayerId: aws.String("String"), // Required
	}
	resp, err := svc.GetHostnameSuggestion(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_GrantAccess() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.GrantAccessInput{
		InstanceId:        aws.String("String"), // Required
		ValidForInMinutes: aws.Int64(1),
	}
	resp, err := svc.GrantAccess(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_RebootInstance() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.RebootInstanceInput{
		InstanceId: aws.String("String"), // Required
	}
	resp, err := svc.RebootInstance(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_RegisterEcsCluster() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.RegisterEcsClusterInput{
		EcsClusterArn: aws.String("String"), // Required
		StackId:       aws.String("String"), // Required
	}
	resp, err := svc.RegisterEcsCluster(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_RegisterElasticIp() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.RegisterElasticIpInput{
		ElasticIp: aws.String("String"), // Required
		StackId:   aws.String("String"), // Required
	}
	resp, err := svc.RegisterElasticIp(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_RegisterInstance() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.RegisterInstanceInput{
		StackId:  aws.String("String"), // Required
		Hostname: aws.String("String"),
		InstanceIdentity: &opsworks.InstanceIdentity{
			Document:  aws.String("String"),
			Signature: aws.String("String"),
		},
		PrivateIp:               aws.String("String"),
		PublicIp:                aws.String("String"),
		RsaPublicKey:            aws.String("String"),
		RsaPublicKeyFingerprint: aws.String("String"),
	}
	resp, err := svc.RegisterInstance(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_RegisterRdsDbInstance() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.RegisterRdsDbInstanceInput{
		DbPassword:       aws.String("String"), // Required
		DbUser:           aws.String("String"), // Required
		RdsDbInstanceArn: aws.String("String"), // Required
		StackId:          aws.String("String"), // Required
	}
	resp, err := svc.RegisterRdsDbInstance(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_RegisterVolume() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.RegisterVolumeInput{
		StackId:     aws.String("String"), // Required
		Ec2VolumeId: aws.String("String"),
	}
	resp, err := svc.RegisterVolume(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_SetLoadBasedAutoScaling() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.SetLoadBasedAutoScalingInput{
		LayerId: aws.String("String"), // Required
		DownScaling: &opsworks.AutoScalingThresholds{
			Alarms: []*string{
				aws.String("String"), // Required
				// More values...
			},
			CpuThreshold:       aws.Float64(1.0),
			IgnoreMetricsTime:  aws.Int64(1),
			InstanceCount:      aws.Int64(1),
			LoadThreshold:      aws.Float64(1.0),
			MemoryThreshold:    aws.Float64(1.0),
			ThresholdsWaitTime: aws.Int64(1),
		},
		Enable: aws.Bool(true),
		UpScaling: &opsworks.AutoScalingThresholds{
			Alarms: []*string{
				aws.String("String"), // Required
				// More values...
			},
			CpuThreshold:       aws.Float64(1.0),
			IgnoreMetricsTime:  aws.Int64(1),
			InstanceCount:      aws.Int64(1),
			LoadThreshold:      aws.Float64(1.0),
			MemoryThreshold:    aws.Float64(1.0),
			ThresholdsWaitTime: aws.Int64(1),
		},
	}
	resp, err := svc.SetLoadBasedAutoScaling(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_SetPermission() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.SetPermissionInput{
		IamUserArn: aws.String("String"), // Required
		StackId:    aws.String("String"), // Required
		AllowSsh:   aws.Bool(true),
		AllowSudo:  aws.Bool(true),
		Level:      aws.String("String"),
	}
	resp, err := svc.SetPermission(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_SetTimeBasedAutoScaling() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.SetTimeBasedAutoScalingInput{
		InstanceId: aws.String("String"), // Required
		AutoScalingSchedule: &opsworks.WeeklyAutoScalingSchedule{
			Friday: map[string]*string{
				"Key": aws.String("Switch"), // Required
				// More values...
			},
			Monday: map[string]*string{
				"Key": aws.String("Switch"), // Required
				// More values...
			},
			Saturday: map[string]*string{
				"Key": aws.String("Switch"), // Required
				// More values...
			},
			Sunday: map[string]*string{
				"Key": aws.String("Switch"), // Required
				// More values...
			},
			Thursday: map[string]*string{
				"Key": aws.String("Switch"), // Required
				// More values...
			},
			Tuesday: map[string]*string{
				"Key": aws.String("Switch"), // Required
				// More values...
			},
			Wednesday: map[string]*string{
				"Key": aws.String("Switch"), // Required
				// More values...
			},
		},
	}
	resp, err := svc.SetTimeBasedAutoScaling(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_StartInstance() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.StartInstanceInput{
		InstanceId: aws.String("String"), // Required
	}
	resp, err := svc.StartInstance(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_StartStack() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.StartStackInput{
		StackId: aws.String("String"), // Required
	}
	resp, err := svc.StartStack(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_StopInstance() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.StopInstanceInput{
		InstanceId: aws.String("String"), // Required
	}
	resp, err := svc.StopInstance(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_StopStack() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.StopStackInput{
		StackId: aws.String("String"), // Required
	}
	resp, err := svc.StopStack(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_UnassignInstance() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.UnassignInstanceInput{
		InstanceId: aws.String("String"), // Required
	}
	resp, err := svc.UnassignInstance(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_UnassignVolume() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.UnassignVolumeInput{
		VolumeId: aws.String("String"), // Required
	}
	resp, err := svc.UnassignVolume(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_UpdateApp() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.UpdateAppInput{
		AppId: aws.String("String"), // Required
		AppSource: &opsworks.Source{
			Password: aws.String("String"),
			Revision: aws.String("String"),
			SshKey:   aws.String("String"),
			Type:     aws.String("SourceType"),
			Url:      aws.String("String"),
			Username: aws.String("String"),
		},
		Attributes: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
		DataSources: []*opsworks.DataSource{
			{ // Required
				Arn:          aws.String("String"),
				DatabaseName: aws.String("String"),
				Type:         aws.String("String"),
			},
			// More values...
		},
		Description: aws.String("String"),
		Domains: []*string{
			aws.String("String"), // Required
			// More values...
		},
		EnableSsl: aws.Bool(true),
		Environment: []*opsworks.EnvironmentVariable{
			{ // Required
				Key:    aws.String("String"), // Required
				Value:  aws.String("String"), // Required
				Secure: aws.Bool(true),
			},
			// More values...
		},
		Name: aws.String("String"),
		SslConfiguration: &opsworks.SslConfiguration{
			Certificate: aws.String("String"), // Required
			PrivateKey:  aws.String("String"), // Required
			Chain:       aws.String("String"),
		},
		Type: aws.String("AppType"),
	}
	resp, err := svc.UpdateApp(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_UpdateElasticIp() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.UpdateElasticIpInput{
		ElasticIp: aws.String("String"), // Required
		Name:      aws.String("String"),
	}
	resp, err := svc.UpdateElasticIp(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_UpdateInstance() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.UpdateInstanceInput{
		InstanceId:           aws.String("String"), // Required
		AgentVersion:         aws.String("String"),
		AmiId:                aws.String("String"),
		Architecture:         aws.String("Architecture"),
		AutoScalingType:      aws.String("AutoScalingType"),
		EbsOptimized:         aws.Bool(true),
		Hostname:             aws.String("String"),
		InstallUpdatesOnBoot: aws.Bool(true),
		InstanceType:         aws.String("String"),
		LayerIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		Os:         aws.String("String"),
		SshKeyName: aws.String("String"),
	}
	resp, err := svc.UpdateInstance(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_UpdateLayer() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.UpdateLayerInput{
		LayerId: aws.String("String"), // Required
		Attributes: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
		AutoAssignElasticIps:     aws.Bool(true),
		AutoAssignPublicIps:      aws.Bool(true),
		CustomInstanceProfileArn: aws.String("String"),
		CustomJson:               aws.String("String"),
		CustomRecipes: &opsworks.Recipes{
			Configure: []*string{
				aws.String("String"), // Required
				// More values...
			},
			Deploy: []*string{
				aws.String("String"), // Required
				// More values...
			},
			Setup: []*string{
				aws.String("String"), // Required
				// More values...
			},
			Shutdown: []*string{
				aws.String("String"), // Required
				// More values...
			},
			Undeploy: []*string{
				aws.String("String"), // Required
				// More values...
			},
		},
		CustomSecurityGroupIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		EnableAutoHealing:    aws.Bool(true),
		InstallUpdatesOnBoot: aws.Bool(true),
		LifecycleEventConfiguration: &opsworks.LifecycleEventConfiguration{
			Shutdown: &opsworks.ShutdownEventConfiguration{
				DelayUntilElbConnectionsDrained: aws.Bool(true),
				ExecutionTimeout:                aws.Int64(1),
			},
		},
		Name: aws.String("String"),
		Packages: []*string{
			aws.String("String"), // Required
			// More values...
		},
		Shortname:                aws.String("String"),
		UseEbsOptimizedInstances: aws.Bool(true),
		VolumeConfigurations: []*opsworks.VolumeConfiguration{
			{ // Required
				MountPoint:    aws.String("String"), // Required
				NumberOfDisks: aws.Int64(1),         // Required
				Size:          aws.Int64(1),         // Required
				Iops:          aws.Int64(1),
				RaidLevel:     aws.Int64(1),
				VolumeType:    aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateLayer(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_UpdateMyUserProfile() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.UpdateMyUserProfileInput{
		SshPublicKey: aws.String("String"),
	}
	resp, err := svc.UpdateMyUserProfile(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_UpdateRdsDbInstance() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.UpdateRdsDbInstanceInput{
		RdsDbInstanceArn: aws.String("String"), // Required
		DbPassword:       aws.String("String"),
		DbUser:           aws.String("String"),
	}
	resp, err := svc.UpdateRdsDbInstance(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_UpdateStack() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.UpdateStackInput{
		StackId:      aws.String("String"), // Required
		AgentVersion: aws.String("String"),
		Attributes: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
		ChefConfiguration: &opsworks.ChefConfiguration{
			BerkshelfVersion: aws.String("String"),
			ManageBerkshelf:  aws.Bool(true),
		},
		ConfigurationManager: &opsworks.StackConfigurationManager{
			Name:    aws.String("String"),
			Version: aws.String("String"),
		},
		CustomCookbooksSource: &opsworks.Source{
			Password: aws.String("String"),
			Revision: aws.String("String"),
			SshKey:   aws.String("String"),
			Type:     aws.String("SourceType"),
			Url:      aws.String("String"),
			Username: aws.String("String"),
		},
		CustomJson:                aws.String("String"),
		DefaultAvailabilityZone:   aws.String("String"),
		DefaultInstanceProfileArn: aws.String("String"),
		DefaultOs:                 aws.String("String"),
		DefaultRootDeviceType:     aws.String("RootDeviceType"),
		DefaultSshKeyName:         aws.String("String"),
		DefaultSubnetId:           aws.String("String"),
		HostnameTheme:             aws.String("String"),
		Name:                      aws.String("String"),
		ServiceRoleArn:            aws.String("String"),
		UseCustomCookbooks:        aws.Bool(true),
		UseOpsworksSecurityGroups: aws.Bool(true),
	}
	resp, err := svc.UpdateStack(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_UpdateUserProfile() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.UpdateUserProfileInput{
		IamUserArn:          aws.String("String"), // Required
		AllowSelfManagement: aws.Bool(true),
		SshPublicKey:        aws.String("String"),
		SshUsername:         aws.String("String"),
	}
	resp, err := svc.UpdateUserProfile(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOpsWorks_UpdateVolume() {
	sess := session.Must(session.NewSession())

	svc := opsworks.New(sess)

	params := &opsworks.UpdateVolumeInput{
		VolumeId:   aws.String("String"), // Required
		MountPoint: aws.String("String"),
		Name:       aws.String("String"),
	}
	resp, err := svc.UpdateVolume(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
