// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package organizations_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/organizations"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleOrganizations_AcceptHandshake() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.AcceptHandshakeInput{
		HandshakeId: aws.String("HandshakeId"), // Required
	}
	resp, err := svc.AcceptHandshake(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_AttachPolicy() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.AttachPolicyInput{
		PolicyId: aws.String("PolicyId"),       // Required
		TargetId: aws.String("PolicyTargetId"), // Required
	}
	resp, err := svc.AttachPolicy(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_CancelHandshake() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.CancelHandshakeInput{
		HandshakeId: aws.String("HandshakeId"), // Required
	}
	resp, err := svc.CancelHandshake(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_CreateAccount() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.CreateAccountInput{
		AccountName: aws.String("AccountName"), // Required
		Email:       aws.String("Email"),       // Required
		IamUserAccessToBilling: aws.String("IAMUserAccessToBilling"),
		RoleName:               aws.String("RoleName"),
	}
	resp, err := svc.CreateAccount(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_CreateOrganization() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.CreateOrganizationInput{
		FeatureSet: aws.String("OrganizationFeatureSet"),
	}
	resp, err := svc.CreateOrganization(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_CreateOrganizationalUnit() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.CreateOrganizationalUnitInput{
		Name:     aws.String("OrganizationalUnitName"), // Required
		ParentId: aws.String("ParentId"),               // Required
	}
	resp, err := svc.CreateOrganizationalUnit(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_CreatePolicy() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.CreatePolicyInput{
		Content:     aws.String("PolicyContent"),     // Required
		Description: aws.String("PolicyDescription"), // Required
		Name:        aws.String("PolicyName"),        // Required
		Type:        aws.String("PolicyType"),        // Required
	}
	resp, err := svc.CreatePolicy(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_DeclineHandshake() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.DeclineHandshakeInput{
		HandshakeId: aws.String("HandshakeId"), // Required
	}
	resp, err := svc.DeclineHandshake(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_DeleteOrganization() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	var params *organizations.DeleteOrganizationInput
	resp, err := svc.DeleteOrganization(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_DeleteOrganizationalUnit() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.DeleteOrganizationalUnitInput{
		OrganizationalUnitId: aws.String("OrganizationalUnitId"), // Required
	}
	resp, err := svc.DeleteOrganizationalUnit(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_DeletePolicy() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.DeletePolicyInput{
		PolicyId: aws.String("PolicyId"), // Required
	}
	resp, err := svc.DeletePolicy(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_DescribeAccount() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.DescribeAccountInput{
		AccountId: aws.String("AccountId"), // Required
	}
	resp, err := svc.DescribeAccount(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_DescribeCreateAccountStatus() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.DescribeCreateAccountStatusInput{
		CreateAccountRequestId: aws.String("CreateAccountRequestId"), // Required
	}
	resp, err := svc.DescribeCreateAccountStatus(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_DescribeHandshake() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.DescribeHandshakeInput{
		HandshakeId: aws.String("HandshakeId"), // Required
	}
	resp, err := svc.DescribeHandshake(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_DescribeOrganization() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	var params *organizations.DescribeOrganizationInput
	resp, err := svc.DescribeOrganization(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_DescribeOrganizationalUnit() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.DescribeOrganizationalUnitInput{
		OrganizationalUnitId: aws.String("OrganizationalUnitId"), // Required
	}
	resp, err := svc.DescribeOrganizationalUnit(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_DescribePolicy() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.DescribePolicyInput{
		PolicyId: aws.String("PolicyId"), // Required
	}
	resp, err := svc.DescribePolicy(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_DetachPolicy() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.DetachPolicyInput{
		PolicyId: aws.String("PolicyId"),       // Required
		TargetId: aws.String("PolicyTargetId"), // Required
	}
	resp, err := svc.DetachPolicy(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_DisablePolicyType() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.DisablePolicyTypeInput{
		PolicyType: aws.String("PolicyType"), // Required
		RootId:     aws.String("RootId"),     // Required
	}
	resp, err := svc.DisablePolicyType(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_EnableAllFeatures() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	var params *organizations.EnableAllFeaturesInput
	resp, err := svc.EnableAllFeatures(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_EnablePolicyType() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.EnablePolicyTypeInput{
		PolicyType: aws.String("PolicyType"), // Required
		RootId:     aws.String("RootId"),     // Required
	}
	resp, err := svc.EnablePolicyType(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_InviteAccountToOrganization() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.InviteAccountToOrganizationInput{
		Target: &organizations.HandshakeParty{ // Required
			Id:   aws.String("HandshakePartyId"),
			Type: aws.String("HandshakePartyType"),
		},
		Notes: aws.String("HandshakeNotes"),
	}
	resp, err := svc.InviteAccountToOrganization(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_LeaveOrganization() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	var params *organizations.LeaveOrganizationInput
	resp, err := svc.LeaveOrganization(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_ListAccounts() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.ListAccountsInput{
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.ListAccounts(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_ListAccountsForParent() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.ListAccountsForParentInput{
		ParentId:   aws.String("ParentId"), // Required
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.ListAccountsForParent(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_ListChildren() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.ListChildrenInput{
		ChildType:  aws.String("ChildType"), // Required
		ParentId:   aws.String("ParentId"),  // Required
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.ListChildren(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_ListCreateAccountStatus() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.ListCreateAccountStatusInput{
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
		States: []*string{
			aws.String("CreateAccountState"), // Required
			// More values...
		},
	}
	resp, err := svc.ListCreateAccountStatus(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_ListHandshakesForAccount() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.ListHandshakesForAccountInput{
		Filter: &organizations.HandshakeFilter{
			ActionType:        aws.String("ActionType"),
			ParentHandshakeId: aws.String("HandshakeId"),
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.ListHandshakesForAccount(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_ListHandshakesForOrganization() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.ListHandshakesForOrganizationInput{
		Filter: &organizations.HandshakeFilter{
			ActionType:        aws.String("ActionType"),
			ParentHandshakeId: aws.String("HandshakeId"),
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.ListHandshakesForOrganization(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_ListOrganizationalUnitsForParent() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.ListOrganizationalUnitsForParentInput{
		ParentId:   aws.String("ParentId"), // Required
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.ListOrganizationalUnitsForParent(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_ListParents() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.ListParentsInput{
		ChildId:    aws.String("ChildId"), // Required
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.ListParents(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_ListPolicies() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.ListPoliciesInput{
		Filter:     aws.String("PolicyType"), // Required
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.ListPolicies(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_ListPoliciesForTarget() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.ListPoliciesForTargetInput{
		Filter:     aws.String("PolicyType"),     // Required
		TargetId:   aws.String("PolicyTargetId"), // Required
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.ListPoliciesForTarget(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_ListRoots() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.ListRootsInput{
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.ListRoots(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_ListTargetsForPolicy() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.ListTargetsForPolicyInput{
		PolicyId:   aws.String("PolicyId"), // Required
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.ListTargetsForPolicy(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_MoveAccount() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.MoveAccountInput{
		AccountId:           aws.String("AccountId"), // Required
		DestinationParentId: aws.String("ParentId"),  // Required
		SourceParentId:      aws.String("ParentId"),  // Required
	}
	resp, err := svc.MoveAccount(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_RemoveAccountFromOrganization() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.RemoveAccountFromOrganizationInput{
		AccountId: aws.String("AccountId"), // Required
	}
	resp, err := svc.RemoveAccountFromOrganization(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_UpdateOrganizationalUnit() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.UpdateOrganizationalUnitInput{
		OrganizationalUnitId: aws.String("OrganizationalUnitId"), // Required
		Name:                 aws.String("OrganizationalUnitName"),
	}
	resp, err := svc.UpdateOrganizationalUnit(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleOrganizations_UpdatePolicy() {
	sess := session.Must(session.NewSession())

	svc := organizations.New(sess)

	params := &organizations.UpdatePolicyInput{
		PolicyId:    aws.String("PolicyId"), // Required
		Content:     aws.String("PolicyContent"),
		Description: aws.String("PolicyDescription"),
		Name:        aws.String("PolicyName"),
	}
	resp, err := svc.UpdatePolicy(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
