// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sfn

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/client"
	"github.com/aws/aws-sdk-go/aws/client/metadata"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/aws/signer/v4"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

// AWS Step Functions is a web service that enables you to coordinate the components
// of distributed applications and microservices using visual workflows. You
// build applications from individual components that each perform a discrete
// function, or task, allowing you to scale and change applications quickly.
// Step Functions provides a graphical console to visualize the components of
// your application as a series of steps. It automatically triggers and tracks
// each step, and retries when there are errors, so your application executes
// in order and as expected, every time. Step Functions logs the state of each
// step, so when things do go wrong, you can diagnose and debug problems quickly.
//
// Step Functions manages the operations and underlying infrastructure for you
// to ensure your application is available at any scale. You can run tasks on
// the AWS cloud, on your own servers, or an any system that has access to AWS.
// Step Functions can be accessed and used with the Step Functions console,
// the AWS SDKs (included with your Beta release invitation email), or an HTTP
// API (the subject of this document).
// The service client's operations are safe to be used concurrently.
// It is not safe to mutate any of the client's properties though.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23
type SFN struct {
	*client.Client
}

// Used for custom client initialization logic
var initClient func(*client.Client)

// Used for custom request initialization logic
var initRequest func(*request.Request)

// Service information constants
const (
	ServiceName = "states"    // Service endpoint prefix API calls made to.
	EndpointsID = ServiceName // Service ID for Regions and Endpoints metadata.
)

// New creates a new instance of the SFN client with a session.
// If additional configuration is needed for the client instance use the optional
// aws.Config parameter to add your extra config.
//
// Example:
//     // Create a SFN client from just a session.
//     svc := sfn.New(mySession)
//
//     // Create a SFN client with additional configuration
//     svc := sfn.New(mySession, aws.NewConfig().WithRegion("us-west-2"))
func New(p client.ConfigProvider, cfgs ...*aws.Config) *SFN {
	c := p.ClientConfig(EndpointsID, cfgs...)
	return newClient(*c.Config, c.Handlers, c.Endpoint, c.SigningRegion, c.SigningName)
}

// newClient creates, initializes and returns a new service client instance.
func newClient(cfg aws.Config, handlers request.Handlers, endpoint, signingRegion, signingName string) *SFN {
	svc := &SFN{
		Client: client.New(
			cfg,
			metadata.ClientInfo{
				ServiceName:   ServiceName,
				SigningName:   signingName,
				SigningRegion: signingRegion,
				Endpoint:      endpoint,
				APIVersion:    "2016-11-23",
				JSONVersion:   "1.0",
				TargetPrefix:  "AWSStepFunctions",
			},
			handlers,
		),
	}

	// Handlers
	svc.Handlers.Sign.PushBackNamed(v4.SignRequestHandler)
	svc.Handlers.Build.PushBackNamed(jsonrpc.BuildHandler)
	svc.Handlers.Unmarshal.PushBackNamed(jsonrpc.UnmarshalHandler)
	svc.Handlers.UnmarshalMeta.PushBackNamed(jsonrpc.UnmarshalMetaHandler)
	svc.Handlers.UnmarshalError.PushBackNamed(jsonrpc.UnmarshalErrorHandler)

	// Run custom client initialization if present
	if initClient != nil {
		initClient(svc.Client)
	}

	return svc
}

// newRequest creates a new request for a SFN operation and runs any
// custom request initialization.
func (c *SFN) newRequest(op *request.Operation, params, data interface{}) *request.Request {
	req := c.NewRequest(op, params, data)

	// Run custom request initialization if present
	if initRequest != nil {
		initRequest(req)
	}

	return req
}
