# Tinker (servicecatalog.internal frontend 2.0)

## Local Dev Setup

This repo is structured after [this starter kit](https://github.com/davezuko/react-redux-starter-kit/blob/master/README.md). See that repo's
README for information about getting your local development environment setup.

Useful devtools:
[Chrome inspector](https://developers.google.com/web/tools/chrome-devtools/)
[React Dev Tools](https://chrome.google.com/webstore/detail/react-developer-tools/fmkadmapgofadopljbjfkapdkoienihi?hl=en)
[Redux Dev Tools](https://chrome.google.com/webstore/detail/redux-devtools/lmhkpmbekcpmknklioeibfkpmmfibljd)
[Apollo Dev Tools](https://github.com/apollographql/apollo-client-devtools)

## Resources
There are tutorials linked for each framework.

This project is a frontend JS application. It uses [React](https://reactjs.org/tutorial/tutorial.html)
 for rendering, [Apollo client](https://www.apollographql.com/docs/react/essentials/get-started.html)
  to call GraphQL and handle loading/error states, [Jest](https://jestjs.io/docs/en/getting-started)
   for testing, and occassionally [Redux](https://redux.js.org/)
    for handling loading/error/querying. For page layout,
CSS, and other formatting concerns, we use [Bootstrap](https://getbootstrap.com/docs/3.3/)
 and [react-bootstrap](https://react-bootstrap.github.io/getting-started/introduction/).
Occassionally, the pages use [redux-form](https://redux-form.com/7.4.2/docs/gettingstarted.md/) for example, the service edit page.

### Running locally

You will want to install npm and yarn. First install node using nvm. See [Here](https://github.com/creationix/nvm#installation).
Then you will want to install v8.11.2
```
nvm install v8.11.2
nvm use v8.11.2
```

Use `yarn start`. This will run the node server locally on port 3000, and API requests will be sent to goracle beta.

### Tests

We use [jest](https://facebook.github.io/jest/) for tests and code coverage. Run `yarn test` and `yarn coverage` to run tests and generate code coverage.
If you make a change that updates test snapshots (i.e. changes html markup), run `yarn test -u` to update the snapshots and check them in, otherwise builds will fail.

#### Test Details

We have xxx major types of objects that we test:

* React components
* Redux actions, async actions, and reducers
* React container components (and other React components that interact with Redux)
* "vanilla" Javascript libraries (e.g. D3 libs)

We use jest snapshots as a quick and dirty way of validating output, especially in combination with enzyme's shallow (see below).

We use [enzyme](https://github.com/airbnb/enzyme) to help test React components and containers.

In particular, we use enzyme's [shallow rendering](https://github.com/airbnb/enzyme/blob/master/docs/api/shallow.md)
in order to make unit tests (and snapshots). `dive()` is a useful function of `shallow` in particular, it is useful for dealing with components
that are wrapped (e.g. Redux connect, forms, routes, etc.)

For testing Redux, we mostly follow the Redux ]Writing Tests](https://redux.js.org/docs/recipes/WritingTests.html) examples
and the packages that they recommend.

There are also mocks for our `lib/graphql` library that do some very basic mocking
of graphql queries based on goracle's schema. When the schema changes, you will need to modify
src/lib/__mocks__/graphSchema.js. You can use graphql-cli to output these.
To mock GraphQl, simply run jest.mock('lib/graphql') this will switch the code run to __mocks__/graphql.js
in the src/lib/ directory. In the mocked version, there is an addMockGQLObject and removeMockGQLObject you can use for mocking.
See ServiceList.integration.spec.js for an example of how to use Jest with GQL mocking.

Integration tests: https://hackernoon.com/low-effort-high-value-integration-tests-in-redux-apps-d3a590bd9fd5

Note that unlike this example, we are using react-test-renderer instead of enzyme because
it seems like with enzyme we are unable to flush all promises, and thus unable to get the
final version of the rendered page using enzyme. Maybe this will go away if we upgrade to react-16?

#### Debugging tests
If something needs inspection, or you would like to inspect the state in
the middle of a test, you can add `debugger;` to it and then do the following:
1. Start the chrome debugger. Open the following in a chrome browser `chrome://inspect`
2. Run this command from terminal: `node --inspect-brk node_modules/.bin/jest --runInBand <TestFile>`
3. Go to the debugger and continue to start the test.
This is from [this website](https://jestjs.io/docs/en/troubleshooting#tests-are-failing-and-you-don-t-know-why)

### Autofixing JS

We use ESLint and [prettier](https://github.com/prettier/prettier) for autoformatting JS.
Run `yarn autofix` to run both `prettier` and `eslint` fixes. To get only style changes, run `yarn fmt` or
`yarn prettier`. That will run `prettier` on all the files in the `src` directory.
Eslint will do things like remove debugger statements for you. Please do this before submitting any PRs for review.

### Running the Docker Container Locally

When the code is deployed on Beanstalk, it runs off of a docker container that is generated from a combination of the `Dockerfile`
in this repo along with the created compiled assets from running the `manta` build. Running the docker container locally is
probably the best way to verify that the bundle, when deployed to beanstalk, will work properly.

There is a script to locally run `manta` and spin up the docker container, attached to STDIN: `./scripts/docker-run.sh`.

You can override the following environment variables, which have sane defaults in the script:

```
TINKER_PORT
API_BASE
HMS_BASE
```

### Compiling locally

If for some reason you don't want to run the Docker container locally, but rather serve the assets locally by
running the golang router directly, this is also possible. (this might be useful if you are rapidly prototyping
some code that involves the asset pipeline, for example)

This can be done with `yarn build`, which compiles JS/HTML/CSS and dumps the minified+uglified bundle into `./dist`.
To serve the compiled application, use the golang router code in `cmd/server/tinker.go` with `go run ./cmd/server/tinker.go`.
The golang app requires certain environment variables be set, in order to deliver the client some runtime environment
configuration options (namely what backend API endpoint to hit). At the time of writing, the only environment variable
required is `API_BASE`, e.g. `https://servicecatalog.internal.justin.tv/api/v1`.

To run the app locally, running with production flags turned on and pointing at production goracle, you could use
`yarn build:production && API_BASE=https://servicecatalog.internal.justin.tv/api/v1 go run ./cmd/server/tinker.go`.
This command will compile the application bundle, and run the router to serve them. The golang app serves a custom
JS script at `/config.js` which the main bundle will request, and use the script to configure said runtime flags.
