job {
    name 'availability-tinker'
    using 'TEMPLATE-autobuild'
    concurrentBuild true

    scm {
        git {
            remote {
                github 'availability/tinker', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }

    wrappers {
        sshAgent 'git-aws-read-key'
        preBuildCleanup()
        timestamps()
        colorizeOutput()
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
        }
    }

    steps {
        shell './scripts/build.sh'
        shell './scripts/push.sh'
        saveDeployArtifact 'availability/tinker-ebextensions', 'deploy/'
    }

    publishers {
        reportQuality('availability/tinker', '.manta/coverage', '*.xml')
    }
}




freeStyleJob('availability-tinker-production-deploy') {
    using 'TEMPLATE-deploy-aws'

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'twitch-central-aws-tcs-access-key'
            string 'AWS_SECRET_KEY', 'twitch-central-aws-tcs-secret-key'
        }
    }

    steps {
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'availability/tinker-ebextensions'
        shell 'rm -f *.manifest*'
        // deploy server
        shell """set +x
                |export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
                |export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
                |export PYTHONUNBUFFERED=1
                |set -x
                |export IMAGE=docker-registry.internal.justin.tv/availability-tinker:\$GIT_COMMIT
                |
                |cat <<EOF > Dockerrun.aws.json
                |{
                |  "AWSEBDockerrunVersion": "1",
                |  "Image": {
                |    "Name": "\$IMAGE",
                |    "Update": "false"
                |  },
                |  "Ports": [
                |    {
                |      "ContainerPort": "8000"
                |    }
                |  ],
                |  "Volumes": [
                |    {
                |      "ContainerDirectory": "/var/app",
                |      "HostDirectory": "/var/app"
                |    },
                |    {
                |      "ContainerDirectory": "/etc/ssl/certs/ca-bundle.crt",
                |      "HostDirectory": "/etc/ssl/certs/ca-bundle.crt"
                |    }
                |  ],
                |  "Logging": "/var/log/"
                |}
                |EOF
                |
                | eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v --region us-west-2
                | eb deploy production-availability-tinker-env""".stripMargin()
    }
}




freeStyleJob('availability-tinker-staging-deploy') {
    using 'TEMPLATE-deploy-aws'

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'twitch-central-dev-tcs-access-key'
            string 'AWS_SECRET_KEY', 'twitch-central-dev-tcs-secret-key'
        }
    }

    steps {
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'availability/tinker-ebextensions'
        shell 'rm -f *.manifest*'
        // deploy server
        shell """set +x
                |export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
                |export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
                |export PYTHONUNBUFFERED=1
                |set -x
                |export IMAGE=docker-registry.internal.justin.tv/availability-tinker:\$GIT_COMMIT
                |
                |cat <<EOF > Dockerrun.aws.json
                |{
                |  "AWSEBDockerrunVersion": "1",
                |  "Image": {
                |    "Name": "\$IMAGE",
                |    "Update": "false"
                |  },
                |  "Ports": [
                |    {
                |      "ContainerPort": "8000"
                |    }
                |  ],
                |  "Volumes": [
                |    {
                |      "ContainerDirectory": "/var/app",
                |      "HostDirectory": "/var/app"
                |    },
                |    {
                |      "ContainerDirectory": "/etc/ssl/certs/ca-bundle.crt",
                |      "HostDirectory": "/etc/ssl/certs/ca-bundle.crt"
                |    }
                |  ],
                |  "Logging": "/var/log/"
                |}
                |EOF
                |
                | eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v --region us-west-2
                | eb deploy staging-availability-tinker-env""".stripMargin()
    }
}




freeStyleJob('availability-tinker-development-deploy') {
    using 'TEMPLATE-deploy-aws'

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'twitch-central-dev-tcs-access-key'
            string 'AWS_SECRET_KEY', 'twitch-central-dev-tcs-secret-key'
        }
    }

    steps {
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'availability/tinker-ebextensions'
        shell 'rm -f *.manifest*'
        // deploy server
        shell """set +x
                |export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
                |export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
                |export PYTHONUNBUFFERED=1
                |set -x
                |export IMAGE=docker-registry.internal.justin.tv/availability-tinker:\$GIT_COMMIT
                |
                |cat <<EOF > Dockerrun.aws.json
                |{
                |  "AWSEBDockerrunVersion": "1",
                |  "Image": {
                |    "Name": "\$IMAGE",
                |    "Update": "false"
                |  },
                |  "Ports": [
                |    {
                |      "ContainerPort": "8000"
                |    }
                |  ],
                |  "Volumes": [
                |    {
                |      "ContainerDirectory": "/var/app",
                |      "HostDirectory": "/var/app"
                |    },
                |    {
                |      "ContainerDirectory": "/etc/ssl/certs/ca-bundle.crt",
                |      "HostDirectory": "/etc/ssl/certs/ca-bundle.crt"
                |    }
                |  ],
                |  "Logging": "/var/log/"
                |}
                |EOF
                |
                | eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v --region us-west-2
                | eb deploy development-availability-tinker-env""".stripMargin()
    }
}

freeStyleJob('availability-tinker-development-noproxy-deploy') {
  using 'TEMPLATE-deploy-aws'

  wrappers {
    credentialsBinding {
      file('COURIERD_PRIVATE_KEY', 'courierd')
      file('AWS_CONFIG_FILE', 'aws_config')
      string 'AWS_ACCESS_KEY', 'twitch-central-dev-tcs-access-key'
      string 'AWS_SECRET_KEY', 'twitch-central-dev-tcs-secret-key'
    }
  }

  steps {
    // download .ebextensions into deploy/.ebextensions
    downloadDeployArtifact 'availability/tinker-ebextensions'
    shell 'rm -f *.manifest*'
    // deploy server
    shell """set +x
                |export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
                |export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
                |export PYTHONUNBUFFERED=1
                |set -x
                |export IMAGE=docker-registry.internal.justin.tv/availability-tinker:\$GIT_COMMIT
                |
                |cat <<EOF > Dockerrun.aws.json
                |{
                |  "AWSEBDockerrunVersion": "1",
                |  "Image": {
                |    "Name": "\$IMAGE",
                |    "Update": "false"
                |  },
                |  "Ports": [
                |    {
                |      "ContainerPort": "8000"
                |    }
                |  ],
                |  "Volumes": [
                |    {
                |      "ContainerDirectory": "/var/app",
                |      "HostDirectory": "/var/app"
                |    },
                |    {
                |      "ContainerDirectory": "/etc/ssl/certs/ca-bundle.crt",
                |      "HostDirectory": "/etc/ssl/certs/ca-bundle.crt"
                |    }
                |  ],
                |  "Logging": "/var/log/"
                |}
                |EOF
                |
                | eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v --region us-west-2
                | eb deploy tinker-bs-development-int-env
                | eb deploy tinker-bs-development-ext-env""".stripMargin()
  }
}

freeStyleJob('availability-tinker-production-noproxy-deploy') {
  using 'TEMPLATE-deploy-aws'

  wrappers {
    credentialsBinding {
      file('COURIERD_PRIVATE_KEY', 'courierd')
      file('AWS_CONFIG_FILE', 'aws_config')
      string 'AWS_ACCESS_KEY', 'twitch-central-aws-tcs-access-key'
      string 'AWS_SECRET_KEY', 'twitch-central-aws-tcs-secret-key'
    }
  }

  steps {
    // download .ebextensions into deploy/.ebextensions
    downloadDeployArtifact 'availability/tinker-ebextensions'
    shell 'rm -f *.manifest*'
    // deploy server
    shell """set +x
                |export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
                |export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
                |export PYTHONUNBUFFERED=1
                |set -x
                |export IMAGE=docker-registry.internal.justin.tv/availability-tinker:\$GIT_COMMIT
                |
                |cat <<EOF > Dockerrun.aws.json
                |{
                |  "AWSEBDockerrunVersion": "1",
                |  "Image": {
                |    "Name": "\$IMAGE",
                |    "Update": "false"
                |  },
                |  "Ports": [
                |    {
                |      "ContainerPort": "8000"
                |    }
                |  ],
                |  "Volumes": [
                |    {
                |      "ContainerDirectory": "/var/app",
                |      "HostDirectory": "/var/app"
                |    },
                |    {
                |      "ContainerDirectory": "/etc/ssl/certs/ca-bundle.crt",
                |      "HostDirectory": "/etc/ssl/certs/ca-bundle.crt"
                |    }
                |  ],
                |  "Logging": "/var/log/"
                |}
                |EOF
                |
                | eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v --region us-west-2
                | eb deploy tinker-bs-production-int-env
                | eb deploy tinker-bs-production-ext-env""".stripMargin()
  }
}

freeStyleJob('availability-tinker-beta-deploy') {
  using 'TEMPLATE-deploy-aws'

  parameters {
    stringParam("AWS_ACCESS_KEY_ID", null, "Get temporary credentials from https://isengard.amazon.com/console-access")
    stringParam("AWS_SECRET_ACCESS_KEY", null, "Get temporary credentials from https://isengard.amazon.com/console-access")
    stringParam("AWS_SESSION_TOKEN", null, "Get temporary credentials from https://isengard.amazon.com/console-access")
  }

  wrappers {
    credentialsBinding {
      file('COURIERD_PRIVATE_KEY', 'courierd')
      file('AWS_CONFIG_FILE', 'aws_config')
    }
  }

  steps {
    // download .ebextensions into deploy/.ebextensions
    downloadDeployArtifact 'availability/tinker-ebextensions'
    shell 'rm -f *.manifest*'
    // deploy server
    shell """set +x
                |export PYTHONUNBUFFERED=1
                |set -x
                |export IMAGE=docker-registry.internal.justin.tv/availability-tinker:\$GIT_COMMIT
                |
                |cat <<EOF > Dockerrun.aws.json
                |{
                |  "AWSEBDockerrunVersion": "1",
                |  "Image": {
                |    "Name": "\$IMAGE",
                |    "Update": "false"
                |  },
                |  "Ports": [
                |    {
                |      "ContainerPort": "8000"
                |    }
                |  ],
                |  "Volumes": [
                |    {
                |      "ContainerDirectory": "/var/app",
                |      "HostDirectory": "/var/app"
                |    },
                |    {
                |      "ContainerDirectory": "/etc/ssl/certs/ca-bundle.crt",
                |      "HostDirectory": "/etc/ssl/certs/ca-bundle.crt"
                |    }
                |  ],
                |  "Logging": "/var/log/"
                |}
                |EOF
                |
                | eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v --region us-west-2
                | eb deploy servicecatalog-beta-env""".stripMargin()
  }

  freeStyleJob('availability-tinker-prod-fulton-deploy') {
    using 'TEMPLATE-deploy-aws'

    parameters {
      stringParam("AWS_ACCESS_KEY_ID", null, "Get temporary credentials from https://isengard.amazon.com/console-access")
      stringParam("AWS_SECRET_ACCESS_KEY", null, "Get temporary credentials from https://isengard.amazon.com/console-access")
      stringParam("AWS_SESSION_TOKEN", null, "Get temporary credentials from https://isengard.amazon.com/console-access")
    }

    wrappers {
      credentialsBinding {
        file('COURIERD_PRIVATE_KEY', 'courierd')
        file('AWS_CONFIG_FILE', 'aws_config')
      }
    }

    steps {
      // download .ebextensions into deploy/.ebextensions
      downloadDeployArtifact 'availability/tinker-ebextensions'
      shell 'rm -f *.manifest*'
      // deploy server
      shell """set +x
                |export PYTHONUNBUFFERED=1
                |set -x
                |export IMAGE=docker-registry.internal.justin.tv/availability-tinker:\$GIT_COMMIT
                |
                |cat <<EOF > Dockerrun.aws.json
                |{
                |  "AWSEBDockerrunVersion": "1",
                |  "Image": {
                |    "Name": "\$IMAGE",
                |    "Update": "false"
                |  },
                |  "Ports": [
                |    {
                |      "ContainerPort": "8000"
                |    }
                |  ],
                |  "Volumes": [
                |    {
                |      "ContainerDirectory": "/var/app",
                |      "HostDirectory": "/var/app"
                |    },
                |    {
                |      "ContainerDirectory": "/etc/ssl/certs/ca-bundle.crt",
                |      "HostDirectory": "/etc/ssl/certs/ca-bundle.crt"
                |    }
                |  ],
                |  "Logging": "/var/log/"
                |}
                |EOF
                |
                | eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v --region us-west-2
                | eb deploy tinker-bs-prod-int-env""".stripMargin()
    }
  }
}
