#!/bin/bash

if [[ -z "$TINKER_PORT" ]] ; then
  TINKER_PORT=8000
fi

if [[ -z "$API_BASE" ]] ; then
  API_BASE="https://servicecatalog-dev.internal.justin.tv/api/v2/query.guardian"
fi

if [[ -z "$HMS_BASE" ]] ; then
  HMS_BASE="https://hms-esk-development.internal.justin.tv/v1"
fi

if [[ -z "$MESSAGING_BASE" ]] ; then
  MESSAGING_BASE="https://servicecatalog-dev.internal.justin.tv/messaging"
fi

manta -f build.json && docker build -t tinker . && docker run -p ${TINKER_PORT}:${TINKER_PORT} -a stderr -e API_BASE=${API_BASE} -e HMS_BASE=${HMS_BASE} -e MESSAGING_BASE=${MESSAGING_BASE} tinker
