import React from "react";
import PropTypes from "prop-types";
import ErrorMessage from "components/ErrorMessage";
import * as d3 from "d3";
import D3DependencyTree from "lib/d3dependencytree";
import { mouseEvent } from "lib/mouseevents";
import shortid from "shortid";

function d3DependencyTree(thisThing) {
  const { upData, downData, clickCallback, height, width } = thisThing.props;

  return new D3DependencyTree({
    el: thisThing.graph,
    id: thisThing.state.id,
    clickCallback: clickCallback,
    upData: upData,
    downData: downData,
    height: height,
    width: width,
  });
}

class DependencyTree extends React.Component {
  constructor(props) {
    super(props);
    this.handleMouseMove = this.handleMouseMove.bind(this);
    this.state = {
      id: shortid.generate(),
    };
  }

  componentDidMount() {
    let d3dg = d3DependencyTree(this);

    d3dg.create();
  }

  componentDidUpdate(prevProps, prevState) {
    let d3dg = d3DependencyTree(this);

    d3dg.update();
  }

  componentWillUnmount() {
    let d3dg = d3DependencyTree(this);

    d3dg.destroy();
  }

  render() {
    return (
      <div
        onMouseMove={this.handleMouseMove}
        ref={graph => {
          this.graph = graph;
        }}
      />
    );
  }

  handleMouseMove(e) {
    // This takes the synthetic mousemove event that React generates and refires
    // a real event down into the SVG, specifically the focus area that we use
    // for the graph.

    const { clientX, clientY, pageX, pagey, screenX, screenY } = e;
    let node = d3
      .select(this.graph)
      .select(".focusArea")
      .node();
    if (node) {
      let me = mouseEvent("mousemove", screenX, screenY, clientX, clientY);
      node.dispatchEvent(me);
    }
  }
}

DependencyTree.propTypes = {
  upData: PropTypes.any.isRequired,
  downData: PropTypes.any.isRequired,
  width: PropTypes.any.isRequired,
  height: PropTypes.any.isRequired,
};

export default DependencyTree;
