import React from "react";
import { connect } from "react-redux";
import { Button, Modal } from "react-bootstrap";
import { clearErrors } from "./Actions";

import ErrorModalStyle from "./ErrorModalStyle.scss";

class ErrorModal extends React.Component {
  constructor(props) {
    super(props);
  }
  render() {
    const { clearErrors, errors } = this.props;

    let errorMessage = "";
    if (errors && errors.length == 1) {
      errorMessage = <p>{errors[0]}</p>;
    } else {
      errorMessage = (
        <ul>
          {errors.map(function(error) {
            return <li>{error}</li>;
          })}
        </ul>
      );
    }

    return (
      <Modal
        className="error-modal"
        show={errors !== undefined && errors.length > 0}
        onHide={clearErrors}
      >
        <Modal.Header>
          <div className="icon-box">
            <span className="glyphicon glyphicon-remove" aria-hidden="true" />
          </div>
        </Modal.Header>
        <Modal.Body className="text-center">
          <h4>Ooops!</h4>
          <p>Something went wrong:</p>
          {errorMessage}
          <Button className="btn btn-success" onClick={clearErrors}>
            Dismiss
          </Button>
        </Modal.Body>
      </Modal>
    );
  }
}

const mapStateToProps = (state, ownProps) => {
  return {
    errors: state.errors,
  };
};

const mapDispatchToProps = {
  clearErrors: clearErrors,
};

export default connect(mapStateToProps, mapDispatchToProps)(ErrorModal);
