import React from "react";
import { Alert, FormGroup, ControlLabel, FormControl } from "react-bootstrap";
import { Link } from "react-router-dom";
import PropTypes from "prop-types";
import WrapperTooltip from "components/WrapperTooltip";

class BasicDisplay extends React.Component {
  render() {
    const { value, display, linkProducer, title } = this.props;
    let tooltipID = this.props.title;
    if (this.props.tooltipID) {
      tooltipID = this.props.tooltipID;
    }

    let displayJSX = <span>{display}</span>;
    // if has link or linkProducer, set it to that
    if (this.props.link || (linkProducer && value != 0)) {
      let link = "";

      if (this.props.link) {
        link = this.props.link;
      } else if (linkProducer) {
        link = linkProducer(value);
      }
      if (link) {
        // <Link> doesn't handle absolute links. Also, open these in a new tab
        if (/^(mailto|https?):/.test(link)) {
          displayJSX = (
            <a href={link} target="_blank">
              {display}
            </a>
          );
        } else {
          displayJSX = <Link to={link}>{display}</Link>;
        }
      }
    }

    let titleDisplay = title + ": ";
    if (!title) {
      titleDisplay = "";
    }
    return (
      <p>
        <b>
          <WrapperTooltip title={titleDisplay} tooltipID={tooltipID} />
        </b>
        {displayJSX}
      </p>
    );
  }
}
BasicDisplay.propTypes = {
  value: PropTypes.any,
  tooltipID: PropTypes.string,
  title: PropTypes.string,
  display: PropTypes.any.isRequired,
  linkProducer: PropTypes.func,
  link: PropTypes.string,
};
export default BasicDisplay;
