import React from "react";
import {
  Alert,
  FormGroup,
  ControlLabel,
  FormControl,
  Checkbox,
} from "react-bootstrap";
import WrapperTooltip from "components/WrapperTooltip";

function attributeByName(attributes, attributeName) {
  for (var i = 0; i < attributes.length; i++) {
    if (attributes[i].name === attributeName) {
      if (attributes[i].deleted) {
        return false;
      }
      return true;
    }
  }
  return false;
}
class FormAttributeCheckbox extends React.Component {
  render() {
    var attributeName = this.props.attributeName;
    var attributes = this.props.input.value;
    var attributeChecked = attributeByName(attributes, attributeName);
    function attributeCheckClicked() {
      var checked = !attributeChecked;
      for (var i = 0; i < attributes.length; i++) {
        if (attributes[i].name === attributeName) {
          attributes[i].value = "";
          attributes[i].deleted = !checked;
          return [...attributes];
        }
      }
      if (checked) {
        var attr = { id: "0", name: attributeName, value: "" };
        attributes.push(attr);
        return [...attributes];
      }

      return attributes;
    }

    if (this.props.isEditing) {
      return (
        <FormGroup>
          <Checkbox
            checked={attributeChecked}
            onChange={() => {
              this.props.input.onChange(attributeCheckClicked());
              this.forceUpdate();
            }}
          >
            <b>
              <WrapperTooltip title={this.props.title} />
            </b>
          </Checkbox>
        </FormGroup>
      );
    } else {
      let title = this.props.title + ": ";
      if (!this.props.title) {
        title = "";
      }
      return (
        <p>
          <b>
            <WrapperTooltip title={title} tooltipID={this.props.title} />
          </b>
          {attributeChecked && <d>Yes</d>}
          {!attributeChecked && <d>No</d>}
        </p>
      );
    }
  }
}

export default FormAttributeCheckbox;
