import React from "react";
import _ from "lodash";
import {
  Modal,
  Button,
  Label,
  Row,
  FormGroup,
  ControlLabel,
  FormControl,
  Col,
  Alert,
} from "react-bootstrap";
import Select from "react-select";
import WrapperTooltip from "components/WrapperTooltip";

function attributesToOptions(attrs, excluded) {
  var data = attrs;
  var options = {};
  for (var i = 0; i < data.length; i++) {
    if (!data[i].deleted && !excluded.includes(data[i].name)) {
      var val = data[i].name + ": " + data[i].value;
      options[val] = {
        label: val,
        value: { name: data[i].name, value: data[i].value, id: data[i].id },
      };
    }
  }
  var res = [];
  var o = _.keys(options).sort();
  var k;
  for (k in o) {
    res.push(options[o[k]]);
  }
  return res;
}

class FormAttributeSelect extends React.Component {
  componentWillMount() {
    this.props.fetchOptions();
    this.props.toggleModal(false, "0", "", "");
  }
  render() {
    var props = this.props;
    var { input, isEditing, excludeAttributes } = props;
    excludeAttributes = excludeAttributes || [];
    if (isEditing) {
      var data = attributesToOptions(props.input.value, excludeAttributes);
      var options = attributesToOptions(props.allOptions, excludeAttributes);
      var dataLabels = data.map(d => d.value.name);
      options = options.filter(opt => !dataLabels.includes(opt.value.name));

      var reduxFormOnChange = (x, action) => {
        var res = {
          attr: x,
          action: action,
        };
        input.onChange(res);
      };
      let onChange = function(values) {
        if (values.length < data.length) {
          var [alteredValue] = data.filter(tag => !values.includes(tag));
          reduxFormOnChange(alteredValue.value, "delete");
        } else if (values.length > data.length) {
          var [alteredValue] = values.filter(tag => !data.includes(tag));
          reduxFormOnChange(alteredValue.value, "add");
        }
      };
      var promptTextCreator = label => {
        return `Press Enter to Create ${label}`;
      };
      return (
        <div>
          <Modal
            bsSize="lg"
            show={props.modalEnabled}
            onHide={() => props.toggleModal(false)}
          >
            <Modal.Header closeButton>
              <Modal.Title>Add an Attribute</Modal.Title>
            </Modal.Header>
            <Modal.Body>
              <ControlLabel>
                <WrapperTooltip title="Attribute Name" />
              </ControlLabel>
              <Select.Creatable
                name={"ModalName"}
                options={props.modalNameOptions}
                value={props.modalName}
                disabled={props.modalNameEditable}
                onChange={props.changeModalName}
                promptTextCreator={promptTextCreator}
              />
              <ControlLabel>
                <WrapperTooltip title="Attribute Value" />
              </ControlLabel>
              {props.modalName === "tier" && (
                <Select
                  name={"ModalName"}
                  options={props.modalValueOptions}
                  value={props.modalValue}
                  onChange={props.changeModalValue}
                  promptTextCreator={promptTextCreator}
                />
              )}
              {props.modalName !== "tier" && (
                <Select.Creatable
                  name={"ModalName"}
                  options={props.modalValueOptions}
                  value={props.modalValue}
                  onChange={props.changeModalValue}
                  promptTextCreator={promptTextCreator}
                />
              )}
            </Modal.Body>
            <Modal.Footer>
              <Button
                onClick={() => {
                  reduxFormOnChange(
                    {
                      name: props.modalName,
                      value: props.modalValue,
                      id: props.modalID,
                    },
                    "edit"
                  );
                  props.toggleModal(false);
                }}
                bsStyle="primary"
              >
                Add Attribute
              </Button>
            </Modal.Footer>
          </Modal>
          <FormGroup
            controlId="formControlsSelect"
            validationState={this.props.meta.error && "error"}
          >
            <ControlLabel>
              <WrapperTooltip title="Attributes" />
            </ControlLabel>
            <Select
              name={"Attributes"}
              options={options}
              value={data}
              multi
              onChange={onChange}
              valueRenderer={value => {
                return (
                  <Button
                    bsStyle="link"
                    bsSize="small"
                    onClick={() => {
                      var attr = value.value;
                      props.toggleModal(true, attr.id, attr.name, attr.value);
                    }}
                  >
                    {value.label}
                  </Button>
                );
              }}
            />
            <FormControl.Feedback />
            {this.props.meta.error && (
              <Alert bsStyle="warning">{this.props.meta.error}</Alert>
            )}
          </FormGroup>
          <Row>
            <Col md={4}>
              <Button
                onClick={() => {
                  props.toggleModal(true, "0", "", "");
                }}
                bsStyle="primary"
              >
                Add Attribute
              </Button>
            </Col>
          </Row>
        </div>
      );
    } else {
      var data = attributesToOptions(props.input.value, excludeAttributes);
      return (
        <div>
          <p>
            <b>
              <WrapperTooltip title="Attributes:" tooltipID="Attributes" />
            </b>
          </p>
          <div className="service-detail-tags">
            {data.map(attr => {
              return (
                <Label
                  key={attr.label}
                  bsStyle="primary"
                  className="service-detail-tag"
                >
                  {attr.label}
                </Label>
              );
            })}
          </div>
        </div>
      );
    }
  }
}

export default FormAttributeSelect;
