import React from "react";
import {
  Alert,
  FormGroup,
  ControlLabel,
  FormControl,
  Checkbox,
} from "react-bootstrap";
import WrapperTooltip from "components/WrapperTooltip";

class FormCheckbox extends React.Component {
  render() {
    if (this.props.isEditing) {
      return (
        <FormGroup>
          <Checkbox
            checked={this.props.input.value}
            onChange={this.props.input.onChange}
          >
            <b>
              <WrapperTooltip title={this.props.title} />
            </b>
          </Checkbox>
        </FormGroup>
      );
    } else {
      return (
        <p>
          <b>
            <WrapperTooltip
              title={this.props.title + ": "}
              tooltipID={this.props.title}
            />
          </b>
          {this.props.input.value && <d>Yes</d>}
          {!this.props.input.value && <d>No</d>}
        </p>
      );
    }
  }
}

export default FormCheckbox;
