import React from "react";
import PropTypes from "prop-types";
import { Glyphicon, Modal, Button, Checkbox } from "react-bootstrap";
import ServiceContainer from "common/ServiceTable/containers/ServiceContainer";
function capitalizeFirstLetter(string) {
  return string[0].toUpperCase() + string.slice(1);
}
class FormMultiSelect extends React.Component {
  componentWillMount() {
    this.props.fetchOptions();
    this.props.toggleModal(false);
  }
  render() {
    const {
      optionRollupToggled,
      input,
      optionNameFormatter,
      isEditing,
      modalEnabled,
      toggleModal,
      dataType,
      dataFunc,
      id,
      allOptions,
      selectedOptions,
      columns,
      rollupKey,
    } = this.props;

    if (isEditing) {
      // create a custom function that takes
      // an item and an action, and dispatches the change
      // to redux-form, so the form data stays in sync with
      // this contained component's state
      var reduxFormOnChange = (x, action) => {
        var res = {
          id: x.id,
          object: x,
          action: action,
          rollupKey: rollupKey,
        };
        input.onChange(res);
      };

      var selectedColumns = [
        {
          title: "Remove",
          key: "id",
          formatter: x => {
            return {
              display: (
                <Button
                  bsSize="small"
                  onClick={() => {
                    reduxFormOnChange(x, "remove");
                  }}
                  bsStyle="danger"
                >
                  <Glyphicon glyph="remove" />
                </Button>
              ),
              value: "remove",
            };
          },
        },
        {
          title: "Name",
          key: "name",
          formatter: optionNameFormatter,
        },
      ];

      if (rollupKey) {
        selectedColumns.push({
          title: "Rollup",
          key: rollupKey,
          formatter: x => {
            return {
              display: (
                <Checkbox
                  checked={x[rollupKey]}
                  onChange={val => {
                    reduxFormOnChange(x, "rollupToggled");
                  }}
                />
              ),
              value: "rollup",
            };
          },
        });
      }
      var optionsColumns = [
        {
          title: "Add",
          key: "id",
          formatter: x => {
            return {
              display: (
                <Button
                  bsSize="small"
                  onClick={() => {
                    reduxFormOnChange(x, "add");
                  }}
                  bsStyle="success"
                >
                  <Glyphicon glyph="plus" />
                </Button>
              ),
              value: "add",
            };
          },
        },
        {
          title: "Name",
          key: "name",
          filter: "text",
          formatter: optionNameFormatter,
          isBasicFilter: true,
        },
      ];

      return (
        <div>
          <Modal
            bsSize="lg"
            show={modalEnabled}
            onHide={() => toggleModal(false)}
          >
            <Modal.Header closeButton>
              <Modal.Title>Add a {dataType}</Modal.Title>
            </Modal.Header>
            <Modal.Body>
              <ServiceContainer
                tableId={id + "Options"}
                data={allOptions}
                dataType={dataType}
                columns={optionsColumns}
                enablePagination
                enableFilters
              />
            </Modal.Body>
          </Modal>

          <ServiceContainer
            tableId={id + "Selected"}
            data={input.value}
            dataType={dataType}
            dataFunc={dataFunc}
            columns={selectedColumns}
            enablePagination={false}
            enableFilters={false}
          />
          <Button onClick={() => toggleModal(true)} bsStyle="primary">
            Add {capitalizeFirstLetter(dataType)}
          </Button>
        </div>
      );
    }

    return (
      <ServiceContainer
        tableId={id + "Table"}
        data={input.value}
        dataType={dataType}
        dataFunc={dataFunc}
        columns={columns}
        isLoading={false}
        hasErrored={false}
        enableFilters={false}
        enablePagination={false}
      />
    );
  }
}

FormMultiSelect.propTypes = {
  input: PropTypes.any.isRequired,
  dataType: PropTypes.string.isRequired,
  dataFunc: PropTypes.func,
  columns: PropTypes.array.isRequired,
  optionNameFormatter: PropTypes.func.isRequired,
};

export default FormMultiSelect;
