// @format
import React from "react";
import PropTypes from "prop-types";
import { ControlLabel, FormControl, FormGroup, Alert } from "react-bootstrap";
import BasicDisplay from "./BasicDisplay";
import VirtualizedSelect from "react-virtualized-select";

import "react-select/dist/react-select.css";
import "react-virtualized/styles.css";
import "react-virtualized-select/styles.css";

class FormSelect extends React.Component {
  componentWillMount() {
    this.props.fetchOptions();
  }
  render() {
    const {
      isEditing,
      title,
      input,
      options,
      additionalOptions,
      currentValue,
      clearable=false,
    } = this.props;

    let allOptions = [{ value: "0", label: "Unknown" }, ...options];
    if (additionalOptions !== undefined) {
      allOptions = [...allOptions, ...additionalOptions];
    }

    if (isEditing) {
      return (
        <FormGroup controlId="formControlsSelect">
          <ControlLabel>{title}</ControlLabel>
          <VirtualizedSelect
            simpleValue
            clearable={clearable}
            onChange={input.onChange}
            options={allOptions}
            value={input.value}
          />
          <FormControl.Feedback />
          {this.props.meta.error && (
            <Alert bsStyle="warning">{this.props.meta.error}</Alert>
          )}
        </FormGroup>
      );
    } else {
      return (
        <BasicDisplay
          {...this.props}
          value={input.value}
          display={currentValue}
        />
      );
    }
  }
}

FormSelect.propTypes = {
  isEditing: PropTypes.bool.isRequired,
  tooltipID: PropTypes.string,
  title: PropTypes.string,
  currentValue: PropTypes.string,
  id: PropTypes.string,
  clearable: PropTypes.bool,
};

export default FormSelect;
