import React from "react";
import { ControlLabel, FormGroup, FormControl } from "react-bootstrap";
import _ from "lodash";

const serviceTypes = {
  "external-product": "External Product",
  "internal-product": "Internal Product",
  "internal-ops": "Internal Operations",
};

// This special form component is because service types are weird
class FormSelectServiceType extends React.Component {
  render() {
    var input = this.props.input;
    if (this.props.isEditing) {
      return (
        <FormGroup controlId="formControlsSelect">
          <ControlLabel>{this.props.title}</ControlLabel>
          <FormControl
            componentClass="select"
            onChange={this.props.input.onChange}
          >
            {_.keys(serviceTypes).map(function(st) {
              return (
                <option value={st} selected={st === input.value}>
                  {serviceTypes[st]}
                </option>
              );
            })}
          </FormControl>
        </FormGroup>
      );
    } else {
      return (
        <p>
          <b>{this.props.title}: </b>
          {serviceTypes[input.value]}
        </p>
      );
    }
  }
}

export default FormSelectServiceType;
