import React from "react";
import { ControlLabel, FormGroup, FormControl, Alert } from "react-bootstrap";
import Select from "react-select";
import WrapperTooltip from "components/WrapperTooltip";
import BasicDisplay from "./BasicDisplay";
import Icon from "react-icons-kit";
import { ic_info } from "react-icons-kit/md/ic_info";
import { Link } from 'react-router-dom'

class FormSelectType extends React.Component {
  render() {
    const {
      input,
      title,
      meta,
      isEditing,
      disabled,
      infoLink,
      customLabelComponent,
    } = this.props;
    const options = this.props.options || [];

    if (isEditing) {
      return (
        <FormGroup validationState={meta.error && "error"}>
          <ControlLabel style={{ display: "flex" }}>
            <WrapperTooltip title={title} />
            {infoLink && (
              <Link
                to={infoLink}
                target="_blank"
                style={{ display: "flex", margin: "0 5px" }}
              >
                <Icon icon={ic_info} />
              </Link>
            )}
            {customLabelComponent && (
              <React.Fragment>{customLabelComponent}</React.Fragment>
            )}
          </ControlLabel>
          <Select
            simpleValue
            clearable={false}
            onChange={input.onChange}
            options={options}
            value={input.value}
            disabled={disabled}
          />
          <FormControl.Feedback />
          {meta.error && <Alert bsStyle="warning">{meta.error}</Alert>}
        </FormGroup>
      );
    } else {
      return (
        <BasicDisplay
          {...this.props}
          display={options.map(item => {
            if (item.value === input.value) {
              return item.label;
            }
          })}
        />
      );
    }
  }
}

export default FormSelectType;
