import React from "react";
import {
  Alert,
  FormGroup,
  ControlLabel,
  FormControl,
  Link,
} from "react-bootstrap";
import BasicDisplay from "./BasicDisplay";

import WrapperTooltip from "components/WrapperTooltip";

class FormText extends React.Component {
  render() {
    if (this.props.tooltipID) {
      var tooltipID = this.props.tooltipID;
    } else {
      var tooltipID = this.props.title;
    }
    if (this.props.isEditing) {
      return (
        <FormGroup validationState={this.props.meta.error && "error"}>
          <ControlLabel>
            <WrapperTooltip title={this.props.title} tooltipID={tooltipID} />
          </ControlLabel>
          <FormControl
            type="text"
            value={this.props.input.value}
            placeholder={this.props.placeholder}
            onChange={this.props.input.onChange}
          />
          <FormControl.Feedback />
          {this.props.meta.error && (
            <Alert bsStyle="warning">{this.props.meta.error}</Alert>
          )}
        </FormGroup>
      );
    } else {
      return <BasicDisplay {...this.props} display={this.props.input.value} />;
    }
  }
}
export default FormText;
