import React from "react";
import { Alert, FormGroup, ControlLabel, FormControl } from "react-bootstrap";
import ReactMarkdown from "react-markdown";
import WrapperTooltip from "components/WrapperTooltip";

import "./FormTextAreaStyle.scss";

class FormTextArea extends React.Component {
  render() {
    const { maxLength, placeholder, input: { value, onChange } } = this.props;
    let inputValue = value;
    let charactersRemaining =
      maxLength - ((inputValue && inputValue.length) || 0);

    if (this.props.tooltipID) {
      var tooltipID = this.props.tooltipID;
    } else {
      var tooltipID = this.props.title;
    }
    if (this.props.isEditing) {
      return (
        <FormGroup validationState={this.props.meta.error && "error"}>
          <ControlLabel>
            <WrapperTooltip title={this.props.title} tooltipID={tooltipID} />
          </ControlLabel>
          <FormControl
            componentClass="textarea"
            value={inputValue}
            placeholder={placeholder}
            onChange={onChange}
            maxLength={maxLength}
          />
          <FormControl.Feedback />
          {maxLength && (
            <span className="text-area__characters-remaining">
              ({charactersRemaining} / {maxLength} characters remaining)
            </span>
          )}
          {this.props.meta.error && (
            <Alert bsStyle="warning">{this.props.meta.error}</Alert>
          )}
        </FormGroup>
      );
    } else {
      return (
        <div>
          <p>
            <b>
              <WrapperTooltip
                title={this.props.title + ":"}
                tooltipID={tooltipID}
              />
            </b>
          </p>
          <ReactMarkdown source={this.props.input.value} />
        </div>
      );
    }
  }
}

export default FormTextArea;
