import FormAttributeSelect from "../components/FormAttributeSelect";
import { connect } from "react-redux";
import { createSelector } from "reselect";
import _ from "lodash";
import {
  formAttributeSelectFetchOptions,
  formAttributeSelectModalToggled,
  formAttributeSelectModalNameChanged,
  formAttributeSelectModalValueChanged,
} from "../modules/form_attribute_select";

const mapStateToProps = (state, ownProps) => {
  const getFilteredModalNameOptions = makeGetFilteredModalNameOptions();
  if (_.has(state.form_attribute_select, ownProps.id)) {
    var thisState = state.form_attribute_select[ownProps.id];
    var modalNameOptions = getFilteredModalNameOptions(thisState, ownProps);
    var allOptions = thisState.allOptions || [];
    var modalEnabled = thisState.modalEnabled || false;

    var modalName = thisState.modalName || "";
    var modalNameEditable = thisState.modalNameEditable;
    var modalValue = thisState.modalValue || "";
    var modalID = thisState.modalID || 0;
    var modalValueOptions = thisState.modalValueOptions || [];
  } else {
    // Some defaults in case this multi selector isn't initialized
    var allOptions = [];
    var modalEnabled = false;
    var modalName = "";
    var modalValue = "";
    var modalID = 0;
    var modalNameEditable = true;
    var modalValueOptions = [];
    var modalNameOptions = [];
  }
  return {
    allOptions: allOptions,
    modalEnabled: modalEnabled,
    modalName: modalName,
    modalValue: modalValue,
    modalNameEditable: modalNameEditable,
    modalID: modalID,
    modalValueOptions: modalValueOptions,
    modalNameOptions: modalNameOptions,
  };
};
export const getModalNameOptions = state => state.modalNameOptions;
export const getCurrentModalName = state => state.modalName;
export const getSelected = (state, props) => props.input.value;
export const getExcluded = (state, props) => props.excludeAttributes || [];

export const makeGetFilteredModalNameOptions = () => {
  return createSelector(
    [getModalNameOptions, getCurrentModalName, getSelected, getExcluded],
    (modalNameOptions, currentModalName, selected, excluded) => {
      if (selected) {
        var selectedNames = selected.map(attr => attr.name);
      } else {
        var selectedNames = [];
      }
      selectedNames.push(...excluded);
      var filteredNameOptions = modalNameOptions;
      if (filteredNameOptions) {
        filteredNameOptions = filteredNameOptions.map(option => {
          option.disabled = selectedNames.includes(option.value);
          return option;
        });
      } else {
        return [];
      }
      if (currentModalName) {
        filteredNameOptions.push({
          label: currentModalName,
          value: currentModalName,
        });
      }
      return filteredNameOptions;
    }
  );
};

const mapDispatchToProps = (dispatch, ownProps) => {
  return {
    fetchOptions: () =>
      dispatch(
        formAttributeSelectFetchOptions(
          ownProps.id,
          ownProps.dataType,
          ownProps.data
        )
      ),
    toggleModal: (bool, id, name, value) => {
      dispatch(
        formAttributeSelectModalToggled(ownProps.id, bool, id, name, value)
      );
    },
    changeModalName: name =>
      dispatch(formAttributeSelectModalNameChanged(ownProps.id, name.value)),
    changeModalValue: value => {
      dispatch(formAttributeSelectModalValueChanged(ownProps.id, value.value));
    },
  };
};

export default connect(mapStateToProps, mapDispatchToProps)(
  FormAttributeSelect
);
