import FormMultiSelect from "../components/FormMultiSelect";
import React from "react";
import { connect } from "react-redux";
import _ from "lodash";
import {
  formMultiSelectFetchOptions,
  formMultiSelectModalToggled,
} from "../modules/form_multi_select";

const mapStateToProps = (state, ownProps) => {
  if (_.has(state.form_multi_select, ownProps.id)) {
    var allOptions = state.form_multi_select[ownProps.id].allOptions || [];
    var modalEnabled =
      state.form_multi_select[ownProps.id].modalEnabled || false;
  } else {
    // Some defaults in case this multi selector isn't initialized
    var allOptions = [];
    var modalEnabled = false;
  }
  return {
    allOptions: allOptions,
    modalEnabled: modalEnabled,
  };
};

const mapDispatchToProps = (dispatch, ownProps) => {
  return {
    fetchOptions: () =>
      dispatch(
        formMultiSelectFetchOptions(
          ownProps.id,
          ownProps.dataType,
          ownProps.optionsQuery,
          ownProps.optionsQueryVars,
          ownProps.selected
        )
      ),
    toggleModal: bool =>
      dispatch(formMultiSelectModalToggled(ownProps.id, bool)),
  };
};

export default connect(mapStateToProps, mapDispatchToProps)(FormMultiSelect);
