// @format
import FormQuerySelect from "../components/FormQuerySelect";
import React from "react";
import { connect } from "react-redux";
import _ from "lodash";
import {
  formQuerySelectModalToggled,
  formQuerySelectQueryDeleted,
  formQuerySelectModalQuerySet,
  formQuerySelectModalTestQuery,
  formQuerySelectModalSetQueryTested,
} from "../modules/form_query_select";

const mapStateToProps = (state, ownProps) => {
  if (_.has(state.form_query_select, ownProps.id)) {
    var modalEnabled =
      state.form_query_select[ownProps.id].modalEnabled || false;
    var modalQuery = state.form_query_select[ownProps.id].modalQuery || {};
    var queryTested = state.form_query_select[ownProps.id].queryTested || false;
    var queryTestSuccess =
      state.form_query_select[ownProps.id].queryTestSuccess || false;
    var queryTestData =
      state.form_query_select[ownProps.id].queryTestData || {};
    var queryTestError =
      state.form_query_select[ownProps.id].queryTestError || null;
  } else {
    // Some defaults in case this multi selector isn't initialized
    var modalEnabled = false;
    var modalQuery = {};
    var queryTested = false;
    var queryTestSuccess = false;
    var queryTestData = {};
    var queryTestError = null;
  }
  return {
    modalEnabled: modalEnabled,
    modalQuery: modalQuery,
    queryTested: queryTested,
    queryTestSuccess: queryTestSuccess,
    queryTestData: queryTestData,
    queryTestError: queryTestError,
  };
};

const mapDispatchToProps = (dispatch, ownProps) => {
  return {
    toggleModal: bool =>
      dispatch(formQuerySelectModalToggled(ownProps.id, bool)),
    setModalQuery: query =>
      dispatch(formQuerySelectModalQuerySet(ownProps.id, query)),
    testQuery: query =>
      dispatch(formQuerySelectModalTestQuery(ownProps.id, query)),
    setQueryTested: bool =>
      dispatch(formQuerySelectModalSetQueryTested(ownProps.id, bool)),
  };
};

export default connect(mapStateToProps, mapDispatchToProps)(FormQuerySelect);
