import FormSelect from "../components/FormSelect";
import React from "react";
import { connect } from "react-redux";
import _ from "lodash";
import { formSelectFetchOptions } from "../modules/form_select";

const mapStateToProps = (state, ownProps) => {
  if (_.has(state.form_select, ownProps.id)) {
    var options = state.form_select[ownProps.id];
  } else {
    var options = [];
  }
  return {
    options: options,
  };
};

const mapDispatchToProps = (dispatch, ownProps) => {
  return {
    fetchOptions: () =>
      dispatch(
        formSelectFetchOptions(
          ownProps.id,
          ownProps.labelKey,
          ownProps.valueKey,
          ownProps.dataType,
          ownProps.query
        )
      ),
  };
};

export default connect(mapStateToProps, mapDispatchToProps)(FormSelect);
