import { connect } from "react-redux";
import _ from "lodash";
import {
  formUserDataSelectFetchOptions,
  formUserDataSelectModalToggled,
  dataTypeChanged,
  descriptionChanged,
} from "../modules/form_user_data_select";
import FormUserDataSelect from "../components/FormUserDataSelect";

const mapStateToProps = (state, ownProps) => {
  // Some defaults in case this multi selector isn't initialized
  let modalEnabled = false;
  let dataType = "";
  let dataTypeOptions = [];
  let selectedDataTypes = [];
  let description = "";

  if (_.has(state.form_user_data_select, ownProps.id)) {
    const thisState = state.form_user_data_select[ownProps.id];
    modalEnabled = thisState.modalEnabled || false;
    dataType = thisState.dataType || "";
    dataTypeOptions = thisState.dataTypeOptions || [];
    selectedDataTypes = thisState.selectedDataTypes || [];
    description = thisState.description || "";
  }

  return {
    modalEnabled,
    dataType,
    dataTypeOptions,
    selectedDataTypes,
    description,
  };
};

const mapDispatchToProps = (dispatch, ownProps) => {
  return {
    fetchOptions: () =>
      dispatch(
        formUserDataSelectFetchOptions(
          ownProps.id,
          ownProps.dataType,
          ownProps.data
        )
      ),
    toggleModal: (enableModal, dataTypeSelected) => {
      ownProps.setFieldValue("custom_tag_description", "");
      dispatch(
        formUserDataSelectModalToggled(
          ownProps.id,
          enableModal,
          dataTypeSelected
        )
      );
    },
    changeUserDataType: dataType =>
      dispatch(dataTypeChanged(ownProps.id, dataType.value)),
    changeDescription: description =>
      dispatch(descriptionChanged(ownProps.id, description.target.value)),
  };
};

export default connect(mapStateToProps, mapDispatchToProps)(FormUserDataSelect);
