import React from "react";
import FormMultiSelect from "./containers/FormMultiSelect";
import FormAttributeSelect from "./containers/FormAttributeSelect";
import FormUserDataSelect from "./containers/FormUserDataSelect";
import { Field } from "redux-form";

function normalizeMultiSelect(val, prevVal) {
  var { action, object, id, rollupKey } = val;
  // Create a new object for state
  var newVal = [];
  // Add all the old values, excluding the
  // one we are removing, if we are indeed removing
  for (var i = 0; i < prevVal.length; i++) {
    if (action === "remove" && prevVal[i].id === id) {
      continue;
    } else if (action === "rollupToggled" && prevVal[i].id === id) {
      let copy = Object.assign({}, prevVal[i]);
      copy[rollupKey] = !prevVal[i][rollupKey];
      newVal.push(copy);
    } else {
      newVal.push(prevVal[i]);
    }
  }
  // If adding, add now
  if (action === "add") {
    newVal.push(object);
  }

  return newVal;
}

function normalizeAttributeSelect(val, prevVal) {
  var { action, attr } = val;
  // Create a new object for state
  var newVal = [];

  if (action === "delete") {
    newVal = prevVal.filter(a => a.value !== attr.value);
    attr.deleted = true;
    newVal.push(attr);
  }

  // If adding, add now
  if (action === "add") {
    newVal = [...prevVal, attr];
  }

  if (action === "edit") {
    newVal = prevVal.filter(a => a.id != attr.id && a.name != attr.name);
    newVal.push(attr);
  }

  return newVal;
}

function normalizeTagSelect(targetTag, previousTags) {
  var { action, attr: tag } = targetTag;
  // Create a new object for state
  let newValue = [];
  previousTags = previousTags || [];

  if (action === "delete") {
    // clear all
    if (tag.id === undefined) {
      newValue = [];
    } else {
      newValue = previousTags.filter(a => a.id !== tag.id);
    }
  }

  if (action === "add") {
    newValue = [...previousTags, tag];
  }

  if (action === "update") {
    newValue = [...tag];
  }

  return newValue;
}

// Wrap the multi-select in a redux-form Field
// before exporting
export class FormMultiSelectField extends React.Component {
  render() {
    const { name, normalizer } = this.props;
    return (
      <Field
        name={name}
        component={FormMultiSelect}
        normalize={normalizer || normalizeMultiSelect}
        {...this.props}
      />
    );
  }
}

// Wrap the multi-select in a redux-form Field
// before exporting
export class FormAttributeSelectField extends React.Component {
  render() {
    return (
      <Field
        name={this.props.name}
        component={FormAttributeSelect}
        normalize={normalizeAttributeSelect}
        {...this.props}
      />
    );
  }
}

export class FormUserDataSelectField extends React.Component {
  render() {
    return (
      <Field
        name={this.props.name}
        component={FormUserDataSelect}
        normalize={normalizeTagSelect}
        {...this.props}
      />
    );
  }
}
