import gql from "graphql-tag";
import _ from "lodash";
import { GraphqlQueryRaw, GraphqlMutation } from "lib/graphql";

// ------------------------------------
// Constants
// ------------------------------------
export const FORM_ATTRIBUTE_SELECT_FETCH_OPTIONS_SUCCESS =
  "FORM_ATTRIBUTE_SELECT_FETCH_OPTIONS_SUCCESS";
export const FORM_ATTRIBUTE_SELECT_MODAL_TOGGLED =
  "FORM_ATTRIBUTE_SELECT_MODAL_TOGGLED";
export const FORM_ATTRIBUTE_SELECT_MODAL_NAME_CHANGED =
  "FORM_ATTRIBUTE_SELECT_MODAL_NAME_CHANGED";
export const FORM_ATTRIBUTE_SELECT_MODAL_VALUE_CHANGED =
  "FORM_ATTRIBUTE_SELECT_MODAL_VALUE_CHANGED";

// ------------------------------------
// Actions
// ------------------------------------
export function formAttributeSelectFetchOptionsSuccess(id, options, selected) {
  return {
    type: FORM_ATTRIBUTE_SELECT_FETCH_OPTIONS_SUCCESS,
    options: options,
    id: id,
  };
}

// Fetches options, initializing both options already selected,
// and options in the pool to be chosen from
export function formAttributeSelectFetchOptions(id, type, selected) {
  var optQuery = gql`
    query Attributes {
      attributes(unique: true) {
        name
        value
      }
    }
  `;
  var optQueryVars = {};
  return dispatch => {
    GraphqlQueryRaw(optQuery, optQueryVars).then(data => {
      var options = _.get(data, type + "s");
      dispatch(formAttributeSelectFetchOptionsSuccess(id, options));
    });
  };
}

export function formAttributeSelectModalToggled(
  id,
  modalEnabled,
  modalID,
  name,
  value
) {
  var modalNameEditable = false;
  if (typeof modalID !== "undefined" && modalID != "0") {
    modalNameEditable = true;
  }
  return {
    type: FORM_ATTRIBUTE_SELECT_MODAL_TOGGLED,
    modalEnabled: modalEnabled,
    id: id,
    modalID: modalID,
    modalName: name,
    modalNameEditable: modalNameEditable,
    modalValue: value,
  };
}
export function formAttributeSelectModalNameChanged(id, name) {
  return {
    type: FORM_ATTRIBUTE_SELECT_MODAL_NAME_CHANGED,
    id: id,
    modalName: name,
  };
}
export function formAttributeSelectModalValueChanged(id, value) {
  return {
    type: FORM_ATTRIBUTE_SELECT_MODAL_VALUE_CHANGED,
    id: id,
    modalValue: value,
  };
}

// ------------------------------------
// Reducers
// ------------------------------------
export function formAttributeSelect(state = {}, action) {
  switch (action.type) {
    case FORM_ATTRIBUTE_SELECT_FETCH_OPTIONS_SUCCESS:
      var optionMap = {};
      var opts = action.options || [];
      var modalNameOptions = [];
      // var selected = state[action.id].selectedOptions.map(opt => opt.name);
      for (var i = 0; i < opts.length; i++) {
        if (optionMap[opts[i].name]) {
          optionMap[opts[i].name].push({
            value: opts[i].value,
            label: opts[i].value,
          });
        } else {
          modalNameOptions.push({
            value: opts[i].name,
            label: opts[i].name,
            // disabled: selected.includes(opts[i].name),
          });
          optionMap[opts[i].name] = [
            {
              value: opts[i].value,
              label: opts[i].value,
            },
          ];
        }
      }
      return {
        ...state,
        [action.id]: {
          ...state[action.id],
          allOptions: action.options,
          optionMap: optionMap,
          modalNameOptions: modalNameOptions,
        },
      };
    case FORM_ATTRIBUTE_SELECT_MODAL_TOGGLED:
      var valueOptions = [];
      if (
        state[action.id] &&
        state[action.id].optionMap &&
        state[action.id].optionMap[action.modalName]
      ) {
        valueOptions = state[action.id].optionMap[action.modalName];
      } else {
        valueOptions = [
          {
            label: "Chose a name for options",
            value: "NOT VALID",
            disabled: true,
          },
        ];
      }
      return {
        ...state,
        [action.id]: {
          ...state[action.id],
          modalEnabled: action.modalEnabled,
          modalID: action.modalID,
          modalName: action.modalName,
          modalValue: action.modalValue,
          modalNameEditable: action.modalNameEditable,
          modalValueOptions: valueOptions,
        },
      };
    case FORM_ATTRIBUTE_SELECT_MODAL_NAME_CHANGED:
      var valueOptions = [];
      if (
        state[action.id].optionMap &&
        state[action.id].optionMap[action.modalName]
      ) {
        state[action.id].optionMap;
        valueOptions = state[action.id].optionMap[action.modalName];
      } else {
        valueOptions = [
          {
            label: "Chose a name that currently exists for options",
            value: "NOT VALID",
            disabled: true,
          },
        ];
      }
      return {
        ...state,
        [action.id]: {
          ...state[action.id],
          modalName: action.modalName,
          modalValueOptions: valueOptions,
        },
      };
    case FORM_ATTRIBUTE_SELECT_MODAL_VALUE_CHANGED:
      return {
        ...state,
        [action.id]: {
          ...state[action.id],
          modalValue: action.modalValue,
        },
      };
    default:
      return state;
  }
}

export default formAttributeSelect;
