import _ from "lodash";
import { GraphqlQueryRaw } from "lib/graphql";

// ------------------------------------
// Constants
// ------------------------------------
export const FORM_MUTLI_SELECT_FETCH_OPTIONS =
  "FORM_MULTI_SELECT_FETCH_OPTIONS";
export const FORM_MULTI_SELECT_FETCH_OPTIONS_SUCCESS =
  "FORM_MULTI_SELECT_FETCH_OPTIONS_SUCCESS";
export const FORM_MULTI_SELECT_MODAL_TOGGLED =
  "FORM_MULTI_SELECT_MODAL_TOGGLED";

// ------------------------------------
// Actions
// ------------------------------------
export function formMultiSelectFetchOptionsSuccess(id, options) {
  return {
    type: FORM_MULTI_SELECT_FETCH_OPTIONS_SUCCESS,
    options: options,
    id: id,
  };
}
// Fetches options, initializing both options already selected,
// and options in the pool to be chosen from
export function formMultiSelectFetchOptions(
  id,
  type,
  optQuery,
  optQueryVars,
  selected
) {
  return dispatch => {
    GraphqlQueryRaw(optQuery, optQueryVars).then(data => {
      var options = _.get(data, type + "s");
      dispatch(formMultiSelectFetchOptionsSuccess(id, options));
    });
  };
}
export function formMultiSelectModalToggled(id, modalEnabled) {
  return {
    type: FORM_MULTI_SELECT_MODAL_TOGGLED,
    modalEnabled: modalEnabled,
    id: id,
  };
}
// ------------------------------------
// Reducers
// ------------------------------------
export function formMultiSelect(state = {}, action) {
  switch (action.type) {
    case FORM_MULTI_SELECT_FETCH_OPTIONS_SUCCESS:
      return {
        ...state,
        [action.id]: {
          ...state[action.id],
          allOptions: action.options,
        },
      };
    // Note that when an option is selected,
    // we also tear down the modal...

    case FORM_MULTI_SELECT_MODAL_TOGGLED:
      return {
        ...state,
        [action.id]: {
          ...state[action.id],
          modalEnabled: action.modalEnabled,
        },
      };
    default:
      return state;
  }
}

export default formMultiSelect;
