import { combineReducers } from "redux";
import _ from "lodash";
import { GraphqlQueryRaw } from "lib/graphql";

// ------------------------------------
// Constants
// ------------------------------------
export const FORM_SELECT_FETCH_OPTIONS = "FORM_SELECT_FETCH_OPTIONS";
export const FORM_SELECT_FETCH_OPTIONS_SUCCESS =
  "FORM_SELECT_FETCH_OPTIONS_SUCCESS";

// ------------------------------------
// Actions
// ------------------------------------
export function formSelectFetchOptionsSuccess(id, options) {
  return {
    type: FORM_SELECT_FETCH_OPTIONS_SUCCESS,
    options: options,
    id: id,
  };
}
export function formSelectFetchOptions(id, label, value, type, query) {
  return dispatch => {
    GraphqlQueryRaw(query, {}).then(data => {
      if (_.has(data, type)) {
        var options = _.get(data, type).map(function(opt) {
          return {
            label: _.get(opt, label),
            value: _.get(opt, value),
          };
        });
        dispatch(formSelectFetchOptionsSuccess(id, options));
      }
    });
  };
}
// ------------------------------------
// Reducers
// ------------------------------------
export function formSelectOptions(state = {}, action) {
  return {
    ...state,
    [action.id]: action.options,
  };
}

export default formSelectOptions;
