import gql from "graphql-tag";
import { GraphqlQueryRaw } from "lib/graphql";

// ------------------------------------
// Constants
// ------------------------------------
export const FORM_USER_DATA_SELECT_FETCH_OPTIONS_SUCCESS =
  "FORM_USER_DATA_SELECT_FETCH_OPTIONS_SUCCESS";
export const FORM_USER_DATA_SELECT_MODAL_TOGGLED =
  "FORM_USER_DATA_SELECT_MODAL_TOGGLED";
export const FORM_DATA_TYPE_CHANGED = "FORM_DATA_TYPE_CHANGED";
export const FORM_DESCRIPTION_CHANGED = "FORM_DESCRIPTION_CHANGED";

// ------------------------------------
// Actions
// ------------------------------------
export function formUserDataSelectFetchOptionsSuccess(id, dataTypeOptions) {
  return {
    type: FORM_USER_DATA_SELECT_FETCH_OPTIONS_SUCCESS,
    dataTypeOptions,
    id,
  };
}

// Fetches options, initializing both options already selected,
// and options in the pool to be chosen from
export function formUserDataSelectFetchOptions(id) {
  var optQuery = gql`
    query {
      defaultUserDataTypes {
        id
        label
        parent_type {
          id
        }
      }
    }
  `;
  var optQueryVars = {};
  return dispatch => {
    GraphqlQueryRaw(optQuery, optQueryVars).then(data => {
      dispatch(
        formUserDataSelectFetchOptionsSuccess(id, data.defaultUserDataTypes)
      );
    });
  };
}

export function formUserDataSelectModalToggled(id, modalEnabled, dataType) {
  return {
    type: FORM_USER_DATA_SELECT_MODAL_TOGGLED,
    modalEnabled,
    id,
    dataType,
  };
}

export function dataTypeChanged(id, dataType) {
  return {
    type: FORM_DATA_TYPE_CHANGED,
    id,
    dataType,
  };
}

export function descriptionChanged(id, description) {
  return {
    type: FORM_DESCRIPTION_CHANGED,
    id,
    description,
  };
}

// ------------------------------------
// Reducers
// ------------------------------------
export function formUserDataSelect(state = {}, action) {
  switch (action.type) {
    case FORM_USER_DATA_SELECT_FETCH_OPTIONS_SUCCESS:
      return {
        ...state,
        [action.id]: {
          ...state[action.id],
          dataTypeOptions: action.dataTypeOptions,
        },
      };
    case FORM_USER_DATA_SELECT_MODAL_TOGGLED: {
      return {
        ...state,
        [action.id]: {
          ...state[action.id],
          modalEnabled: action.modalEnabled,
          dataType: action.dataType,
          description: "",
        },
      };
    }
    case FORM_DATA_TYPE_CHANGED: {
      return {
        ...state,
        [action.id]: {
          ...state[action.id],
          dataType: action.dataType,
        },
      };
    }
    case FORM_DESCRIPTION_CHANGED: {
      return {
        ...state,
        [action.id]: {
          ...state[action.id],
          description: action.description,
        },
      };
    }
    default:
      return state;
  }
}

export default formUserDataSelect;
