import React from "react";
import PropTypes from "prop-types";
import { Button, Modal, Panel, Table } from "react-bootstrap";
import moment from "moment";

import { DiffPatcher } from "jsondiffpatch/src/diffpatcher";
import { HtmlFormatter } from "jsondiffpatch/src/formatters/html";
import "jsondiffpatch/public/formatters-styles/html.css";
import "jsondiffpatch/public/formatters-styles/annotated.css";

import _ from "lodash";

export function jsonPretty(s) {
  if (s == "") {
    return "None";
  }
  try {
    return JSON.stringify(JSON.parse(s), null, 2);
  } catch (e) {
    return s;
  }
}

class LogRecord extends React.Component {
  render() {
    let content;

    var prestyle = {
      width: "500px",
      overflow: "auto",
    };

    var createdString = moment(this.props.log.created).format(
      "YYYY-MM-DD HH:mm:ss"
    );

    var htmlDiff;
    if (this.props.log.before && this.props.log.before) {
      const patcher = new DiffPatcher();
      const formatter = new HtmlFormatter();
      var left = JSON.parse(this.props.log.before);
      var right = JSON.parse(this.props.log.after);
      var delta = patcher.diff(left, right);
      htmlDiff = formatter.format(delta) || "No change";
    }

    content = (
      <Panel header="Log Entry">
        <p>
          <b>{_.capitalize(this.props.log.item_type)}:</b>
          {this.props.log.item_label}
        </p>
        <p>
          <b>Author:</b> {this.props.log.author}
        </p>
        <p>
          <b>Action:</b> {this.props.log.action}
        </p>
        <p>
          <b>Time:</b>
          {createdString}
        </p>
        {htmlDiff && (
          <p>
            <b>Changes:</b>
            <div dangerouslySetInnerHTML={{ __html: htmlDiff }} />
          </p>
        )}
        <p>
          <b>Before:</b>
          <pre style={prestyle}>{jsonPretty(this.props.log.before)}</pre>
        </p>
        <p>
          <b>After:</b>
          <pre style={prestyle}>{jsonPretty(this.props.log.after)}</pre>
        </p>
      </Panel>
    );
    return content;
  }
}

export default LogRecord;
