import React from "react";
import PropTypes from "prop-types";
import { Button, Modal, Panel, Table } from "react-bootstrap";
import moment from "moment";
import LogRecord from "./LogRecord";

class LogRecordList extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      modalVisible: false,
      modalLog: null,
    };
  }
  showModal(log) {
    this.setState({
      modalVisible: true,
      modalLog: log,
    });
  }
  hideModal() {
    this.setState({
      modalVisible: false,
      modalLog: null,
    });
  }
  render() {
    let content;
    const { modalVisible } = this.state;

    content = (
      <Panel header="Most recent changes:">
        <Table>
          <thead>
            <tr>
              <th>LogID</th>
              <th>Change Time</th>
              <th>Author</th>
              <th>Action</th>
              <th>Details</th>
            </tr>
          </thead>
          <tbody>
            {this.props.logs &&
              this.props.logs.map(l => {
                var createdString = moment(l.created).format(
                  "YYYY-MM-DD HH:mm:ss"
                );
                return (
                  <tr key={l.id}>
                    <td>{l.id}</td>
                    <td>{createdString}</td>
                    <td>{l.author}</td>
                    <td>{l.action}</td>
                    <td>
                      <Button bsSize="small" onClick={() => this.showModal(l)}>
                        Details
                      </Button>
                    </td>
                  </tr>
                );
              })}
          </tbody>
        </Table>
        <Modal show={modalVisible} onHide={() => this.hideModal()}>
          {modalVisible && <LogRecord log={this.state.modalLog} />}
        </Modal>
      </Panel>
    );

    return content;
  }
}

export default LogRecordList;
