import React from "react";
import PropTypes from "prop-types";
import moment from "moment";
import { Row, Button, ButtonGroup } from "react-bootstrap";

class RecentTimeChooser extends React.Component {
  render() {
    const { timeBegin, timeEnd, timeRangeCallback } = this.props;

    function setTimeRange(range) {
      return function() {
        timeRangeCallback([
          moment()
            .subtract(range, "seconds")
            .unix(),
          moment().unix(),
        ]);
      };
    }

    return (
      <ButtonGroup className="pull-right">
        <Button onClick={setTimeRange(3600)}>Last Hour</Button>
        <Button onClick={setTimeRange(21600)}>Last 6 Hours</Button>
        <Button onClick={setTimeRange(86400)}>Last Day</Button>
        <Button onClick={setTimeRange(604800)}>Last Week</Button>
      </ButtonGroup>
    );
  }
}

RecentTimeChooser.propTypes = {
  timeBegin: PropTypes.number,
  timeEnd: PropTypes.number,
  timeRangeCallback: PropTypes.func.isRequired,
};

export default RecentTimeChooser;
