Service Table
===

This component can be used across the application to render rich tables displaying formatted columns of information,
as defined by the upstream caller.

Usage
---

```
import ServiceTable from '<relative_path>/common/ServiceTable/containers/ServiceContainer'

const MyComponent = ({myData, columns, ...otherProps}) => {
  return (
    <ServiceTable
      tableId="uniqueTableSomewhereInTinker"
      data={myData}
      dataType="service" // "component", "metric", etc...
      columns={columns}
      enablePagination={true}
      enableFilters={false}
      defaultItemsPerPage={50}
    />
  )
}
```
Arguments:
* `tableId` - Some unique table name ID. Used to namespace state stored about this table (so you can do things like render multiple tables on one page)
* `data` - The data to render in the table.  If the data passed into the table changes, the table will re-render
* `dataType` - The resource type the table is dealing with; supports types that have data in `hms-esk`, so things like `component`, `service` and `metric`; used to template the API requests to fetch `hms-esk` data
* `columns` - Column schema definition (see below); used to define the columns and structure of the table
* `enablePagination` - Boolean for whether or not to show a page selector and items per page dropdown; will show all elements in the table with no paging options if false (default: `true`)
* `enableFilters` - Boolean for whether or not to show a `Filters` heading; if you don't have any configured filters, set this to `false` (default: `true`)
* `defaultItemsPerPage` - Number of items to display per page (default: `10`)

Column Schema
--- 

In your component, define a column schema.  It will look something like this:
```
var columns = [
    {
      title: "Name",
      key: "name",
      filter: "text",
      formatter: function(service) {
        var l = Link;
        var toService = "/services/"+service.id;
        return {
          display: <Link to={toService}>{service.name}</Link>,
          value: service.name
        }
      }
    },
    {
      title: "Team",
      filter: "select",
      key: "team.name"
    },
    {
      title: "Business Unit",
      filter: "select",
      key: "team.org.name"
    }
  ]
  ```
The column definition should be an array of objects with the following possible attributes:
* `title` - The title of the column, to be displayed as the header
* `key` - The unique identifier of this column; for data passed into the table, _you should be able to call _`_.has(dataItem, key)`! The value of the lookup should be a string, and that string will be used as the basis for sorting and filtering.
* `filter` - If not null, will create a filter on this column; use `"select"` for a dropdown filter, and `"text"` for a typing text search filter
* `formatter` - Takes a function which should return a JS object with keys `display` (a JSX structure for rendering the column cell) and `value` (a string used for filtering and sorting, the canonical 'value' of the cell); used to render formatted data into a column, making it great for things like rendering columns as links, etc; if absent, renders the value of the `key` if no `formatter` specified (`_.get(item, column.key)`)

Out of the Box Features
---
* Sorting
* Filters, both text and dropdown
* Modals that drilldown into the `Today` and `Week To Date` numbers on-click (work in progress, can be improved)
* Pagination

TODO
---
* Allow disabling filters, pagination, and sorting via flags (that default to true)
