// ------------------------------------
// Constants
// ------------------------------------
export const TABLE_INIT = "TABLE_INIT";
export const TABLE_CURRENT_PAGE = "TABLE_CURRENT_PAGE";
export const TABLE_ITEMS_PER_PAGE = "TABLE_ITEMS_PER_PAGE";
export const TABLE_FILTER_DATA = "TABLE_FILTER_DATA";
export const TABLE_SORTING = "TABLE_SORTING";
export const TABLE_SERVICE_SHOW_FILTERS =
  "TABLE_SERVICE_SHOW_FILTERS";

// ------------------------------------
// Actions
// ------------------------------------
export function tableInitAction(t, filters, sorting, itemsPerPage) {
  return {
    type: TABLE_INIT,
    table: t,
    filters: filters,
    sorting: sorting,
    itemsPerPage: itemsPerPage,
    modal: {
      enabled: false,
      id: null,
      window: null,
    },
    modalData: {
      info: null,
      data: null,
    },
  };
}

export function tableCurrentPageAction(t, i) {
  return {
    type: TABLE_CURRENT_PAGE,
    table: t,
    currentPage: i,
  };
}

export function tableItemsPerPageAction(t, i) {
  return {
    type: TABLE_ITEMS_PER_PAGE,
    table: t,
    itemsPerPage: i,
  };
}

export function tableFiltersAction(t, key, value) {
  return {
    type: TABLE_FILTER_DATA,
    table: t,
    filterKey: key,
    filterValue: value,
  };
}

export function tableSortingAction(t, key, order) {
  return {
    type: TABLE_SORTING,
    table: t,
    sortKey: key,
    sortOrder: order,
  };
}

export function tableShowFiltersAction(t, bool) {
  return {
    type: TABLE_SERVICE_SHOW_FILTERS,
    table: t,
    showFilters: bool,
  };
}

// ------------------------------------
// Reducers
// ------------------------------------
const initialTableData = {};

export function tableData(state = initialTableData, action) {
  switch (action.type) {
    // initialize table state for this particular table (sharded on action.table)
    case TABLE_INIT:
      return {
        ...state,
        [action.table]: {
          filters: action.filters,
          pagination: {
            itemsPerPage: action.itemsPerPage,
            currentPage: 1,
          },
          sorting: action.sorting,
          modal: {
            enabled: false,
            window: null,
            id: null,
          },
        },
      };
    case TABLE_FILTER_DATA:
      return {
        ...state,
        [action.table]: {
          ...state[action.table],
          filters: {
            ...state[action.table].filters,
            [action.filterKey]: {
              ...state[action.table].filters[action.filterKey],
              value: action.filterValue,
            },
          },
          pagination: {
            ...state[action.table].pagination,
            currentPage: 1,
          },
        },
      };
    case TABLE_ITEMS_PER_PAGE:
      return {
        ...state,
        [action.table]: {
          ...state[action.table],
          pagination: {
            currentPage: 1,
            itemsPerPage: action.itemsPerPage,
          },
        },
      };
    case TABLE_CURRENT_PAGE:
      return {
        ...state,
        [action.table]: {
          ...state[action.table],
          pagination: {
            ...state[action.table].pagination,
            currentPage: action.currentPage,
          },
        },
      };
    case TABLE_SORTING:
      // when we change the sort order, set the sort portion of
      // the state object to the right values
      var currentKey = state[action.table].sorting.key;
      var currentOrder = state[action.table].sorting.order;
      var newKey = action.sortKey;
      var newSortData = {};
      // if the sort key isnt changing, flip the order
      if (newKey === currentKey) {
        if (currentOrder === "asc") {
          var newOrder = "desc";
        } else {
          var newOrder = "asc";
        }
      } else {
        var newOrder = "desc";
      }
      return {
        ...state,
        [action.table]: {
          ...state[action.table],
          sorting: {
            key: newKey,
            order: newOrder,
          },
        },
      };
    case TABLE_SERVICE_SHOW_FILTERS:
      return {
        ...state,
        [action.table]: {
          ...state[action.table],
          showFilters: action.showFilters,
        },
      };
    default:
      return state;
  }
}

export default tableData;
