import React from "react";
import FormSelect from "common/FormFields/containers/FormSelect";
import PropTypes from "prop-types";
import UserView from "./UserView/UserView";
import { getUserDisplayName } from "./Util";
import { Field } from "redux-form";
import { toEmployeeEmail } from "lib/formatters";
import gql from "graphql-tag";

// cn is full name
const employeesOptionsQuery = gql`
  query UserOptions {
    users {
      cn
      preferred_name
      inactive
      employee_number
      status
      error
    }
  }
`;

class UserSelect extends React.Component {
  render() {
    const { isEditing, reduxPath, user, title, onChange, showIcon, showLabel, clearable } = this.props;
    let userName = "Unknown",
      additionalOwnerOptions = [],
      userLink = null;

    if (user !== undefined && user !== null) {
      const userID = user.id;

      if (user.status === "active") {
        userName = getUserDisplayName(user);
        userLink = toEmployeeEmail(user.uid);
      } else if (user.status === "missing") {
        userName = `Employee ID #${userID} (missing in LDAP)`;
      } else if (user.status === "error") {
        userName = `Employee ID #${userID} (error: ${user.error})`;
      }

      additionalOwnerOptions = [{ label: userName, value: userID }];
    }

    if (isEditing) {
      return (
        <Field
          name={reduxPath}
          component={FormSelect}
          link={userLink}
          title={title}
          labelKey="preferred_name"
          valueKey="employee_number"
          dataType="users"
          query={employeesOptionsQuery}
          id="user"
          isEditing={isEditing}
          currentValue={userName}
          additionalOptions={additionalOwnerOptions}
          onChange={onChange}
          clearable={clearable}
        />
      );
    } else {
      return <UserView user={user} title={title} showIcon={showIcon} showLabel={showLabel} />;
    }
  }
}

UserSelect.propTypes = {
  isEditing: PropTypes.bool,
  reduxPath: PropTypes.string,
  user: PropTypes.object,
  showIcon: PropTypes.bool,
  showLabel: PropTypes.bool,
};

export default UserSelect;
