import React from "react";
import { Popover, OverlayTrigger } from "react-bootstrap";
import { toEmployeeEmail } from "lib/formatters";
import PropTypes from "prop-types";
import { Query } from "react-apollo";
import gql from "graphql-tag";
import { LoadingSpinner } from "../../../components/LoadingSpinner";
import ErrorDisplay from "../../../components/ErrorDisplay";

const managersForUserQuery = gql `
  query managers($user_id: ID!) {
    managers(user_id: $user_id) {
      user_id
      preferred_name
    }
}
`

export const ManagersView = ({ user_id }) => (
  <Query query={managersForUserQuery} variables={{ user_id }}>
    {({ loading, error, data}) => {
      if (loading) {
        return <LoadingSpinner />
      }
      if (error) {
        return <p>Failed to retrieve management hierarchy!</p>
      }
      let managers = data.managers;
      if (!managers || managers === undefined || managers.length === 0){
        return <p>Could not find managers in management hierarchy!</p>
      }
      var hierarchy = [];
      for (let manager of managers) {
        hierarchy.push(manager.preferred_name)
      }
      hierarchy.reverse();
      const listItems = hierarchy.map((manager) =>
        <li key={manager}>{manager}</li>
      );
      return <ul>{listItems}</ul>
    }}
  </Query>
)


ManagersView.propTypes = {
  user_id: PropTypes.string.isRequired,
  loading: PropTypes.bool,
  error: PropTypes.object,
  managers: PropTypes.array,
}

class ManagerInfoPopover extends React.Component {
  render() {
    const { id, trigger, user_id } = this.props;
    if (user_id === undefined) {
      return;
    }
    let popover = (
      <Popover
        className="user-info-popover"
        id={"popover-" + id}
        title={"Management Hierarchy"}
      >
        <ol className="user-list">
          <li key="1">
            <ManagersView user_id={user_id}/>
          </li>
        </ol>
      </Popover>
    );
    return (
      <OverlayTrigger
        rootClose
        trigger="click"
        placement="right"
        overlay={popover}
      >
        {trigger}
      </OverlayTrigger>
    );
  }
}

ManagerInfoPopover.propTypes = {
  trigger: PropTypes.object,
  id: PropTypes.string,
  user_id: PropTypes.string,
};

export default ManagerInfoPopover;
