import React from "react";
import { Popover, OverlayTrigger } from "react-bootstrap";
import Icon from "react-icons-kit";
import { book } from "react-icons-kit/fa/book";
import { envelope } from "react-icons-kit/fa/envelope";
import { mapMarker } from "react-icons-kit/fa/mapMarker";
import { phone } from "react-icons-kit/icomoon/phone";
import { slack } from 'react-icons-kit/fa/slack';
import { tree } from "react-icons-kit/icomoon/tree";
import { toEmployeeEmail } from "lib/formatters";
import PropTypes from "prop-types";
import { getUserDisplayName } from '../Util';

import UserInfoStyle from "./UserInfoStyle.scss";

class UserInfoPopover extends React.Component {
  render() {
    const { id, trigger, user } = this.props;
    if (user === undefined) {
      return;
    }
    let manager = "";
    if (user.manager) {
      const managerRegex = /cn=([-\w ]*)([\(\) \w]*)?,/g;
      let regResult = managerRegex.exec(user.manager);
      if (regResult !== null && regResult.length > 1) {
        manager = regResult[1];
      }
    }
    let departmentPhonetool =
      "https://phonetool.amazon.com/search?filter_type=Department+name&query=" +
      user.department;

    let userSlack = "unknown";
    if (user.slack) {
          userSlack = <a target="_blank" href={"https://twitch.slack.com/app_redirect?channel=" + user.slack.id}>{user.slack.name}</a>;
    }

    let popover = (
      <Popover
        className="user-info-popover"
        id={"popover-" + id}
        title={getUserDisplayName(user)}
      >
        <ol className="user-list">
          <li key="1">
            <Icon icon={mapMarker} />
            <span>{user.building_name}</span>
          </li>
          <li key="2">
            <Icon icon={envelope} />
            <span>
              <a target="_blank" href={toEmployeeEmail(user.uid)}>
                {user.uid + "@twitch.tv"}
              </a>
            </span>
          </li>
          <li key="3">
            <Icon icon={book} />
            <span>
              <a target="_blank" href={departmentPhonetool}>
                *{user.department}
              </a>
            </span>
          </li>
          <li key="4">
            <Icon icon={tree} />
            <span>{manager}</span>
          </li>
          <li key="5">
            <Icon icon={phone} />
            <span>
              <a
                target="_blank"
                href={"https://phonetool.amazon.com/users/" + user.amazon_uid}
              >
                *Go to Phonetool
              </a>
            </span>
          </li>
          <li key="6">
            <Icon icon={slack} />
            <span>{userSlack}</span>
          </li>
          <small>*Must be on WPA2 to access Phonetool</small>
        </ol>
      </Popover>
    );
    return (
      <OverlayTrigger
        rootClose
        trigger="click"
        placement="right"
        overlay={popover}
      >
        {trigger}
      </OverlayTrigger>
    );
  }
}

UserInfoPopover.propTypes = {
  trigger: PropTypes.object,
  id: PropTypes.string,
  user: PropTypes.object,
};

export default UserInfoPopover;
