import React from "react";
import PropTypes from "prop-types";
import WrapperTooltip from "components/WrapperTooltip";
import { info } from "react-icons-kit/icomoon/info";
import Icon from "react-icons-kit";
import UserinfoPopover from "./UserInfoPopover";
import { getUserDisplayName } from '../Util';

import UserInfoStyle from "./UserInfoStyle.scss";

class UserView extends React.Component {
  render() {
    const { id, title, user, showLabel=true, showIcon=true} = this.props;
    let userName = "Unknown";
    const userDefined = user !== undefined && user !== null;

    if (userDefined) {
      userName = getUserDisplayName(user);
    }
    let userValue = userName;

    if (userDefined && showIcon) {
      userValue = (
        <a target="_blank">
          {userName} {<Icon className="user-info-icon" icon={info} />}
        </a>
      );
      userValue = <UserinfoPopover id={id} user={user} trigger={userValue} />;
    }

    let label = null;
    if (showLabel) {
      label =  <b>
        <WrapperTooltip title={title && title + ": "} tooltipID={title} />
      </b>
    }

    return (
      <div className={"user-view"}>
        {label}
        {userValue}
      </div>
    );
  }
}

UserView.propTypes = {
  user: PropTypes.object,
  showLabel: PropTypes.bool,
  showIcon: PropTypes.bool,
  id: PropTypes.string,
  title: PropTypes.string,
};

export default UserView;
