// @format
import { combineReducers } from "redux";
import _ from "lodash";
import {
  REQUEST_SERVICE,
  RECEIVE_SERVICE,
  RECEIVE_SERVICES,
  DELETE_SERVICE_SUCCESS,
  REQUEST_SERVICES,
} from "./actions";

//
// Reducers
//

function service(
  state = {
    isFetching: false,
    service: undefined,
  },
  action,
  serviceData
) {
  switch (action.type) {
    case REQUEST_SERVICE:
      return {
        ...state,
        isFetching: true,
      };
    case RECEIVE_SERVICES:
    case RECEIVE_SERVICE: {
      return {
        ...state,
        isFetching: false,
        isError: !!action.status.error,
        service: serviceData,
        status: action.status,
        receivedAt: action.receivedAt,
        detailed: action.detailed,
      };
    }
  }
}

function servicesByID(state = {
  isFetching: false
}, action) {
  switch (action.type) {
    case RECEIVE_SERVICE:
    case REQUEST_SERVICE:
      return {
        ...state,
        [action.serviceID]: service(
          state[action.serviceID],
          action,
          action.service
        ),
      };
    case REQUEST_SERVICES:
      return {
        ...state,
        isFetching: true,
      }
    case RECEIVE_SERVICES:
      // start state with set of services already in state
      let sByID = {
        ...state,
      };
      if (action.status && action.status.error) {
        sByID.hasErrored = true;
        sByID.error = action.status.error;
        return sByID
      }
      // for each service received, add/update state for it
      for (var i = 0; i < action.services.length; i++) {
        let s = action.services[i];
        sByID[s.id] = service(_.get(state, s.id, {}), action, s);
      }
      sByID.isFetching = false;
      return sByID;
    case DELETE_SERVICE_SUCCESS:
      var sByID = {
        ...state,
      };
      // Remove the service id.
      delete sByID[action.serviceID];
      return sByID;
    default:
      return state;
  }
}

const goracleReducers = combineReducers({
  servicesByID,
});

export default goracleReducers;
