// @format
import React from "react";
import {Button, Col, Modal, Row} from "react-bootstrap";

export class Actions extends React.Component {
  constructor(props) {
    super(props);
    this.state = {modalEnabled: false};
  }

  render() {
    // handleSubmit is provided by ReduxForm
    const {valid, handleSubmit, reset, toggleEditing, isEditing} = this.props;
    var toggleModal = bool => {
      this.setState(previousState => {
        return {modalEnabled: bool};
      });
    };
    var onSubmit = data => {
      this.props.update(data);
    };
    return (
      <Row>
        <Col md={4}>
          {this.props.isEditing && (
            <div>
              <Button
                bsStyle="primary"
                disabled={!valid}
                onClick={handleSubmit(onSubmit)}
              >
                Save
              </Button>
              <Button
                onClick={() => {
                  reset();
                  toggleEditing(false);
                }}
              >
                Cancel
              </Button>
            </div>
          )}
          {!isEditing && (
            <span>
              <Button bsStyle="primary" onClick={() => toggleEditing(true)}>
                Edit
              </Button>
              {this.props.delete && (
                <Button
                  bsStyle="danger"
                  onClick={() => {
                    toggleModal(true);
                  }}
                >
                  Delete
                </Button>
              )}
            </span>
          )}
        </Col>
        <Modal
          bsSize="lg"
          show={this.state.modalEnabled}
          onHide={() => toggleModal(false)}
        >
          <Modal.Header closeButton>
            <Modal.Title>Confirm Delete</Modal.Title>
          </Modal.Header>
          <Modal.Body>Are you sure you want to delete this?</Modal.Body>

          <Modal.Footer>
            <Button
              onClick={() => {
                toggleModal(false);
              }}
              bsStyle="primary"
            >
              Cancel
            </Button>
            <Button
              onClick={() => {
                this.props.delete();
              }}
              bsStyle="danger"
            >
              Delete
            </Button>
          </Modal.Footer>
        </Modal>
      </Row>
    );
  }
}

export default Actions;
