// @format
import React from "react";
import {Redirect, Route} from "react-router-dom";
import {ConnectedRouter} from "react-router-redux";
import {Provider} from "react-redux";
import {ApolloProvider} from "react-apollo";
import PropTypes from "prop-types";
import ReactGA from "react-ga";
import {RouterToUrlQuery} from "react-url-query";
import {graphqlClient} from "../lib/graphql";
import CoreLayout from "../layouts/PageLayout/PageLayout";
import ErrorModal from "../common/ErrorHandling/ErrorModal";
import ServiceList from "../routes/Services/containers/ServiceListContainer";
import ServiceView from "../routes/Services/containers/ServiceViewContainer";
import ServiceOwnerView from "../routes/ServiceOwners/ServiceOwnerPage";
import LogReportsPage from "../routes/Logs/LogReportsPage";
import LoginComponent from "../routes/Login/LoginComponent";
import LogoutComponent from "../routes/Login/LogoutComponent";
import {IsDevelopment, IsLocal, IsProduction} from "../lib/env";
import BackendWrapperView from "../routes/Services/components/BackendWrapperView";

if (document.location.hostname === "servicecatalog.internal.justin.tv") {
  ReactGA.initialize("UA-97236991-1");
}
if (document.location.hostname === "servicecatalog-beta.internal.justin.tv") {
  ReactGA.initialize("UA-105711273-1");
}

function logPageView() {
  ReactGA.set({page: window.location.pathname + window.location.search});
  ReactGA.pageview(window.location.pathname + window.location.search);
  return null;
}

class App extends React.Component {
  shouldComponentUpdate() {
    return false;
  }

  render() {
    // Enable Google Analytics in production
    var routes = (
      <div>

        {/* forward any url with '/api' to goracle with rest of the url left as is */}
        {IsLocal() && <Route path='/api' component={() => {
          window.location = 'http://servicecatalog-local.internal.justin.tv:8000' + window.location.pathname;
          return null;
        }}/>}
        {IsDevelopment() && <Route path='/api' component={() => {
          window.location = 'https://servicecatalog-api-beta.internal.justin.tv' + window.location.pathname;
          return null;
        }}/>}
        {IsProduction() && <Route path='/api' component={() => {
          window.location = 'https://servicecatalog-api.internal.justin.tv' + window.location.pathname;
          return null;
        }}/>}

        {/* correct all non-servicecatalog urls */}
        {IsLocal() && !document.location.href.includes("http://servicecatalog-local.internal.justin.tv:3000") &&
        <Route component={() => {
          window.location = 'http://servicecatalog-local.internal.justin.tv:3000' + window.location.pathname;
          return null;
        }}/>}
        {IsDevelopment() && !document.location.href.includes("https://servicecatalog-beta.internal.justin.tv") &&
        <Route component={() => {
          window.location = 'https://servicecatalog-dev.internal.justin.tv' + window.location.pathname;
          return null;
        }}/>}
        {IsProduction() && !document.location.href.includes("https://servicecatalog.internal.justin.tv") &&
        <Route component={() => {
          window.location = 'https://servicecatalog.internal.justin.tv' + window.location.pathname;
          return null;
        }}/>}

        {/* log a page-view in prod or dev */}
        {(document.location.hostname === "servicecatalog.internal.justin.tv" ||
          document.location.hostname ===
          "servicecatalog-beta.internal.justin.tv") && (
          <Route component={logPageView}/>
        )}

        {/*Setting the sun on these URLs, redirect them to Service Index page*/}
        <Route path="/(components|metrics|accounts|orgs|team)/" render={() => (
          <Redirect to="/services/"/>
        )}/>
        <Route exact path="/(components|metrics|accounts|orgs|team)/:id" render={() => (
          <Redirect to="/services/"/>
        )}/>

        <Route path="/messaging/" component={BackendWrapperView}/>
        <Route path="/services/:id" component={ServiceView}/>
        <Route exact path="/services/" component={ServiceList}/>
        <Route exact path="/serviceOwner/" component={ServiceOwnerView}/>
        <Route exact path="/serviceOwner/:uid" component={ServiceOwnerView}/>
        <Route exact path="/logReports/" component={LogReportsPage}/>
        <Route exact path="/login/" component={LoginComponent}/>
        <Route exact path="/logout/" component={LogoutComponent}/>
        <Route exact path="/oauth2/callback/" component={LoginComponent}/>
        <Route exact path="/" component={ServiceList}/>

        <ErrorModal/>
      </div>
    );

    var router = (
      <ConnectedRouter history={this.props.history}>
        <RouterToUrlQuery>
          <CoreLayout>{routes}</CoreLayout>
        </RouterToUrlQuery>
      </ConnectedRouter>
    );

    return (
      <ApolloProvider client={graphqlClient}>
        <Provider store={this.props.store}>
          <div style={{height: "100%"}}>{router} </div>
        </Provider>
      </ApolloProvider>
    );
  }
}

App.propTypes = {
  store: PropTypes.object.isRequired,
  history: PropTypes.object.isRequired,
};

export default App;
