import { Popover, Glyphicon, OverlayTrigger } from "react-bootstrap";
import React from "react";
import PropTypes from "prop-types";

export const HoverTooltip = ({
  title,
  body,
  pullRight = true,
  placement = "bottom",
}) => {
  var popover = (
    <Popover id="popover-trigger-hover-focus" title={title}>
      {body}
    </Popover>
  );
  if (pullRight) {
    var glyph = (
      <div className="pull-right">
        <Glyphicon glyph="question-sign" />
      </div>
    );
  } else {
    var glyph = <Glyphicon glyph="question-sign" />;
  }
  var overlay = (
    <OverlayTrigger
      trigger={["hover", "focus"]}
      placement={placement}
      overlay={popover}
    >
      {glyph}
    </OverlayTrigger>
  );
  return overlay;
};

HoverTooltip.propTypes = {
  title: PropTypes.string.isRequired,
  text: PropTypes.node.isRequired,
  pullRight: PropTypes.bool,
  placement: PropTypes.string,
};

export default HoverTooltip;
