import React from "react";
import _ from "lodash";
import Icon from "react-icons-kit";
import { slack } from "react-icons-kit/fa/slack";
import { envelope } from "react-icons-kit/fa/envelope";
import { toggleMessagingModal } from "store/uiReducer";
import { setMessageSendTo, setMessageReplyTo } from "store/messaging";
import { connect } from "react-redux";
import { Button, ButtonToolbar } from "react-bootstrap";

class MessagingButtons extends React.Component {
  render() {
    const {
      toggleMessagingModal,
      contacts,
      titleFunc,
      defaultReplyTo,
    } = this.props;
    if (!contacts) {
      return null;
    }
    let compress = list => _.uniq(_.compact(list));
    let onClick = (type, sendTo, replyTo) => {
      toggleMessagingModal(true, type, compress(sendTo), titleFunc, replyTo);
    };
    const buttonArray = [
      {
        icon: slack,
        onClick: () => {
          onClick("slack", contacts.slacks, defaultReplyTo);
        },
        contact: compress(contacts.slacks),
        disabled: !(compress(contacts.slacks).length > 0),
      },
    ];
    return (
      <ButtonToolbar>
        {buttonArray.map((button, index) => {
          return (
            <Button
              key={index}
              onClick={button.onClick}
              bsStyle="primary"
              disabled={button.disabled}
              style={{ float: "right" }}
            >
              <Icon icon={button.icon} />
            </Button>
          );
        })}
      </ButtonToolbar>
    );
  }
}

var mapDispatchToProps = function(dispatch) {
  return {
    toggleMessagingModal: (open, type, sendTo, titleFunc, replyTo) => {
      dispatch(setMessageSendTo(sendTo));
      dispatch(setMessageReplyTo(replyTo));
      dispatch(toggleMessagingModal(open, type, titleFunc));
    },
  };
};

var mapStateToProps = function(state, ownProps) {
  return {
    defaultReplyTo: ownProps.defaultReplyTo,
  };
};

export default connect(mapStateToProps, mapDispatchToProps)(MessagingButtons);
