import React from "react";
import PropTypes from "prop-types";
import { connect } from "react-redux";
import { Modal, ControlLabel, FormControl, Button } from "react-bootstrap";
import { toggleServiceDependencyModal } from "store/uiReducer";
import WrapperTooltip from "components/WrapperTooltip";
import ServiceDependencyTree from "components/ServiceDependencyTree";

class ServiceDependencyModal extends React.Component {
  render() {
    const { serviceID, open, closeServiceDependencyModal } = this.props;
    let onHide = () => {
      closeServiceDependencyModal();
    };
    return (
      <Modal bsSize="lg" show={open} onHide={onHide}>
        <Modal.Header closeButton>
          <Modal.Title>Service Dependencies</Modal.Title>
        </Modal.Header>
        <Modal.Body>
          <ServiceDependencyTree serviceID={serviceID} />
        </Modal.Body>
        <Modal.Footer />
      </Modal>
    );
  }
}

var mapDispatchToProps = function(dispatch) {
  return {
    closeServiceDependencyModal: () => {
      dispatch(toggleServiceDependencyModal(false));
    },
  };
};

var mapStateToProps = function(state) {
  return {
    open: state.uiReducer.serviceDependencyModal.open,
    serviceID: state.uiReducer.serviceDependencyModal.serviceID,
  };
};

export default connect(mapStateToProps, mapDispatchToProps)(
  ServiceDependencyModal
);
