// @format
import { Popover, Glyphicon, OverlayTrigger } from "react-bootstrap";
import React from "react";
import PropTypes from "prop-types";

import ReactMarkdown from "react-markdown";

const tooltipMap = {
  "Aggregation Method":
    "This determines how the data produced by the Queries are combined within a 5 minute bucket. Defaults to Sum if not set. Ex. Sum means all the points in the 5 minute bucket are added together",
  Query: "This is the Graphite Query that is used to generate data.",
  "Query Type":
    "This determines how the data produced by the Queries are combined and then compared to the threshold. Ex. (Error Count)/(Request Count) is used for Error Rate Calculations",
  Attributes:
    "Attributes can be used by anyone to tag items that they have a special interest in. They can then be used to filter on Index Pages.",
  Alias:
    "The human-readable identifier for an AWS Account.  This cannot be updated here; reach out to #availability-team for help changing this.",
  "AWS Account ID":
    "The unique string of numbers assigned to an account by AWS upon creation. Cannot be changed.",
  "Attribute Name":
    "This is the name of the attribute. It can be filtered on to show all objects that have an attribute with a name. It is always converted to lowercase.  Ex: All services with tier set regardless of values",
  "Attribute Value":
    "This is the value of the attribute. It can be used to store a value for the name Ex tier:1. It can also be used to attach arbitrary data to an object.",
  "Business Unit":
    "(AKA Org, BU) is a high level organization at Twitch.  Business Units combine into a tree-like structure, BUs being parents or children of other BUs.  Business Units can contain many Teams. The list of BUs is maintained by Capacity Planing.",
  "Business Units":
    "(AKA Orgs, BUs) are high level organizations at Twitch.  Business Units combine into a tree-like structure, BUs being parents or children of other BUs.  Business Units can contain many Teams. The list of BUs is maintained by Capacity Planing.",
  Description:
    "The Description should contain any information that may be helpful to an someone who is not familiar with the object. Ex: Purpose, Runbooks, Wiki pages, or Git repositories",
  "Calculation Type":
    "This determines which queries will be used to calculate availability. Ex. Error Rate=(Error Count)/(Request Count)",
  Name: "This is the name of the object you are viewing.",
  "Rollup to Component": `If Yes, the availability information in this metric is included in a rollup to its parent component.
A metric should be rolled up if it accurately represents the availability of the service that the component is part of. In more detail, metrics that are rolled up influence whether the service is considered up or down in dashboards and reports.
`,
  Threshold:
    "If the metric crosses this threshold it will be considered unavailable.",
  "Latency Query":
    "When the calculation type of the metric is Latency this is the metric used to calculate availability.",
  teamForMetricPage:
    "This is determined by which team owns the service of the component that this metric belongs to.",
  Component: `A collection of related physical infrastructure items that collectively implement a service. This does not mean one piece of infrastructure (like one EC2 host) but rather a set of infrastructure items with the same configuration and code deployed to them. For example:

AWS load balancers, such as ELBs (Elastic Load Balancers) and ALBs (Application Load Balancers)
Beanstalk applications, where a group of hosts is deployed and load balanced via AWS Elastic Beanstalk
Visage client, that is, a client embedded into our visage API infrastructure
Host groups, for example, a set of EC2 instances running the same system image and service code

With correct configuration of AWS accounts, many AWS components (in particular, ELBs) can be discovered automatically by the dashboard. Components not discovered automatically can be added to the dashboard manually, along with your desired metrics.
`,
  Metric: `Each component should have associated with it availability metrics. See Appendix A: Availability Metric Calculations and Rollups.

As currently implemented, availability metrics are sets of related Graphite queries.`,
  "Primary Owner":
    "Primary Owner is responsible for day-to-day operation of the service.",
  Service: `One or more components that, conceptually, present a unified API to their clients. An example is an HTTP Web service that contains these components:

* An ELB
* A set of EC2 hosts behind that ELB
* An RDS data store
* A caching layer
`,
  Team:
    "A Twitch engineering group. A team has basic descriptive information and contact information (Slack room and email address). Teams own components and services in the dashboard.",
  "Metric Name":
    "Descriptive, easily search-able name. , and (ideally) identify a component or service it is related to.",
  "Metric Description":
    "A description that will help people, especially those outside your team, understand the metric. Use Markdown format.",
  Status:
    "The availability of the last 5 minutes. Healthy: Within SLA. Unhealthy: Out of SLA.",
  Today: "The availability since midnight UTC",
  "Week To Date": "The availability since midnight UTC Sunday.",
  "E-mail": "E-mail address at which the members of this team can be reached.",
  "Slack Channel": "A public channel in Slack where this team can be reached.",
  "Service Slack":
    "Slack channel specific to this service (overrides Team Slack)",
  "Team Slack": "Slack channel of the team that owns this service",
  queryEditColumn:
    "Newly added queries require the Metric to be save before they are directly edited. Alternatively copy the query string, add a new query, and delete the original.",

  "Include in Latency Report":
    "If this is selected this metric will be included in the latency report. The report will use selected Latency Query and Threshold.",
  Tier:
    "A number specifying the criticality of a service. Tier 1 services lead to Sev-1 incidents when unavailable, while tier 2 do not. More service tier definitions are coming soon. Add the `tier` attribute to a service for it to show up in this column.",
  service_validation_actions:
    "Use these buttons to validate (green check mark) or invalidate (red X) the correctness of various aspects of this service",
  service_validation_type:
    "Indicates the portion of the service that is being validated/invalidated/etc",
  service_validation_last:
    "Indicates the last timestamp at which an aspect of a service was validated/invalidated/etc",
  service_validation_history:
    "Use this to see a full history of validations of a particular type for the service",
  "Service Type": `
Classification of a service's scope within Twitch:
* External Product - Externally facing, provides features to the end user
* Internal Product - Internally facing only, provides supporting tech for External Products
* Internal Ops - Internally facing services supporting operation (think DNS, Graphite, LDAP, etc)
`,
  "Availability Objective":
    "The availability uptime percentage that this service targets as an SLO. This objective is compared against the availability computed from configured metrics.",
  "Availability Validation":
    "Filters services by the `availability` validation status",
  "Primary Owner Validation":
    "Indicates if the primary owner contact has been validated",
  Dependencies:
    "This service depends on downstream Services. Upstream services depend on this service. For example, for a web application server, the load balancer would be upstream, and the database would be downstream.",
  Stage:
    "The stage the service is deployed in. Examples: beta, prod, etc.",
  Region:
    "The region the service is deployed in. Examples: us-west-2, us-east-1, etc.",
  "VPC Endpoint Name":
    "The VPC Endpoint Service Name, used for communicating with Twitch services over PrivateLink",
  Hostname:
    "The hostname used for connecting to the service",
  Port:
    "The port used for connecting to the service (integer)",
  "SSL Enabled":
    "Whether SSL is enabled (checked) of disabled (unchecked) for this endpoint",
  "Remove Endpoint?":
    "Click the red button to remove the endpoint. Please remember to save after removing.",
  Manager:
    "The manager of the Primary Owner based on contacts service (powered by HR IT)",
  Team:
    "The team of the Primary Owner based on contacts service (powered by HR IT)",
  Org:
    "The org of the Primary Owner based on contacts service (powered by HR IT)",
  "Business Unit":
    "The business unit of the Primary Owner based on contacts service (powered by HR IT)",
  "Service State":
    "The state of service, Active or Inactive",
  "View Mode":
    "Disable the edit buttons for State, Primary Owner and Slack Channel",
  "Edit Mode":
    "Enable the edit buttons for State, Primary Owner and Slack Channel. This page currently supports updates on individual services"
};

export const WrapperTooltip = ({ title, tooltipID }) => {
  if (tooltipID) {
    var body = tooltipMap[tooltipID];
  } else {
    var body = tooltipMap[title];
  }
  if (!body) {
    return <span>{title}</span>;
  }
  var id = `popover-trigger-hover-focus-${title}`;
  var popover = (
    <Popover id={id} title={title}>
      <ReactMarkdown source={body} />
    </Popover>
  );
  var glyph = <Glyphicon glyph="question-sign" />;
  return (
    <OverlayTrigger
      inline
      key={id}
      trigger={["hover", "focus"]}
      placement="bottom"
      overlay={popover}
    >
      <span>{title}</span>
    </OverlayTrigger>
  );
};

WrapperTooltip.propTypes = {
  title: PropTypes.string.isRequired,
  tooltipID: PropTypes.string,
};

export default WrapperTooltip;
